// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package frauddetector

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateModelVersionInput struct {
	_ struct{} `type:"structure"`

	// The model description.
	//
	// Description is a required field
	Description *string `locationName:"description" min:"1" type:"string" required:"true"`

	// The model ID.
	//
	// ModelId is a required field
	ModelId *string `locationName:"modelId" min:"1" type:"string" required:"true"`

	// The model type.
	//
	// ModelType is a required field
	ModelType ModelTypeEnum `locationName:"modelType" type:"string" required:"true" enum:"true"`

	// The model version.
	//
	// ModelVersionNumber is a required field
	ModelVersionNumber *string `locationName:"modelVersionNumber" min:"1" type:"string" required:"true"`

	// The new model status.
	//
	// Status is a required field
	Status ModelVersionStatus `locationName:"status" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s UpdateModelVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateModelVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateModelVersionInput"}

	if s.Description == nil {
		invalidParams.Add(aws.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.ModelId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ModelId"))
	}
	if s.ModelId != nil && len(*s.ModelId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ModelId", 1))
	}
	if len(s.ModelType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ModelType"))
	}

	if s.ModelVersionNumber == nil {
		invalidParams.Add(aws.NewErrParamRequired("ModelVersionNumber"))
	}
	if s.ModelVersionNumber != nil && len(*s.ModelVersionNumber) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ModelVersionNumber", 1))
	}
	if len(s.Status) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Status"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateModelVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateModelVersionOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateModelVersion = "UpdateModelVersion"

// UpdateModelVersionRequest returns a request value for making API operation for
// Amazon Fraud Detector.
//
// Updates a model version. You can update the description and status attributes
// using this action. You can perform the following status updates:
//
// Change the TRAINING_COMPLETE status to ACTIVE
//
// Change ACTIVE back to TRAINING_COMPLETE
//
//    // Example sending a request using UpdateModelVersionRequest.
//    req := client.UpdateModelVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/frauddetector-2019-11-15/UpdateModelVersion
func (c *Client) UpdateModelVersionRequest(input *UpdateModelVersionInput) UpdateModelVersionRequest {
	op := &aws.Operation{
		Name:       opUpdateModelVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateModelVersionInput{}
	}

	req := c.newRequest(op, input, &UpdateModelVersionOutput{})
	return UpdateModelVersionRequest{Request: req, Input: input, Copy: c.UpdateModelVersionRequest}
}

// UpdateModelVersionRequest is the request type for the
// UpdateModelVersion API operation.
type UpdateModelVersionRequest struct {
	*aws.Request
	Input *UpdateModelVersionInput
	Copy  func(*UpdateModelVersionInput) UpdateModelVersionRequest
}

// Send marshals and sends the UpdateModelVersion API request.
func (r UpdateModelVersionRequest) Send(ctx context.Context) (*UpdateModelVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateModelVersionResponse{
		UpdateModelVersionOutput: r.Request.Data.(*UpdateModelVersionOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateModelVersionResponse is the response type for the
// UpdateModelVersion API operation.
type UpdateModelVersionResponse struct {
	*UpdateModelVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateModelVersion request.
func (r *UpdateModelVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
