// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package eks

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type UpdateNodegroupConfigInput struct {
	_ struct{} `type:"structure"`

	// Unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientRequestToken *string `locationName:"clientRequestToken" type:"string" idempotencyToken:"true"`

	// The name of the Amazon EKS cluster that the managed node group resides in.
	//
	// ClusterName is a required field
	ClusterName *string `location:"uri" locationName:"name" type:"string" required:"true"`

	// The Kubernetes labels to be applied to the nodes in the node group after
	// the update.
	Labels *UpdateLabelsPayload `locationName:"labels" type:"structure"`

	// The name of the managed node group to update.
	//
	// NodegroupName is a required field
	NodegroupName *string `location:"uri" locationName:"nodegroupName" type:"string" required:"true"`

	// The scaling configuration details for the Auto Scaling group after the update.
	ScalingConfig *NodegroupScalingConfig `locationName:"scalingConfig" type:"structure"`
}

// String returns the string representation
func (s UpdateNodegroupConfigInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNodegroupConfigInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateNodegroupConfigInput"}

	if s.ClusterName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClusterName"))
	}

	if s.NodegroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("NodegroupName"))
	}
	if s.ScalingConfig != nil {
		if err := s.ScalingConfig.Validate(); err != nil {
			invalidParams.AddNested("ScalingConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateNodegroupConfigInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	var ClientRequestToken string
	if s.ClientRequestToken != nil {
		ClientRequestToken = *s.ClientRequestToken
	} else {
		ClientRequestToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientRequestToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientRequestToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Labels != nil {
		v := s.Labels

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "labels", v, metadata)
	}
	if s.ScalingConfig != nil {
		v := s.ScalingConfig

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "scalingConfig", v, metadata)
	}
	if s.ClusterName != nil {
		v := *s.ClusterName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.NodegroupName != nil {
		v := *s.NodegroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "nodegroupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type UpdateNodegroupConfigOutput struct {
	_ struct{} `type:"structure"`

	// An object representing an asynchronous update.
	Update *Update `locationName:"update" type:"structure"`
}

// String returns the string representation
func (s UpdateNodegroupConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateNodegroupConfigOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Update != nil {
		v := s.Update

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "update", v, metadata)
	}
	return nil
}

const opUpdateNodegroupConfig = "UpdateNodegroupConfig"

// UpdateNodegroupConfigRequest returns a request value for making API operation for
// Amazon Elastic Kubernetes Service.
//
// Updates an Amazon EKS managed node group configuration. Your node group continues
// to function during the update. The response output includes an update ID
// that you can use to track the status of your node group update with the DescribeUpdate
// API operation. Currently you can update the Kubernetes labels for a node
// group or the scaling configuration.
//
//    // Example sending a request using UpdateNodegroupConfigRequest.
//    req := client.UpdateNodegroupConfigRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/eks-2017-11-01/UpdateNodegroupConfig
func (c *Client) UpdateNodegroupConfigRequest(input *UpdateNodegroupConfigInput) UpdateNodegroupConfigRequest {
	op := &aws.Operation{
		Name:       opUpdateNodegroupConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/clusters/{name}/node-groups/{nodegroupName}/update-config",
	}

	if input == nil {
		input = &UpdateNodegroupConfigInput{}
	}

	req := c.newRequest(op, input, &UpdateNodegroupConfigOutput{})
	return UpdateNodegroupConfigRequest{Request: req, Input: input, Copy: c.UpdateNodegroupConfigRequest}
}

// UpdateNodegroupConfigRequest is the request type for the
// UpdateNodegroupConfig API operation.
type UpdateNodegroupConfigRequest struct {
	*aws.Request
	Input *UpdateNodegroupConfigInput
	Copy  func(*UpdateNodegroupConfigInput) UpdateNodegroupConfigRequest
}

// Send marshals and sends the UpdateNodegroupConfig API request.
func (r UpdateNodegroupConfigRequest) Send(ctx context.Context) (*UpdateNodegroupConfigResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateNodegroupConfigResponse{
		UpdateNodegroupConfigOutput: r.Request.Data.(*UpdateNodegroupConfigOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateNodegroupConfigResponse is the response type for the
// UpdateNodegroupConfig API operation.
type UpdateNodegroupConfigResponse struct {
	*UpdateNodegroupConfigOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateNodegroupConfig request.
func (r *UpdateNodegroupConfigResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
