// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateDirectConnectGatewayAssociationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon VPC prefixes to advertise to the Direct Connect gateway.
	AddAllowedPrefixesToDirectConnectGateway []RouteFilterPrefix `locationName:"addAllowedPrefixesToDirectConnectGateway" type:"list"`

	// The ID of the Direct Connect gateway association.
	AssociationId *string `locationName:"associationId" type:"string"`

	// The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.
	RemoveAllowedPrefixesToDirectConnectGateway []RouteFilterPrefix `locationName:"removeAllowedPrefixesToDirectConnectGateway" type:"list"`
}

// String returns the string representation
func (s UpdateDirectConnectGatewayAssociationInput) String() string {
	return awsutil.Prettify(s)
}

type UpdateDirectConnectGatewayAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Information about an association between a Direct Connect gateway and a virtual
	// private gateway or transit gateway.
	DirectConnectGatewayAssociation *DirectConnectGatewayAssociation `locationName:"directConnectGatewayAssociation" type:"structure"`
}

// String returns the string representation
func (s UpdateDirectConnectGatewayAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateDirectConnectGatewayAssociation = "UpdateDirectConnectGatewayAssociation"

// UpdateDirectConnectGatewayAssociationRequest returns a request value for making API operation for
// AWS Direct Connect.
//
// Updates the specified attributes of the Direct Connect gateway association.
//
// Add or remove prefixes from the association.
//
//    // Example sending a request using UpdateDirectConnectGatewayAssociationRequest.
//    req := client.UpdateDirectConnectGatewayAssociationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/directconnect-2012-10-25/UpdateDirectConnectGatewayAssociation
func (c *Client) UpdateDirectConnectGatewayAssociationRequest(input *UpdateDirectConnectGatewayAssociationInput) UpdateDirectConnectGatewayAssociationRequest {
	op := &aws.Operation{
		Name:       opUpdateDirectConnectGatewayAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDirectConnectGatewayAssociationInput{}
	}

	req := c.newRequest(op, input, &UpdateDirectConnectGatewayAssociationOutput{})
	return UpdateDirectConnectGatewayAssociationRequest{Request: req, Input: input, Copy: c.UpdateDirectConnectGatewayAssociationRequest}
}

// UpdateDirectConnectGatewayAssociationRequest is the request type for the
// UpdateDirectConnectGatewayAssociation API operation.
type UpdateDirectConnectGatewayAssociationRequest struct {
	*aws.Request
	Input *UpdateDirectConnectGatewayAssociationInput
	Copy  func(*UpdateDirectConnectGatewayAssociationInput) UpdateDirectConnectGatewayAssociationRequest
}

// Send marshals and sends the UpdateDirectConnectGatewayAssociation API request.
func (r UpdateDirectConnectGatewayAssociationRequest) Send(ctx context.Context) (*UpdateDirectConnectGatewayAssociationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDirectConnectGatewayAssociationResponse{
		UpdateDirectConnectGatewayAssociationOutput: r.Request.Data.(*UpdateDirectConnectGatewayAssociationOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDirectConnectGatewayAssociationResponse is the response type for the
// UpdateDirectConnectGatewayAssociation API operation.
type UpdateDirectConnectGatewayAssociationResponse struct {
	*UpdateDirectConnectGatewayAssociationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDirectConnectGatewayAssociation request.
func (r *UpdateDirectConnectGatewayAssociationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
