// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package databasemigrationservice_test

import (
	"context"
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/aws/awserr"
	"github.com/aws/aws-sdk-go-v2/aws/external"
	"github.com/aws/aws-sdk-go-v2/service/databasemigrationservice"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// Add tags to resource
//
// Adds metadata tags to an AWS DMS resource, including replication instance, endpoint,
// security group, and migration task. These tags can also be used with cost allocation
// reporting to track cost associated with AWS DMS resources, or used in a Condition
// statement in an IAM policy for AWS DMS.
func ExampleClient_AddTagsToResourceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.AddTagsToResourceInput{
		ResourceArn: aws.String("arn:aws:dms:us-east-1:123456789012:endpoint:ASXWXJZLNWNT5HTWCGV2BUJQ7E"),
		Tags: []databasemigrationservice.Tag{
			{
				Key:   aws.String("Acount"),
				Value: aws.String("1633456"),
			},
		},
	}

	req := svc.AddTagsToResourceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Create endpoint
//
// Creates an endpoint using the provided settings.
func ExampleClient_CreateEndpointRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.CreateEndpointInput{
		CertificateArn:            aws.String(""),
		DatabaseName:              aws.String("testdb"),
		EndpointIdentifier:        aws.String("test-endpoint-1"),
		EndpointType:              databasemigrationservice.ReplicationEndpointTypeValueSource,
		EngineName:                aws.String("mysql"),
		ExtraConnectionAttributes: aws.String(""),
		KmsKeyId:                  aws.String("arn:aws:kms:us-east-1:123456789012:key/4c1731d6-5435-ed4d-be13-d53411a7cfbd"),
		Password:                  aws.String("pasword"),
		Port:                      aws.Int64(3306),
		ServerName:                aws.String("mydb.cx1llnox7iyx.us-west-2.rds.amazonaws.com"),
		SslMode:                   databasemigrationservice.DmsSslModeValueRequire,
		Tags: []databasemigrationservice.Tag{
			{
				Key:   aws.String("Acount"),
				Value: aws.String("143327655"),
			},
		},
		Username: aws.String("username"),
	}

	req := svc.CreateEndpointRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceAlreadyExistsFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceAlreadyExistsFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Create replication instance
//
// Creates the replication instance using the specified parameters.
func ExampleClient_CreateReplicationInstanceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.CreateReplicationInstanceInput{
		AllocatedStorage:                 aws.Int64(123),
		AutoMinorVersionUpgrade:          aws.Bool(true),
		AvailabilityZone:                 aws.String(""),
		EngineVersion:                    aws.String(""),
		KmsKeyId:                         aws.String(""),
		MultiAZ:                          aws.Bool(true),
		PreferredMaintenanceWindow:       aws.String(""),
		PubliclyAccessible:               aws.Bool(true),
		ReplicationInstanceClass:         aws.String(""),
		ReplicationInstanceIdentifier:    aws.String(""),
		ReplicationSubnetGroupIdentifier: aws.String(""),
		Tags: []databasemigrationservice.Tag{
			{
				Key:   aws.String("string"),
				Value: aws.String("string"),
			},
		},
	}

	req := svc.CreateReplicationInstanceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceAlreadyExistsFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceAlreadyExistsFault, aerr.Error())
			case databasemigrationservice.ErrCodeInsufficientResourceCapacityFault:
				fmt.Println(databasemigrationservice.ErrCodeInsufficientResourceCapacityFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			case databasemigrationservice.ErrCodeStorageQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeStorageQuotaExceededFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeReplicationSubnetGroupDoesNotCoverEnoughAZs:
				fmt.Println(databasemigrationservice.ErrCodeReplicationSubnetGroupDoesNotCoverEnoughAZs, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidSubnet:
				fmt.Println(databasemigrationservice.ErrCodeInvalidSubnet, aerr.Error())
			case databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Create replication subnet group
//
// Creates a replication subnet group given a list of the subnet IDs in a VPC.
func ExampleClient_CreateReplicationSubnetGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.CreateReplicationSubnetGroupInput{
		ReplicationSubnetGroupDescription: aws.String("US West subnet group"),
		ReplicationSubnetGroupIdentifier:  aws.String("us-west-2ab-vpc-215ds366"),
		SubnetIds: []string{
			"subnet-e145356n",
			"subnet-58f79200",
		},
		Tags: []databasemigrationservice.Tag{
			{
				Key:   aws.String("Acount"),
				Value: aws.String("145235"),
			},
		},
	}

	req := svc.CreateReplicationSubnetGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceAlreadyExistsFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceAlreadyExistsFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			case databasemigrationservice.ErrCodeReplicationSubnetGroupDoesNotCoverEnoughAZs:
				fmt.Println(databasemigrationservice.ErrCodeReplicationSubnetGroupDoesNotCoverEnoughAZs, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidSubnet:
				fmt.Println(databasemigrationservice.ErrCodeInvalidSubnet, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Create replication task
//
// Creates a replication task using the specified parameters.
func ExampleClient_CreateReplicationTaskRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.CreateReplicationTaskInput{
		CdcStartTime:              parseTime("2006-01-02T15:04:05Z", "2016-12-14T18:25:43Z"),
		MigrationType:             databasemigrationservice.MigrationTypeValueFullLoad,
		ReplicationInstanceArn:    aws.String("arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ"),
		ReplicationTaskIdentifier: aws.String("task1"),
		ReplicationTaskSettings:   aws.String(""),
		SourceEndpointArn:         aws.String("arn:aws:dms:us-east-1:123456789012:endpoint:ZW5UAN6P4E77EC7YWHK4RZZ3BE"),
		TableMappings:             aws.String("file://mappingfile.json"),
		Tags: []databasemigrationservice.Tag{
			{
				Key:   aws.String("Acount"),
				Value: aws.String("24352226"),
			},
		},
		TargetEndpointArn: aws.String("arn:aws:dms:us-east-1:123456789012:endpoint:ASXWXJZLNWNT5HTWCGV2BUJQ7E"),
	}

	req := svc.CreateReplicationTaskRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceAlreadyExistsFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceAlreadyExistsFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Delete Certificate
//
// Deletes the specified certificate.
func ExampleClient_DeleteCertificateRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.DeleteCertificateInput{
		CertificateArn: aws.String("arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUSM457DE6XFJCJQ"),
	}

	req := svc.DeleteCertificateRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Delete Connection
//
// Deletes the connection between the replication instance and the endpoint.
func ExampleClient_DeleteConnectionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.DeleteConnectionInput{
		EndpointArn:            aws.String("arn:aws:dms:us-east-1:123456789012:endpoint:RAAR3R22XSH46S3PWLC3NJAWKM"),
		ReplicationInstanceArn: aws.String("arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ"),
	}

	req := svc.DeleteConnectionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Delete Endpoint
//
// Deletes the specified endpoint. All tasks associated with the endpoint must be deleted
// before you can delete the endpoint.
func ExampleClient_DeleteEndpointRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.DeleteEndpointInput{
		EndpointArn: aws.String("arn:aws:dms:us-east-1:123456789012:endpoint:RAAR3R22XSH46S3PWLC3NJAWKM"),
	}

	req := svc.DeleteEndpointRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Delete Replication Instance
//
// Deletes the specified replication instance. You must delete any migration tasks that
// are associated with the replication instance before you can delete it.
func ExampleClient_DeleteReplicationInstanceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.DeleteReplicationInstanceInput{
		ReplicationInstanceArn: aws.String("arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ"),
	}

	req := svc.DeleteReplicationInstanceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Delete Replication Subnet Group
//
// Deletes a replication subnet group.
func ExampleClient_DeleteReplicationSubnetGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.DeleteReplicationSubnetGroupInput{
		ReplicationSubnetGroupIdentifier: aws.String("us-west-2ab-vpc-215ds366"),
	}

	req := svc.DeleteReplicationSubnetGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Delete Replication Task
//
// Deletes the specified replication task.
func ExampleClient_DeleteReplicationTaskRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.DeleteReplicationTaskInput{
		ReplicationTaskArn: aws.String("arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ"),
	}

	req := svc.DeleteReplicationTaskRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe acount attributes
//
// Lists all of the AWS DMS attributes for a customer account. The attributes include
// AWS DMS quotas for the account, such as the number of replication instances allowed.
// The description for a quota includes the quota name, current usage toward that quota,
// and the quota's maximum value. This operation does not take any parameters.
func ExampleClient_DescribeAccountAttributesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.DescribeAccountAttributesInput{}

	req := svc.DescribeAccountAttributesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe certificates
//
// Provides a description of the certificate.
func ExampleClient_DescribeCertificatesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.DescribeCertificatesInput{
		Filters: []databasemigrationservice.Filter{
			{
				Name: aws.String("string"),
				Values: []string{
					"string",
					"string",
				},
			},
		},
		Marker:     aws.String(""),
		MaxRecords: aws.Int64(123),
	}

	req := svc.DescribeCertificatesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe connections
//
// Describes the status of the connections that have been made between the replication
// instance and an endpoint. Connections are created when you test an endpoint.
func ExampleClient_DescribeConnectionsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.DescribeConnectionsInput{
		Filters: []databasemigrationservice.Filter{
			{
				Name: aws.String("string"),
				Values: []string{
					"string",
					"string",
				},
			},
		},
		Marker:     aws.String(""),
		MaxRecords: aws.Int64(123),
	}

	req := svc.DescribeConnectionsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe endpoint types
//
// Returns information about the type of endpoints available.
func ExampleClient_DescribeEndpointTypesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.DescribeEndpointTypesInput{
		Filters: []databasemigrationservice.Filter{
			{
				Name: aws.String("string"),
				Values: []string{
					"string",
					"string",
				},
			},
		},
		Marker:     aws.String(""),
		MaxRecords: aws.Int64(123),
	}

	req := svc.DescribeEndpointTypesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe endpoints
//
// Returns information about the endpoints for your account in the current region.
func ExampleClient_DescribeEndpointsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.DescribeEndpointsInput{
		Filters: []databasemigrationservice.Filter{
			{
				Name: aws.String("string"),
				Values: []string{
					"string",
					"string",
				},
			},
		},
		Marker:     aws.String(""),
		MaxRecords: aws.Int64(123),
	}

	req := svc.DescribeEndpointsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe orderable replication instances
//
// Returns information about the replication instance types that can be created in the
// specified region.
func ExampleClient_DescribeOrderableReplicationInstancesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.DescribeOrderableReplicationInstancesInput{
		Marker:     aws.String(""),
		MaxRecords: aws.Int64(123),
	}

	req := svc.DescribeOrderableReplicationInstancesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe refresh schema status
//
// Returns the status of the refresh-schemas operation.
func ExampleClient_DescribeRefreshSchemasStatusRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.DescribeRefreshSchemasStatusInput{
		EndpointArn: aws.String(""),
	}

	req := svc.DescribeRefreshSchemasStatusRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe replication instances
//
// Returns the status of the refresh-schemas operation.
func ExampleClient_DescribeReplicationInstancesRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.DescribeReplicationInstancesInput{
		Filters: []databasemigrationservice.Filter{
			{
				Name: aws.String("string"),
				Values: []string{
					"string",
					"string",
				},
			},
		},
		Marker:     aws.String(""),
		MaxRecords: aws.Int64(123),
	}

	req := svc.DescribeReplicationInstancesRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe replication subnet groups
//
// Returns information about the replication subnet groups.
func ExampleClient_DescribeReplicationSubnetGroupsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.DescribeReplicationSubnetGroupsInput{
		Filters: []databasemigrationservice.Filter{
			{
				Name: aws.String("string"),
				Values: []string{
					"string",
					"string",
				},
			},
		},
		Marker:     aws.String(""),
		MaxRecords: aws.Int64(123),
	}

	req := svc.DescribeReplicationSubnetGroupsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe replication tasks
//
// Returns information about replication tasks for your account in the current region.
func ExampleClient_DescribeReplicationTasksRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.DescribeReplicationTasksInput{
		Filters: []databasemigrationservice.Filter{
			{
				Name: aws.String("string"),
				Values: []string{
					"string",
					"string",
				},
			},
		},
		Marker:     aws.String(""),
		MaxRecords: aws.Int64(123),
	}

	req := svc.DescribeReplicationTasksRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe schemas
//
// Returns information about the schema for the specified endpoint.
func ExampleClient_DescribeSchemasRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.DescribeSchemasInput{
		EndpointArn: aws.String(""),
		Marker:      aws.String(""),
		MaxRecords:  aws.Int64(123),
	}

	req := svc.DescribeSchemasRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Describe table statistics
//
// Returns table statistics on the database migration task, including table name, rows
// inserted, rows updated, and rows deleted.
func ExampleClient_DescribeTableStatisticsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.DescribeTableStatisticsInput{
		Marker:             aws.String(""),
		MaxRecords:         aws.Int64(123),
		ReplicationTaskArn: aws.String(""),
	}

	req := svc.DescribeTableStatisticsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Import certificate
//
// Uploads the specified certificate.
func ExampleClient_ImportCertificateRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.ImportCertificateInput{
		CertificateIdentifier: aws.String(""),
		CertificatePem:        aws.String(""),
	}

	req := svc.ImportCertificateRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceAlreadyExistsFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceAlreadyExistsFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidCertificateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidCertificateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// List tags for resource
//
// Lists all tags for an AWS DMS resource.
func ExampleClient_ListTagsForResourceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.ListTagsForResourceInput{
		ResourceArn: aws.String(""),
	}

	req := svc.ListTagsForResourceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Modify endpoint
//
// Modifies the specified endpoint.
func ExampleClient_ModifyEndpointRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.ModifyEndpointInput{
		CertificateArn:            aws.String(""),
		DatabaseName:              aws.String(""),
		EndpointArn:               aws.String(""),
		EndpointIdentifier:        aws.String(""),
		EndpointType:              databasemigrationservice.ReplicationEndpointTypeValueSource,
		EngineName:                aws.String(""),
		ExtraConnectionAttributes: aws.String(""),
		Password:                  aws.String(""),
		Port:                      aws.Int64(123),
		ServerName:                aws.String(""),
		SslMode:                   databasemigrationservice.DmsSslModeValueRequire,
		Username:                  aws.String(""),
	}

	req := svc.ModifyEndpointRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceAlreadyExistsFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceAlreadyExistsFault, aerr.Error())
			case databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Modify replication instance
//
// Modifies the replication instance to apply new settings. You can change one or more
// parameters by specifying these parameters and the new values in the request. Some
// settings are applied during the maintenance window.
func ExampleClient_ModifyReplicationInstanceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.ModifyReplicationInstanceInput{
		AllocatedStorage:              aws.Int64(123),
		AllowMajorVersionUpgrade:      aws.Bool(true),
		ApplyImmediately:              aws.Bool(true),
		AutoMinorVersionUpgrade:       aws.Bool(true),
		EngineVersion:                 aws.String("1.5.0"),
		MultiAZ:                       aws.Bool(true),
		PreferredMaintenanceWindow:    aws.String("sun:06:00-sun:14:00"),
		ReplicationInstanceArn:        aws.String("arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ"),
		ReplicationInstanceClass:      aws.String("dms.t2.micro"),
		ReplicationInstanceIdentifier: aws.String("test-rep-1"),
	}

	req := svc.ModifyReplicationInstanceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceAlreadyExistsFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceAlreadyExistsFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInsufficientResourceCapacityFault:
				fmt.Println(databasemigrationservice.ErrCodeInsufficientResourceCapacityFault, aerr.Error())
			case databasemigrationservice.ErrCodeStorageQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeStorageQuotaExceededFault, aerr.Error())
			case databasemigrationservice.ErrCodeUpgradeDependencyFailureFault:
				fmt.Println(databasemigrationservice.ErrCodeUpgradeDependencyFailureFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Modify replication subnet group
//
// Modifies the settings for the specified replication subnet group.
func ExampleClient_ModifyReplicationSubnetGroupRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.ModifyReplicationSubnetGroupInput{
		ReplicationSubnetGroupDescription: aws.String(""),
		ReplicationSubnetGroupIdentifier:  aws.String(""),
	}

	req := svc.ModifyReplicationSubnetGroupRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			case databasemigrationservice.ErrCodeSubnetAlreadyInUse:
				fmt.Println(databasemigrationservice.ErrCodeSubnetAlreadyInUse, aerr.Error())
			case databasemigrationservice.ErrCodeReplicationSubnetGroupDoesNotCoverEnoughAZs:
				fmt.Println(databasemigrationservice.ErrCodeReplicationSubnetGroupDoesNotCoverEnoughAZs, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidSubnet:
				fmt.Println(databasemigrationservice.ErrCodeInvalidSubnet, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Refresh schema
//
// Populates the schema for the specified endpoint. This is an asynchronous operation
// and can take several minutes. You can check the status of this operation by calling
// the describe-refresh-schemas-status operation.
func ExampleClient_RefreshSchemasRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.RefreshSchemasInput{
		EndpointArn:            aws.String(""),
		ReplicationInstanceArn: aws.String(""),
	}

	req := svc.RefreshSchemasRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Remove tags from resource
//
// Removes metadata tags from an AWS DMS resource.
func ExampleClient_RemoveTagsFromResourceRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.RemoveTagsFromResourceInput{
		ResourceArn: aws.String("arn:aws:dms:us-east-1:123456789012:endpoint:ASXWXJZLNWNT5HTWCGV2BUJQ7E"),
	}

	req := svc.RemoveTagsFromResourceRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Start replication task
//
// Starts the replication task.
func ExampleClient_StartReplicationTaskRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.StartReplicationTaskInput{
		CdcStartTime:             parseTime("2006-01-02T15:04:05Z", "2016-12-14T13:33:20Z"),
		ReplicationTaskArn:       aws.String("arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ"),
		StartReplicationTaskType: databasemigrationservice.StartReplicationTaskTypeValueStartReplication,
	}

	req := svc.StartReplicationTaskRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeAccessDeniedFault:
				fmt.Println(databasemigrationservice.ErrCodeAccessDeniedFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Stop replication task
//
// Stops the replication task.
func ExampleClient_StopReplicationTaskRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.StopReplicationTaskInput{
		ReplicationTaskArn: aws.String("arn:aws:dms:us-east-1:123456789012:endpoint:ASXWXJZLNWNT5HTWCGV2BUJQ7E"),
	}

	req := svc.StopReplicationTaskRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}

// Test conection
//
// Tests the connection between the replication instance and the endpoint.
func ExampleClient_TestConnectionRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := databasemigrationservice.New(cfg)
	input := &databasemigrationservice.TestConnectionInput{
		EndpointArn:            aws.String("arn:aws:dms:us-east-1:123456789012:endpoint:RAAR3R22XSH46S3PWLC3NJAWKM"),
		ReplicationInstanceArn: aws.String("arn:aws:dms:us-east-1:123456789012:rep:6UTDJGBOUS3VI3SUWA66XFJCJQ"),
	}

	req := svc.TestConnectionRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case databasemigrationservice.ErrCodeResourceNotFoundFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceNotFoundFault, aerr.Error())
			case databasemigrationservice.ErrCodeInvalidResourceStateFault:
				fmt.Println(databasemigrationservice.ErrCodeInvalidResourceStateFault, aerr.Error())
			case databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault:
				fmt.Println(databasemigrationservice.ErrCodeKMSKeyNotAccessibleFault, aerr.Error())
			case databasemigrationservice.ErrCodeResourceQuotaExceededFault:
				fmt.Println(databasemigrationservice.ErrCodeResourceQuotaExceededFault, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
