// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudformation

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListTypeVersionsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the type for which you want version summary
	// information.
	//
	// Conditional: You must specify TypeName or Arn.
	Arn *string `type:"string"`

	// The deprecation status of the type versions that you want to get summary
	// information about.
	//
	// Valid values include:
	//
	//    * LIVE: The type version is registered and can be used in CloudFormation
	//    operations, dependent on its provisioning behavior and visibility scope.
	//
	//    * DEPRECATED: The type version has been deregistered and can no longer
	//    be used in CloudFormation operations.
	DeprecatedStatus DeprecatedStatus `type:"string" enum:"true"`

	// The maximum number of results to be returned with a single call. If the number
	// of available results exceeds this maximum, the response includes a NextToken
	// value that you can assign to the NextToken request parameter to get the next
	// set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous paginated request didn't return all of the remaining results,
	// the response object's NextToken parameter value is set to a token. To retrieve
	// the next set of results, call this action again and assign that token to
	// the request object's NextToken parameter. If there are no remaining results,
	// the previous response object's NextToken parameter is set to null.
	NextToken *string `min:"1" type:"string"`

	// The kind of the type.
	//
	// Currently the only valid value is RESOURCE.
	Type RegistryType `type:"string" enum:"true"`

	// The name of the type for which you want version summary information.
	//
	// Conditional: You must specify TypeName or Arn.
	TypeName *string `min:"10" type:"string"`
}

// String returns the string representation
func (s ListTypeVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTypeVersionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListTypeVersionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.TypeName != nil && len(*s.TypeName) < 10 {
		invalidParams.Add(aws.NewErrParamMinLen("TypeName", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListTypeVersionsOutput struct {
	_ struct{} `type:"structure"`

	// If the request doesn't return all of the remaining results, NextToken is
	// set to a token. To retrieve the next set of results, call this action again
	// and assign that token to the request object's NextToken parameter. If the
	// request returns all results, NextToken is set to null.
	NextToken *string `min:"1" type:"string"`

	// A list of TypeVersionSummary structures that contain information about the
	// specified type's versions.
	TypeVersionSummaries []TypeVersionSummary `type:"list"`
}

// String returns the string representation
func (s ListTypeVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListTypeVersions = "ListTypeVersions"

// ListTypeVersionsRequest returns a request value for making API operation for
// AWS CloudFormation.
//
// Returns summary information about the versions of a type.
//
//    // Example sending a request using ListTypeVersionsRequest.
//    req := client.ListTypeVersionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cloudformation-2010-05-15/ListTypeVersions
func (c *Client) ListTypeVersionsRequest(input *ListTypeVersionsInput) ListTypeVersionsRequest {
	op := &aws.Operation{
		Name:       opListTypeVersions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTypeVersionsInput{}
	}

	req := c.newRequest(op, input, &ListTypeVersionsOutput{})
	return ListTypeVersionsRequest{Request: req, Input: input, Copy: c.ListTypeVersionsRequest}
}

// ListTypeVersionsRequest is the request type for the
// ListTypeVersions API operation.
type ListTypeVersionsRequest struct {
	*aws.Request
	Input *ListTypeVersionsInput
	Copy  func(*ListTypeVersionsInput) ListTypeVersionsRequest
}

// Send marshals and sends the ListTypeVersions API request.
func (r ListTypeVersionsRequest) Send(ctx context.Context) (*ListTypeVersionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTypeVersionsResponse{
		ListTypeVersionsOutput: r.Request.Data.(*ListTypeVersionsOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListTypeVersionsRequestPaginator returns a paginator for ListTypeVersions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListTypeVersionsRequest(input)
//   p := cloudformation.NewListTypeVersionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListTypeVersionsPaginator(req ListTypeVersionsRequest) ListTypeVersionsPaginator {
	return ListTypeVersionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListTypeVersionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListTypeVersionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListTypeVersionsPaginator struct {
	aws.Pager
}

func (p *ListTypeVersionsPaginator) CurrentPage() *ListTypeVersionsOutput {
	return p.Pager.CurrentPage().(*ListTypeVersionsOutput)
}

// ListTypeVersionsResponse is the response type for the
// ListTypeVersions API operation.
type ListTypeVersionsResponse struct {
	*ListTypeVersionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTypeVersions request.
func (r *ListTypeVersionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
