// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// ContainerScanResult A scan result for a container scan
type ContainerScanResult struct {

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of container scan result. Immutable and generated on creation.
	Id *string `mandatory:"true" json:"id"`

	// Repository in which the container image scanned is located
	Repository *string `mandatory:"true" json:"repository"`

	// Image name
	Image *string `mandatory:"true" json:"image"`

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container scan result's compartment. This is set to the same as the compartmentId of the container scan target
	CompartmentId *string `mandatory:"true" json:"compartmentId"`

	// Highest problem severity in this report
	HighestProblemSeverity ScanResultProblemSeverityEnum `mandatory:"true" json:"highestProblemSeverity"`

	// Date and time the scan was started, as described in RFC 3339 (https://tools.ietf.org/rfc/rfc3339)
	TimeStarted *common.SDKTime `mandatory:"true" json:"timeStarted"`

	// Date and time the scan was completed, as described in RFC 3339 (https://tools.ietf.org/rfc/rfc3339)
	TimeFinished *common.SDKTime `mandatory:"true" json:"timeFinished"`

	// List of problems found in this scan
	Problems []ContainerScanResultProblem `mandatory:"true" json:"problems"`

	// The URL of the docker registry the repository is located in.
	RegistryUrl *string `mandatory:"false" json:"registryUrl"`

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to where scan was performed.
	TargetCompartmentId *string `mandatory:"false" json:"targetCompartmentId"`

	// The OCID (https://docs.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of container scan target.
	ContainerScanTargetId *string `mandatory:"false" json:"containerScanTargetId"`

	// Total number of problems found in this scan
	ProblemCount *int `mandatory:"false" json:"problemCount"`
}

func (m ContainerScanResult) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m ContainerScanResult) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingScanResultProblemSeverityEnum(string(m.HighestProblemSeverity)); !ok && m.HighestProblemSeverity != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for HighestProblemSeverity: %s. Supported values are: %s.", m.HighestProblemSeverity, strings.Join(GetScanResultProblemSeverityEnumStringValues(), ",")))
	}

	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}
