/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import com.mongodb.DBRef;
import java.util.function.Function;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.ValueExpressionEvaluator;
import org.springframework.data.mongodb.core.convert.DbRefProxyHandler;
import org.springframework.data.mongodb.core.convert.ObjectPath;
import org.springframework.data.mongodb.core.convert.ValueResolver;
import org.springframework.data.mongodb.core.mapping.MongoPersistentEntity;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.lang.Nullable;

class DefaultDbRefProxyHandler
implements DbRefProxyHandler {
    private final MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext;
    private final ValueResolver resolver;
    private final Function<Object, ValueExpressionEvaluator> evaluatorFactory;

    public DefaultDbRefProxyHandler(MappingContext<? extends MongoPersistentEntity<?>, MongoPersistentProperty> mappingContext, ValueResolver resolver, Function<Object, ValueExpressionEvaluator> evaluatorFactory) {
        this.mappingContext = mappingContext;
        this.resolver = resolver;
        this.evaluatorFactory = evaluatorFactory;
    }

    @Override
    public Object populateId(MongoPersistentProperty property, @Nullable DBRef source, Object proxy) {
        if (source == null) {
            return proxy;
        }
        MongoPersistentEntity entity = (MongoPersistentEntity)this.mappingContext.getRequiredPersistentEntity((PersistentProperty)property);
        MongoPersistentProperty idProperty = (MongoPersistentProperty)entity.getRequiredIdProperty();
        if (idProperty.usePropertyAccess()) {
            return proxy;
        }
        ValueExpressionEvaluator evaluator = this.evaluatorFactory.apply(proxy);
        PersistentPropertyAccessor accessor = entity.getPropertyAccessor(proxy);
        Document object = new Document(idProperty.getFieldName(), source.getId());
        ObjectPath objectPath = ObjectPath.ROOT.push(proxy, entity, null);
        accessor.setProperty((PersistentProperty)idProperty, this.resolver.getValueInternal(idProperty, (Bson)object, evaluator, objectPath));
        return proxy;
    }
}

