/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Crossover;
import io.jenetics.NumericGene;
import io.jenetics.internal.math.random;
import io.jenetics.internal.util.Hash;
import io.jenetics.internal.util.require;
import io.jenetics.util.MSeq;
import io.jenetics.util.RandomRegistry;
import java.util.Random;

public class LineCrossover<G extends NumericGene<?, G>, C extends Comparable<? super C>>
extends Crossover<G, C> {
    private final double _p;

    public LineCrossover(double probability2, double p) {
        super(probability2);
        this._p = require.nonNegative(p, "p");
    }

    public LineCrossover(double probability2) {
        this(probability2, 0.0);
    }

    public LineCrossover() {
        this(0.2, 0.0);
    }

    @Override
    protected int crossover(MSeq<G> v, MSeq<G> w) {
        Random random2 = RandomRegistry.getRandom();
        double min = ((Number)((NumericGene)v.get(0)).getMin()).doubleValue();
        double max = ((Number)((NumericGene)v.get(0)).getMax()).doubleValue();
        double a = random.nextDouble(-this._p, 1.0 + this._p, random2);
        double b = random.nextDouble(-this._p, 1.0 + this._p, random2);
        boolean changed = false;
        int n = Math.min(v.length(), w.length());
        for (int i = 0; i < n; ++i) {
            double vi = ((NumericGene)v.get(i)).doubleValue();
            double wi = ((NumericGene)w.get(i)).doubleValue();
            double t = a * vi + (1.0 - a) * wi;
            double s = b * wi + (1.0 - b) * vi;
            if (!(t >= min) || !(s >= min) || !(t < max) || !(s < max)) continue;
            v.set(i, ((NumericGene)v.get(i)).newInstance(t));
            w.set(i, ((NumericGene)w.get(i)).newInstance(s));
            changed = true;
        }
        return changed ? 2 : 0;
    }

    @Override
    public int hashCode() {
        return Hash.of(this.getClass()).and(super.hashCode()).value();
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof LineCrossover && super.equals(obj);
    }

    public String toString() {
        return String.format("%s[p=%f]", this.getClass().getSimpleName(), this._probability);
    }
}

