/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.floorplan.shape;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.ubnt.model.api.floorplan.FloorPlanShapeType;
import com.ubnt.model.api.floorplan.shape.FloorPlanDeviceDto;
import com.ubnt.model.api.floorplan.shape.FloorPlanMapDto;
import com.ubnt.model.api.floorplan.shape.FloorPlanScaleDto;
import com.ubnt.model.api.floorplan.shape.FloorPlanWallDto;
import com.ubnt.service.floorplan.FloorPlanShapeDocument;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotEmpty;
import org.hibernate.validator.constraints.UUID;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=FloorPlanDeviceDto.class, name="device"), @JsonSubTypes.Type(value=FloorPlanMapDto.class, name="map"), @JsonSubTypes.Type(value=FloorPlanScaleDto.class, name="scale"), @JsonSubTypes.Type(value=FloorPlanWallDto.class, name="wall")})
public interface FloorPlanShapeDto {
    @JsonProperty(value="_id")
    public String id();

    @JsonProperty(value="status")
    @Min(value=0L)
    public @Min(value=0L) int status();

    @JsonProperty(value="type")
    public FloorPlanShapeType type();

    @JsonProperty(value="plan_id")
    @NotEmpty
    public String planId();

    @JsonProperty(value="uuid")
    @NotEmpty
    @UUID
    public String uuid();

    public FloorPlanShapeDocument toDocument(String var1, String var2);

    public static FloorPlanShapeDto ofDocument(FloorPlanShapeDocument floorPlanShapeDocument) {
        return switch (floorPlanShapeDocument.getType()) {
            default -> throw new IncompatibleClassChangeError();
            case FloorPlanShapeType.DEVICE -> FloorPlanDeviceDto.ofDocument(floorPlanShapeDocument);
            case FloorPlanShapeType.WALL -> FloorPlanWallDto.ofDocument(floorPlanShapeDocument);
            case FloorPlanShapeType.SCALE -> FloorPlanScaleDto.ofDocument(floorPlanShapeDocument);
            case FloorPlanShapeType.MAP -> FloorPlanMapDto.ofDocument(floorPlanShapeDocument);
        };
    }
}

