/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.io.graphml;

import com.mxgraph.io.graphml.mxGraphMlConstants;
import com.mxgraph.io.graphml.mxGraphMlShapeEdge;
import com.mxgraph.io.graphml.mxGraphMlShapeNode;
import com.mxgraph.io.graphml.mxGraphMlUtils;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class mxGraphMlData {
    private String dataId = "";
    private String dataKey = "";
    private String dataValue = "";
    private mxGraphMlShapeNode dataShapeNode;
    private mxGraphMlShapeEdge dataShapeEdge;

    public mxGraphMlData(String dataId, String dataKey, String dataValue, mxGraphMlShapeEdge dataShapeEdge, mxGraphMlShapeNode dataShapeNode) {
        this.dataId = dataId;
        this.dataKey = dataKey;
        this.dataValue = dataValue;
        this.dataShapeNode = dataShapeNode;
        this.dataShapeEdge = dataShapeEdge;
    }

    public mxGraphMlData(Element dataElement) {
        this.dataId = dataElement.getAttribute(mxGraphMlConstants.ID);
        this.dataKey = dataElement.getAttribute(mxGraphMlConstants.KEY);
        this.dataValue = "";
        Element shapeNodeElement = mxGraphMlUtils.childsTag(dataElement, mxGraphMlConstants.JGRAPH + mxGraphMlConstants.SHAPENODE);
        Element shapeEdgeElement = mxGraphMlUtils.childsTag(dataElement, mxGraphMlConstants.JGRAPH + mxGraphMlConstants.SHAPEEDGE);
        if (shapeNodeElement != null) {
            this.dataShapeNode = new mxGraphMlShapeNode(shapeNodeElement);
        } else if (shapeEdgeElement != null) {
            this.dataShapeEdge = new mxGraphMlShapeEdge(shapeEdgeElement);
        } else {
            NodeList childs = dataElement.getChildNodes();
            List<Node> childrens = mxGraphMlUtils.copyNodeList(childs);
            for (Node n : childrens) {
                if (!n.getNodeName().equals("#text")) continue;
                this.dataValue = this.dataValue + n.getNodeValue();
            }
            this.dataValue = this.dataValue.trim();
        }
    }

    public mxGraphMlData() {
    }

    public String getDataId() {
        return this.dataId;
    }

    public void setDataId(String dataId) {
        this.dataId = dataId;
    }

    public String getDataKey() {
        return this.dataKey;
    }

    public void setDataKey(String dataKey) {
        this.dataKey = dataKey;
    }

    public String getDataValue() {
        return this.dataValue;
    }

    public void setDataValue(String dataValue) {
        this.dataValue = dataValue;
    }

    public mxGraphMlShapeNode getDataShapeNode() {
        return this.dataShapeNode;
    }

    public void setDataShapeNode(mxGraphMlShapeNode dataShapeNode) {
        this.dataShapeNode = dataShapeNode;
    }

    public mxGraphMlShapeEdge getDataShapeEdge() {
        return this.dataShapeEdge;
    }

    public void setDataShapeEdge(mxGraphMlShapeEdge dataShapeEdge) {
        this.dataShapeEdge = dataShapeEdge;
    }

    public Element generateNodeElement(Document document) {
        Element data = document.createElement(mxGraphMlConstants.DATA);
        data.setAttribute(mxGraphMlConstants.KEY, this.dataKey);
        Element shapeNodeElement = this.dataShapeNode.generateElement(document);
        data.appendChild(shapeNodeElement);
        return data;
    }

    public Element generateEdgeElement(Document document) {
        Element data = document.createElement(mxGraphMlConstants.DATA);
        data.setAttribute(mxGraphMlConstants.KEY, this.dataKey);
        Element shapeEdgeElement = this.dataShapeEdge.generateElement(document);
        data.appendChild(shapeEdgeElement);
        return data;
    }
}

