/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.analysis;

import java.util.Hashtable;
import java.util.Map;

public class mxFibonacciHeap {
    protected Map<Object, Node> nodes = new Hashtable<Object, Node>();
    protected Node min;
    protected int size;

    public Node getNode(Object element, boolean create) {
        Node node = this.nodes.get(element);
        if (node == null && create) {
            node = new Node(element, Double.MAX_VALUE);
            this.nodes.put(element, node);
            this.insert(node, node.getKey());
        }
        return node;
    }

    public boolean isEmpty() {
        return this.min == null;
    }

    public void decreaseKey(Node x, double k) {
        if (k > x.key) {
            throw new IllegalArgumentException("decreaseKey() got larger key value");
        }
        x.key = k;
        Node y = x.parent;
        if (y != null && x.key < y.key) {
            this.cut(x, y);
            this.cascadingCut(y);
        }
        if (this.min == null || x.key < this.min.key) {
            this.min = x;
        }
    }

    public void delete(Node x) {
        this.decreaseKey(x, Double.NEGATIVE_INFINITY);
        this.removeMin();
    }

    public void insert(Node node, double key) {
        node.key = key;
        if (this.min != null) {
            node.left = this.min;
            node.right = this.min.right;
            this.min.right = node;
            node.right.left = node;
            if (key < this.min.key) {
                this.min = node;
            }
        } else {
            this.min = node;
        }
        ++this.size;
    }

    public Node min() {
        return this.min;
    }

    public Node removeMin() {
        Node z = this.min;
        if (z != null) {
            Node x = z.child;
            for (int numKids = z.degree; numKids > 0; --numKids) {
                Node tempRight = x.right;
                x.left.right = x.right;
                x.right.left = x.left;
                x.left = this.min;
                x.right = this.min.right;
                this.min.right = x;
                x.right.left = x;
                x.parent = null;
                x = tempRight;
            }
            z.left.right = z.right;
            z.right.left = z.left;
            if (z == z.right) {
                this.min = null;
            } else {
                this.min = z.right;
                this.consolidate();
            }
            --this.size;
        }
        return z;
    }

    public int size() {
        return this.size;
    }

    public static mxFibonacciHeap union(mxFibonacciHeap h1, mxFibonacciHeap h2) {
        mxFibonacciHeap h = new mxFibonacciHeap();
        if (h1 != null && h2 != null) {
            h.min = h1.min;
            if (h.min != null) {
                if (h2.min != null) {
                    h.min.right.left = h2.min.left;
                    h2.min.left.right = h.min.right;
                    h.min.right = h2.min;
                    h2.min.left = h.min;
                    if (h2.min.key < h1.min.key) {
                        h.min = h2.min;
                    }
                }
            } else {
                h.min = h2.min;
            }
            h.size = h1.size + h2.size;
        }
        return h;
    }

    protected void cascadingCut(Node y) {
        Node z = y.parent;
        if (z != null) {
            if (!y.mark) {
                y.mark = true;
            } else {
                this.cut(y, z);
                this.cascadingCut(z);
            }
        }
    }

    protected void consolidate() {
        int arraySize = this.size + 1;
        Node[] array = new Node[arraySize];
        for (int i = 0; i < arraySize; ++i) {
            array[i] = null;
        }
        int numRoots = 0;
        Node x = this.min;
        if (x != null) {
            ++numRoots;
            x = x.right;
            while (x != this.min) {
                ++numRoots;
                x = x.right;
            }
        }
        while (numRoots > 0) {
            int d = x.degree;
            Node next = x.right;
            while (array[d] != null) {
                Node y = array[d];
                if (x.key > y.key) {
                    Node temp = y;
                    y = x;
                    x = temp;
                }
                this.link(y, x);
                array[d] = null;
                ++d;
            }
            array[d] = x;
            x = next;
            --numRoots;
        }
        this.min = null;
        for (int i = 0; i < arraySize; ++i) {
            if (array[i] == null) continue;
            if (this.min != null) {
                array[i].left.right = array[i].right;
                array[i].right.left = array[i].left;
                array[i].left = this.min;
                array[i].right = this.min.right;
                this.min.right = array[i];
                array[i].right.left = array[i];
                if (!(array[i].key < this.min.key)) continue;
                this.min = array[i];
                continue;
            }
            this.min = array[i];
        }
    }

    protected void cut(Node x, Node y) {
        x.left.right = x.right;
        x.right.left = x.left;
        --y.degree;
        if (y.child == x) {
            y.child = x.right;
        }
        if (y.degree == 0) {
            y.child = null;
        }
        x.left = this.min;
        x.right = this.min.right;
        this.min.right = x;
        x.right.left = x;
        x.parent = null;
        x.mark = false;
    }

    protected void link(Node y, Node x) {
        y.left.right = y.right;
        y.right.left = y.left;
        y.parent = x;
        if (x.child == null) {
            x.child = y;
            y.right = y;
            y.left = y;
        } else {
            y.left = x.child;
            y.right = x.child.right;
            x.child.right = y;
            y.right.left = y;
        }
        ++x.degree;
        y.mark = false;
    }

    public static class Node {
        Object userObject;
        Node child;
        Node left;
        Node parent;
        Node right;
        boolean mark;
        double key;
        int degree;

        public Node(Object userObject, double key) {
            this.userObject = userObject;
            this.right = this;
            this.left = this;
            this.key = key;
        }

        public final double getKey() {
            return this.key;
        }

        public Object getUserObject() {
            return this.userObject;
        }

        public void setUserObject(Object userObject) {
            this.userObject = userObject;
        }
    }
}

