/*
 * Decompiled with CFR 0.152.
 */
package org.vinniks.parsla.parser.text;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.Set;
import lombok.NonNull;
import org.vinniks.parsla.grammar.Grammar;
import org.vinniks.parsla.parser.NoActionListener;
import org.vinniks.parsla.parser.Parser;
import org.vinniks.parsla.parser.ParserOutputListener;
import org.vinniks.parsla.syntaxtree.SyntaxTreeBuilder;
import org.vinniks.parsla.syntaxtree.SyntaxTreeNode;
import org.vinniks.parsla.tokenizer.TokenIterator;
import org.vinniks.parsla.tokenizer.text.TextPosition;
import org.vinniks.parsla.tokenizer.text.TextTokenizer;

public class TextParser
extends Parser<TextPosition> {
    private final TextTokenizer tokenizer;

    public TextParser(Grammar grammar, Set<String> ignoredTokenTypes, @NonNull TextTokenizer tokenizer) {
        super(grammar, ignoredTokenTypes);
        if (tokenizer == null) {
            throw new NullPointerException("tokenizer is marked non-null but is null");
        }
        this.tokenizer = tokenizer;
    }

    public TextParser(Grammar grammar, TextTokenizer tokenizer) {
        this(grammar, Collections.emptySet(), tokenizer);
    }

    public void parse(@NonNull Reader source, String rootRuleName, ParserOutputListener<TextPosition> outputListener) throws IOException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        try (TokenIterator<TextPosition> tokenIterator = this.tokenizer.getTokenIterator(source);){
            this.parse(tokenIterator, rootRuleName, outputListener);
        }
    }

    public void parse(@NonNull String source, String rootRuleName, ParserOutputListener<TextPosition> outputListener) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        try (StringReader reader = new StringReader(source);){
            this.parse(reader, rootRuleName, outputListener);
        }
    }

    public SyntaxTreeNode<TextPosition> parse(Reader source, String rootRuleName) throws IOException {
        SyntaxTreeBuilder<TextPosition> syntaxTreeBuilder = new SyntaxTreeBuilder<TextPosition>();
        this.parse(source, rootRuleName, syntaxTreeBuilder);
        return syntaxTreeBuilder.build();
    }

    public SyntaxTreeNode<TextPosition> parse(@NonNull String source, String rootRuleName) {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        StringReader reader = new StringReader(source);
        try {
            SyntaxTreeNode<TextPosition> syntaxTreeNode = this.parse(reader, rootRuleName);
            reader.close();
            return syntaxTreeNode;
        }
        catch (Throwable throwable) {
            try {
                reader.close();
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void validate(Reader source, String rootRuleName) throws IOException {
        this.parse(source, rootRuleName, new NoActionListener<TextPosition>());
    }

    public void validate(String source, String rootRuleName) {
        this.parse(source, rootRuleName, new NoActionListener<TextPosition>());
    }
}

