/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.trace.api.preformance;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.sun.management.GarbageCollectorMXBean;
import com.ubnt.service.trace.api.preformance.GcCycleStats;
import java.util.Arrays;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class GcTypeInfo {
    private String name;
    private List<String> memoryPoolNames;
    private Long collectionCount;
    private Long collectionTimeMillis;
    private GcCycleStats lastGcCycleStats;

    public String getName() {
        return this.name;
    }

    public List<String> getMemoryPoolNames() {
        return this.memoryPoolNames;
    }

    public Long getCollectionCount() {
        return this.collectionCount;
    }

    public Long getCollectionTimeMillis() {
        return this.collectionTimeMillis;
    }

    public GcCycleStats getLastGcCycleStats() {
        return this.lastGcCycleStats;
    }

    public static GcTypeInfo of(GarbageCollectorMXBean garbageCollectorMXBean) {
        GcTypeInfo gcTypeInfo = new GcTypeInfo();
        gcTypeInfo.name = garbageCollectorMXBean.getName();
        gcTypeInfo.memoryPoolNames = Arrays.asList(garbageCollectorMXBean.getMemoryPoolNames());
        gcTypeInfo.collectionCount = garbageCollectorMXBean.getCollectionCount();
        gcTypeInfo.collectionTimeMillis = garbageCollectorMXBean.getCollectionTime();
        gcTypeInfo.lastGcCycleStats = GcCycleStats.of(garbageCollectorMXBean.getLastGcInfo());
        return gcTypeInfo;
    }
}

