/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.sslinspection.logs.model;

import com.fasterxml.jackson.annotation.JsonValue;
import com.ubnt.service.sslinspection.logs.model.SslInspectionSearchEngineCategory;
import jakarta.annotation.Nullable;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;

public final class SslInspectionSearchEngine
extends Enum<SslInspectionSearchEngine> {
    public static final /* enum */ SslInspectionSearchEngine AOL = new SslInspectionSearchEngine("74", "AOL", "aol.com", SslInspectionSearchEngineCategory.SEARCH_ENGINE, true);
    public static final /* enum */ SslInspectionSearchEngine ASK = new SslInspectionSearchEngine("72", "Ask", "ask.com", SslInspectionSearchEngineCategory.SEARCH_ENGINE, true);
    public static final /* enum */ SslInspectionSearchEngine BILIBILI = new SslInspectionSearchEngine("79", "bilibili", "bilibili.com", SslInspectionSearchEngineCategory.SEARCH_ENGINE, true);
    public static final /* enum */ SslInspectionSearchEngine BAIDU = new SslInspectionSearchEngine("6", "Baidu", "baidu.com", SslInspectionSearchEngineCategory.SEARCH_ENGINE, true);
    public static final /* enum */ SslInspectionSearchEngine BING = new SslInspectionSearchEngine("30", "Bing", "bing.com", SslInspectionSearchEngineCategory.SEARCH_ENGINE, true);
    public static final /* enum */ SslInspectionSearchEngine CHAT_GPT = new SslInspectionSearchEngine("1012", "ChatGpt", "chatgpt.com", SslInspectionSearchEngineCategory.LLM, true);
    public static final /* enum */ SslInspectionSearchEngine CLOUDE_AI = new SslInspectionSearchEngine("1014", "ClaudeAI", "claude.ai", SslInspectionSearchEngineCategory.LLM, false);
    public static final /* enum */ SslInspectionSearchEngine DUCK_DUCK_GO = new SslInspectionSearchEngine("41", "DuckDuckGo", "duckduckgo.com", SslInspectionSearchEngineCategory.SEARCH_ENGINE, true);
    public static final /* enum */ SslInspectionSearchEngine GOOGLE = new SslInspectionSearchEngine("1", "Google", "google.com", SslInspectionSearchEngineCategory.SEARCH_ENGINE, true);
    public static final /* enum */ SslInspectionSearchEngine META_AI = new SslInspectionSearchEngine("1013", "MetaAI", "meta.ai", SslInspectionSearchEngineCategory.LLM, false);
    public static final /* enum */ SslInspectionSearchEngine NAVER = new SslInspectionSearchEngine("31", "Naver", "naver.com", SslInspectionSearchEngineCategory.SEARCH_ENGINE, true);
    public static final /* enum */ SslInspectionSearchEngine SEARCH = new SslInspectionSearchEngine("73", "Search", "search.com", SslInspectionSearchEngineCategory.SEARCH_ENGINE, true);
    public static final /* enum */ SslInspectionSearchEngine YAHOO = new SslInspectionSearchEngine("8", "Yahoo", "yahoo.com", SslInspectionSearchEngineCategory.SEARCH_ENGINE, true);
    public static final /* enum */ SslInspectionSearchEngine YANDEX = new SslInspectionSearchEngine("9", "Yandex", "yandex.com", SslInspectionSearchEngineCategory.SEARCH_ENGINE, true);
    public static final /* enum */ SslInspectionSearchEngine YOUTUBE = new SslInspectionSearchEngine("2", "YouTube", "youtube.com", SslInspectionSearchEngineCategory.SEARCH_ENGINE, true);
    private static final String ANY_REGIONAL_GOOGLE_DOMAIN_MATCH = "google.";
    private static final List<SslInspectionSearchEngine> ALL;
    private final String id;
    private final String name;
    private final String domain;
    private final SslInspectionSearchEngineCategory category;
    private final boolean allowedForInclusion;
    private static final /* synthetic */ SslInspectionSearchEngine[] $VALUES;

    public static SslInspectionSearchEngine[] values() {
        return (SslInspectionSearchEngine[])$VALUES.clone();
    }

    public static SslInspectionSearchEngine valueOf(String string) {
        return Enum.valueOf(SslInspectionSearchEngine.class, string);
    }

    private SslInspectionSearchEngine(String string2, String string3, String string4, SslInspectionSearchEngineCategory sslInspectionSearchEngineCategory, boolean bl) {
        this.id = string2;
        this.name = string3;
        this.domain = string4;
        this.category = sslInspectionSearchEngineCategory;
        this.allowedForInclusion = bl;
    }

    @JsonValue
    public String toString() {
        return this.getId();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDomain() {
        return this.domain;
    }

    public SslInspectionSearchEngineCategory getCategory() {
        return this.category;
    }

    public boolean isAllowedForInclusion() {
        return this.allowedForInclusion;
    }

    public static List<SslInspectionSearchEngine> all() {
        return ALL;
    }

    public static List<SslInspectionSearchEngine> allAllowedForInclusion() {
        return SslInspectionSearchEngine.all().stream().filter(SslInspectionSearchEngine::isAllowedForInclusion).toList();
    }

    public static Optional<SslInspectionSearchEngine> ofDomain(@Nullable String string) {
        return string != null ? Stream.of(SslInspectionSearchEngine.values()).filter(sslInspectionSearchEngine -> string.endsWith(sslInspectionSearchEngine.domain) || SslInspectionSearchEngine.\u00d200000(sslInspectionSearchEngine, string)).findAny() : Optional.empty();
    }

    private static boolean \u00d200000(SslInspectionSearchEngine sslInspectionSearchEngine, String string) {
        return sslInspectionSearchEngine == GOOGLE && string.contains(ANY_REGIONAL_GOOGLE_DOMAIN_MATCH);
    }

    private static /* synthetic */ SslInspectionSearchEngine[] \u00d300000() {
        return new SslInspectionSearchEngine[]{AOL, ASK, BILIBILI, BAIDU, BING, CHAT_GPT, CLOUDE_AI, DUCK_DUCK_GO, GOOGLE, META_AI, NAVER, SEARCH, YAHOO, YANDEX, YOUTUBE};
    }

    static {
        $VALUES = SslInspectionSearchEngine.\u00d300000();
        ALL = EnumSet.allOf(SslInspectionSearchEngine.class).stream().sorted(Comparator.comparingInt(Enum::ordinal)).toList();
    }
}

