/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.service.analytics.api.devicereport.wireless;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.ubnt.data.X;
import java.util.concurrent.TimeUnit;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class VapStats {
    private Long startTime;
    private Long endTime;
    private Long sumRxBytes;
    private Long sumTxBytes;
    private Double avgSatisfaction;
    private Double avgSnr;
    private Double avgRxTcpRtt;
    private Double avgTxTcpRtt;
    private Long sumRxTcpStalls;
    private Long sumTxTcpStalls;
    private Long avgWifiLatency;
    private Long sumTxMpduAttempts;
    private Long sumTxMpduRetries;
    private Long sumTxMpduXRetries;
    private Long sumWpaTimeouts;
    private Long sumDnsTimeouts;
    private Long sumDhcpTimeouts;
    private Long sumArpTimeouts;
    private Double avgClients;
    private Double avgClientsHighSatisfaction;
    private Double avgClientsLowSatisfaction;
    private Double avgPhyRate;
    private Integer highSatisfactionLevel = 80;
    private Integer lowSatisfactionLevel = 70;

    public VapStats(X x2, long l2) {
        Long l3 = x2.getLongOrNull("wifi_tx_latency_avg");
        this.startTime = x2.getLong("time");
        this.endTime = l2;
        this.sumRxBytes = x2.getLong("rx_bytes");
        this.sumTxBytes = x2.getLong("tx_bytes");
        this.avgSatisfaction = x2.getDoubleOrNull("performance");
        this.avgSnr = x2.getDoubleOrNull("client_signal_avg");
        this.avgRxTcpRtt = x2.getDoubleOrNull("rx_tcp_lat_avg");
        this.avgTxTcpRtt = x2.getDoubleOrNull("tx_tcp_lat_avg");
        this.sumRxTcpStalls = x2.getLong("rx_tcp_stalls");
        this.sumTxTcpStalls = x2.getLong("tx_tcp_stalls");
        this.avgWifiLatency = l3 != null ? Long.valueOf(TimeUnit.MICROSECONDS.toMillis(l3)) : l3;
        this.sumTxMpduAttempts = x2.getLong("tx_total");
        this.sumTxMpduRetries = x2.getLong("tx_retries");
        this.sumTxMpduXRetries = x2.getLong("wifi_tx_dropped");
        this.sumWpaTimeouts = x2.getLong("sta_wpa_auth_failures");
        this.sumDnsTimeouts = x2.getLong("sta_dns_failures");
        this.sumDhcpTimeouts = x2.getLong("sta_dhcp_failures");
        this.sumArpTimeouts = x2.getLong("sta_arp_failures");
        this.avgClients = x2.getDouble("num_sta_avg");
        this.avgClientsHighSatisfaction = x2.getDoubleOrNull("ratio_sta_high_ux_avg");
        this.avgClientsLowSatisfaction = x2.getDoubleOrNull("ratio_sta_low_ux_avg");
        this.avgPhyRate = x2.getDoubleOrNull("sta_tx_rate");
    }

    public Long getStartTime() {
        return this.startTime;
    }

    public Long getEndTime() {
        return this.endTime;
    }

    public Long getSumRxBytes() {
        return this.sumRxBytes;
    }

    public Long getSumTxBytes() {
        return this.sumTxBytes;
    }

    public Double getAvgSatisfaction() {
        return this.avgSatisfaction;
    }

    public Double getAvgSnr() {
        return this.avgSnr;
    }

    public Double getAvgRxTcpRtt() {
        return this.avgRxTcpRtt;
    }

    public Double getAvgTxTcpRtt() {
        return this.avgTxTcpRtt;
    }

    public Long getSumRxTcpStalls() {
        return this.sumRxTcpStalls;
    }

    public Long getSumTxTcpStalls() {
        return this.sumTxTcpStalls;
    }

    public Long getAvgWifiLatency() {
        return this.avgWifiLatency;
    }

    public Long getSumTxMpduAttempts() {
        return this.sumTxMpduAttempts;
    }

    public Long getSumTxMpduRetries() {
        return this.sumTxMpduRetries;
    }

    public Long getSumTxMpduXRetries() {
        return this.sumTxMpduXRetries;
    }

    public Long getSumWpaTimeouts() {
        return this.sumWpaTimeouts;
    }

    public Long getSumDnsTimeouts() {
        return this.sumDnsTimeouts;
    }

    public Long getSumDhcpTimeouts() {
        return this.sumDhcpTimeouts;
    }

    public Long getSumArpTimeouts() {
        return this.sumArpTimeouts;
    }

    public Double getAvgClients() {
        return this.avgClients;
    }

    public Double getAvgClientsHighSatisfaction() {
        return this.avgClientsHighSatisfaction;
    }

    public Double getAvgClientsLowSatisfaction() {
        return this.avgClientsLowSatisfaction;
    }

    public Double getAvgPhyRate() {
        return this.avgPhyRate;
    }

    public Integer getHighSatisfactionLevel() {
        return this.highSatisfactionLevel;
    }

    public Integer getLowSatisfactionLevel() {
        return this.lowSatisfactionLevel;
    }
}

