/*
 * Decompiled with CFR 0.152.
 */
package com.ubnt.model.api.topology;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ubnt.model.api.topology.PendingDeviceEdgeDto;
import com.ubnt.model.api.topology.WiredClientEdgeDto;
import com.ubnt.model.api.topology.WiredDeviceEdgeDto;
import com.ubnt.model.api.topology.WirelessClientEdgeDto;
import com.ubnt.model.api.topology.WirelessDeviceEdgeDto;
import com.ubnt.model.api.topology.exception.UnknownEdgeClassException;
import com.ubnt.service.system.superclass;
import com.ubnt.service.topology.C;
import com.ubnt.service.topology.L;
import com.ubnt.service.topology.T;
import com.ubnt.service.topology.class;
import com.ubnt.service.topology.o00O;
import com.ubnt.service.topology.private;
import com.ubnt.service.topology.while;
import com.ubnt.service.trace.logerror.AnalyticsAppender;
import java.util.Optional;

public abstract class TopologyEdgeDto {
    @JsonProperty(value="type")
    public abstract while getType();

    @JsonProperty(value="uplinkMac")
    public abstract String getUplinkMac();

    @JsonProperty(value="downlinkMac")
    public abstract String getDownlinkMac();

    @JsonProperty(value="networkId")
    public abstract Optional<String> getNetworkId();

    public static TopologyEdgeDto of(C c2) {
        if (c2 instanceof class) {
            return WiredDeviceEdgeDto.of((class)c2);
        }
        if (c2 instanceof L) {
            return WirelessDeviceEdgeDto.of((L)c2);
        }
        if (c2 instanceof o00O) {
            return WiredClientEdgeDto.of((o00O)c2);
        }
        if (c2 instanceof T) {
            return WirelessClientEdgeDto.of((T)c2);
        }
        if (c2 instanceof private) {
            return PendingDeviceEdgeDto.of((private)c2);
        }
        superclass.\u00d300000.error(AnalyticsAppender.SEND_TO_ANALYTICS, "Unknown topology edge class: {}", (Object)c2);
        throw new UnknownEdgeClassException(c2);
    }
}

