/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.util;

import io.jenetics.util.ISeq;
import io.jenetics.util.MSeq;
import io.jenetics.util.SeqList;
import io.jenetics.util.SeqSpliterator;
import io.jenetics.util.SeqView;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Seq<T>
extends Iterable<T>,
IntFunction<T> {
    public static final Seq<?> EMPTY = ISeq.EMPTY;

    public T get(int var1);

    @Override
    default public T apply(int index) {
        return this.get(index);
    }

    public int length();

    default public int size() {
        return this.length();
    }

    default public boolean isEmpty() {
        return this.length() == 0;
    }

    default public boolean nonEmpty() {
        return !this.isEmpty();
    }

    default public boolean forAll(Predicate<? super T> predicate) {
        boolean valid = true;
        if (this instanceof RandomAccess) {
            int n = this.length();
            for (int i = 0; i < n && valid; ++i) {
                valid = predicate.test(this.get(i));
            }
        } else {
            Iterator<T> it = this.iterator();
            while (it.hasNext() && valid) {
                valid = predicate.test(it.next());
            }
        }
        return valid;
    }

    @Override
    default public Iterator<T> iterator() {
        return this.asList().iterator();
    }

    default public ListIterator<T> listIterator() {
        return this.asList().listIterator();
    }

    default public Stream<T> stream() {
        return StreamSupport.stream(new SeqSpliterator(this), false);
    }

    default public Stream<T> parallelStream() {
        return StreamSupport.stream(new SeqSpliterator(this), true);
    }

    @Override
    default public Spliterator<T> spliterator() {
        return new SeqSpliterator(this);
    }

    default public boolean contains(Object element) {
        return this.indexOf(element) != -1;
    }

    default public int indexOf(Object element) {
        return this.indexOf(element, 0, this.length());
    }

    default public int indexOf(Object element, int start) {
        return this.indexOf(element, start, this.length());
    }

    default public int indexOf(Object element, int start, int end) {
        return element != null ? this.indexWhere(element::equals, start, end) : this.indexWhere(Objects::isNull, start, end);
    }

    default public int indexWhere(Predicate<? super T> predicate) {
        return this.indexWhere(predicate, 0, this.length());
    }

    default public int indexWhere(Predicate<? super T> predicate, int start) {
        return this.indexWhere(predicate, start, this.length());
    }

    default public int indexWhere(Predicate<? super T> predicate, int start, int end) {
        Objects.requireNonNull(predicate, "Predicate");
        io.jenetics.internal.collection.Array.checkIndex(start, end, this.length());
        int index = -1;
        for (int i = start; i < end && index == -1; ++i) {
            if (!predicate.test(this.get(i))) continue;
            index = i;
        }
        return index;
    }

    default public int lastIndexOf(Object element) {
        return this.lastIndexOf(element, 0, this.length());
    }

    default public int lastIndexOf(Object element, int end) {
        return this.lastIndexOf(element, 0, end);
    }

    default public int lastIndexOf(Object element, int start, int end) {
        return element != null ? this.lastIndexWhere(element::equals, start, end) : this.lastIndexWhere(Objects::isNull, start, end);
    }

    default public int lastIndexWhere(Predicate<? super T> predicate) {
        return this.lastIndexWhere(predicate, 0, this.length());
    }

    default public int lastIndexWhere(Predicate<? super T> predicate, int end) {
        return this.lastIndexWhere(predicate, 0, end);
    }

    default public int lastIndexWhere(Predicate<? super T> predicate, int start, int end) {
        Objects.requireNonNull(predicate, "Predicate");
        io.jenetics.internal.collection.Array.checkIndex(start, end, this.length());
        int index = -1;
        int i = end;
        while (--i >= start && index == -1) {
            if (!predicate.test(this.get(i))) continue;
            index = i;
        }
        return index;
    }

    public <B> Seq<B> map(Function<? super T, ? extends B> var1);

    default public Seq<T> append(T ... values) {
        return this.append((Iterable<? extends T>)Seq.of(values));
    }

    public Seq<T> append(Iterable<? extends T> var1);

    default public Seq<T> prepend(T ... values) {
        return this.prepend((Iterable<? extends T>)Seq.of(values));
    }

    public Seq<T> prepend(Iterable<? extends T> var1);

    default public List<T> asList() {
        return new SeqList(this);
    }

    default public Object[] toArray() {
        Object[] array2 = new Object[this.size()];
        int i = this.size();
        while (--i >= 0) {
            array2[i] = this.get(i);
        }
        return array2;
    }

    default public <B> B[] toArray(B[] array2) {
        if (array2.length < this.length()) {
            Object[] copy = (Object[])Array.newInstance(array2.getClass().getComponentType(), this.length());
            int i = this.length();
            while (--i >= 0) {
                copy[i] = this.get(i);
            }
            return copy;
        }
        int n = this.length();
        for (int i = 0; i < n; ++i) {
            array2[i] = this.get(i);
        }
        if (array2.length > this.length()) {
            array2[this.length()] = null;
        }
        return array2;
    }

    public Seq<T> subSeq(int var1);

    public Seq<T> subSeq(int var1, int var2);

    default public boolean isSorted() {
        boolean sorted = true;
        int n = this.length() - 1;
        for (int i = 0; i < n && sorted; ++i) {
            sorted = ((Comparable)this.get(i)).compareTo(this.get(i + 1)) <= 0;
        }
        return sorted;
    }

    default public boolean isSorted(Comparator<? super T> comparator) {
        boolean sorted = true;
        int n = this.length() - 1;
        for (int i = 0; i < n && sorted; ++i) {
            sorted = comparator.compare(this.get(i), this.get(i + 1)) <= 0;
        }
        return sorted;
    }

    default public MSeq<T> asMSeq() {
        return this instanceof MSeq ? (MSeq)this : MSeq.of(this);
    }

    default public ISeq<T> asISeq() {
        return this instanceof ISeq ? (ISeq)this : ISeq.of(this);
    }

    public int hashCode();

    public boolean equals(Object var1);

    default public String toString(String prefix, String separator, String suffix) {
        return this.stream().map(Objects::toString).collect(Collectors.joining(separator, prefix, suffix));
    }

    default public String toString(String separator) {
        return this.toString("", separator, "");
    }

    public static int hashCode(Seq<?> seq) {
        int hash = 1;
        for (Object element : seq) {
            hash = 31 * hash + (element == null ? 0 : element.hashCode());
        }
        return hash;
    }

    public static boolean equals(Seq<?> seq, Object obj) {
        if (obj == seq) {
            return true;
        }
        if (!(obj instanceof Seq)) {
            return false;
        }
        Seq other = (Seq)obj;
        boolean equals = seq.length() == other.length();
        int i = seq.length();
        while (equals && --i >= 0) {
            Object element = seq.get(i);
            if (element != null) {
                equals = element.equals(other.get(i));
                continue;
            }
            equals = other.get(i) == null;
        }
        return equals;
    }

    public static <T> Seq<T> empty() {
        return ISeq.empty();
    }

    public static <T> Collector<T, ?, Seq<T>> toSeq() {
        return Collector.of(ArrayList::new, List::add, (left, right) -> {
            left.addAll(right);
            return left;
        }, Seq::of, new Collector.Characteristics[0]);
    }

    @SafeVarargs
    public static <T> Seq<T> of(T ... values) {
        return ISeq.of(values);
    }

    public static <T> Seq<T> of(Iterable<? extends T> values) {
        return ISeq.of(values);
    }

    public static <T> Seq<T> of(Supplier<? extends T> supplier, int length) {
        return ISeq.of(supplier, length);
    }

    public static <T> Seq<T> viewOf(List<? extends T> list) {
        return list.isEmpty() ? Seq.empty() : new SeqView<T>(list);
    }

    public static <T> Seq<T> viewOf(T[] array2) {
        return array2.length == 0 ? Seq.empty() : new SeqView<T>(Arrays.asList(array2));
    }
}

