/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.util;

import java.util.Comparator;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;

public final class LimitSpliterator<T>
implements Spliterator<T> {
    private final Spliterator<T> _spliterator;
    private final Predicate<? super T> _proceed;
    private boolean _limited = false;

    private LimitSpliterator(Spliterator<T> spliterator, Predicate<? super T> proceed) {
        this._spliterator = Objects.requireNonNull(spliterator);
        this._proceed = Objects.requireNonNull(proceed);
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        boolean hasNext = this._spliterator.tryAdvance(element -> {
            if (this._proceed.test(element)) {
                action.accept(element);
            } else {
                this._limited = true;
            }
        });
        return hasNext && !this._limited;
    }

    @Override
    public Spliterator<T> trySplit() {
        Spliterator<T> split = this._spliterator.trySplit();
        return split == null ? null : new LimitSpliterator<T>(split, this._proceed);
    }

    @Override
    public long estimateSize() {
        return 0L;
    }

    @Override
    public int characteristics() {
        return this._spliterator.characteristics() & 0xFFFFFFBF & 0xFFFFBFFF;
    }

    @Override
    public Comparator<? super T> getComparator() {
        return this._spliterator.getComparator();
    }

    public static <T> LimitSpliterator<T> of(Spliterator<T> spliterator, Predicate<? super T> proceed) {
        return new LimitSpliterator<T>(spliterator, proceed);
    }
}

