/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import io.jenetics.Gene;
import io.jenetics.Phenotype;
import io.jenetics.internal.util.require;
import io.jenetics.util.ISeq;
import java.util.Objects;

public final class EvolutionStart<G extends Gene<?, G>, C extends Comparable<? super C>> {
    private final ISeq<Phenotype<G, C>> _population;
    private final long _generation;

    private EvolutionStart(ISeq<Phenotype<G, C>> population, long generation) {
        this._population = Objects.requireNonNull(population);
        this._generation = require.positive(generation);
    }

    public ISeq<Phenotype<G, C>> getPopulation() {
        return this._population;
    }

    public long getGeneration() {
        return this._generation;
    }

    public int hashCode() {
        int hash = 17;
        hash = (int)((long)hash + (31L * this._generation + 17L));
        return hash += 31 * Objects.hashCode(this._population) + 17;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof EvolutionStart && this._generation == ((EvolutionStart)obj)._generation && Objects.equals(this._population, ((EvolutionStart)obj)._population);
    }

    public String toString() {
        return String.format("EvolutionStart[population-size=%d, generation=%d]", this._population.size(), this._generation);
    }

    public static <G extends Gene<?, G>, C extends Comparable<? super C>> EvolutionStart<G, C> of(ISeq<Phenotype<G, C>> population, long generation) {
        return new EvolutionStart<G, C>(population, generation);
    }
}

