/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Gene;
import io.jenetics.Optimize;
import io.jenetics.Phenotype;
import io.jenetics.Selector;
import io.jenetics.internal.util.Equality;
import io.jenetics.internal.util.Hash;
import io.jenetics.util.ISeq;
import io.jenetics.util.MSeq;
import io.jenetics.util.Seq;
import java.util.Objects;

public final class TruncationSelector<G extends Gene<?, G>, C extends Comparable<? super C>>
implements Selector<G, C> {
    private final int _n;

    public TruncationSelector(int n) {
        if (n < 1) {
            throw new IllegalArgumentException(String.format("n must be greater or equal 1, but was %d.", n));
        }
        this._n = n;
    }

    public TruncationSelector() {
        this(Integer.MAX_VALUE);
    }

    @Override
    public ISeq<Phenotype<G, C>> select(Seq<Phenotype<G, C>> population, int count, Optimize opt) {
        Objects.requireNonNull(population, "Population");
        Objects.requireNonNull(opt, "Optimization");
        if (count < 0) {
            throw new IllegalArgumentException(String.format("Selection count must be greater or equal then zero, but was %s", count));
        }
        MSeq selection = MSeq.ofLength(population.isEmpty() ? 0 : count);
        if (count > 0 && !population.isEmpty()) {
            int length;
            Object copy = population.asISeq().copy();
            copy.sort((a, b) -> opt.descending().compare(a.getFitness(), b.getFitness()));
            int size = count;
            do {
                length = Math.min(Math.min(copy.size(), size), this._n);
                for (int i = 0; i < length; ++i) {
                    selection.set(count - size + i, copy.get(i));
                }
            } while ((size -= length) > 0);
        }
        return selection.toISeq();
    }

    public int hashCode() {
        return Hash.of(this.getClass()).value();
    }

    public boolean equals(Object obj) {
        return Equality.ofType(this, obj);
    }

    public String toString() {
        return this.getClass().getName();
    }
}

