/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.Chromosome;
import io.jenetics.Gene;
import io.jenetics.internal.util.Equality;
import io.jenetics.util.Factory;
import io.jenetics.util.ISeq;
import io.jenetics.util.MSeq;
import io.jenetics.util.Seq;
import io.jenetics.util.Verifiable;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;

public final class Genotype<G extends Gene<?, G>>
implements Factory<Genotype<G>>,
Iterable<Chromosome<G>>,
Verifiable,
Serializable {
    private static final long serialVersionUID = 3L;
    private final ISeq<Chromosome<G>> _chromosomes;
    private volatile Boolean _valid = null;

    Genotype(ISeq<? extends Chromosome<G>> chromosomes) {
        if (chromosomes.isEmpty()) {
            throw new IllegalArgumentException("No chromosomes given.");
        }
        this._chromosomes = ISeq.upcast(chromosomes);
    }

    private static int ngenes(Seq<? extends Chromosome<?>> chromosomes) {
        int count = 0;
        int n = chromosomes.length();
        for (int i = 0; i < n; ++i) {
            count += chromosomes.get(i).length();
        }
        return count;
    }

    public Chromosome<G> getChromosome(int index) {
        assert (this._chromosomes != null);
        assert (this._chromosomes.get(index) != null);
        return (Chromosome)this._chromosomes.get(index);
    }

    public Chromosome<G> getChromosome() {
        assert (this._chromosomes != null);
        assert (this._chromosomes.get(0) != null);
        return (Chromosome)this._chromosomes.get(0);
    }

    public G getGene() {
        assert (this._chromosomes != null);
        assert (this._chromosomes.get(0) != null);
        return ((Chromosome)this._chromosomes.get(0)).getGene();
    }

    public G get(int chromosomeIndex, int geneIndex) {
        return this.getChromosome(chromosomeIndex).getGene(geneIndex);
    }

    public Chromosome<G> get(int chromosomeIndex) {
        return this.getChromosome(chromosomeIndex);
    }

    public ISeq<Chromosome<G>> toSeq() {
        return this._chromosomes;
    }

    @Override
    public Iterator<Chromosome<G>> iterator() {
        return this._chromosomes.iterator();
    }

    public Stream<Chromosome<G>> stream() {
        return this._chromosomes.stream();
    }

    public int length() {
        return this._chromosomes.length();
    }

    public int geneCount() {
        int count = 0;
        int n = this._chromosomes.length();
        for (int i = 0; i < n; ++i) {
            count += ((Chromosome)this._chromosomes.get(i)).length();
        }
        return count;
    }

    @Override
    public boolean isValid() {
        Boolean valid = this._valid;
        if (valid == null) {
            this._valid = valid = Boolean.valueOf(this._chromosomes.forAll(Verifiable::isValid));
        }
        return this._valid;
    }

    @Override
    public Genotype<G> newInstance() {
        return new Genotype<G>(this._chromosomes.map(Factory::newInstance));
    }

    public int hashCode() {
        int hash = 17;
        return hash += 31 * Objects.hashCode(this._chromosomes) + 37;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Genotype && Equality.eq(this._chromosomes, ((Genotype)obj)._chromosomes);
    }

    public String toString() {
        return this._chromosomes.toString();
    }

    @SafeVarargs
    public static <G extends Gene<?, G>> Genotype<G> of(Chromosome<G> first, Chromosome<G> ... rest) {
        MSeq<Chromosome<G>> seq = MSeq.ofLength(1 + rest.length);
        seq.set(0, first);
        for (int i = 0; i < rest.length; ++i) {
            seq.set(i + 1, rest[i]);
        }
        return new Genotype<G>(seq.toISeq());
    }

    public static <G extends Gene<?, G>> Genotype<G> of(Factory<? extends Chromosome<G>> factory, int n) {
        ISeq<Chromosome> ch = ISeq.of(factory::newInstance, n);
        return new Genotype<G>(ch);
    }

    public static <G extends Gene<?, G>> Genotype<G> of(Iterable<? extends Chromosome<G>> chromosomes) {
        return new Genotype<G>(ISeq.of(chromosomes));
    }
}

