/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.BitGene;
import io.jenetics.BitGeneISeq;
import io.jenetics.BitGeneStore;
import io.jenetics.internal.collection.Array;
import io.jenetics.internal.collection.ArrayMSeq;
import io.jenetics.internal.util.bit;
import io.jenetics.util.MSeq;

final class BitGeneMSeq
extends ArrayMSeq<BitGene> {
    private static final long serialVersionUID = 1L;

    private BitGeneMSeq(Array<BitGene> array2) {
        super(array2);
        assert (array2.store() instanceof BitGeneStore);
    }

    @Override
    public void swap(int i, int j) {
        this.array.checkIndex(i);
        this.array.checkIndex(j);
        this.array.copyIfSealed();
        byte[] bytes = ((BitGeneStore)this.array.store()).array;
        boolean temp = bit.get(bytes, i);
        bit.set(bytes, i, bit.get(bytes, j));
        bit.set(bytes, j, temp);
    }

    @Override
    public void swap(int start, int end, MSeq<BitGene> other, int otherStart) {
        if (other instanceof BitGeneMSeq) {
            this.checkIndex(start, end, otherStart, other.length());
            BitGeneMSeq otherMSeq = (BitGeneMSeq)other;
            BitGeneStore thisStore = (BitGeneStore)this.array.store();
            BitGeneStore otherStore = (BitGeneStore)otherMSeq.array.store();
            this.array.copyIfSealed();
            otherMSeq.array.copyIfSealed();
            thisStore.swap(start, end, otherStore, otherStart);
        } else {
            super.swap(start, end, other, otherStart);
        }
    }

    @Override
    public BitGeneMSeq copy() {
        return new BitGeneMSeq(this.array.copy());
    }

    public BitGeneISeq toISeq() {
        return new BitGeneISeq(this.array.seal());
    }

    static BitGeneMSeq of(byte[] genes, int length) {
        return new BitGeneMSeq(Array.of(BitGeneStore.of(genes, length)));
    }

    static BitGeneMSeq of(Array<BitGene> array2) {
        return new BitGeneMSeq(array2);
    }
}

