/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.ipv6;

import com.googlecode.ipv6.IPv6Address;
import com.googlecode.ipv6.IPv6Network;
import com.googlecode.ipv6.IPv6NetworkMask;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class IPv6AddressRange
implements Comparable<IPv6AddressRange>,
Iterable<IPv6Address>,
Serializable {
    private final IPv6Address first;
    private final IPv6Address last;

    IPv6AddressRange(IPv6Address first, IPv6Address last) {
        if (first.compareTo(last) > 0) {
            throw new IllegalArgumentException("Cannot create ip address range with last address < first address");
        }
        this.first = first;
        this.last = last;
    }

    public static IPv6AddressRange fromFirstAndLast(IPv6Address first, IPv6Address last) {
        return new IPv6AddressRange(first, last);
    }

    public boolean contains(IPv6Address address) {
        return this.first.compareTo(address) <= 0 && this.last.compareTo(address) >= 0;
    }

    public boolean contains(IPv6AddressRange range) {
        return this.contains(range.first) && this.contains(range.last);
    }

    public boolean overlaps(IPv6AddressRange range) {
        return this.contains(range.first) || this.contains(range.last) || range.contains(this.first) || range.contains(this.last);
    }

    @Override
    public Iterator<IPv6Address> iterator() {
        return new IPv6AddressRangeIterator();
    }

    public BigInteger size() {
        BigInteger firstAsBigInteger = new BigInteger(1, this.first.toByteArray());
        BigInteger lastAsBigInteger = new BigInteger(1, this.last.toByteArray());
        return lastAsBigInteger.subtract(firstAsBigInteger).add(BigInteger.ONE);
    }

    public Iterator<IPv6Network> toSubnets() {
        return new IPv6AddressRangeAsSubnetsIterator();
    }

    public List<IPv6AddressRange> remove(IPv6Address address) {
        if (address == null) {
            throw new IllegalArgumentException("invalid address [null]");
        }
        if (!this.contains(address)) {
            return Collections.singletonList(this);
        }
        if (address.equals(this.first) && address.equals(this.last)) {
            return Collections.emptyList();
        }
        if (address.equals(this.first)) {
            return Collections.singletonList(IPv6AddressRange.fromFirstAndLast(this.first.add(1), this.last));
        }
        if (address.equals(this.last)) {
            return Collections.singletonList(IPv6AddressRange.fromFirstAndLast(this.first, this.last.subtract(1)));
        }
        return Arrays.asList(IPv6AddressRange.fromFirstAndLast(this.first, address.subtract(1)), IPv6AddressRange.fromFirstAndLast(address.add(1), this.last));
    }

    public IPv6AddressRange extend(IPv6Address address) {
        if (address.compareTo(this.first) < 0) {
            return IPv6AddressRange.fromFirstAndLast(address, this.last);
        }
        if (address.compareTo(this.last) > 0) {
            return IPv6AddressRange.fromFirstAndLast(this.first, address);
        }
        return this;
    }

    public List<IPv6AddressRange> remove(IPv6Network network) {
        if (network == null) {
            throw new IllegalArgumentException("invalid network [null]");
        }
        if (!this.contains(network)) {
            return Collections.singletonList(this);
        }
        if (this.equals(network)) {
            return Collections.emptyList();
        }
        if (this.first.equals(network.getFirst())) {
            return Collections.singletonList(IPv6AddressRange.fromFirstAndLast(network.getLast().add(1), this.last));
        }
        if (this.last.equals(network.getLast())) {
            return Collections.singletonList(IPv6AddressRange.fromFirstAndLast(this.first, network.getFirst().subtract(1)));
        }
        return Arrays.asList(IPv6AddressRange.fromFirstAndLast(this.first, network.getFirst().subtract(1)), IPv6AddressRange.fromFirstAndLast(network.getLast().add(1), this.last));
    }

    public String toString() {
        return this.first.toString() + " - " + this.last.toString();
    }

    public String toLongString() {
        return this.first.toLongString() + " - " + this.last.toLongString();
    }

    @Override
    public int compareTo(IPv6AddressRange that) {
        if (!this.first.equals(that.first)) {
            return this.first.compareTo(that.first);
        }
        return this.last.compareTo(that.last);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IPv6AddressRange)) {
            return false;
        }
        IPv6AddressRange that = (IPv6AddressRange)o;
        if (this.first != null ? !this.first.equals(that.first) : that.first != null) {
            return false;
        }
        return !(this.last != null ? !this.last.equals(that.last) : that.last != null);
    }

    public int hashCode() {
        int result = this.first != null ? this.first.hashCode() : 0;
        result = 31 * result + (this.last != null ? this.last.hashCode() : 0);
        return result;
    }

    public IPv6Address getFirst() {
        return this.first;
    }

    public IPv6Address getLast() {
        return this.last;
    }

    private class IPv6AddressRangeAsSubnetsIterator
    implements Iterator<IPv6Network> {
        private IPv6Address base;
        private IPv6Network next;

        private IPv6AddressRangeAsSubnetsIterator() {
            this.base = IPv6AddressRange.this.first;
        }

        @Override
        public IPv6Network next() {
            if (this.hasNext()) {
                int step;
                for (step = 0; step < 128 && !this.base.setBit(step).equals(this.base) && this.base.maximumAddressWithNetworkMask(IPv6NetworkMask.fromPrefixLength(127 - step)).compareTo(IPv6AddressRange.this.last) <= 0; ++step) {
                }
                this.next = IPv6Network.fromAddressAndMask(this.base, IPv6NetworkMask.fromPrefixLength(128 - step));
                this.base = this.next.getLast().compareTo(IPv6AddressRange.this.last) < 0 ? this.next.getLast().add(1) : null;
            } else {
                throw new NoSuchElementException();
            }
            return this.next;
        }

        @Override
        public boolean hasNext() {
            return this.base != null && this.base.compareTo(IPv6AddressRange.this.last) <= 0;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator provides read only access");
        }
    }

    private final class IPv6AddressRangeIterator
    implements Iterator<IPv6Address> {
        private IPv6Address current;

        private IPv6AddressRangeIterator() {
            this.current = IPv6AddressRange.this.first;
        }

        @Override
        public boolean hasNext() {
            return this.current.compareTo(IPv6AddressRange.this.last) <= 0;
        }

        @Override
        public IPv6Address next() {
            if (this.hasNext()) {
                IPv6Address result = this.current;
                this.current = this.current.add(1);
                return result;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator provides read only access");
        }
    }
}

