// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/eventarc/v1/eventarc.proto

package eventarcpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Eventarc_GetTrigger_FullMethodName                = "/google.cloud.eventarc.v1.Eventarc/GetTrigger"
	Eventarc_ListTriggers_FullMethodName              = "/google.cloud.eventarc.v1.Eventarc/ListTriggers"
	Eventarc_CreateTrigger_FullMethodName             = "/google.cloud.eventarc.v1.Eventarc/CreateTrigger"
	Eventarc_UpdateTrigger_FullMethodName             = "/google.cloud.eventarc.v1.Eventarc/UpdateTrigger"
	Eventarc_DeleteTrigger_FullMethodName             = "/google.cloud.eventarc.v1.Eventarc/DeleteTrigger"
	Eventarc_GetChannel_FullMethodName                = "/google.cloud.eventarc.v1.Eventarc/GetChannel"
	Eventarc_ListChannels_FullMethodName              = "/google.cloud.eventarc.v1.Eventarc/ListChannels"
	Eventarc_CreateChannel_FullMethodName             = "/google.cloud.eventarc.v1.Eventarc/CreateChannel"
	Eventarc_UpdateChannel_FullMethodName             = "/google.cloud.eventarc.v1.Eventarc/UpdateChannel"
	Eventarc_DeleteChannel_FullMethodName             = "/google.cloud.eventarc.v1.Eventarc/DeleteChannel"
	Eventarc_GetProvider_FullMethodName               = "/google.cloud.eventarc.v1.Eventarc/GetProvider"
	Eventarc_ListProviders_FullMethodName             = "/google.cloud.eventarc.v1.Eventarc/ListProviders"
	Eventarc_GetChannelConnection_FullMethodName      = "/google.cloud.eventarc.v1.Eventarc/GetChannelConnection"
	Eventarc_ListChannelConnections_FullMethodName    = "/google.cloud.eventarc.v1.Eventarc/ListChannelConnections"
	Eventarc_CreateChannelConnection_FullMethodName   = "/google.cloud.eventarc.v1.Eventarc/CreateChannelConnection"
	Eventarc_DeleteChannelConnection_FullMethodName   = "/google.cloud.eventarc.v1.Eventarc/DeleteChannelConnection"
	Eventarc_GetGoogleChannelConfig_FullMethodName    = "/google.cloud.eventarc.v1.Eventarc/GetGoogleChannelConfig"
	Eventarc_UpdateGoogleChannelConfig_FullMethodName = "/google.cloud.eventarc.v1.Eventarc/UpdateGoogleChannelConfig"
	Eventarc_GetMessageBus_FullMethodName             = "/google.cloud.eventarc.v1.Eventarc/GetMessageBus"
	Eventarc_ListMessageBuses_FullMethodName          = "/google.cloud.eventarc.v1.Eventarc/ListMessageBuses"
	Eventarc_ListMessageBusEnrollments_FullMethodName = "/google.cloud.eventarc.v1.Eventarc/ListMessageBusEnrollments"
	Eventarc_CreateMessageBus_FullMethodName          = "/google.cloud.eventarc.v1.Eventarc/CreateMessageBus"
	Eventarc_UpdateMessageBus_FullMethodName          = "/google.cloud.eventarc.v1.Eventarc/UpdateMessageBus"
	Eventarc_DeleteMessageBus_FullMethodName          = "/google.cloud.eventarc.v1.Eventarc/DeleteMessageBus"
	Eventarc_GetEnrollment_FullMethodName             = "/google.cloud.eventarc.v1.Eventarc/GetEnrollment"
	Eventarc_ListEnrollments_FullMethodName           = "/google.cloud.eventarc.v1.Eventarc/ListEnrollments"
	Eventarc_CreateEnrollment_FullMethodName          = "/google.cloud.eventarc.v1.Eventarc/CreateEnrollment"
	Eventarc_UpdateEnrollment_FullMethodName          = "/google.cloud.eventarc.v1.Eventarc/UpdateEnrollment"
	Eventarc_DeleteEnrollment_FullMethodName          = "/google.cloud.eventarc.v1.Eventarc/DeleteEnrollment"
	Eventarc_GetPipeline_FullMethodName               = "/google.cloud.eventarc.v1.Eventarc/GetPipeline"
	Eventarc_ListPipelines_FullMethodName             = "/google.cloud.eventarc.v1.Eventarc/ListPipelines"
	Eventarc_CreatePipeline_FullMethodName            = "/google.cloud.eventarc.v1.Eventarc/CreatePipeline"
	Eventarc_UpdatePipeline_FullMethodName            = "/google.cloud.eventarc.v1.Eventarc/UpdatePipeline"
	Eventarc_DeletePipeline_FullMethodName            = "/google.cloud.eventarc.v1.Eventarc/DeletePipeline"
	Eventarc_GetGoogleApiSource_FullMethodName        = "/google.cloud.eventarc.v1.Eventarc/GetGoogleApiSource"
	Eventarc_ListGoogleApiSources_FullMethodName      = "/google.cloud.eventarc.v1.Eventarc/ListGoogleApiSources"
	Eventarc_CreateGoogleApiSource_FullMethodName     = "/google.cloud.eventarc.v1.Eventarc/CreateGoogleApiSource"
	Eventarc_UpdateGoogleApiSource_FullMethodName     = "/google.cloud.eventarc.v1.Eventarc/UpdateGoogleApiSource"
	Eventarc_DeleteGoogleApiSource_FullMethodName     = "/google.cloud.eventarc.v1.Eventarc/DeleteGoogleApiSource"
)

// EventarcClient is the client API for Eventarc service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type EventarcClient interface {
	// Get a single trigger.
	GetTrigger(ctx context.Context, in *GetTriggerRequest, opts ...grpc.CallOption) (*Trigger, error)
	// List triggers.
	ListTriggers(ctx context.Context, in *ListTriggersRequest, opts ...grpc.CallOption) (*ListTriggersResponse, error)
	// Create a new trigger in a particular project and location.
	CreateTrigger(ctx context.Context, in *CreateTriggerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Update a single trigger.
	UpdateTrigger(ctx context.Context, in *UpdateTriggerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Delete a single trigger.
	DeleteTrigger(ctx context.Context, in *DeleteTriggerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Get a single Channel.
	GetChannel(ctx context.Context, in *GetChannelRequest, opts ...grpc.CallOption) (*Channel, error)
	// List channels.
	ListChannels(ctx context.Context, in *ListChannelsRequest, opts ...grpc.CallOption) (*ListChannelsResponse, error)
	// Create a new channel in a particular project and location.
	CreateChannel(ctx context.Context, in *CreateChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Update a single channel.
	UpdateChannel(ctx context.Context, in *UpdateChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Delete a single channel.
	DeleteChannel(ctx context.Context, in *DeleteChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Get a single Provider.
	GetProvider(ctx context.Context, in *GetProviderRequest, opts ...grpc.CallOption) (*Provider, error)
	// List providers.
	ListProviders(ctx context.Context, in *ListProvidersRequest, opts ...grpc.CallOption) (*ListProvidersResponse, error)
	// Get a single ChannelConnection.
	GetChannelConnection(ctx context.Context, in *GetChannelConnectionRequest, opts ...grpc.CallOption) (*ChannelConnection, error)
	// List channel connections.
	ListChannelConnections(ctx context.Context, in *ListChannelConnectionsRequest, opts ...grpc.CallOption) (*ListChannelConnectionsResponse, error)
	// Create a new ChannelConnection in a particular project and location.
	CreateChannelConnection(ctx context.Context, in *CreateChannelConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Delete a single ChannelConnection.
	DeleteChannelConnection(ctx context.Context, in *DeleteChannelConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Get a GoogleChannelConfig.
	// The name of the GoogleChannelConfig in the response is ALWAYS coded with
	// projectID.
	GetGoogleChannelConfig(ctx context.Context, in *GetGoogleChannelConfigRequest, opts ...grpc.CallOption) (*GoogleChannelConfig, error)
	// Update a single GoogleChannelConfig
	UpdateGoogleChannelConfig(ctx context.Context, in *UpdateGoogleChannelConfigRequest, opts ...grpc.CallOption) (*GoogleChannelConfig, error)
	// Get a single MessageBus.
	GetMessageBus(ctx context.Context, in *GetMessageBusRequest, opts ...grpc.CallOption) (*MessageBus, error)
	// List message buses.
	ListMessageBuses(ctx context.Context, in *ListMessageBusesRequest, opts ...grpc.CallOption) (*ListMessageBusesResponse, error)
	// List message bus enrollments.
	ListMessageBusEnrollments(ctx context.Context, in *ListMessageBusEnrollmentsRequest, opts ...grpc.CallOption) (*ListMessageBusEnrollmentsResponse, error)
	// Create a new MessageBus in a particular project and location.
	CreateMessageBus(ctx context.Context, in *CreateMessageBusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Update a single message bus.
	UpdateMessageBus(ctx context.Context, in *UpdateMessageBusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Delete a single message bus.
	DeleteMessageBus(ctx context.Context, in *DeleteMessageBusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Get a single Enrollment.
	GetEnrollment(ctx context.Context, in *GetEnrollmentRequest, opts ...grpc.CallOption) (*Enrollment, error)
	// List Enrollments.
	ListEnrollments(ctx context.Context, in *ListEnrollmentsRequest, opts ...grpc.CallOption) (*ListEnrollmentsResponse, error)
	// Create a new Enrollment in a particular project and location.
	CreateEnrollment(ctx context.Context, in *CreateEnrollmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Update a single Enrollment.
	UpdateEnrollment(ctx context.Context, in *UpdateEnrollmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Delete a single Enrollment.
	DeleteEnrollment(ctx context.Context, in *DeleteEnrollmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Get a single Pipeline.
	GetPipeline(ctx context.Context, in *GetPipelineRequest, opts ...grpc.CallOption) (*Pipeline, error)
	// List pipelines.
	ListPipelines(ctx context.Context, in *ListPipelinesRequest, opts ...grpc.CallOption) (*ListPipelinesResponse, error)
	// Create a new Pipeline in a particular project and location.
	CreatePipeline(ctx context.Context, in *CreatePipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Update a single pipeline.
	UpdatePipeline(ctx context.Context, in *UpdatePipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Delete a single pipeline.
	DeletePipeline(ctx context.Context, in *DeletePipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Get a single GoogleApiSource.
	GetGoogleApiSource(ctx context.Context, in *GetGoogleApiSourceRequest, opts ...grpc.CallOption) (*GoogleApiSource, error)
	// List GoogleApiSources.
	ListGoogleApiSources(ctx context.Context, in *ListGoogleApiSourcesRequest, opts ...grpc.CallOption) (*ListGoogleApiSourcesResponse, error)
	// Create a new GoogleApiSource in a particular project and location.
	CreateGoogleApiSource(ctx context.Context, in *CreateGoogleApiSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Update a single GoogleApiSource.
	UpdateGoogleApiSource(ctx context.Context, in *UpdateGoogleApiSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Delete a single GoogleApiSource.
	DeleteGoogleApiSource(ctx context.Context, in *DeleteGoogleApiSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type eventarcClient struct {
	cc grpc.ClientConnInterface
}

func NewEventarcClient(cc grpc.ClientConnInterface) EventarcClient {
	return &eventarcClient{cc}
}

func (c *eventarcClient) GetTrigger(ctx context.Context, in *GetTriggerRequest, opts ...grpc.CallOption) (*Trigger, error) {
	out := new(Trigger)
	err := c.cc.Invoke(ctx, Eventarc_GetTrigger_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) ListTriggers(ctx context.Context, in *ListTriggersRequest, opts ...grpc.CallOption) (*ListTriggersResponse, error) {
	out := new(ListTriggersResponse)
	err := c.cc.Invoke(ctx, Eventarc_ListTriggers_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) CreateTrigger(ctx context.Context, in *CreateTriggerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Eventarc_CreateTrigger_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) UpdateTrigger(ctx context.Context, in *UpdateTriggerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Eventarc_UpdateTrigger_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) DeleteTrigger(ctx context.Context, in *DeleteTriggerRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Eventarc_DeleteTrigger_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) GetChannel(ctx context.Context, in *GetChannelRequest, opts ...grpc.CallOption) (*Channel, error) {
	out := new(Channel)
	err := c.cc.Invoke(ctx, Eventarc_GetChannel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) ListChannels(ctx context.Context, in *ListChannelsRequest, opts ...grpc.CallOption) (*ListChannelsResponse, error) {
	out := new(ListChannelsResponse)
	err := c.cc.Invoke(ctx, Eventarc_ListChannels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) CreateChannel(ctx context.Context, in *CreateChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Eventarc_CreateChannel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) UpdateChannel(ctx context.Context, in *UpdateChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Eventarc_UpdateChannel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) DeleteChannel(ctx context.Context, in *DeleteChannelRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Eventarc_DeleteChannel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) GetProvider(ctx context.Context, in *GetProviderRequest, opts ...grpc.CallOption) (*Provider, error) {
	out := new(Provider)
	err := c.cc.Invoke(ctx, Eventarc_GetProvider_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) ListProviders(ctx context.Context, in *ListProvidersRequest, opts ...grpc.CallOption) (*ListProvidersResponse, error) {
	out := new(ListProvidersResponse)
	err := c.cc.Invoke(ctx, Eventarc_ListProviders_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) GetChannelConnection(ctx context.Context, in *GetChannelConnectionRequest, opts ...grpc.CallOption) (*ChannelConnection, error) {
	out := new(ChannelConnection)
	err := c.cc.Invoke(ctx, Eventarc_GetChannelConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) ListChannelConnections(ctx context.Context, in *ListChannelConnectionsRequest, opts ...grpc.CallOption) (*ListChannelConnectionsResponse, error) {
	out := new(ListChannelConnectionsResponse)
	err := c.cc.Invoke(ctx, Eventarc_ListChannelConnections_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) CreateChannelConnection(ctx context.Context, in *CreateChannelConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Eventarc_CreateChannelConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) DeleteChannelConnection(ctx context.Context, in *DeleteChannelConnectionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Eventarc_DeleteChannelConnection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) GetGoogleChannelConfig(ctx context.Context, in *GetGoogleChannelConfigRequest, opts ...grpc.CallOption) (*GoogleChannelConfig, error) {
	out := new(GoogleChannelConfig)
	err := c.cc.Invoke(ctx, Eventarc_GetGoogleChannelConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) UpdateGoogleChannelConfig(ctx context.Context, in *UpdateGoogleChannelConfigRequest, opts ...grpc.CallOption) (*GoogleChannelConfig, error) {
	out := new(GoogleChannelConfig)
	err := c.cc.Invoke(ctx, Eventarc_UpdateGoogleChannelConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) GetMessageBus(ctx context.Context, in *GetMessageBusRequest, opts ...grpc.CallOption) (*MessageBus, error) {
	out := new(MessageBus)
	err := c.cc.Invoke(ctx, Eventarc_GetMessageBus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) ListMessageBuses(ctx context.Context, in *ListMessageBusesRequest, opts ...grpc.CallOption) (*ListMessageBusesResponse, error) {
	out := new(ListMessageBusesResponse)
	err := c.cc.Invoke(ctx, Eventarc_ListMessageBuses_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) ListMessageBusEnrollments(ctx context.Context, in *ListMessageBusEnrollmentsRequest, opts ...grpc.CallOption) (*ListMessageBusEnrollmentsResponse, error) {
	out := new(ListMessageBusEnrollmentsResponse)
	err := c.cc.Invoke(ctx, Eventarc_ListMessageBusEnrollments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) CreateMessageBus(ctx context.Context, in *CreateMessageBusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Eventarc_CreateMessageBus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) UpdateMessageBus(ctx context.Context, in *UpdateMessageBusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Eventarc_UpdateMessageBus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) DeleteMessageBus(ctx context.Context, in *DeleteMessageBusRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Eventarc_DeleteMessageBus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) GetEnrollment(ctx context.Context, in *GetEnrollmentRequest, opts ...grpc.CallOption) (*Enrollment, error) {
	out := new(Enrollment)
	err := c.cc.Invoke(ctx, Eventarc_GetEnrollment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) ListEnrollments(ctx context.Context, in *ListEnrollmentsRequest, opts ...grpc.CallOption) (*ListEnrollmentsResponse, error) {
	out := new(ListEnrollmentsResponse)
	err := c.cc.Invoke(ctx, Eventarc_ListEnrollments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) CreateEnrollment(ctx context.Context, in *CreateEnrollmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Eventarc_CreateEnrollment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) UpdateEnrollment(ctx context.Context, in *UpdateEnrollmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Eventarc_UpdateEnrollment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) DeleteEnrollment(ctx context.Context, in *DeleteEnrollmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Eventarc_DeleteEnrollment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) GetPipeline(ctx context.Context, in *GetPipelineRequest, opts ...grpc.CallOption) (*Pipeline, error) {
	out := new(Pipeline)
	err := c.cc.Invoke(ctx, Eventarc_GetPipeline_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) ListPipelines(ctx context.Context, in *ListPipelinesRequest, opts ...grpc.CallOption) (*ListPipelinesResponse, error) {
	out := new(ListPipelinesResponse)
	err := c.cc.Invoke(ctx, Eventarc_ListPipelines_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) CreatePipeline(ctx context.Context, in *CreatePipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Eventarc_CreatePipeline_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) UpdatePipeline(ctx context.Context, in *UpdatePipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Eventarc_UpdatePipeline_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) DeletePipeline(ctx context.Context, in *DeletePipelineRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Eventarc_DeletePipeline_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) GetGoogleApiSource(ctx context.Context, in *GetGoogleApiSourceRequest, opts ...grpc.CallOption) (*GoogleApiSource, error) {
	out := new(GoogleApiSource)
	err := c.cc.Invoke(ctx, Eventarc_GetGoogleApiSource_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) ListGoogleApiSources(ctx context.Context, in *ListGoogleApiSourcesRequest, opts ...grpc.CallOption) (*ListGoogleApiSourcesResponse, error) {
	out := new(ListGoogleApiSourcesResponse)
	err := c.cc.Invoke(ctx, Eventarc_ListGoogleApiSources_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) CreateGoogleApiSource(ctx context.Context, in *CreateGoogleApiSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Eventarc_CreateGoogleApiSource_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) UpdateGoogleApiSource(ctx context.Context, in *UpdateGoogleApiSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Eventarc_UpdateGoogleApiSource_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *eventarcClient) DeleteGoogleApiSource(ctx context.Context, in *DeleteGoogleApiSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Eventarc_DeleteGoogleApiSource_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EventarcServer is the server API for Eventarc service.
// All implementations should embed UnimplementedEventarcServer
// for forward compatibility
type EventarcServer interface {
	// Get a single trigger.
	GetTrigger(context.Context, *GetTriggerRequest) (*Trigger, error)
	// List triggers.
	ListTriggers(context.Context, *ListTriggersRequest) (*ListTriggersResponse, error)
	// Create a new trigger in a particular project and location.
	CreateTrigger(context.Context, *CreateTriggerRequest) (*longrunningpb.Operation, error)
	// Update a single trigger.
	UpdateTrigger(context.Context, *UpdateTriggerRequest) (*longrunningpb.Operation, error)
	// Delete a single trigger.
	DeleteTrigger(context.Context, *DeleteTriggerRequest) (*longrunningpb.Operation, error)
	// Get a single Channel.
	GetChannel(context.Context, *GetChannelRequest) (*Channel, error)
	// List channels.
	ListChannels(context.Context, *ListChannelsRequest) (*ListChannelsResponse, error)
	// Create a new channel in a particular project and location.
	CreateChannel(context.Context, *CreateChannelRequest) (*longrunningpb.Operation, error)
	// Update a single channel.
	UpdateChannel(context.Context, *UpdateChannelRequest) (*longrunningpb.Operation, error)
	// Delete a single channel.
	DeleteChannel(context.Context, *DeleteChannelRequest) (*longrunningpb.Operation, error)
	// Get a single Provider.
	GetProvider(context.Context, *GetProviderRequest) (*Provider, error)
	// List providers.
	ListProviders(context.Context, *ListProvidersRequest) (*ListProvidersResponse, error)
	// Get a single ChannelConnection.
	GetChannelConnection(context.Context, *GetChannelConnectionRequest) (*ChannelConnection, error)
	// List channel connections.
	ListChannelConnections(context.Context, *ListChannelConnectionsRequest) (*ListChannelConnectionsResponse, error)
	// Create a new ChannelConnection in a particular project and location.
	CreateChannelConnection(context.Context, *CreateChannelConnectionRequest) (*longrunningpb.Operation, error)
	// Delete a single ChannelConnection.
	DeleteChannelConnection(context.Context, *DeleteChannelConnectionRequest) (*longrunningpb.Operation, error)
	// Get a GoogleChannelConfig.
	// The name of the GoogleChannelConfig in the response is ALWAYS coded with
	// projectID.
	GetGoogleChannelConfig(context.Context, *GetGoogleChannelConfigRequest) (*GoogleChannelConfig, error)
	// Update a single GoogleChannelConfig
	UpdateGoogleChannelConfig(context.Context, *UpdateGoogleChannelConfigRequest) (*GoogleChannelConfig, error)
	// Get a single MessageBus.
	GetMessageBus(context.Context, *GetMessageBusRequest) (*MessageBus, error)
	// List message buses.
	ListMessageBuses(context.Context, *ListMessageBusesRequest) (*ListMessageBusesResponse, error)
	// List message bus enrollments.
	ListMessageBusEnrollments(context.Context, *ListMessageBusEnrollmentsRequest) (*ListMessageBusEnrollmentsResponse, error)
	// Create a new MessageBus in a particular project and location.
	CreateMessageBus(context.Context, *CreateMessageBusRequest) (*longrunningpb.Operation, error)
	// Update a single message bus.
	UpdateMessageBus(context.Context, *UpdateMessageBusRequest) (*longrunningpb.Operation, error)
	// Delete a single message bus.
	DeleteMessageBus(context.Context, *DeleteMessageBusRequest) (*longrunningpb.Operation, error)
	// Get a single Enrollment.
	GetEnrollment(context.Context, *GetEnrollmentRequest) (*Enrollment, error)
	// List Enrollments.
	ListEnrollments(context.Context, *ListEnrollmentsRequest) (*ListEnrollmentsResponse, error)
	// Create a new Enrollment in a particular project and location.
	CreateEnrollment(context.Context, *CreateEnrollmentRequest) (*longrunningpb.Operation, error)
	// Update a single Enrollment.
	UpdateEnrollment(context.Context, *UpdateEnrollmentRequest) (*longrunningpb.Operation, error)
	// Delete a single Enrollment.
	DeleteEnrollment(context.Context, *DeleteEnrollmentRequest) (*longrunningpb.Operation, error)
	// Get a single Pipeline.
	GetPipeline(context.Context, *GetPipelineRequest) (*Pipeline, error)
	// List pipelines.
	ListPipelines(context.Context, *ListPipelinesRequest) (*ListPipelinesResponse, error)
	// Create a new Pipeline in a particular project and location.
	CreatePipeline(context.Context, *CreatePipelineRequest) (*longrunningpb.Operation, error)
	// Update a single pipeline.
	UpdatePipeline(context.Context, *UpdatePipelineRequest) (*longrunningpb.Operation, error)
	// Delete a single pipeline.
	DeletePipeline(context.Context, *DeletePipelineRequest) (*longrunningpb.Operation, error)
	// Get a single GoogleApiSource.
	GetGoogleApiSource(context.Context, *GetGoogleApiSourceRequest) (*GoogleApiSource, error)
	// List GoogleApiSources.
	ListGoogleApiSources(context.Context, *ListGoogleApiSourcesRequest) (*ListGoogleApiSourcesResponse, error)
	// Create a new GoogleApiSource in a particular project and location.
	CreateGoogleApiSource(context.Context, *CreateGoogleApiSourceRequest) (*longrunningpb.Operation, error)
	// Update a single GoogleApiSource.
	UpdateGoogleApiSource(context.Context, *UpdateGoogleApiSourceRequest) (*longrunningpb.Operation, error)
	// Delete a single GoogleApiSource.
	DeleteGoogleApiSource(context.Context, *DeleteGoogleApiSourceRequest) (*longrunningpb.Operation, error)
}

// UnimplementedEventarcServer should be embedded to have forward compatible implementations.
type UnimplementedEventarcServer struct {
}

func (UnimplementedEventarcServer) GetTrigger(context.Context, *GetTriggerRequest) (*Trigger, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTrigger not implemented")
}
func (UnimplementedEventarcServer) ListTriggers(context.Context, *ListTriggersRequest) (*ListTriggersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTriggers not implemented")
}
func (UnimplementedEventarcServer) CreateTrigger(context.Context, *CreateTriggerRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTrigger not implemented")
}
func (UnimplementedEventarcServer) UpdateTrigger(context.Context, *UpdateTriggerRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTrigger not implemented")
}
func (UnimplementedEventarcServer) DeleteTrigger(context.Context, *DeleteTriggerRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTrigger not implemented")
}
func (UnimplementedEventarcServer) GetChannel(context.Context, *GetChannelRequest) (*Channel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetChannel not implemented")
}
func (UnimplementedEventarcServer) ListChannels(context.Context, *ListChannelsRequest) (*ListChannelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListChannels not implemented")
}
func (UnimplementedEventarcServer) CreateChannel(context.Context, *CreateChannelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateChannel not implemented")
}
func (UnimplementedEventarcServer) UpdateChannel(context.Context, *UpdateChannelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateChannel not implemented")
}
func (UnimplementedEventarcServer) DeleteChannel(context.Context, *DeleteChannelRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteChannel not implemented")
}
func (UnimplementedEventarcServer) GetProvider(context.Context, *GetProviderRequest) (*Provider, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProvider not implemented")
}
func (UnimplementedEventarcServer) ListProviders(context.Context, *ListProvidersRequest) (*ListProvidersResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListProviders not implemented")
}
func (UnimplementedEventarcServer) GetChannelConnection(context.Context, *GetChannelConnectionRequest) (*ChannelConnection, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetChannelConnection not implemented")
}
func (UnimplementedEventarcServer) ListChannelConnections(context.Context, *ListChannelConnectionsRequest) (*ListChannelConnectionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListChannelConnections not implemented")
}
func (UnimplementedEventarcServer) CreateChannelConnection(context.Context, *CreateChannelConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateChannelConnection not implemented")
}
func (UnimplementedEventarcServer) DeleteChannelConnection(context.Context, *DeleteChannelConnectionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteChannelConnection not implemented")
}
func (UnimplementedEventarcServer) GetGoogleChannelConfig(context.Context, *GetGoogleChannelConfigRequest) (*GoogleChannelConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGoogleChannelConfig not implemented")
}
func (UnimplementedEventarcServer) UpdateGoogleChannelConfig(context.Context, *UpdateGoogleChannelConfigRequest) (*GoogleChannelConfig, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGoogleChannelConfig not implemented")
}
func (UnimplementedEventarcServer) GetMessageBus(context.Context, *GetMessageBusRequest) (*MessageBus, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMessageBus not implemented")
}
func (UnimplementedEventarcServer) ListMessageBuses(context.Context, *ListMessageBusesRequest) (*ListMessageBusesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMessageBuses not implemented")
}
func (UnimplementedEventarcServer) ListMessageBusEnrollments(context.Context, *ListMessageBusEnrollmentsRequest) (*ListMessageBusEnrollmentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMessageBusEnrollments not implemented")
}
func (UnimplementedEventarcServer) CreateMessageBus(context.Context, *CreateMessageBusRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMessageBus not implemented")
}
func (UnimplementedEventarcServer) UpdateMessageBus(context.Context, *UpdateMessageBusRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateMessageBus not implemented")
}
func (UnimplementedEventarcServer) DeleteMessageBus(context.Context, *DeleteMessageBusRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMessageBus not implemented")
}
func (UnimplementedEventarcServer) GetEnrollment(context.Context, *GetEnrollmentRequest) (*Enrollment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEnrollment not implemented")
}
func (UnimplementedEventarcServer) ListEnrollments(context.Context, *ListEnrollmentsRequest) (*ListEnrollmentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEnrollments not implemented")
}
func (UnimplementedEventarcServer) CreateEnrollment(context.Context, *CreateEnrollmentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEnrollment not implemented")
}
func (UnimplementedEventarcServer) UpdateEnrollment(context.Context, *UpdateEnrollmentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEnrollment not implemented")
}
func (UnimplementedEventarcServer) DeleteEnrollment(context.Context, *DeleteEnrollmentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEnrollment not implemented")
}
func (UnimplementedEventarcServer) GetPipeline(context.Context, *GetPipelineRequest) (*Pipeline, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPipeline not implemented")
}
func (UnimplementedEventarcServer) ListPipelines(context.Context, *ListPipelinesRequest) (*ListPipelinesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPipelines not implemented")
}
func (UnimplementedEventarcServer) CreatePipeline(context.Context, *CreatePipelineRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePipeline not implemented")
}
func (UnimplementedEventarcServer) UpdatePipeline(context.Context, *UpdatePipelineRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePipeline not implemented")
}
func (UnimplementedEventarcServer) DeletePipeline(context.Context, *DeletePipelineRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePipeline not implemented")
}
func (UnimplementedEventarcServer) GetGoogleApiSource(context.Context, *GetGoogleApiSourceRequest) (*GoogleApiSource, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGoogleApiSource not implemented")
}
func (UnimplementedEventarcServer) ListGoogleApiSources(context.Context, *ListGoogleApiSourcesRequest) (*ListGoogleApiSourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGoogleApiSources not implemented")
}
func (UnimplementedEventarcServer) CreateGoogleApiSource(context.Context, *CreateGoogleApiSourceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGoogleApiSource not implemented")
}
func (UnimplementedEventarcServer) UpdateGoogleApiSource(context.Context, *UpdateGoogleApiSourceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGoogleApiSource not implemented")
}
func (UnimplementedEventarcServer) DeleteGoogleApiSource(context.Context, *DeleteGoogleApiSourceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGoogleApiSource not implemented")
}

// UnsafeEventarcServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to EventarcServer will
// result in compilation errors.
type UnsafeEventarcServer interface {
	mustEmbedUnimplementedEventarcServer()
}

func RegisterEventarcServer(s grpc.ServiceRegistrar, srv EventarcServer) {
	s.RegisterService(&Eventarc_ServiceDesc, srv)
}

func _Eventarc_GetTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).GetTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_GetTrigger_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).GetTrigger(ctx, req.(*GetTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_ListTriggers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTriggersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).ListTriggers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_ListTriggers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).ListTriggers(ctx, req.(*ListTriggersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_CreateTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).CreateTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_CreateTrigger_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).CreateTrigger(ctx, req.(*CreateTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_UpdateTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).UpdateTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_UpdateTrigger_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).UpdateTrigger(ctx, req.(*UpdateTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_DeleteTrigger_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTriggerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).DeleteTrigger(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_DeleteTrigger_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).DeleteTrigger(ctx, req.(*DeleteTriggerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_GetChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).GetChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_GetChannel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).GetChannel(ctx, req.(*GetChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_ListChannels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListChannelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).ListChannels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_ListChannels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).ListChannels(ctx, req.(*ListChannelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_CreateChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).CreateChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_CreateChannel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).CreateChannel(ctx, req.(*CreateChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_UpdateChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).UpdateChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_UpdateChannel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).UpdateChannel(ctx, req.(*UpdateChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_DeleteChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).DeleteChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_DeleteChannel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).DeleteChannel(ctx, req.(*DeleteChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_GetProvider_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProviderRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).GetProvider(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_GetProvider_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).GetProvider(ctx, req.(*GetProviderRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_ListProviders_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListProvidersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).ListProviders(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_ListProviders_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).ListProviders(ctx, req.(*ListProvidersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_GetChannelConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetChannelConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).GetChannelConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_GetChannelConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).GetChannelConnection(ctx, req.(*GetChannelConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_ListChannelConnections_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListChannelConnectionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).ListChannelConnections(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_ListChannelConnections_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).ListChannelConnections(ctx, req.(*ListChannelConnectionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_CreateChannelConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateChannelConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).CreateChannelConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_CreateChannelConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).CreateChannelConnection(ctx, req.(*CreateChannelConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_DeleteChannelConnection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteChannelConnectionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).DeleteChannelConnection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_DeleteChannelConnection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).DeleteChannelConnection(ctx, req.(*DeleteChannelConnectionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_GetGoogleChannelConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGoogleChannelConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).GetGoogleChannelConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_GetGoogleChannelConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).GetGoogleChannelConfig(ctx, req.(*GetGoogleChannelConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_UpdateGoogleChannelConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGoogleChannelConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).UpdateGoogleChannelConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_UpdateGoogleChannelConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).UpdateGoogleChannelConfig(ctx, req.(*UpdateGoogleChannelConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_GetMessageBus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMessageBusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).GetMessageBus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_GetMessageBus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).GetMessageBus(ctx, req.(*GetMessageBusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_ListMessageBuses_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMessageBusesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).ListMessageBuses(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_ListMessageBuses_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).ListMessageBuses(ctx, req.(*ListMessageBusesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_ListMessageBusEnrollments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMessageBusEnrollmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).ListMessageBusEnrollments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_ListMessageBusEnrollments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).ListMessageBusEnrollments(ctx, req.(*ListMessageBusEnrollmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_CreateMessageBus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMessageBusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).CreateMessageBus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_CreateMessageBus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).CreateMessageBus(ctx, req.(*CreateMessageBusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_UpdateMessageBus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMessageBusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).UpdateMessageBus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_UpdateMessageBus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).UpdateMessageBus(ctx, req.(*UpdateMessageBusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_DeleteMessageBus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMessageBusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).DeleteMessageBus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_DeleteMessageBus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).DeleteMessageBus(ctx, req.(*DeleteMessageBusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_GetEnrollment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEnrollmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).GetEnrollment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_GetEnrollment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).GetEnrollment(ctx, req.(*GetEnrollmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_ListEnrollments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEnrollmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).ListEnrollments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_ListEnrollments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).ListEnrollments(ctx, req.(*ListEnrollmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_CreateEnrollment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEnrollmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).CreateEnrollment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_CreateEnrollment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).CreateEnrollment(ctx, req.(*CreateEnrollmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_UpdateEnrollment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEnrollmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).UpdateEnrollment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_UpdateEnrollment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).UpdateEnrollment(ctx, req.(*UpdateEnrollmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_DeleteEnrollment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEnrollmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).DeleteEnrollment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_DeleteEnrollment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).DeleteEnrollment(ctx, req.(*DeleteEnrollmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_GetPipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).GetPipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_GetPipeline_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).GetPipeline(ctx, req.(*GetPipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_ListPipelines_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPipelinesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).ListPipelines(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_ListPipelines_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).ListPipelines(ctx, req.(*ListPipelinesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_CreatePipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).CreatePipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_CreatePipeline_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).CreatePipeline(ctx, req.(*CreatePipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_UpdatePipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).UpdatePipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_UpdatePipeline_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).UpdatePipeline(ctx, req.(*UpdatePipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_DeletePipeline_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePipelineRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).DeletePipeline(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_DeletePipeline_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).DeletePipeline(ctx, req.(*DeletePipelineRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_GetGoogleApiSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGoogleApiSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).GetGoogleApiSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_GetGoogleApiSource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).GetGoogleApiSource(ctx, req.(*GetGoogleApiSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_ListGoogleApiSources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGoogleApiSourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).ListGoogleApiSources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_ListGoogleApiSources_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).ListGoogleApiSources(ctx, req.(*ListGoogleApiSourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_CreateGoogleApiSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGoogleApiSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).CreateGoogleApiSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_CreateGoogleApiSource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).CreateGoogleApiSource(ctx, req.(*CreateGoogleApiSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_UpdateGoogleApiSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGoogleApiSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).UpdateGoogleApiSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_UpdateGoogleApiSource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).UpdateGoogleApiSource(ctx, req.(*UpdateGoogleApiSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Eventarc_DeleteGoogleApiSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGoogleApiSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventarcServer).DeleteGoogleApiSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Eventarc_DeleteGoogleApiSource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventarcServer).DeleteGoogleApiSource(ctx, req.(*DeleteGoogleApiSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Eventarc_ServiceDesc is the grpc.ServiceDesc for Eventarc service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Eventarc_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.eventarc.v1.Eventarc",
	HandlerType: (*EventarcServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetTrigger",
			Handler:    _Eventarc_GetTrigger_Handler,
		},
		{
			MethodName: "ListTriggers",
			Handler:    _Eventarc_ListTriggers_Handler,
		},
		{
			MethodName: "CreateTrigger",
			Handler:    _Eventarc_CreateTrigger_Handler,
		},
		{
			MethodName: "UpdateTrigger",
			Handler:    _Eventarc_UpdateTrigger_Handler,
		},
		{
			MethodName: "DeleteTrigger",
			Handler:    _Eventarc_DeleteTrigger_Handler,
		},
		{
			MethodName: "GetChannel",
			Handler:    _Eventarc_GetChannel_Handler,
		},
		{
			MethodName: "ListChannels",
			Handler:    _Eventarc_ListChannels_Handler,
		},
		{
			MethodName: "CreateChannel",
			Handler:    _Eventarc_CreateChannel_Handler,
		},
		{
			MethodName: "UpdateChannel",
			Handler:    _Eventarc_UpdateChannel_Handler,
		},
		{
			MethodName: "DeleteChannel",
			Handler:    _Eventarc_DeleteChannel_Handler,
		},
		{
			MethodName: "GetProvider",
			Handler:    _Eventarc_GetProvider_Handler,
		},
		{
			MethodName: "ListProviders",
			Handler:    _Eventarc_ListProviders_Handler,
		},
		{
			MethodName: "GetChannelConnection",
			Handler:    _Eventarc_GetChannelConnection_Handler,
		},
		{
			MethodName: "ListChannelConnections",
			Handler:    _Eventarc_ListChannelConnections_Handler,
		},
		{
			MethodName: "CreateChannelConnection",
			Handler:    _Eventarc_CreateChannelConnection_Handler,
		},
		{
			MethodName: "DeleteChannelConnection",
			Handler:    _Eventarc_DeleteChannelConnection_Handler,
		},
		{
			MethodName: "GetGoogleChannelConfig",
			Handler:    _Eventarc_GetGoogleChannelConfig_Handler,
		},
		{
			MethodName: "UpdateGoogleChannelConfig",
			Handler:    _Eventarc_UpdateGoogleChannelConfig_Handler,
		},
		{
			MethodName: "GetMessageBus",
			Handler:    _Eventarc_GetMessageBus_Handler,
		},
		{
			MethodName: "ListMessageBuses",
			Handler:    _Eventarc_ListMessageBuses_Handler,
		},
		{
			MethodName: "ListMessageBusEnrollments",
			Handler:    _Eventarc_ListMessageBusEnrollments_Handler,
		},
		{
			MethodName: "CreateMessageBus",
			Handler:    _Eventarc_CreateMessageBus_Handler,
		},
		{
			MethodName: "UpdateMessageBus",
			Handler:    _Eventarc_UpdateMessageBus_Handler,
		},
		{
			MethodName: "DeleteMessageBus",
			Handler:    _Eventarc_DeleteMessageBus_Handler,
		},
		{
			MethodName: "GetEnrollment",
			Handler:    _Eventarc_GetEnrollment_Handler,
		},
		{
			MethodName: "ListEnrollments",
			Handler:    _Eventarc_ListEnrollments_Handler,
		},
		{
			MethodName: "CreateEnrollment",
			Handler:    _Eventarc_CreateEnrollment_Handler,
		},
		{
			MethodName: "UpdateEnrollment",
			Handler:    _Eventarc_UpdateEnrollment_Handler,
		},
		{
			MethodName: "DeleteEnrollment",
			Handler:    _Eventarc_DeleteEnrollment_Handler,
		},
		{
			MethodName: "GetPipeline",
			Handler:    _Eventarc_GetPipeline_Handler,
		},
		{
			MethodName: "ListPipelines",
			Handler:    _Eventarc_ListPipelines_Handler,
		},
		{
			MethodName: "CreatePipeline",
			Handler:    _Eventarc_CreatePipeline_Handler,
		},
		{
			MethodName: "UpdatePipeline",
			Handler:    _Eventarc_UpdatePipeline_Handler,
		},
		{
			MethodName: "DeletePipeline",
			Handler:    _Eventarc_DeletePipeline_Handler,
		},
		{
			MethodName: "GetGoogleApiSource",
			Handler:    _Eventarc_GetGoogleApiSource_Handler,
		},
		{
			MethodName: "ListGoogleApiSources",
			Handler:    _Eventarc_ListGoogleApiSources_Handler,
		},
		{
			MethodName: "CreateGoogleApiSource",
			Handler:    _Eventarc_CreateGoogleApiSource_Handler,
		},
		{
			MethodName: "UpdateGoogleApiSource",
			Handler:    _Eventarc_UpdateGoogleApiSource_Handler,
		},
		{
			MethodName: "DeleteGoogleApiSource",
			Handler:    _Eventarc_DeleteGoogleApiSource_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/eventarc/v1/eventarc.proto",
}
