// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v3.21.12
// source: yandex/cloud/video/v1/video_service.proto

package video

import (
	context "context"
	operation "github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	VideoService_Get_FullMethodName                = "/yandex.cloud.video.v1.VideoService/Get"
	VideoService_List_FullMethodName               = "/yandex.cloud.video.v1.VideoService/List"
	VideoService_BatchGet_FullMethodName           = "/yandex.cloud.video.v1.VideoService/BatchGet"
	VideoService_Create_FullMethodName             = "/yandex.cloud.video.v1.VideoService/Create"
	VideoService_Update_FullMethodName             = "/yandex.cloud.video.v1.VideoService/Update"
	VideoService_Transcode_FullMethodName          = "/yandex.cloud.video.v1.VideoService/Transcode"
	VideoService_Delete_FullMethodName             = "/yandex.cloud.video.v1.VideoService/Delete"
	VideoService_BatchDelete_FullMethodName        = "/yandex.cloud.video.v1.VideoService/BatchDelete"
	VideoService_PerformAction_FullMethodName      = "/yandex.cloud.video.v1.VideoService/PerformAction"
	VideoService_GetPlayerURL_FullMethodName       = "/yandex.cloud.video.v1.VideoService/GetPlayerURL"
	VideoService_BatchGetPlayerURLs_FullMethodName = "/yandex.cloud.video.v1.VideoService/BatchGetPlayerURLs"
	VideoService_GetManifests_FullMethodName       = "/yandex.cloud.video.v1.VideoService/GetManifests"
)

// VideoServiceClient is the client API for VideoService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// Video management service.
// Provides methods for creating, retrieving, updating, and deleting videos,
// as well as managing video-related operations such as transcoding, publishing,
// and generating playback URLs.
type VideoServiceClient interface {
	// Retrieves detailed information about a specific video by its ID.
	// Returns all video metadata, status, and related information.
	Get(ctx context.Context, in *GetVideoRequest, opts ...grpc.CallOption) (*Video, error)
	// Lists all videos in a specific channel with pagination support.
	// Results can be filtered and sorted using the provided parameters.
	List(ctx context.Context, in *ListVideoRequest, opts ...grpc.CallOption) (*ListVideoResponse, error)
	// Retrieves multiple videos by their IDs in a specific channel in a single request.
	// This is more efficient than making multiple Get requests when retrieving several videos.
	BatchGet(ctx context.Context, in *BatchGetVideosRequest, opts ...grpc.CallOption) (*BatchGetVideosResponse, error)
	// Creates a new video in the specified channel.
	// The video can be created from different sources: TUS upload, direct link, or S3 storage.
	Create(ctx context.Context, in *CreateVideoRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Updates an existing video's metadata and settings.
	// Only fields specified in the field_mask will be updated.
	Update(ctx context.Context, in *UpdateVideoRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Initiates or updates video transcoding with specified parameters.
	// Can be used to start transcoding for videos with auto_transcode=DISABLE,
	// or to re-process a completed video with new transcoding settings.
	// Supports additional features like subtitle processing, translation, and summarization.
	Transcode(ctx context.Context, in *TranscodeVideoRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes a specific video by its ID.
	Delete(ctx context.Context, in *DeleteVideoRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Deletes multiple videos in a specific channel in a single request.
	// This is more efficient than making multiple Delete requests when removing several videos.
	BatchDelete(ctx context.Context, in *BatchDeleteVideosRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Performs a specific action on a video, such as publishing or unpublishing.
	PerformAction(ctx context.Context, in *PerformVideoActionRequest, opts ...grpc.CallOption) (*operation.Operation, error)
	// Generates a standard player URL for watching the video.
	// The URL respects the video's access rights and can include custom player parameters.
	// For videos with signed URL access, an expiration duration can be specified.
	GetPlayerURL(ctx context.Context, in *GetVideoPlayerURLRequest, opts ...grpc.CallOption) (*GetVideoPlayerURLResponse, error)
	// Generates multiple player URLs for a list of videos in a specific channel in a single request.
	// This is more efficient than making multiple GetPlayerURL requests when retrieving several URLs.
	BatchGetPlayerURLs(ctx context.Context, in *BatchGetVideoPlayerURLsRequest, opts ...grpc.CallOption) (*BatchGetVideoPlayerURLsResponse, error)
	// Retrieves the manifest URLs for a specific video.
	// Manifests are used by video players to access the video content with adaptive bitrate streaming.
	// Supports different manifest types (HLS, DASH) and configuration parameters.
	GetManifests(ctx context.Context, in *GetVideoManifestsRequest, opts ...grpc.CallOption) (*GetVideoManifestsResponse, error)
}

type videoServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewVideoServiceClient(cc grpc.ClientConnInterface) VideoServiceClient {
	return &videoServiceClient{cc}
}

func (c *videoServiceClient) Get(ctx context.Context, in *GetVideoRequest, opts ...grpc.CallOption) (*Video, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(Video)
	err := c.cc.Invoke(ctx, VideoService_Get_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoServiceClient) List(ctx context.Context, in *ListVideoRequest, opts ...grpc.CallOption) (*ListVideoResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(ListVideoResponse)
	err := c.cc.Invoke(ctx, VideoService_List_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoServiceClient) BatchGet(ctx context.Context, in *BatchGetVideosRequest, opts ...grpc.CallOption) (*BatchGetVideosResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(BatchGetVideosResponse)
	err := c.cc.Invoke(ctx, VideoService_BatchGet_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoServiceClient) Create(ctx context.Context, in *CreateVideoRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, VideoService_Create_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoServiceClient) Update(ctx context.Context, in *UpdateVideoRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, VideoService_Update_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoServiceClient) Transcode(ctx context.Context, in *TranscodeVideoRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, VideoService_Transcode_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoServiceClient) Delete(ctx context.Context, in *DeleteVideoRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, VideoService_Delete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoServiceClient) BatchDelete(ctx context.Context, in *BatchDeleteVideosRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, VideoService_BatchDelete_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoServiceClient) PerformAction(ctx context.Context, in *PerformVideoActionRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(operation.Operation)
	err := c.cc.Invoke(ctx, VideoService_PerformAction_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoServiceClient) GetPlayerURL(ctx context.Context, in *GetVideoPlayerURLRequest, opts ...grpc.CallOption) (*GetVideoPlayerURLResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetVideoPlayerURLResponse)
	err := c.cc.Invoke(ctx, VideoService_GetPlayerURL_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoServiceClient) BatchGetPlayerURLs(ctx context.Context, in *BatchGetVideoPlayerURLsRequest, opts ...grpc.CallOption) (*BatchGetVideoPlayerURLsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(BatchGetVideoPlayerURLsResponse)
	err := c.cc.Invoke(ctx, VideoService_BatchGetPlayerURLs_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *videoServiceClient) GetManifests(ctx context.Context, in *GetVideoManifestsRequest, opts ...grpc.CallOption) (*GetVideoManifestsResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(GetVideoManifestsResponse)
	err := c.cc.Invoke(ctx, VideoService_GetManifests_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VideoServiceServer is the server API for VideoService service.
// All implementations should embed UnimplementedVideoServiceServer
// for forward compatibility.
//
// Video management service.
// Provides methods for creating, retrieving, updating, and deleting videos,
// as well as managing video-related operations such as transcoding, publishing,
// and generating playback URLs.
type VideoServiceServer interface {
	// Retrieves detailed information about a specific video by its ID.
	// Returns all video metadata, status, and related information.
	Get(context.Context, *GetVideoRequest) (*Video, error)
	// Lists all videos in a specific channel with pagination support.
	// Results can be filtered and sorted using the provided parameters.
	List(context.Context, *ListVideoRequest) (*ListVideoResponse, error)
	// Retrieves multiple videos by their IDs in a specific channel in a single request.
	// This is more efficient than making multiple Get requests when retrieving several videos.
	BatchGet(context.Context, *BatchGetVideosRequest) (*BatchGetVideosResponse, error)
	// Creates a new video in the specified channel.
	// The video can be created from different sources: TUS upload, direct link, or S3 storage.
	Create(context.Context, *CreateVideoRequest) (*operation.Operation, error)
	// Updates an existing video's metadata and settings.
	// Only fields specified in the field_mask will be updated.
	Update(context.Context, *UpdateVideoRequest) (*operation.Operation, error)
	// Initiates or updates video transcoding with specified parameters.
	// Can be used to start transcoding for videos with auto_transcode=DISABLE,
	// or to re-process a completed video with new transcoding settings.
	// Supports additional features like subtitle processing, translation, and summarization.
	Transcode(context.Context, *TranscodeVideoRequest) (*operation.Operation, error)
	// Deletes a specific video by its ID.
	Delete(context.Context, *DeleteVideoRequest) (*operation.Operation, error)
	// Deletes multiple videos in a specific channel in a single request.
	// This is more efficient than making multiple Delete requests when removing several videos.
	BatchDelete(context.Context, *BatchDeleteVideosRequest) (*operation.Operation, error)
	// Performs a specific action on a video, such as publishing or unpublishing.
	PerformAction(context.Context, *PerformVideoActionRequest) (*operation.Operation, error)
	// Generates a standard player URL for watching the video.
	// The URL respects the video's access rights and can include custom player parameters.
	// For videos with signed URL access, an expiration duration can be specified.
	GetPlayerURL(context.Context, *GetVideoPlayerURLRequest) (*GetVideoPlayerURLResponse, error)
	// Generates multiple player URLs for a list of videos in a specific channel in a single request.
	// This is more efficient than making multiple GetPlayerURL requests when retrieving several URLs.
	BatchGetPlayerURLs(context.Context, *BatchGetVideoPlayerURLsRequest) (*BatchGetVideoPlayerURLsResponse, error)
	// Retrieves the manifest URLs for a specific video.
	// Manifests are used by video players to access the video content with adaptive bitrate streaming.
	// Supports different manifest types (HLS, DASH) and configuration parameters.
	GetManifests(context.Context, *GetVideoManifestsRequest) (*GetVideoManifestsResponse, error)
}

// UnimplementedVideoServiceServer should be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedVideoServiceServer struct{}

func (UnimplementedVideoServiceServer) Get(context.Context, *GetVideoRequest) (*Video, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedVideoServiceServer) List(context.Context, *ListVideoRequest) (*ListVideoResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedVideoServiceServer) BatchGet(context.Context, *BatchGetVideosRequest) (*BatchGetVideosResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchGet not implemented")
}
func (UnimplementedVideoServiceServer) Create(context.Context, *CreateVideoRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Create not implemented")
}
func (UnimplementedVideoServiceServer) Update(context.Context, *UpdateVideoRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedVideoServiceServer) Transcode(context.Context, *TranscodeVideoRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Transcode not implemented")
}
func (UnimplementedVideoServiceServer) Delete(context.Context, *DeleteVideoRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedVideoServiceServer) BatchDelete(context.Context, *BatchDeleteVideosRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchDelete not implemented")
}
func (UnimplementedVideoServiceServer) PerformAction(context.Context, *PerformVideoActionRequest) (*operation.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PerformAction not implemented")
}
func (UnimplementedVideoServiceServer) GetPlayerURL(context.Context, *GetVideoPlayerURLRequest) (*GetVideoPlayerURLResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPlayerURL not implemented")
}
func (UnimplementedVideoServiceServer) BatchGetPlayerURLs(context.Context, *BatchGetVideoPlayerURLsRequest) (*BatchGetVideoPlayerURLsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchGetPlayerURLs not implemented")
}
func (UnimplementedVideoServiceServer) GetManifests(context.Context, *GetVideoManifestsRequest) (*GetVideoManifestsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetManifests not implemented")
}
func (UnimplementedVideoServiceServer) testEmbeddedByValue() {}

// UnsafeVideoServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to VideoServiceServer will
// result in compilation errors.
type UnsafeVideoServiceServer interface {
	mustEmbedUnimplementedVideoServiceServer()
}

func RegisterVideoServiceServer(s grpc.ServiceRegistrar, srv VideoServiceServer) {
	// If the following call pancis, it indicates UnimplementedVideoServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&VideoService_ServiceDesc, srv)
}

func _VideoService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoServiceServer).Get(ctx, req.(*GetVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoService_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoServiceServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoService_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoServiceServer).List(ctx, req.(*ListVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoService_BatchGet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGetVideosRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoServiceServer).BatchGet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoService_BatchGet_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoServiceServer).BatchGet(ctx, req.(*BatchGetVideosRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoService_Create_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoServiceServer).Create(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoService_Create_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoServiceServer).Create(ctx, req.(*CreateVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoService_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoServiceServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoService_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoServiceServer).Update(ctx, req.(*UpdateVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoService_Transcode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TranscodeVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoServiceServer).Transcode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoService_Transcode_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoServiceServer).Transcode(ctx, req.(*TranscodeVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoService_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVideoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoServiceServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoService_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoServiceServer).Delete(ctx, req.(*DeleteVideoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoService_BatchDelete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteVideosRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoServiceServer).BatchDelete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoService_BatchDelete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoServiceServer).BatchDelete(ctx, req.(*BatchDeleteVideosRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoService_PerformAction_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PerformVideoActionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoServiceServer).PerformAction(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoService_PerformAction_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoServiceServer).PerformAction(ctx, req.(*PerformVideoActionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoService_GetPlayerURL_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVideoPlayerURLRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoServiceServer).GetPlayerURL(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoService_GetPlayerURL_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoServiceServer).GetPlayerURL(ctx, req.(*GetVideoPlayerURLRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoService_BatchGetPlayerURLs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchGetVideoPlayerURLsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoServiceServer).BatchGetPlayerURLs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoService_BatchGetPlayerURLs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoServiceServer).BatchGetPlayerURLs(ctx, req.(*BatchGetVideoPlayerURLsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VideoService_GetManifests_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVideoManifestsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VideoServiceServer).GetManifests(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VideoService_GetManifests_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VideoServiceServer).GetManifests(ctx, req.(*GetVideoManifestsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// VideoService_ServiceDesc is the grpc.ServiceDesc for VideoService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var VideoService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "yandex.cloud.video.v1.VideoService",
	HandlerType: (*VideoServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _VideoService_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _VideoService_List_Handler,
		},
		{
			MethodName: "BatchGet",
			Handler:    _VideoService_BatchGet_Handler,
		},
		{
			MethodName: "Create",
			Handler:    _VideoService_Create_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _VideoService_Update_Handler,
		},
		{
			MethodName: "Transcode",
			Handler:    _VideoService_Transcode_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _VideoService_Delete_Handler,
		},
		{
			MethodName: "BatchDelete",
			Handler:    _VideoService_BatchDelete_Handler,
		},
		{
			MethodName: "PerformAction",
			Handler:    _VideoService_PerformAction_Handler,
		},
		{
			MethodName: "GetPlayerURL",
			Handler:    _VideoService_GetPlayerURL_Handler,
		},
		{
			MethodName: "BatchGetPlayerURLs",
			Handler:    _VideoService_BatchGetPlayerURLs_Handler,
		},
		{
			MethodName: "GetManifests",
			Handler:    _VideoService_GetManifests_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "yandex/cloud/video/v1/video_service.proto",
}
