// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/policytroubleshooter/iam/v3/troubleshooter.proto

package iampb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	PolicyTroubleshooter_TroubleshootIamPolicy_FullMethodName = "/google.cloud.policytroubleshooter.iam.v3.PolicyTroubleshooter/TroubleshootIamPolicy"
)

// PolicyTroubleshooterClient is the client API for PolicyTroubleshooter service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PolicyTroubleshooterClient interface {
	// Checks whether a principal has a specific permission for a specific
	// resource, and explains why the principal does or doesn't have that
	// permission.
	TroubleshootIamPolicy(ctx context.Context, in *TroubleshootIamPolicyRequest, opts ...grpc.CallOption) (*TroubleshootIamPolicyResponse, error)
}

type policyTroubleshooterClient struct {
	cc grpc.ClientConnInterface
}

func NewPolicyTroubleshooterClient(cc grpc.ClientConnInterface) PolicyTroubleshooterClient {
	return &policyTroubleshooterClient{cc}
}

func (c *policyTroubleshooterClient) TroubleshootIamPolicy(ctx context.Context, in *TroubleshootIamPolicyRequest, opts ...grpc.CallOption) (*TroubleshootIamPolicyResponse, error) {
	out := new(TroubleshootIamPolicyResponse)
	err := c.cc.Invoke(ctx, PolicyTroubleshooter_TroubleshootIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PolicyTroubleshooterServer is the server API for PolicyTroubleshooter service.
// All implementations should embed UnimplementedPolicyTroubleshooterServer
// for forward compatibility
type PolicyTroubleshooterServer interface {
	// Checks whether a principal has a specific permission for a specific
	// resource, and explains why the principal does or doesn't have that
	// permission.
	TroubleshootIamPolicy(context.Context, *TroubleshootIamPolicyRequest) (*TroubleshootIamPolicyResponse, error)
}

// UnimplementedPolicyTroubleshooterServer should be embedded to have forward compatible implementations.
type UnimplementedPolicyTroubleshooterServer struct {
}

func (UnimplementedPolicyTroubleshooterServer) TroubleshootIamPolicy(context.Context, *TroubleshootIamPolicyRequest) (*TroubleshootIamPolicyResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TroubleshootIamPolicy not implemented")
}

// UnsafePolicyTroubleshooterServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PolicyTroubleshooterServer will
// result in compilation errors.
type UnsafePolicyTroubleshooterServer interface {
	mustEmbedUnimplementedPolicyTroubleshooterServer()
}

func RegisterPolicyTroubleshooterServer(s grpc.ServiceRegistrar, srv PolicyTroubleshooterServer) {
	s.RegisterService(&PolicyTroubleshooter_ServiceDesc, srv)
}

func _PolicyTroubleshooter_TroubleshootIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TroubleshootIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PolicyTroubleshooterServer).TroubleshootIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PolicyTroubleshooter_TroubleshootIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PolicyTroubleshooterServer).TroubleshootIamPolicy(ctx, req.(*TroubleshootIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// PolicyTroubleshooter_ServiceDesc is the grpc.ServiceDesc for PolicyTroubleshooter service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var PolicyTroubleshooter_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.policytroubleshooter.iam.v3.PolicyTroubleshooter",
	HandlerType: (*PolicyTroubleshooterServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "TroubleshootIamPolicy",
			Handler:    _PolicyTroubleshooter_TroubleshootIamPolicy_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/policytroubleshooter/iam/v3/troubleshooter.proto",
}
