/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.handler;

import jakarta.inject.Inject;
import java.util.List;
import org.traccar.handler.BasePositionHandler;
import org.traccar.helper.model.GeofenceUtil;
import org.traccar.model.Position;
import org.traccar.session.cache.CacheManager;

public class GeofenceHandler
extends BasePositionHandler {
    private final CacheManager cacheManager;

    @Inject
    public GeofenceHandler(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public void onPosition(Position position, BasePositionHandler.Callback callback) {
        List<Long> geofenceIds = GeofenceUtil.getCurrentGeofences(this.cacheManager, position);
        if (!geofenceIds.isEmpty()) {
            position.setGeofenceIds(geofenceIds);
        }
        callback.processed(false);
    }
}

