/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta1

// IngressStatusApplyConfiguration represents a declarative configuration of the IngressStatus type for use
// with apply.
//
// IngressStatus describes the current state of the Ingress.
type IngressStatusApplyConfiguration struct {
	// loadBalancer contains the current status of the load-balancer.
	LoadBalancer *IngressLoadBalancerStatusApplyConfiguration `json:"loadBalancer,omitempty"`
}

// IngressStatusApplyConfiguration constructs a declarative configuration of the IngressStatus type for use with
// apply.
func IngressStatus() *IngressStatusApplyConfiguration {
	return &IngressStatusApplyConfiguration{}
}

// WithLoadBalancer sets the LoadBalancer field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the LoadBalancer field is set to the value of the last call.
func (b *IngressStatusApplyConfiguration) WithLoadBalancer(value *IngressLoadBalancerStatusApplyConfiguration) *IngressStatusApplyConfiguration {
	b.LoadBalancer = value
	return b
}
