// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/vmmigration/v1/vmmigration.proto

package vmmigrationpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	VmMigration_ListSources_FullMethodName               = "/google.cloud.vmmigration.v1.VmMigration/ListSources"
	VmMigration_GetSource_FullMethodName                 = "/google.cloud.vmmigration.v1.VmMigration/GetSource"
	VmMigration_CreateSource_FullMethodName              = "/google.cloud.vmmigration.v1.VmMigration/CreateSource"
	VmMigration_UpdateSource_FullMethodName              = "/google.cloud.vmmigration.v1.VmMigration/UpdateSource"
	VmMigration_DeleteSource_FullMethodName              = "/google.cloud.vmmigration.v1.VmMigration/DeleteSource"
	VmMigration_FetchInventory_FullMethodName            = "/google.cloud.vmmigration.v1.VmMigration/FetchInventory"
	VmMigration_FetchStorageInventory_FullMethodName     = "/google.cloud.vmmigration.v1.VmMigration/FetchStorageInventory"
	VmMigration_ListUtilizationReports_FullMethodName    = "/google.cloud.vmmigration.v1.VmMigration/ListUtilizationReports"
	VmMigration_GetUtilizationReport_FullMethodName      = "/google.cloud.vmmigration.v1.VmMigration/GetUtilizationReport"
	VmMigration_CreateUtilizationReport_FullMethodName   = "/google.cloud.vmmigration.v1.VmMigration/CreateUtilizationReport"
	VmMigration_DeleteUtilizationReport_FullMethodName   = "/google.cloud.vmmigration.v1.VmMigration/DeleteUtilizationReport"
	VmMigration_ListDatacenterConnectors_FullMethodName  = "/google.cloud.vmmigration.v1.VmMigration/ListDatacenterConnectors"
	VmMigration_GetDatacenterConnector_FullMethodName    = "/google.cloud.vmmigration.v1.VmMigration/GetDatacenterConnector"
	VmMigration_CreateDatacenterConnector_FullMethodName = "/google.cloud.vmmigration.v1.VmMigration/CreateDatacenterConnector"
	VmMigration_DeleteDatacenterConnector_FullMethodName = "/google.cloud.vmmigration.v1.VmMigration/DeleteDatacenterConnector"
	VmMigration_UpgradeAppliance_FullMethodName          = "/google.cloud.vmmigration.v1.VmMigration/UpgradeAppliance"
	VmMigration_CreateMigratingVm_FullMethodName         = "/google.cloud.vmmigration.v1.VmMigration/CreateMigratingVm"
	VmMigration_ListMigratingVms_FullMethodName          = "/google.cloud.vmmigration.v1.VmMigration/ListMigratingVms"
	VmMigration_GetMigratingVm_FullMethodName            = "/google.cloud.vmmigration.v1.VmMigration/GetMigratingVm"
	VmMigration_UpdateMigratingVm_FullMethodName         = "/google.cloud.vmmigration.v1.VmMigration/UpdateMigratingVm"
	VmMigration_DeleteMigratingVm_FullMethodName         = "/google.cloud.vmmigration.v1.VmMigration/DeleteMigratingVm"
	VmMigration_StartMigration_FullMethodName            = "/google.cloud.vmmigration.v1.VmMigration/StartMigration"
	VmMigration_ResumeMigration_FullMethodName           = "/google.cloud.vmmigration.v1.VmMigration/ResumeMigration"
	VmMigration_PauseMigration_FullMethodName            = "/google.cloud.vmmigration.v1.VmMigration/PauseMigration"
	VmMigration_FinalizeMigration_FullMethodName         = "/google.cloud.vmmigration.v1.VmMigration/FinalizeMigration"
	VmMigration_ExtendMigration_FullMethodName           = "/google.cloud.vmmigration.v1.VmMigration/ExtendMigration"
	VmMigration_CreateCloneJob_FullMethodName            = "/google.cloud.vmmigration.v1.VmMigration/CreateCloneJob"
	VmMigration_CancelCloneJob_FullMethodName            = "/google.cloud.vmmigration.v1.VmMigration/CancelCloneJob"
	VmMigration_ListCloneJobs_FullMethodName             = "/google.cloud.vmmigration.v1.VmMigration/ListCloneJobs"
	VmMigration_GetCloneJob_FullMethodName               = "/google.cloud.vmmigration.v1.VmMigration/GetCloneJob"
	VmMigration_CreateCutoverJob_FullMethodName          = "/google.cloud.vmmigration.v1.VmMigration/CreateCutoverJob"
	VmMigration_CancelCutoverJob_FullMethodName          = "/google.cloud.vmmigration.v1.VmMigration/CancelCutoverJob"
	VmMigration_ListCutoverJobs_FullMethodName           = "/google.cloud.vmmigration.v1.VmMigration/ListCutoverJobs"
	VmMigration_GetCutoverJob_FullMethodName             = "/google.cloud.vmmigration.v1.VmMigration/GetCutoverJob"
	VmMigration_ListGroups_FullMethodName                = "/google.cloud.vmmigration.v1.VmMigration/ListGroups"
	VmMigration_GetGroup_FullMethodName                  = "/google.cloud.vmmigration.v1.VmMigration/GetGroup"
	VmMigration_CreateGroup_FullMethodName               = "/google.cloud.vmmigration.v1.VmMigration/CreateGroup"
	VmMigration_UpdateGroup_FullMethodName               = "/google.cloud.vmmigration.v1.VmMigration/UpdateGroup"
	VmMigration_DeleteGroup_FullMethodName               = "/google.cloud.vmmigration.v1.VmMigration/DeleteGroup"
	VmMigration_AddGroupMigration_FullMethodName         = "/google.cloud.vmmigration.v1.VmMigration/AddGroupMigration"
	VmMigration_RemoveGroupMigration_FullMethodName      = "/google.cloud.vmmigration.v1.VmMigration/RemoveGroupMigration"
	VmMigration_ListTargetProjects_FullMethodName        = "/google.cloud.vmmigration.v1.VmMigration/ListTargetProjects"
	VmMigration_GetTargetProject_FullMethodName          = "/google.cloud.vmmigration.v1.VmMigration/GetTargetProject"
	VmMigration_CreateTargetProject_FullMethodName       = "/google.cloud.vmmigration.v1.VmMigration/CreateTargetProject"
	VmMigration_UpdateTargetProject_FullMethodName       = "/google.cloud.vmmigration.v1.VmMigration/UpdateTargetProject"
	VmMigration_DeleteTargetProject_FullMethodName       = "/google.cloud.vmmigration.v1.VmMigration/DeleteTargetProject"
	VmMigration_ListReplicationCycles_FullMethodName     = "/google.cloud.vmmigration.v1.VmMigration/ListReplicationCycles"
	VmMigration_GetReplicationCycle_FullMethodName       = "/google.cloud.vmmigration.v1.VmMigration/GetReplicationCycle"
	VmMigration_ListImageImports_FullMethodName          = "/google.cloud.vmmigration.v1.VmMigration/ListImageImports"
	VmMigration_GetImageImport_FullMethodName            = "/google.cloud.vmmigration.v1.VmMigration/GetImageImport"
	VmMigration_CreateImageImport_FullMethodName         = "/google.cloud.vmmigration.v1.VmMigration/CreateImageImport"
	VmMigration_DeleteImageImport_FullMethodName         = "/google.cloud.vmmigration.v1.VmMigration/DeleteImageImport"
	VmMigration_ListImageImportJobs_FullMethodName       = "/google.cloud.vmmigration.v1.VmMigration/ListImageImportJobs"
	VmMigration_GetImageImportJob_FullMethodName         = "/google.cloud.vmmigration.v1.VmMigration/GetImageImportJob"
	VmMigration_CancelImageImportJob_FullMethodName      = "/google.cloud.vmmigration.v1.VmMigration/CancelImageImportJob"
	VmMigration_CreateDiskMigrationJob_FullMethodName    = "/google.cloud.vmmigration.v1.VmMigration/CreateDiskMigrationJob"
	VmMigration_ListDiskMigrationJobs_FullMethodName     = "/google.cloud.vmmigration.v1.VmMigration/ListDiskMigrationJobs"
	VmMigration_GetDiskMigrationJob_FullMethodName       = "/google.cloud.vmmigration.v1.VmMigration/GetDiskMigrationJob"
	VmMigration_UpdateDiskMigrationJob_FullMethodName    = "/google.cloud.vmmigration.v1.VmMigration/UpdateDiskMigrationJob"
	VmMigration_DeleteDiskMigrationJob_FullMethodName    = "/google.cloud.vmmigration.v1.VmMigration/DeleteDiskMigrationJob"
	VmMigration_RunDiskMigrationJob_FullMethodName       = "/google.cloud.vmmigration.v1.VmMigration/RunDiskMigrationJob"
	VmMigration_CancelDiskMigrationJob_FullMethodName    = "/google.cloud.vmmigration.v1.VmMigration/CancelDiskMigrationJob"
)

// VmMigrationClient is the client API for VmMigration service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type VmMigrationClient interface {
	// Lists Sources in a given project and location.
	ListSources(ctx context.Context, in *ListSourcesRequest, opts ...grpc.CallOption) (*ListSourcesResponse, error)
	// Gets details of a single Source.
	GetSource(ctx context.Context, in *GetSourceRequest, opts ...grpc.CallOption) (*Source, error)
	// Creates a new Source in a given project and location.
	CreateSource(ctx context.Context, in *CreateSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Source.
	UpdateSource(ctx context.Context, in *UpdateSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Source.
	DeleteSource(ctx context.Context, in *DeleteSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// List remote source's inventory of VMs.
	// The remote source is the onprem vCenter (remote in the sense it's not in
	// Compute Engine). The inventory describes the list of existing VMs in that
	// source. Note that this operation lists the VMs on the remote source, as
	// opposed to listing the MigratingVms resources in the vmmigration service.
	FetchInventory(ctx context.Context, in *FetchInventoryRequest, opts ...grpc.CallOption) (*FetchInventoryResponse, error)
	// List remote source's inventory of storage resources.
	// The remote source is another cloud vendor (e.g. AWS, Azure).
	// The inventory describes the list of existing storage resources in that
	// source. Note that this operation lists the resources on the remote source,
	// as opposed to listing the MigratingVms resources in the vmmigration
	// service.
	FetchStorageInventory(ctx context.Context, in *FetchStorageInventoryRequest, opts ...grpc.CallOption) (*FetchStorageInventoryResponse, error)
	// Lists Utilization Reports of the given Source.
	ListUtilizationReports(ctx context.Context, in *ListUtilizationReportsRequest, opts ...grpc.CallOption) (*ListUtilizationReportsResponse, error)
	// Gets a single Utilization Report.
	GetUtilizationReport(ctx context.Context, in *GetUtilizationReportRequest, opts ...grpc.CallOption) (*UtilizationReport, error)
	// Creates a new UtilizationReport.
	CreateUtilizationReport(ctx context.Context, in *CreateUtilizationReportRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Utilization Report.
	DeleteUtilizationReport(ctx context.Context, in *DeleteUtilizationReportRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists DatacenterConnectors in a given Source.
	ListDatacenterConnectors(ctx context.Context, in *ListDatacenterConnectorsRequest, opts ...grpc.CallOption) (*ListDatacenterConnectorsResponse, error)
	// Gets details of a single DatacenterConnector.
	GetDatacenterConnector(ctx context.Context, in *GetDatacenterConnectorRequest, opts ...grpc.CallOption) (*DatacenterConnector, error)
	// Creates a new DatacenterConnector in a given Source.
	CreateDatacenterConnector(ctx context.Context, in *CreateDatacenterConnectorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single DatacenterConnector.
	DeleteDatacenterConnector(ctx context.Context, in *DeleteDatacenterConnectorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Upgrades the appliance relate to this DatacenterConnector to the in-place
	// updateable version.
	UpgradeAppliance(ctx context.Context, in *UpgradeApplianceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new MigratingVm in a given Source.
	CreateMigratingVm(ctx context.Context, in *CreateMigratingVmRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists MigratingVms in a given Source.
	ListMigratingVms(ctx context.Context, in *ListMigratingVmsRequest, opts ...grpc.CallOption) (*ListMigratingVmsResponse, error)
	// Gets details of a single MigratingVm.
	GetMigratingVm(ctx context.Context, in *GetMigratingVmRequest, opts ...grpc.CallOption) (*MigratingVm, error)
	// Updates the parameters of a single MigratingVm.
	UpdateMigratingVm(ctx context.Context, in *UpdateMigratingVmRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single MigratingVm.
	DeleteMigratingVm(ctx context.Context, in *DeleteMigratingVmRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Starts migration for a VM. Starts the process of uploading
	// data and creating snapshots, in replication cycles scheduled by the policy.
	StartMigration(ctx context.Context, in *StartMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Resumes a migration for a VM. When called on a paused migration, will start
	// the process of uploading data and creating snapshots; when called on a
	// completed cut-over migration, will update the migration to active state and
	// start the process of uploading data and creating snapshots.
	ResumeMigration(ctx context.Context, in *ResumeMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Pauses a migration for a VM. If cycle tasks are running they will be
	// cancelled, preserving source task data. Further replication cycles will not
	// be triggered while the VM is paused.
	PauseMigration(ctx context.Context, in *PauseMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Marks a migration as completed, deleting migration resources that are no
	// longer being used. Only applicable after cutover is done.
	FinalizeMigration(ctx context.Context, in *FinalizeMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Extend the migrating VM time to live.
	ExtendMigration(ctx context.Context, in *ExtendMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Initiates a Clone of a specific migrating VM.
	CreateCloneJob(ctx context.Context, in *CreateCloneJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Initiates the cancellation of a running clone job.
	CancelCloneJob(ctx context.Context, in *CancelCloneJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the CloneJobs of a migrating VM. Only 25 most recent CloneJobs are
	// listed.
	ListCloneJobs(ctx context.Context, in *ListCloneJobsRequest, opts ...grpc.CallOption) (*ListCloneJobsResponse, error)
	// Gets details of a single CloneJob.
	GetCloneJob(ctx context.Context, in *GetCloneJobRequest, opts ...grpc.CallOption) (*CloneJob, error)
	// Initiates a Cutover of a specific migrating VM.
	// The returned LRO is completed when the cutover job resource is created
	// and the job is initiated.
	CreateCutoverJob(ctx context.Context, in *CreateCutoverJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Initiates the cancellation of a running cutover job.
	CancelCutoverJob(ctx context.Context, in *CancelCutoverJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the CutoverJobs of a migrating VM. Only 25 most recent CutoverJobs
	// are listed.
	ListCutoverJobs(ctx context.Context, in *ListCutoverJobsRequest, opts ...grpc.CallOption) (*ListCutoverJobsResponse, error)
	// Gets details of a single CutoverJob.
	GetCutoverJob(ctx context.Context, in *GetCutoverJobRequest, opts ...grpc.CallOption) (*CutoverJob, error)
	// Lists Groups in a given project and location.
	ListGroups(ctx context.Context, in *ListGroupsRequest, opts ...grpc.CallOption) (*ListGroupsResponse, error)
	// Gets details of a single Group.
	GetGroup(ctx context.Context, in *GetGroupRequest, opts ...grpc.CallOption) (*Group, error)
	// Creates a new Group in a given project and location.
	CreateGroup(ctx context.Context, in *CreateGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Group.
	UpdateGroup(ctx context.Context, in *UpdateGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Group.
	DeleteGroup(ctx context.Context, in *DeleteGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Adds a MigratingVm to a Group.
	AddGroupMigration(ctx context.Context, in *AddGroupMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Removes a MigratingVm from a Group.
	RemoveGroupMigration(ctx context.Context, in *RemoveGroupMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists TargetProjects in a given project.
	//
	// NOTE: TargetProject is a global resource; hence the only supported value
	// for location is `global`.
	ListTargetProjects(ctx context.Context, in *ListTargetProjectsRequest, opts ...grpc.CallOption) (*ListTargetProjectsResponse, error)
	// Gets details of a single TargetProject.
	//
	// NOTE: TargetProject is a global resource; hence the only supported value
	// for location is `global`.
	GetTargetProject(ctx context.Context, in *GetTargetProjectRequest, opts ...grpc.CallOption) (*TargetProject, error)
	// Creates a new TargetProject in a given project.
	//
	// NOTE: TargetProject is a global resource; hence the only supported value
	// for location is `global`.
	CreateTargetProject(ctx context.Context, in *CreateTargetProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single TargetProject.
	//
	// NOTE: TargetProject is a global resource; hence the only supported value
	// for location is `global`.
	UpdateTargetProject(ctx context.Context, in *UpdateTargetProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single TargetProject.
	//
	// NOTE: TargetProject is a global resource; hence the only supported value
	// for location is `global`.
	DeleteTargetProject(ctx context.Context, in *DeleteTargetProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists ReplicationCycles in a given MigratingVM.
	ListReplicationCycles(ctx context.Context, in *ListReplicationCyclesRequest, opts ...grpc.CallOption) (*ListReplicationCyclesResponse, error)
	// Gets details of a single ReplicationCycle.
	GetReplicationCycle(ctx context.Context, in *GetReplicationCycleRequest, opts ...grpc.CallOption) (*ReplicationCycle, error)
	// Lists ImageImports in a given project.
	ListImageImports(ctx context.Context, in *ListImageImportsRequest, opts ...grpc.CallOption) (*ListImageImportsResponse, error)
	// Gets details of a single ImageImport.
	GetImageImport(ctx context.Context, in *GetImageImportRequest, opts ...grpc.CallOption) (*ImageImport, error)
	// Creates a new ImageImport in a given project.
	CreateImageImport(ctx context.Context, in *CreateImageImportRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single ImageImport.
	DeleteImageImport(ctx context.Context, in *DeleteImageImportRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists ImageImportJobs in a given project.
	ListImageImportJobs(ctx context.Context, in *ListImageImportJobsRequest, opts ...grpc.CallOption) (*ListImageImportJobsResponse, error)
	// Gets details of a single ImageImportJob.
	GetImageImportJob(ctx context.Context, in *GetImageImportJobRequest, opts ...grpc.CallOption) (*ImageImportJob, error)
	// Initiates the cancellation of a running ImageImportJob.
	CancelImageImportJob(ctx context.Context, in *CancelImageImportJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a new disk migration job in a given Source.
	CreateDiskMigrationJob(ctx context.Context, in *CreateDiskMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists DiskMigrationJobs in a given Source.
	ListDiskMigrationJobs(ctx context.Context, in *ListDiskMigrationJobsRequest, opts ...grpc.CallOption) (*ListDiskMigrationJobsResponse, error)
	// Gets details of a single DiskMigrationJob.
	GetDiskMigrationJob(ctx context.Context, in *GetDiskMigrationJobRequest, opts ...grpc.CallOption) (*DiskMigrationJob, error)
	// Updates the parameters of a single DiskMigrationJob.
	UpdateDiskMigrationJob(ctx context.Context, in *UpdateDiskMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single DiskMigrationJob.
	DeleteDiskMigrationJob(ctx context.Context, in *DeleteDiskMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Runs the disk migration job.
	RunDiskMigrationJob(ctx context.Context, in *RunDiskMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Cancels the disk migration job.
	CancelDiskMigrationJob(ctx context.Context, in *CancelDiskMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type vmMigrationClient struct {
	cc grpc.ClientConnInterface
}

func NewVmMigrationClient(cc grpc.ClientConnInterface) VmMigrationClient {
	return &vmMigrationClient{cc}
}

func (c *vmMigrationClient) ListSources(ctx context.Context, in *ListSourcesRequest, opts ...grpc.CallOption) (*ListSourcesResponse, error) {
	out := new(ListSourcesResponse)
	err := c.cc.Invoke(ctx, VmMigration_ListSources_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) GetSource(ctx context.Context, in *GetSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, VmMigration_GetSource_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CreateSource(ctx context.Context, in *CreateSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_CreateSource_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) UpdateSource(ctx context.Context, in *UpdateSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_UpdateSource_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) DeleteSource(ctx context.Context, in *DeleteSourceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_DeleteSource_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) FetchInventory(ctx context.Context, in *FetchInventoryRequest, opts ...grpc.CallOption) (*FetchInventoryResponse, error) {
	out := new(FetchInventoryResponse)
	err := c.cc.Invoke(ctx, VmMigration_FetchInventory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) FetchStorageInventory(ctx context.Context, in *FetchStorageInventoryRequest, opts ...grpc.CallOption) (*FetchStorageInventoryResponse, error) {
	out := new(FetchStorageInventoryResponse)
	err := c.cc.Invoke(ctx, VmMigration_FetchStorageInventory_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) ListUtilizationReports(ctx context.Context, in *ListUtilizationReportsRequest, opts ...grpc.CallOption) (*ListUtilizationReportsResponse, error) {
	out := new(ListUtilizationReportsResponse)
	err := c.cc.Invoke(ctx, VmMigration_ListUtilizationReports_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) GetUtilizationReport(ctx context.Context, in *GetUtilizationReportRequest, opts ...grpc.CallOption) (*UtilizationReport, error) {
	out := new(UtilizationReport)
	err := c.cc.Invoke(ctx, VmMigration_GetUtilizationReport_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CreateUtilizationReport(ctx context.Context, in *CreateUtilizationReportRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_CreateUtilizationReport_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) DeleteUtilizationReport(ctx context.Context, in *DeleteUtilizationReportRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_DeleteUtilizationReport_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) ListDatacenterConnectors(ctx context.Context, in *ListDatacenterConnectorsRequest, opts ...grpc.CallOption) (*ListDatacenterConnectorsResponse, error) {
	out := new(ListDatacenterConnectorsResponse)
	err := c.cc.Invoke(ctx, VmMigration_ListDatacenterConnectors_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) GetDatacenterConnector(ctx context.Context, in *GetDatacenterConnectorRequest, opts ...grpc.CallOption) (*DatacenterConnector, error) {
	out := new(DatacenterConnector)
	err := c.cc.Invoke(ctx, VmMigration_GetDatacenterConnector_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CreateDatacenterConnector(ctx context.Context, in *CreateDatacenterConnectorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_CreateDatacenterConnector_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) DeleteDatacenterConnector(ctx context.Context, in *DeleteDatacenterConnectorRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_DeleteDatacenterConnector_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) UpgradeAppliance(ctx context.Context, in *UpgradeApplianceRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_UpgradeAppliance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CreateMigratingVm(ctx context.Context, in *CreateMigratingVmRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_CreateMigratingVm_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) ListMigratingVms(ctx context.Context, in *ListMigratingVmsRequest, opts ...grpc.CallOption) (*ListMigratingVmsResponse, error) {
	out := new(ListMigratingVmsResponse)
	err := c.cc.Invoke(ctx, VmMigration_ListMigratingVms_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) GetMigratingVm(ctx context.Context, in *GetMigratingVmRequest, opts ...grpc.CallOption) (*MigratingVm, error) {
	out := new(MigratingVm)
	err := c.cc.Invoke(ctx, VmMigration_GetMigratingVm_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) UpdateMigratingVm(ctx context.Context, in *UpdateMigratingVmRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_UpdateMigratingVm_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) DeleteMigratingVm(ctx context.Context, in *DeleteMigratingVmRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_DeleteMigratingVm_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) StartMigration(ctx context.Context, in *StartMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_StartMigration_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) ResumeMigration(ctx context.Context, in *ResumeMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_ResumeMigration_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) PauseMigration(ctx context.Context, in *PauseMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_PauseMigration_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) FinalizeMigration(ctx context.Context, in *FinalizeMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_FinalizeMigration_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) ExtendMigration(ctx context.Context, in *ExtendMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_ExtendMigration_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CreateCloneJob(ctx context.Context, in *CreateCloneJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_CreateCloneJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CancelCloneJob(ctx context.Context, in *CancelCloneJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_CancelCloneJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) ListCloneJobs(ctx context.Context, in *ListCloneJobsRequest, opts ...grpc.CallOption) (*ListCloneJobsResponse, error) {
	out := new(ListCloneJobsResponse)
	err := c.cc.Invoke(ctx, VmMigration_ListCloneJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) GetCloneJob(ctx context.Context, in *GetCloneJobRequest, opts ...grpc.CallOption) (*CloneJob, error) {
	out := new(CloneJob)
	err := c.cc.Invoke(ctx, VmMigration_GetCloneJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CreateCutoverJob(ctx context.Context, in *CreateCutoverJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_CreateCutoverJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CancelCutoverJob(ctx context.Context, in *CancelCutoverJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_CancelCutoverJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) ListCutoverJobs(ctx context.Context, in *ListCutoverJobsRequest, opts ...grpc.CallOption) (*ListCutoverJobsResponse, error) {
	out := new(ListCutoverJobsResponse)
	err := c.cc.Invoke(ctx, VmMigration_ListCutoverJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) GetCutoverJob(ctx context.Context, in *GetCutoverJobRequest, opts ...grpc.CallOption) (*CutoverJob, error) {
	out := new(CutoverJob)
	err := c.cc.Invoke(ctx, VmMigration_GetCutoverJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) ListGroups(ctx context.Context, in *ListGroupsRequest, opts ...grpc.CallOption) (*ListGroupsResponse, error) {
	out := new(ListGroupsResponse)
	err := c.cc.Invoke(ctx, VmMigration_ListGroups_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) GetGroup(ctx context.Context, in *GetGroupRequest, opts ...grpc.CallOption) (*Group, error) {
	out := new(Group)
	err := c.cc.Invoke(ctx, VmMigration_GetGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CreateGroup(ctx context.Context, in *CreateGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_CreateGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) UpdateGroup(ctx context.Context, in *UpdateGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_UpdateGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) DeleteGroup(ctx context.Context, in *DeleteGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_DeleteGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) AddGroupMigration(ctx context.Context, in *AddGroupMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_AddGroupMigration_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) RemoveGroupMigration(ctx context.Context, in *RemoveGroupMigrationRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_RemoveGroupMigration_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) ListTargetProjects(ctx context.Context, in *ListTargetProjectsRequest, opts ...grpc.CallOption) (*ListTargetProjectsResponse, error) {
	out := new(ListTargetProjectsResponse)
	err := c.cc.Invoke(ctx, VmMigration_ListTargetProjects_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) GetTargetProject(ctx context.Context, in *GetTargetProjectRequest, opts ...grpc.CallOption) (*TargetProject, error) {
	out := new(TargetProject)
	err := c.cc.Invoke(ctx, VmMigration_GetTargetProject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CreateTargetProject(ctx context.Context, in *CreateTargetProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_CreateTargetProject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) UpdateTargetProject(ctx context.Context, in *UpdateTargetProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_UpdateTargetProject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) DeleteTargetProject(ctx context.Context, in *DeleteTargetProjectRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_DeleteTargetProject_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) ListReplicationCycles(ctx context.Context, in *ListReplicationCyclesRequest, opts ...grpc.CallOption) (*ListReplicationCyclesResponse, error) {
	out := new(ListReplicationCyclesResponse)
	err := c.cc.Invoke(ctx, VmMigration_ListReplicationCycles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) GetReplicationCycle(ctx context.Context, in *GetReplicationCycleRequest, opts ...grpc.CallOption) (*ReplicationCycle, error) {
	out := new(ReplicationCycle)
	err := c.cc.Invoke(ctx, VmMigration_GetReplicationCycle_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) ListImageImports(ctx context.Context, in *ListImageImportsRequest, opts ...grpc.CallOption) (*ListImageImportsResponse, error) {
	out := new(ListImageImportsResponse)
	err := c.cc.Invoke(ctx, VmMigration_ListImageImports_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) GetImageImport(ctx context.Context, in *GetImageImportRequest, opts ...grpc.CallOption) (*ImageImport, error) {
	out := new(ImageImport)
	err := c.cc.Invoke(ctx, VmMigration_GetImageImport_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CreateImageImport(ctx context.Context, in *CreateImageImportRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_CreateImageImport_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) DeleteImageImport(ctx context.Context, in *DeleteImageImportRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_DeleteImageImport_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) ListImageImportJobs(ctx context.Context, in *ListImageImportJobsRequest, opts ...grpc.CallOption) (*ListImageImportJobsResponse, error) {
	out := new(ListImageImportJobsResponse)
	err := c.cc.Invoke(ctx, VmMigration_ListImageImportJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) GetImageImportJob(ctx context.Context, in *GetImageImportJobRequest, opts ...grpc.CallOption) (*ImageImportJob, error) {
	out := new(ImageImportJob)
	err := c.cc.Invoke(ctx, VmMigration_GetImageImportJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CancelImageImportJob(ctx context.Context, in *CancelImageImportJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_CancelImageImportJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CreateDiskMigrationJob(ctx context.Context, in *CreateDiskMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_CreateDiskMigrationJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) ListDiskMigrationJobs(ctx context.Context, in *ListDiskMigrationJobsRequest, opts ...grpc.CallOption) (*ListDiskMigrationJobsResponse, error) {
	out := new(ListDiskMigrationJobsResponse)
	err := c.cc.Invoke(ctx, VmMigration_ListDiskMigrationJobs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) GetDiskMigrationJob(ctx context.Context, in *GetDiskMigrationJobRequest, opts ...grpc.CallOption) (*DiskMigrationJob, error) {
	out := new(DiskMigrationJob)
	err := c.cc.Invoke(ctx, VmMigration_GetDiskMigrationJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) UpdateDiskMigrationJob(ctx context.Context, in *UpdateDiskMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_UpdateDiskMigrationJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) DeleteDiskMigrationJob(ctx context.Context, in *DeleteDiskMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_DeleteDiskMigrationJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) RunDiskMigrationJob(ctx context.Context, in *RunDiskMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_RunDiskMigrationJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *vmMigrationClient) CancelDiskMigrationJob(ctx context.Context, in *CancelDiskMigrationJobRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, VmMigration_CancelDiskMigrationJob_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VmMigrationServer is the server API for VmMigration service.
// All implementations should embed UnimplementedVmMigrationServer
// for forward compatibility
type VmMigrationServer interface {
	// Lists Sources in a given project and location.
	ListSources(context.Context, *ListSourcesRequest) (*ListSourcesResponse, error)
	// Gets details of a single Source.
	GetSource(context.Context, *GetSourceRequest) (*Source, error)
	// Creates a new Source in a given project and location.
	CreateSource(context.Context, *CreateSourceRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Source.
	UpdateSource(context.Context, *UpdateSourceRequest) (*longrunningpb.Operation, error)
	// Deletes a single Source.
	DeleteSource(context.Context, *DeleteSourceRequest) (*longrunningpb.Operation, error)
	// List remote source's inventory of VMs.
	// The remote source is the onprem vCenter (remote in the sense it's not in
	// Compute Engine). The inventory describes the list of existing VMs in that
	// source. Note that this operation lists the VMs on the remote source, as
	// opposed to listing the MigratingVms resources in the vmmigration service.
	FetchInventory(context.Context, *FetchInventoryRequest) (*FetchInventoryResponse, error)
	// List remote source's inventory of storage resources.
	// The remote source is another cloud vendor (e.g. AWS, Azure).
	// The inventory describes the list of existing storage resources in that
	// source. Note that this operation lists the resources on the remote source,
	// as opposed to listing the MigratingVms resources in the vmmigration
	// service.
	FetchStorageInventory(context.Context, *FetchStorageInventoryRequest) (*FetchStorageInventoryResponse, error)
	// Lists Utilization Reports of the given Source.
	ListUtilizationReports(context.Context, *ListUtilizationReportsRequest) (*ListUtilizationReportsResponse, error)
	// Gets a single Utilization Report.
	GetUtilizationReport(context.Context, *GetUtilizationReportRequest) (*UtilizationReport, error)
	// Creates a new UtilizationReport.
	CreateUtilizationReport(context.Context, *CreateUtilizationReportRequest) (*longrunningpb.Operation, error)
	// Deletes a single Utilization Report.
	DeleteUtilizationReport(context.Context, *DeleteUtilizationReportRequest) (*longrunningpb.Operation, error)
	// Lists DatacenterConnectors in a given Source.
	ListDatacenterConnectors(context.Context, *ListDatacenterConnectorsRequest) (*ListDatacenterConnectorsResponse, error)
	// Gets details of a single DatacenterConnector.
	GetDatacenterConnector(context.Context, *GetDatacenterConnectorRequest) (*DatacenterConnector, error)
	// Creates a new DatacenterConnector in a given Source.
	CreateDatacenterConnector(context.Context, *CreateDatacenterConnectorRequest) (*longrunningpb.Operation, error)
	// Deletes a single DatacenterConnector.
	DeleteDatacenterConnector(context.Context, *DeleteDatacenterConnectorRequest) (*longrunningpb.Operation, error)
	// Upgrades the appliance relate to this DatacenterConnector to the in-place
	// updateable version.
	UpgradeAppliance(context.Context, *UpgradeApplianceRequest) (*longrunningpb.Operation, error)
	// Creates a new MigratingVm in a given Source.
	CreateMigratingVm(context.Context, *CreateMigratingVmRequest) (*longrunningpb.Operation, error)
	// Lists MigratingVms in a given Source.
	ListMigratingVms(context.Context, *ListMigratingVmsRequest) (*ListMigratingVmsResponse, error)
	// Gets details of a single MigratingVm.
	GetMigratingVm(context.Context, *GetMigratingVmRequest) (*MigratingVm, error)
	// Updates the parameters of a single MigratingVm.
	UpdateMigratingVm(context.Context, *UpdateMigratingVmRequest) (*longrunningpb.Operation, error)
	// Deletes a single MigratingVm.
	DeleteMigratingVm(context.Context, *DeleteMigratingVmRequest) (*longrunningpb.Operation, error)
	// Starts migration for a VM. Starts the process of uploading
	// data and creating snapshots, in replication cycles scheduled by the policy.
	StartMigration(context.Context, *StartMigrationRequest) (*longrunningpb.Operation, error)
	// Resumes a migration for a VM. When called on a paused migration, will start
	// the process of uploading data and creating snapshots; when called on a
	// completed cut-over migration, will update the migration to active state and
	// start the process of uploading data and creating snapshots.
	ResumeMigration(context.Context, *ResumeMigrationRequest) (*longrunningpb.Operation, error)
	// Pauses a migration for a VM. If cycle tasks are running they will be
	// cancelled, preserving source task data. Further replication cycles will not
	// be triggered while the VM is paused.
	PauseMigration(context.Context, *PauseMigrationRequest) (*longrunningpb.Operation, error)
	// Marks a migration as completed, deleting migration resources that are no
	// longer being used. Only applicable after cutover is done.
	FinalizeMigration(context.Context, *FinalizeMigrationRequest) (*longrunningpb.Operation, error)
	// Extend the migrating VM time to live.
	ExtendMigration(context.Context, *ExtendMigrationRequest) (*longrunningpb.Operation, error)
	// Initiates a Clone of a specific migrating VM.
	CreateCloneJob(context.Context, *CreateCloneJobRequest) (*longrunningpb.Operation, error)
	// Initiates the cancellation of a running clone job.
	CancelCloneJob(context.Context, *CancelCloneJobRequest) (*longrunningpb.Operation, error)
	// Lists the CloneJobs of a migrating VM. Only 25 most recent CloneJobs are
	// listed.
	ListCloneJobs(context.Context, *ListCloneJobsRequest) (*ListCloneJobsResponse, error)
	// Gets details of a single CloneJob.
	GetCloneJob(context.Context, *GetCloneJobRequest) (*CloneJob, error)
	// Initiates a Cutover of a specific migrating VM.
	// The returned LRO is completed when the cutover job resource is created
	// and the job is initiated.
	CreateCutoverJob(context.Context, *CreateCutoverJobRequest) (*longrunningpb.Operation, error)
	// Initiates the cancellation of a running cutover job.
	CancelCutoverJob(context.Context, *CancelCutoverJobRequest) (*longrunningpb.Operation, error)
	// Lists the CutoverJobs of a migrating VM. Only 25 most recent CutoverJobs
	// are listed.
	ListCutoverJobs(context.Context, *ListCutoverJobsRequest) (*ListCutoverJobsResponse, error)
	// Gets details of a single CutoverJob.
	GetCutoverJob(context.Context, *GetCutoverJobRequest) (*CutoverJob, error)
	// Lists Groups in a given project and location.
	ListGroups(context.Context, *ListGroupsRequest) (*ListGroupsResponse, error)
	// Gets details of a single Group.
	GetGroup(context.Context, *GetGroupRequest) (*Group, error)
	// Creates a new Group in a given project and location.
	CreateGroup(context.Context, *CreateGroupRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Group.
	UpdateGroup(context.Context, *UpdateGroupRequest) (*longrunningpb.Operation, error)
	// Deletes a single Group.
	DeleteGroup(context.Context, *DeleteGroupRequest) (*longrunningpb.Operation, error)
	// Adds a MigratingVm to a Group.
	AddGroupMigration(context.Context, *AddGroupMigrationRequest) (*longrunningpb.Operation, error)
	// Removes a MigratingVm from a Group.
	RemoveGroupMigration(context.Context, *RemoveGroupMigrationRequest) (*longrunningpb.Operation, error)
	// Lists TargetProjects in a given project.
	//
	// NOTE: TargetProject is a global resource; hence the only supported value
	// for location is `global`.
	ListTargetProjects(context.Context, *ListTargetProjectsRequest) (*ListTargetProjectsResponse, error)
	// Gets details of a single TargetProject.
	//
	// NOTE: TargetProject is a global resource; hence the only supported value
	// for location is `global`.
	GetTargetProject(context.Context, *GetTargetProjectRequest) (*TargetProject, error)
	// Creates a new TargetProject in a given project.
	//
	// NOTE: TargetProject is a global resource; hence the only supported value
	// for location is `global`.
	CreateTargetProject(context.Context, *CreateTargetProjectRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single TargetProject.
	//
	// NOTE: TargetProject is a global resource; hence the only supported value
	// for location is `global`.
	UpdateTargetProject(context.Context, *UpdateTargetProjectRequest) (*longrunningpb.Operation, error)
	// Deletes a single TargetProject.
	//
	// NOTE: TargetProject is a global resource; hence the only supported value
	// for location is `global`.
	DeleteTargetProject(context.Context, *DeleteTargetProjectRequest) (*longrunningpb.Operation, error)
	// Lists ReplicationCycles in a given MigratingVM.
	ListReplicationCycles(context.Context, *ListReplicationCyclesRequest) (*ListReplicationCyclesResponse, error)
	// Gets details of a single ReplicationCycle.
	GetReplicationCycle(context.Context, *GetReplicationCycleRequest) (*ReplicationCycle, error)
	// Lists ImageImports in a given project.
	ListImageImports(context.Context, *ListImageImportsRequest) (*ListImageImportsResponse, error)
	// Gets details of a single ImageImport.
	GetImageImport(context.Context, *GetImageImportRequest) (*ImageImport, error)
	// Creates a new ImageImport in a given project.
	CreateImageImport(context.Context, *CreateImageImportRequest) (*longrunningpb.Operation, error)
	// Deletes a single ImageImport.
	DeleteImageImport(context.Context, *DeleteImageImportRequest) (*longrunningpb.Operation, error)
	// Lists ImageImportJobs in a given project.
	ListImageImportJobs(context.Context, *ListImageImportJobsRequest) (*ListImageImportJobsResponse, error)
	// Gets details of a single ImageImportJob.
	GetImageImportJob(context.Context, *GetImageImportJobRequest) (*ImageImportJob, error)
	// Initiates the cancellation of a running ImageImportJob.
	CancelImageImportJob(context.Context, *CancelImageImportJobRequest) (*longrunningpb.Operation, error)
	// Creates a new disk migration job in a given Source.
	CreateDiskMigrationJob(context.Context, *CreateDiskMigrationJobRequest) (*longrunningpb.Operation, error)
	// Lists DiskMigrationJobs in a given Source.
	ListDiskMigrationJobs(context.Context, *ListDiskMigrationJobsRequest) (*ListDiskMigrationJobsResponse, error)
	// Gets details of a single DiskMigrationJob.
	GetDiskMigrationJob(context.Context, *GetDiskMigrationJobRequest) (*DiskMigrationJob, error)
	// Updates the parameters of a single DiskMigrationJob.
	UpdateDiskMigrationJob(context.Context, *UpdateDiskMigrationJobRequest) (*longrunningpb.Operation, error)
	// Deletes a single DiskMigrationJob.
	DeleteDiskMigrationJob(context.Context, *DeleteDiskMigrationJobRequest) (*longrunningpb.Operation, error)
	// Runs the disk migration job.
	RunDiskMigrationJob(context.Context, *RunDiskMigrationJobRequest) (*longrunningpb.Operation, error)
	// Cancels the disk migration job.
	CancelDiskMigrationJob(context.Context, *CancelDiskMigrationJobRequest) (*longrunningpb.Operation, error)
}

// UnimplementedVmMigrationServer should be embedded to have forward compatible implementations.
type UnimplementedVmMigrationServer struct {
}

func (UnimplementedVmMigrationServer) ListSources(context.Context, *ListSourcesRequest) (*ListSourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSources not implemented")
}
func (UnimplementedVmMigrationServer) GetSource(context.Context, *GetSourceRequest) (*Source, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSource not implemented")
}
func (UnimplementedVmMigrationServer) CreateSource(context.Context, *CreateSourceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSource not implemented")
}
func (UnimplementedVmMigrationServer) UpdateSource(context.Context, *UpdateSourceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSource not implemented")
}
func (UnimplementedVmMigrationServer) DeleteSource(context.Context, *DeleteSourceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSource not implemented")
}
func (UnimplementedVmMigrationServer) FetchInventory(context.Context, *FetchInventoryRequest) (*FetchInventoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchInventory not implemented")
}
func (UnimplementedVmMigrationServer) FetchStorageInventory(context.Context, *FetchStorageInventoryRequest) (*FetchStorageInventoryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchStorageInventory not implemented")
}
func (UnimplementedVmMigrationServer) ListUtilizationReports(context.Context, *ListUtilizationReportsRequest) (*ListUtilizationReportsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListUtilizationReports not implemented")
}
func (UnimplementedVmMigrationServer) GetUtilizationReport(context.Context, *GetUtilizationReportRequest) (*UtilizationReport, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetUtilizationReport not implemented")
}
func (UnimplementedVmMigrationServer) CreateUtilizationReport(context.Context, *CreateUtilizationReportRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateUtilizationReport not implemented")
}
func (UnimplementedVmMigrationServer) DeleteUtilizationReport(context.Context, *DeleteUtilizationReportRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteUtilizationReport not implemented")
}
func (UnimplementedVmMigrationServer) ListDatacenterConnectors(context.Context, *ListDatacenterConnectorsRequest) (*ListDatacenterConnectorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDatacenterConnectors not implemented")
}
func (UnimplementedVmMigrationServer) GetDatacenterConnector(context.Context, *GetDatacenterConnectorRequest) (*DatacenterConnector, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDatacenterConnector not implemented")
}
func (UnimplementedVmMigrationServer) CreateDatacenterConnector(context.Context, *CreateDatacenterConnectorRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDatacenterConnector not implemented")
}
func (UnimplementedVmMigrationServer) DeleteDatacenterConnector(context.Context, *DeleteDatacenterConnectorRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDatacenterConnector not implemented")
}
func (UnimplementedVmMigrationServer) UpgradeAppliance(context.Context, *UpgradeApplianceRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpgradeAppliance not implemented")
}
func (UnimplementedVmMigrationServer) CreateMigratingVm(context.Context, *CreateMigratingVmRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMigratingVm not implemented")
}
func (UnimplementedVmMigrationServer) ListMigratingVms(context.Context, *ListMigratingVmsRequest) (*ListMigratingVmsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListMigratingVms not implemented")
}
func (UnimplementedVmMigrationServer) GetMigratingVm(context.Context, *GetMigratingVmRequest) (*MigratingVm, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMigratingVm not implemented")
}
func (UnimplementedVmMigrationServer) UpdateMigratingVm(context.Context, *UpdateMigratingVmRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateMigratingVm not implemented")
}
func (UnimplementedVmMigrationServer) DeleteMigratingVm(context.Context, *DeleteMigratingVmRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteMigratingVm not implemented")
}
func (UnimplementedVmMigrationServer) StartMigration(context.Context, *StartMigrationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartMigration not implemented")
}
func (UnimplementedVmMigrationServer) ResumeMigration(context.Context, *ResumeMigrationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResumeMigration not implemented")
}
func (UnimplementedVmMigrationServer) PauseMigration(context.Context, *PauseMigrationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PauseMigration not implemented")
}
func (UnimplementedVmMigrationServer) FinalizeMigration(context.Context, *FinalizeMigrationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FinalizeMigration not implemented")
}
func (UnimplementedVmMigrationServer) ExtendMigration(context.Context, *ExtendMigrationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExtendMigration not implemented")
}
func (UnimplementedVmMigrationServer) CreateCloneJob(context.Context, *CreateCloneJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCloneJob not implemented")
}
func (UnimplementedVmMigrationServer) CancelCloneJob(context.Context, *CancelCloneJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelCloneJob not implemented")
}
func (UnimplementedVmMigrationServer) ListCloneJobs(context.Context, *ListCloneJobsRequest) (*ListCloneJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCloneJobs not implemented")
}
func (UnimplementedVmMigrationServer) GetCloneJob(context.Context, *GetCloneJobRequest) (*CloneJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCloneJob not implemented")
}
func (UnimplementedVmMigrationServer) CreateCutoverJob(context.Context, *CreateCutoverJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCutoverJob not implemented")
}
func (UnimplementedVmMigrationServer) CancelCutoverJob(context.Context, *CancelCutoverJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelCutoverJob not implemented")
}
func (UnimplementedVmMigrationServer) ListCutoverJobs(context.Context, *ListCutoverJobsRequest) (*ListCutoverJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListCutoverJobs not implemented")
}
func (UnimplementedVmMigrationServer) GetCutoverJob(context.Context, *GetCutoverJobRequest) (*CutoverJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCutoverJob not implemented")
}
func (UnimplementedVmMigrationServer) ListGroups(context.Context, *ListGroupsRequest) (*ListGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGroups not implemented")
}
func (UnimplementedVmMigrationServer) GetGroup(context.Context, *GetGroupRequest) (*Group, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGroup not implemented")
}
func (UnimplementedVmMigrationServer) CreateGroup(context.Context, *CreateGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateGroup not implemented")
}
func (UnimplementedVmMigrationServer) UpdateGroup(context.Context, *UpdateGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGroup not implemented")
}
func (UnimplementedVmMigrationServer) DeleteGroup(context.Context, *DeleteGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteGroup not implemented")
}
func (UnimplementedVmMigrationServer) AddGroupMigration(context.Context, *AddGroupMigrationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddGroupMigration not implemented")
}
func (UnimplementedVmMigrationServer) RemoveGroupMigration(context.Context, *RemoveGroupMigrationRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveGroupMigration not implemented")
}
func (UnimplementedVmMigrationServer) ListTargetProjects(context.Context, *ListTargetProjectsRequest) (*ListTargetProjectsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTargetProjects not implemented")
}
func (UnimplementedVmMigrationServer) GetTargetProject(context.Context, *GetTargetProjectRequest) (*TargetProject, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTargetProject not implemented")
}
func (UnimplementedVmMigrationServer) CreateTargetProject(context.Context, *CreateTargetProjectRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTargetProject not implemented")
}
func (UnimplementedVmMigrationServer) UpdateTargetProject(context.Context, *UpdateTargetProjectRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTargetProject not implemented")
}
func (UnimplementedVmMigrationServer) DeleteTargetProject(context.Context, *DeleteTargetProjectRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTargetProject not implemented")
}
func (UnimplementedVmMigrationServer) ListReplicationCycles(context.Context, *ListReplicationCyclesRequest) (*ListReplicationCyclesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListReplicationCycles not implemented")
}
func (UnimplementedVmMigrationServer) GetReplicationCycle(context.Context, *GetReplicationCycleRequest) (*ReplicationCycle, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetReplicationCycle not implemented")
}
func (UnimplementedVmMigrationServer) ListImageImports(context.Context, *ListImageImportsRequest) (*ListImageImportsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListImageImports not implemented")
}
func (UnimplementedVmMigrationServer) GetImageImport(context.Context, *GetImageImportRequest) (*ImageImport, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetImageImport not implemented")
}
func (UnimplementedVmMigrationServer) CreateImageImport(context.Context, *CreateImageImportRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateImageImport not implemented")
}
func (UnimplementedVmMigrationServer) DeleteImageImport(context.Context, *DeleteImageImportRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteImageImport not implemented")
}
func (UnimplementedVmMigrationServer) ListImageImportJobs(context.Context, *ListImageImportJobsRequest) (*ListImageImportJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListImageImportJobs not implemented")
}
func (UnimplementedVmMigrationServer) GetImageImportJob(context.Context, *GetImageImportJobRequest) (*ImageImportJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetImageImportJob not implemented")
}
func (UnimplementedVmMigrationServer) CancelImageImportJob(context.Context, *CancelImageImportJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelImageImportJob not implemented")
}
func (UnimplementedVmMigrationServer) CreateDiskMigrationJob(context.Context, *CreateDiskMigrationJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDiskMigrationJob not implemented")
}
func (UnimplementedVmMigrationServer) ListDiskMigrationJobs(context.Context, *ListDiskMigrationJobsRequest) (*ListDiskMigrationJobsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDiskMigrationJobs not implemented")
}
func (UnimplementedVmMigrationServer) GetDiskMigrationJob(context.Context, *GetDiskMigrationJobRequest) (*DiskMigrationJob, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDiskMigrationJob not implemented")
}
func (UnimplementedVmMigrationServer) UpdateDiskMigrationJob(context.Context, *UpdateDiskMigrationJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDiskMigrationJob not implemented")
}
func (UnimplementedVmMigrationServer) DeleteDiskMigrationJob(context.Context, *DeleteDiskMigrationJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDiskMigrationJob not implemented")
}
func (UnimplementedVmMigrationServer) RunDiskMigrationJob(context.Context, *RunDiskMigrationJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RunDiskMigrationJob not implemented")
}
func (UnimplementedVmMigrationServer) CancelDiskMigrationJob(context.Context, *CancelDiskMigrationJobRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CancelDiskMigrationJob not implemented")
}

// UnsafeVmMigrationServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to VmMigrationServer will
// result in compilation errors.
type UnsafeVmMigrationServer interface {
	mustEmbedUnimplementedVmMigrationServer()
}

func RegisterVmMigrationServer(s grpc.ServiceRegistrar, srv VmMigrationServer) {
	s.RegisterService(&VmMigration_ServiceDesc, srv)
}

func _VmMigration_ListSources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ListSources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_ListSources_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ListSources(ctx, req.(*ListSourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_GetSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).GetSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_GetSource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).GetSource(ctx, req.(*GetSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CreateSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CreateSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_CreateSource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CreateSource(ctx, req.(*CreateSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_UpdateSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).UpdateSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_UpdateSource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).UpdateSource(ctx, req.(*UpdateSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_DeleteSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).DeleteSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_DeleteSource_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).DeleteSource(ctx, req.(*DeleteSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_FetchInventory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchInventoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).FetchInventory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_FetchInventory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).FetchInventory(ctx, req.(*FetchInventoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_FetchStorageInventory_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchStorageInventoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).FetchStorageInventory(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_FetchStorageInventory_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).FetchStorageInventory(ctx, req.(*FetchStorageInventoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_ListUtilizationReports_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUtilizationReportsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ListUtilizationReports(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_ListUtilizationReports_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ListUtilizationReports(ctx, req.(*ListUtilizationReportsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_GetUtilizationReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUtilizationReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).GetUtilizationReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_GetUtilizationReport_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).GetUtilizationReport(ctx, req.(*GetUtilizationReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CreateUtilizationReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateUtilizationReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CreateUtilizationReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_CreateUtilizationReport_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CreateUtilizationReport(ctx, req.(*CreateUtilizationReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_DeleteUtilizationReport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteUtilizationReportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).DeleteUtilizationReport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_DeleteUtilizationReport_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).DeleteUtilizationReport(ctx, req.(*DeleteUtilizationReportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_ListDatacenterConnectors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDatacenterConnectorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ListDatacenterConnectors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_ListDatacenterConnectors_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ListDatacenterConnectors(ctx, req.(*ListDatacenterConnectorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_GetDatacenterConnector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDatacenterConnectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).GetDatacenterConnector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_GetDatacenterConnector_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).GetDatacenterConnector(ctx, req.(*GetDatacenterConnectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CreateDatacenterConnector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDatacenterConnectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CreateDatacenterConnector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_CreateDatacenterConnector_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CreateDatacenterConnector(ctx, req.(*CreateDatacenterConnectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_DeleteDatacenterConnector_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDatacenterConnectorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).DeleteDatacenterConnector(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_DeleteDatacenterConnector_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).DeleteDatacenterConnector(ctx, req.(*DeleteDatacenterConnectorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_UpgradeAppliance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpgradeApplianceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).UpgradeAppliance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_UpgradeAppliance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).UpgradeAppliance(ctx, req.(*UpgradeApplianceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CreateMigratingVm_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMigratingVmRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CreateMigratingVm(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_CreateMigratingVm_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CreateMigratingVm(ctx, req.(*CreateMigratingVmRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_ListMigratingVms_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMigratingVmsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ListMigratingVms(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_ListMigratingVms_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ListMigratingVms(ctx, req.(*ListMigratingVmsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_GetMigratingVm_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMigratingVmRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).GetMigratingVm(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_GetMigratingVm_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).GetMigratingVm(ctx, req.(*GetMigratingVmRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_UpdateMigratingVm_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateMigratingVmRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).UpdateMigratingVm(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_UpdateMigratingVm_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).UpdateMigratingVm(ctx, req.(*UpdateMigratingVmRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_DeleteMigratingVm_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMigratingVmRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).DeleteMigratingVm(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_DeleteMigratingVm_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).DeleteMigratingVm(ctx, req.(*DeleteMigratingVmRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_StartMigration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartMigrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).StartMigration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_StartMigration_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).StartMigration(ctx, req.(*StartMigrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_ResumeMigration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeMigrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ResumeMigration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_ResumeMigration_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ResumeMigration(ctx, req.(*ResumeMigrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_PauseMigration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PauseMigrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).PauseMigration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_PauseMigration_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).PauseMigration(ctx, req.(*PauseMigrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_FinalizeMigration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FinalizeMigrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).FinalizeMigration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_FinalizeMigration_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).FinalizeMigration(ctx, req.(*FinalizeMigrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_ExtendMigration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExtendMigrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ExtendMigration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_ExtendMigration_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ExtendMigration(ctx, req.(*ExtendMigrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CreateCloneJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCloneJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CreateCloneJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_CreateCloneJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CreateCloneJob(ctx, req.(*CreateCloneJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CancelCloneJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelCloneJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CancelCloneJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_CancelCloneJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CancelCloneJob(ctx, req.(*CancelCloneJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_ListCloneJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCloneJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ListCloneJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_ListCloneJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ListCloneJobs(ctx, req.(*ListCloneJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_GetCloneJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCloneJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).GetCloneJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_GetCloneJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).GetCloneJob(ctx, req.(*GetCloneJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CreateCutoverJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCutoverJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CreateCutoverJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_CreateCutoverJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CreateCutoverJob(ctx, req.(*CreateCutoverJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CancelCutoverJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelCutoverJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CancelCutoverJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_CancelCutoverJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CancelCutoverJob(ctx, req.(*CancelCutoverJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_ListCutoverJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCutoverJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ListCutoverJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_ListCutoverJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ListCutoverJobs(ctx, req.(*ListCutoverJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_GetCutoverJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCutoverJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).GetCutoverJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_GetCutoverJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).GetCutoverJob(ctx, req.(*GetCutoverJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_ListGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ListGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_ListGroups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ListGroups(ctx, req.(*ListGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_GetGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).GetGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_GetGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).GetGroup(ctx, req.(*GetGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CreateGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CreateGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_CreateGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CreateGroup(ctx, req.(*CreateGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_UpdateGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).UpdateGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_UpdateGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).UpdateGroup(ctx, req.(*UpdateGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_DeleteGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).DeleteGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_DeleteGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).DeleteGroup(ctx, req.(*DeleteGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_AddGroupMigration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddGroupMigrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).AddGroupMigration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_AddGroupMigration_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).AddGroupMigration(ctx, req.(*AddGroupMigrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_RemoveGroupMigration_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveGroupMigrationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).RemoveGroupMigration(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_RemoveGroupMigration_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).RemoveGroupMigration(ctx, req.(*RemoveGroupMigrationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_ListTargetProjects_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTargetProjectsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ListTargetProjects(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_ListTargetProjects_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ListTargetProjects(ctx, req.(*ListTargetProjectsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_GetTargetProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTargetProjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).GetTargetProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_GetTargetProject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).GetTargetProject(ctx, req.(*GetTargetProjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CreateTargetProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTargetProjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CreateTargetProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_CreateTargetProject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CreateTargetProject(ctx, req.(*CreateTargetProjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_UpdateTargetProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTargetProjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).UpdateTargetProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_UpdateTargetProject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).UpdateTargetProject(ctx, req.(*UpdateTargetProjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_DeleteTargetProject_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTargetProjectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).DeleteTargetProject(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_DeleteTargetProject_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).DeleteTargetProject(ctx, req.(*DeleteTargetProjectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_ListReplicationCycles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReplicationCyclesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ListReplicationCycles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_ListReplicationCycles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ListReplicationCycles(ctx, req.(*ListReplicationCyclesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_GetReplicationCycle_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetReplicationCycleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).GetReplicationCycle(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_GetReplicationCycle_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).GetReplicationCycle(ctx, req.(*GetReplicationCycleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_ListImageImports_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListImageImportsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ListImageImports(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_ListImageImports_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ListImageImports(ctx, req.(*ListImageImportsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_GetImageImport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetImageImportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).GetImageImport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_GetImageImport_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).GetImageImport(ctx, req.(*GetImageImportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CreateImageImport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateImageImportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CreateImageImport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_CreateImageImport_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CreateImageImport(ctx, req.(*CreateImageImportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_DeleteImageImport_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteImageImportRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).DeleteImageImport(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_DeleteImageImport_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).DeleteImageImport(ctx, req.(*DeleteImageImportRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_ListImageImportJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListImageImportJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ListImageImportJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_ListImageImportJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ListImageImportJobs(ctx, req.(*ListImageImportJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_GetImageImportJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetImageImportJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).GetImageImportJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_GetImageImportJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).GetImageImportJob(ctx, req.(*GetImageImportJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CancelImageImportJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelImageImportJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CancelImageImportJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_CancelImageImportJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CancelImageImportJob(ctx, req.(*CancelImageImportJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CreateDiskMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDiskMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CreateDiskMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_CreateDiskMigrationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CreateDiskMigrationJob(ctx, req.(*CreateDiskMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_ListDiskMigrationJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDiskMigrationJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).ListDiskMigrationJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_ListDiskMigrationJobs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).ListDiskMigrationJobs(ctx, req.(*ListDiskMigrationJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_GetDiskMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDiskMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).GetDiskMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_GetDiskMigrationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).GetDiskMigrationJob(ctx, req.(*GetDiskMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_UpdateDiskMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDiskMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).UpdateDiskMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_UpdateDiskMigrationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).UpdateDiskMigrationJob(ctx, req.(*UpdateDiskMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_DeleteDiskMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDiskMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).DeleteDiskMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_DeleteDiskMigrationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).DeleteDiskMigrationJob(ctx, req.(*DeleteDiskMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_RunDiskMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunDiskMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).RunDiskMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_RunDiskMigrationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).RunDiskMigrationJob(ctx, req.(*RunDiskMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VmMigration_CancelDiskMigrationJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelDiskMigrationJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VmMigrationServer).CancelDiskMigrationJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: VmMigration_CancelDiskMigrationJob_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VmMigrationServer).CancelDiskMigrationJob(ctx, req.(*CancelDiskMigrationJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// VmMigration_ServiceDesc is the grpc.ServiceDesc for VmMigration service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var VmMigration_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.vmmigration.v1.VmMigration",
	HandlerType: (*VmMigrationServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListSources",
			Handler:    _VmMigration_ListSources_Handler,
		},
		{
			MethodName: "GetSource",
			Handler:    _VmMigration_GetSource_Handler,
		},
		{
			MethodName: "CreateSource",
			Handler:    _VmMigration_CreateSource_Handler,
		},
		{
			MethodName: "UpdateSource",
			Handler:    _VmMigration_UpdateSource_Handler,
		},
		{
			MethodName: "DeleteSource",
			Handler:    _VmMigration_DeleteSource_Handler,
		},
		{
			MethodName: "FetchInventory",
			Handler:    _VmMigration_FetchInventory_Handler,
		},
		{
			MethodName: "FetchStorageInventory",
			Handler:    _VmMigration_FetchStorageInventory_Handler,
		},
		{
			MethodName: "ListUtilizationReports",
			Handler:    _VmMigration_ListUtilizationReports_Handler,
		},
		{
			MethodName: "GetUtilizationReport",
			Handler:    _VmMigration_GetUtilizationReport_Handler,
		},
		{
			MethodName: "CreateUtilizationReport",
			Handler:    _VmMigration_CreateUtilizationReport_Handler,
		},
		{
			MethodName: "DeleteUtilizationReport",
			Handler:    _VmMigration_DeleteUtilizationReport_Handler,
		},
		{
			MethodName: "ListDatacenterConnectors",
			Handler:    _VmMigration_ListDatacenterConnectors_Handler,
		},
		{
			MethodName: "GetDatacenterConnector",
			Handler:    _VmMigration_GetDatacenterConnector_Handler,
		},
		{
			MethodName: "CreateDatacenterConnector",
			Handler:    _VmMigration_CreateDatacenterConnector_Handler,
		},
		{
			MethodName: "DeleteDatacenterConnector",
			Handler:    _VmMigration_DeleteDatacenterConnector_Handler,
		},
		{
			MethodName: "UpgradeAppliance",
			Handler:    _VmMigration_UpgradeAppliance_Handler,
		},
		{
			MethodName: "CreateMigratingVm",
			Handler:    _VmMigration_CreateMigratingVm_Handler,
		},
		{
			MethodName: "ListMigratingVms",
			Handler:    _VmMigration_ListMigratingVms_Handler,
		},
		{
			MethodName: "GetMigratingVm",
			Handler:    _VmMigration_GetMigratingVm_Handler,
		},
		{
			MethodName: "UpdateMigratingVm",
			Handler:    _VmMigration_UpdateMigratingVm_Handler,
		},
		{
			MethodName: "DeleteMigratingVm",
			Handler:    _VmMigration_DeleteMigratingVm_Handler,
		},
		{
			MethodName: "StartMigration",
			Handler:    _VmMigration_StartMigration_Handler,
		},
		{
			MethodName: "ResumeMigration",
			Handler:    _VmMigration_ResumeMigration_Handler,
		},
		{
			MethodName: "PauseMigration",
			Handler:    _VmMigration_PauseMigration_Handler,
		},
		{
			MethodName: "FinalizeMigration",
			Handler:    _VmMigration_FinalizeMigration_Handler,
		},
		{
			MethodName: "ExtendMigration",
			Handler:    _VmMigration_ExtendMigration_Handler,
		},
		{
			MethodName: "CreateCloneJob",
			Handler:    _VmMigration_CreateCloneJob_Handler,
		},
		{
			MethodName: "CancelCloneJob",
			Handler:    _VmMigration_CancelCloneJob_Handler,
		},
		{
			MethodName: "ListCloneJobs",
			Handler:    _VmMigration_ListCloneJobs_Handler,
		},
		{
			MethodName: "GetCloneJob",
			Handler:    _VmMigration_GetCloneJob_Handler,
		},
		{
			MethodName: "CreateCutoverJob",
			Handler:    _VmMigration_CreateCutoverJob_Handler,
		},
		{
			MethodName: "CancelCutoverJob",
			Handler:    _VmMigration_CancelCutoverJob_Handler,
		},
		{
			MethodName: "ListCutoverJobs",
			Handler:    _VmMigration_ListCutoverJobs_Handler,
		},
		{
			MethodName: "GetCutoverJob",
			Handler:    _VmMigration_GetCutoverJob_Handler,
		},
		{
			MethodName: "ListGroups",
			Handler:    _VmMigration_ListGroups_Handler,
		},
		{
			MethodName: "GetGroup",
			Handler:    _VmMigration_GetGroup_Handler,
		},
		{
			MethodName: "CreateGroup",
			Handler:    _VmMigration_CreateGroup_Handler,
		},
		{
			MethodName: "UpdateGroup",
			Handler:    _VmMigration_UpdateGroup_Handler,
		},
		{
			MethodName: "DeleteGroup",
			Handler:    _VmMigration_DeleteGroup_Handler,
		},
		{
			MethodName: "AddGroupMigration",
			Handler:    _VmMigration_AddGroupMigration_Handler,
		},
		{
			MethodName: "RemoveGroupMigration",
			Handler:    _VmMigration_RemoveGroupMigration_Handler,
		},
		{
			MethodName: "ListTargetProjects",
			Handler:    _VmMigration_ListTargetProjects_Handler,
		},
		{
			MethodName: "GetTargetProject",
			Handler:    _VmMigration_GetTargetProject_Handler,
		},
		{
			MethodName: "CreateTargetProject",
			Handler:    _VmMigration_CreateTargetProject_Handler,
		},
		{
			MethodName: "UpdateTargetProject",
			Handler:    _VmMigration_UpdateTargetProject_Handler,
		},
		{
			MethodName: "DeleteTargetProject",
			Handler:    _VmMigration_DeleteTargetProject_Handler,
		},
		{
			MethodName: "ListReplicationCycles",
			Handler:    _VmMigration_ListReplicationCycles_Handler,
		},
		{
			MethodName: "GetReplicationCycle",
			Handler:    _VmMigration_GetReplicationCycle_Handler,
		},
		{
			MethodName: "ListImageImports",
			Handler:    _VmMigration_ListImageImports_Handler,
		},
		{
			MethodName: "GetImageImport",
			Handler:    _VmMigration_GetImageImport_Handler,
		},
		{
			MethodName: "CreateImageImport",
			Handler:    _VmMigration_CreateImageImport_Handler,
		},
		{
			MethodName: "DeleteImageImport",
			Handler:    _VmMigration_DeleteImageImport_Handler,
		},
		{
			MethodName: "ListImageImportJobs",
			Handler:    _VmMigration_ListImageImportJobs_Handler,
		},
		{
			MethodName: "GetImageImportJob",
			Handler:    _VmMigration_GetImageImportJob_Handler,
		},
		{
			MethodName: "CancelImageImportJob",
			Handler:    _VmMigration_CancelImageImportJob_Handler,
		},
		{
			MethodName: "CreateDiskMigrationJob",
			Handler:    _VmMigration_CreateDiskMigrationJob_Handler,
		},
		{
			MethodName: "ListDiskMigrationJobs",
			Handler:    _VmMigration_ListDiskMigrationJobs_Handler,
		},
		{
			MethodName: "GetDiskMigrationJob",
			Handler:    _VmMigration_GetDiskMigrationJob_Handler,
		},
		{
			MethodName: "UpdateDiskMigrationJob",
			Handler:    _VmMigration_UpdateDiskMigrationJob_Handler,
		},
		{
			MethodName: "DeleteDiskMigrationJob",
			Handler:    _VmMigration_DeleteDiskMigrationJob_Handler,
		},
		{
			MethodName: "RunDiskMigrationJob",
			Handler:    _VmMigration_RunDiskMigrationJob_Handler,
		},
		{
			MethodName: "CancelDiskMigrationJob",
			Handler:    _VmMigration_CancelDiskMigrationJob_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/vmmigration/v1/vmmigration.proto",
}
