// Copyright (c) 2016, 2018, 2019, Oracle and/or its affiliates. All rights reserved.
// Code generated. DO NOT EDIT.

// Events API
//
// API for the Events Service. Use this API to manage rules and actions that create automation
// in your tenancy. For more information, see Overview of Events (https://docs.cloud.oracle.com/iaas/Content/Events/Concepts/eventsoverview.htm).
//

package events

import (
	"encoding/json"
	"github.com/oracle/oci-go-sdk/common"
)

// NotificationServiceAction An action that delivers to an Oracle Notification Service topic.
type NotificationServiceAction struct {

	// The OCID (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the action.
	Id *string `mandatory:"true" json:"id"`

	// A message generated by the Events service about the current state of this rule.
	LifecycleMessage *string `mandatory:"true" json:"lifecycleMessage"`

	// A string that describes the details of the action. It does not have to be unique, and you can change it. Avoid entering
	// confidential information.
	Description *string `mandatory:"false" json:"description"`

	// The OCID (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the topic to which messages are delivered.
	TopicId *string `mandatory:"false" json:"topicId"`

	// The current state of the rule.
	LifecycleState ActionLifecycleStateEnum `mandatory:"true" json:"lifecycleState"`
}

//GetId returns Id
func (m NotificationServiceAction) GetId() *string {
	return m.Id
}

//GetLifecycleMessage returns LifecycleMessage
func (m NotificationServiceAction) GetLifecycleMessage() *string {
	return m.LifecycleMessage
}

//GetLifecycleState returns LifecycleState
func (m NotificationServiceAction) GetLifecycleState() ActionLifecycleStateEnum {
	return m.LifecycleState
}

//GetDescription returns Description
func (m NotificationServiceAction) GetDescription() *string {
	return m.Description
}

func (m NotificationServiceAction) String() string {
	return common.PointerString(m)
}

// MarshalJSON marshals to json representation
func (m NotificationServiceAction) MarshalJSON() (buff []byte, e error) {
	type MarshalTypeNotificationServiceAction NotificationServiceAction
	s := struct {
		DiscriminatorParam string `json:"actionType"`
		MarshalTypeNotificationServiceAction
	}{
		"ONS",
		(MarshalTypeNotificationServiceAction)(m),
	}

	return json.Marshal(&s)
}
