package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// VulnerabilityDataObjectResource 资产信息
type VulnerabilityDataObjectResource struct {

	// 资产ID
	Id *string `json:"id,omitempty"`

	// 资产名称
	Name *string `json:"name,omitempty"`

	// 资产类型
	Type *string `json:"type,omitempty"`

	// 提供商
	Provider *string `json:"provider,omitempty"`

	// 区域ID
	RegionId *string `json:"region_id,omitempty"`

	// 租户ID
	DomainId *string `json:"domain_id,omitempty"`

	// 项目ID
	ProjectId *string `json:"project_id,omitempty"`

	// 企业项目ID
	EpId *string `json:"ep_id,omitempty"`

	// 资产标签
	Tags map[string]string `json:"tags,omitempty"`
}

func (o VulnerabilityDataObjectResource) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "VulnerabilityDataObjectResource struct{}"
	}

	return strings.Join([]string{"VulnerabilityDataObjectResource", string(data)}, " ")
}
