// Copyright 2017 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/devtools/sourcerepo/v1/sourcerepo.proto

package sourcerepo

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	v1 "google.golang.org/genproto/googleapis/iam/v1"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A repository (or repo) is a Git repository storing versioned source content.
type Repo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the repository, of the form
	// `projects/<project>/repos/<repo>`.  The repo name may contain slashes.
	// eg, `projects/myproject/repos/name/with/slash`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The disk usage of the repo, in bytes. Read-only field. Size is only
	// returned by GetRepo.
	Size int64 `protobuf:"varint,2,opt,name=size,proto3" json:"size,omitempty"`
	// URL to clone the repository from Google Cloud Source Repositories.
	// Read-only field.
	Url string `protobuf:"bytes,3,opt,name=url,proto3" json:"url,omitempty"`
	// How this repository mirrors a repository managed by another service.
	// Read-only field.
	MirrorConfig *MirrorConfig `protobuf:"bytes,4,opt,name=mirror_config,json=mirrorConfig,proto3" json:"mirror_config,omitempty"`
}

func (x *Repo) Reset() {
	*x = Repo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_sourcerepo_v1_sourcerepo_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Repo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Repo) ProtoMessage() {}

func (x *Repo) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_sourcerepo_v1_sourcerepo_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Repo.ProtoReflect.Descriptor instead.
func (*Repo) Descriptor() ([]byte, []int) {
	return file_google_devtools_sourcerepo_v1_sourcerepo_proto_rawDescGZIP(), []int{0}
}

func (x *Repo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Repo) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *Repo) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *Repo) GetMirrorConfig() *MirrorConfig {
	if x != nil {
		return x.MirrorConfig
	}
	return nil
}

// Configuration to automatically mirror a repository from another
// hosting service, for example GitHub or BitBucket.
type MirrorConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URL of the main repository at the other hosting service.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// ID of the webhook listening to updates to trigger mirroring.
	// Removing this webhook from the other hosting service will stop
	// Google Cloud Source Repositories from receiving notifications,
	// and thereby disabling mirroring.
	WebhookId string `protobuf:"bytes,2,opt,name=webhook_id,json=webhookId,proto3" json:"webhook_id,omitempty"`
	// ID of the SSH deploy key at the other hosting service.
	// Removing this key from the other service would deauthorize
	// Google Cloud Source Repositories from mirroring.
	DeployKeyId string `protobuf:"bytes,3,opt,name=deploy_key_id,json=deployKeyId,proto3" json:"deploy_key_id,omitempty"`
}

func (x *MirrorConfig) Reset() {
	*x = MirrorConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_sourcerepo_v1_sourcerepo_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MirrorConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MirrorConfig) ProtoMessage() {}

func (x *MirrorConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_sourcerepo_v1_sourcerepo_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MirrorConfig.ProtoReflect.Descriptor instead.
func (*MirrorConfig) Descriptor() ([]byte, []int) {
	return file_google_devtools_sourcerepo_v1_sourcerepo_proto_rawDescGZIP(), []int{1}
}

func (x *MirrorConfig) GetUrl() string {
	if x != nil {
		return x.Url
	}
	return ""
}

func (x *MirrorConfig) GetWebhookId() string {
	if x != nil {
		return x.WebhookId
	}
	return ""
}

func (x *MirrorConfig) GetDeployKeyId() string {
	if x != nil {
		return x.DeployKeyId
	}
	return ""
}

// Request for GetRepo.
type GetRepoRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the requested repository. Values are of the form
	// `projects/<project>/repos/<repo>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetRepoRequest) Reset() {
	*x = GetRepoRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_sourcerepo_v1_sourcerepo_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetRepoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetRepoRequest) ProtoMessage() {}

func (x *GetRepoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_sourcerepo_v1_sourcerepo_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetRepoRequest.ProtoReflect.Descriptor instead.
func (*GetRepoRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_sourcerepo_v1_sourcerepo_proto_rawDescGZIP(), []int{2}
}

func (x *GetRepoRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request for ListRepos.
type ListReposRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The project ID whose repos should be listed. Values are of the form
	// `projects/<project>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Maximum number of repositories to return; between 1 and 500.
	// If not set or zero, defaults to 100 at the server.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Resume listing repositories where a prior ListReposResponse
	// left off. This is an opaque token that must be obtained from
	// a recent, prior ListReposResponse's next_page_token field.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListReposRequest) Reset() {
	*x = ListReposRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_sourcerepo_v1_sourcerepo_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReposRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReposRequest) ProtoMessage() {}

func (x *ListReposRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_sourcerepo_v1_sourcerepo_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReposRequest.ProtoReflect.Descriptor instead.
func (*ListReposRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_sourcerepo_v1_sourcerepo_proto_rawDescGZIP(), []int{3}
}

func (x *ListReposRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ListReposRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListReposRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response for ListRepos.  The size is not set in the returned repositories.
type ListReposResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The listed repos.
	Repos []*Repo `protobuf:"bytes,1,rep,name=repos,proto3" json:"repos,omitempty"`
	// If non-empty, additional repositories exist within the project. These
	// can be retrieved by including this value in the next ListReposRequest's
	// page_token field.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListReposResponse) Reset() {
	*x = ListReposResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_sourcerepo_v1_sourcerepo_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListReposResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListReposResponse) ProtoMessage() {}

func (x *ListReposResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_sourcerepo_v1_sourcerepo_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListReposResponse.ProtoReflect.Descriptor instead.
func (*ListReposResponse) Descriptor() ([]byte, []int) {
	return file_google_devtools_sourcerepo_v1_sourcerepo_proto_rawDescGZIP(), []int{4}
}

func (x *ListReposResponse) GetRepos() []*Repo {
	if x != nil {
		return x.Repos
	}
	return nil
}

func (x *ListReposResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request for CreateRepo
type CreateRepoRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The project in which to create the repo. Values are of the form
	// `projects/<project>`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The repo to create.  Only name should be set; setting other fields
	// is an error.  The project in the name should match the parent field.
	Repo *Repo `protobuf:"bytes,2,opt,name=repo,proto3" json:"repo,omitempty"`
}

func (x *CreateRepoRequest) Reset() {
	*x = CreateRepoRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_sourcerepo_v1_sourcerepo_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateRepoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateRepoRequest) ProtoMessage() {}

func (x *CreateRepoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_sourcerepo_v1_sourcerepo_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateRepoRequest.ProtoReflect.Descriptor instead.
func (*CreateRepoRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_sourcerepo_v1_sourcerepo_proto_rawDescGZIP(), []int{5}
}

func (x *CreateRepoRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateRepoRequest) GetRepo() *Repo {
	if x != nil {
		return x.Repo
	}
	return nil
}

// Request for DeleteRepo.
type DeleteRepoRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the repo to delete. Values are of the form
	// `projects/<project>/repos/<repo>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteRepoRequest) Reset() {
	*x = DeleteRepoRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_devtools_sourcerepo_v1_sourcerepo_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteRepoRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteRepoRequest) ProtoMessage() {}

func (x *DeleteRepoRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_devtools_sourcerepo_v1_sourcerepo_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteRepoRequest.ProtoReflect.Descriptor instead.
func (*DeleteRepoRequest) Descriptor() ([]byte, []int) {
	return file_google_devtools_sourcerepo_v1_sourcerepo_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteRepoRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_devtools_sourcerepo_v1_sourcerepo_proto protoreflect.FileDescriptor

var file_google_devtools_sourcerepo_v1_sourcerepo_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x72, 0x65, 0x70, 0x6f, 0x2f, 0x76, 0x31, 0x2f,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x72, 0x65, 0x70, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x1d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x72, 0x65, 0x70, 0x6f, 0x2e, 0x76, 0x31, 0x1a,
	0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f,
	0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x69, 0x61, 0x6d,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x69, 0x61, 0x6d, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74, 0x79,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x92, 0x01, 0x0a, 0x04, 0x52, 0x65, 0x70, 0x6f, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x10, 0x0a, 0x03, 0x75, 0x72, 0x6c, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x50, 0x0a, 0x0d, 0x6d, 0x69, 0x72,
	0x72, 0x6f, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f,
	0x6c, 0x73, 0x2e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x72, 0x65, 0x70, 0x6f, 0x2e, 0x76, 0x31,
	0x2e, 0x4d, 0x69, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0c, 0x6d,
	0x69, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x22, 0x63, 0x0a, 0x0c, 0x4d,
	0x69, 0x72, 0x72, 0x6f, 0x72, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x10, 0x0a, 0x03, 0x75,
	0x72, 0x6c, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x75, 0x72, 0x6c, 0x12, 0x1d, 0x0a,
	0x0a, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x09, 0x77, 0x65, 0x62, 0x68, 0x6f, 0x6f, 0x6b, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0d,
	0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x5f, 0x6b, 0x65, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x70, 0x6c, 0x6f, 0x79, 0x4b, 0x65, 0x79, 0x49, 0x64,
	0x22, 0x24, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x62, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65,
	0x70, 0x6f, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b,
	0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x76, 0x0a, 0x11, 0x4c, 0x69,
	0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x39, 0x0a, 0x05, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x23,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x72, 0x65, 0x70, 0x6f, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x70, 0x6f, 0x52, 0x05, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x64, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x37, 0x0a, 0x04, 0x72, 0x65, 0x70, 0x6f, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x23, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x72, 0x65, 0x70, 0x6f, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x70, 0x6f, 0x52, 0x04, 0x72, 0x65, 0x70, 0x6f, 0x22, 0x27, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x32, 0xf8, 0x07, 0x0a, 0x0a, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x70, 0x6f,
	0x12, 0x93, 0x01, 0x0a, 0x09, 0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x12, 0x2f,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73,
	0x2e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x72, 0x65, 0x70, 0x6f, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x72, 0x65, 0x70, 0x6f, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x23, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1d, 0x12, 0x1b, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x12, 0x85, 0x01, 0x0a, 0x07, 0x47, 0x65, 0x74, 0x52, 0x65,
	0x70, 0x6f, 0x12, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x72, 0x65, 0x70, 0x6f, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x52, 0x65, 0x70, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x72, 0x65, 0x70, 0x6f, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x70, 0x6f, 0x22, 0x26, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x20, 0x12, 0x1e,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x2f, 0x2a, 0x2a, 0x7d, 0x12, 0x90,
	0x01, 0x0a, 0x0a, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x12, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c, 0x73, 0x2e,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x72, 0x65, 0x70, 0x6f, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x72, 0x65, 0x70, 0x6f, 0x2e, 0x76, 0x31, 0x2e,
	0x52, 0x65, 0x70, 0x6f, 0x22, 0x2b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x25, 0x22, 0x1d, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x3a, 0x04, 0x72, 0x65, 0x70,
	0x6f, 0x12, 0x7e, 0x0a, 0x0a, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x12,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f, 0x6f, 0x6c,
	0x73, 0x2e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x72, 0x65, 0x70, 0x6f, 0x2e, 0x76, 0x31, 0x2e,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x26, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x20, 0x2a, 0x1e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x2f, 0x2a, 0x2a,
	0x7d, 0x12, 0x85, 0x01, 0x0a, 0x0c, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x3a, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x34, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x72, 0x65, 0x70, 0x6f, 0x73, 0x2f, 0x2a, 0x2a, 0x7d, 0x3a, 0x73, 0x65, 0x74, 0x49, 0x61, 0x6d,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3a, 0x01, 0x2a, 0x12, 0x82, 0x01, 0x0a, 0x0c, 0x47, 0x65,
	0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x22, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x49, 0x61,
	0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x15,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x22, 0x37, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x31, 0x12, 0x2f, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70, 0x6f, 0x73, 0x2f, 0x2a, 0x2a,
	0x7d, 0x3a, 0x67, 0x65, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0xab,
	0x01, 0x0a, 0x12, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69,
	0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72,
	0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x69, 0x61, 0x6d, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x40, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x3a, 0x22, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x72, 0x65, 0x70,
	0x6f, 0x73, 0x2f, 0x2a, 0x2a, 0x7d, 0x3a, 0x74, 0x65, 0x73, 0x74, 0x49, 0x61, 0x6d, 0x50, 0x65,
	0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x3a, 0x01, 0x2a, 0x42, 0x7f, 0x0a, 0x21,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x64, 0x65, 0x76, 0x74, 0x6f,
	0x6f, 0x6c, 0x73, 0x2e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x72, 0x65, 0x70, 0x6f, 0x2e, 0x76,
	0x31, 0x42, 0x0f, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x47, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c,
	0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x64, 0x65, 0x76, 0x74,
	0x6f, 0x6f, 0x6c, 0x73, 0x2f, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x72, 0x65, 0x70, 0x6f, 0x2f,
	0x76, 0x31, 0x3b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x72, 0x65, 0x70, 0x6f, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_devtools_sourcerepo_v1_sourcerepo_proto_rawDescOnce sync.Once
	file_google_devtools_sourcerepo_v1_sourcerepo_proto_rawDescData = file_google_devtools_sourcerepo_v1_sourcerepo_proto_rawDesc
)

func file_google_devtools_sourcerepo_v1_sourcerepo_proto_rawDescGZIP() []byte {
	file_google_devtools_sourcerepo_v1_sourcerepo_proto_rawDescOnce.Do(func() {
		file_google_devtools_sourcerepo_v1_sourcerepo_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_devtools_sourcerepo_v1_sourcerepo_proto_rawDescData)
	})
	return file_google_devtools_sourcerepo_v1_sourcerepo_proto_rawDescData
}

var file_google_devtools_sourcerepo_v1_sourcerepo_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_devtools_sourcerepo_v1_sourcerepo_proto_goTypes = []interface{}{
	(*Repo)(nil),                          // 0: google.devtools.sourcerepo.v1.Repo
	(*MirrorConfig)(nil),                  // 1: google.devtools.sourcerepo.v1.MirrorConfig
	(*GetRepoRequest)(nil),                // 2: google.devtools.sourcerepo.v1.GetRepoRequest
	(*ListReposRequest)(nil),              // 3: google.devtools.sourcerepo.v1.ListReposRequest
	(*ListReposResponse)(nil),             // 4: google.devtools.sourcerepo.v1.ListReposResponse
	(*CreateRepoRequest)(nil),             // 5: google.devtools.sourcerepo.v1.CreateRepoRequest
	(*DeleteRepoRequest)(nil),             // 6: google.devtools.sourcerepo.v1.DeleteRepoRequest
	(*v1.SetIamPolicyRequest)(nil),        // 7: google.iam.v1.SetIamPolicyRequest
	(*v1.GetIamPolicyRequest)(nil),        // 8: google.iam.v1.GetIamPolicyRequest
	(*v1.TestIamPermissionsRequest)(nil),  // 9: google.iam.v1.TestIamPermissionsRequest
	(*emptypb.Empty)(nil),                 // 10: google.protobuf.Empty
	(*v1.Policy)(nil),                     // 11: google.iam.v1.Policy
	(*v1.TestIamPermissionsResponse)(nil), // 12: google.iam.v1.TestIamPermissionsResponse
}
var file_google_devtools_sourcerepo_v1_sourcerepo_proto_depIdxs = []int32{
	1,  // 0: google.devtools.sourcerepo.v1.Repo.mirror_config:type_name -> google.devtools.sourcerepo.v1.MirrorConfig
	0,  // 1: google.devtools.sourcerepo.v1.ListReposResponse.repos:type_name -> google.devtools.sourcerepo.v1.Repo
	0,  // 2: google.devtools.sourcerepo.v1.CreateRepoRequest.repo:type_name -> google.devtools.sourcerepo.v1.Repo
	3,  // 3: google.devtools.sourcerepo.v1.SourceRepo.ListRepos:input_type -> google.devtools.sourcerepo.v1.ListReposRequest
	2,  // 4: google.devtools.sourcerepo.v1.SourceRepo.GetRepo:input_type -> google.devtools.sourcerepo.v1.GetRepoRequest
	5,  // 5: google.devtools.sourcerepo.v1.SourceRepo.CreateRepo:input_type -> google.devtools.sourcerepo.v1.CreateRepoRequest
	6,  // 6: google.devtools.sourcerepo.v1.SourceRepo.DeleteRepo:input_type -> google.devtools.sourcerepo.v1.DeleteRepoRequest
	7,  // 7: google.devtools.sourcerepo.v1.SourceRepo.SetIamPolicy:input_type -> google.iam.v1.SetIamPolicyRequest
	8,  // 8: google.devtools.sourcerepo.v1.SourceRepo.GetIamPolicy:input_type -> google.iam.v1.GetIamPolicyRequest
	9,  // 9: google.devtools.sourcerepo.v1.SourceRepo.TestIamPermissions:input_type -> google.iam.v1.TestIamPermissionsRequest
	4,  // 10: google.devtools.sourcerepo.v1.SourceRepo.ListRepos:output_type -> google.devtools.sourcerepo.v1.ListReposResponse
	0,  // 11: google.devtools.sourcerepo.v1.SourceRepo.GetRepo:output_type -> google.devtools.sourcerepo.v1.Repo
	0,  // 12: google.devtools.sourcerepo.v1.SourceRepo.CreateRepo:output_type -> google.devtools.sourcerepo.v1.Repo
	10, // 13: google.devtools.sourcerepo.v1.SourceRepo.DeleteRepo:output_type -> google.protobuf.Empty
	11, // 14: google.devtools.sourcerepo.v1.SourceRepo.SetIamPolicy:output_type -> google.iam.v1.Policy
	11, // 15: google.devtools.sourcerepo.v1.SourceRepo.GetIamPolicy:output_type -> google.iam.v1.Policy
	12, // 16: google.devtools.sourcerepo.v1.SourceRepo.TestIamPermissions:output_type -> google.iam.v1.TestIamPermissionsResponse
	10, // [10:17] is the sub-list for method output_type
	3,  // [3:10] is the sub-list for method input_type
	3,  // [3:3] is the sub-list for extension type_name
	3,  // [3:3] is the sub-list for extension extendee
	0,  // [0:3] is the sub-list for field type_name
}

func init() { file_google_devtools_sourcerepo_v1_sourcerepo_proto_init() }
func file_google_devtools_sourcerepo_v1_sourcerepo_proto_init() {
	if File_google_devtools_sourcerepo_v1_sourcerepo_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_devtools_sourcerepo_v1_sourcerepo_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Repo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_sourcerepo_v1_sourcerepo_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MirrorConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_sourcerepo_v1_sourcerepo_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetRepoRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_sourcerepo_v1_sourcerepo_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReposRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_sourcerepo_v1_sourcerepo_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListReposResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_sourcerepo_v1_sourcerepo_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateRepoRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_devtools_sourcerepo_v1_sourcerepo_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteRepoRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_devtools_sourcerepo_v1_sourcerepo_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_devtools_sourcerepo_v1_sourcerepo_proto_goTypes,
		DependencyIndexes: file_google_devtools_sourcerepo_v1_sourcerepo_proto_depIdxs,
		MessageInfos:      file_google_devtools_sourcerepo_v1_sourcerepo_proto_msgTypes,
	}.Build()
	File_google_devtools_sourcerepo_v1_sourcerepo_proto = out.File
	file_google_devtools_sourcerepo_v1_sourcerepo_proto_rawDesc = nil
	file_google_devtools_sourcerepo_v1_sourcerepo_proto_goTypes = nil
	file_google_devtools_sourcerepo_v1_sourcerepo_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// SourceRepoClient is the client API for SourceRepo service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SourceRepoClient interface {
	// Returns all repos belonging to a project. The sizes of the repos are
	// not set by ListRepos.  To get the size of a repo, use GetRepo.
	ListRepos(ctx context.Context, in *ListReposRequest, opts ...grpc.CallOption) (*ListReposResponse, error)
	// Returns information about a repo.
	GetRepo(ctx context.Context, in *GetRepoRequest, opts ...grpc.CallOption) (*Repo, error)
	// Creates a repo in the given project with the given name.
	//
	// If the named repository already exists, `CreateRepo` returns
	// `ALREADY_EXISTS`.
	CreateRepo(ctx context.Context, in *CreateRepoRequest, opts ...grpc.CallOption) (*Repo, error)
	// Deletes a repo.
	DeleteRepo(ctx context.Context, in *DeleteRepoRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Sets the access control policy on the specified resource. Replaces any
	// existing policy.
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Gets the access control policy for a resource.
	// Returns an empty policy if the resource exists and does not have a policy
	// set.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns permissions that a caller has on the specified resource.
	// If the resource does not exist, this will return an empty set of
	// permissions, not a NOT_FOUND error.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
}

type sourceRepoClient struct {
	cc grpc.ClientConnInterface
}

func NewSourceRepoClient(cc grpc.ClientConnInterface) SourceRepoClient {
	return &sourceRepoClient{cc}
}

func (c *sourceRepoClient) ListRepos(ctx context.Context, in *ListReposRequest, opts ...grpc.CallOption) (*ListReposResponse, error) {
	out := new(ListReposResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.sourcerepo.v1.SourceRepo/ListRepos", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sourceRepoClient) GetRepo(ctx context.Context, in *GetRepoRequest, opts ...grpc.CallOption) (*Repo, error) {
	out := new(Repo)
	err := c.cc.Invoke(ctx, "/google.devtools.sourcerepo.v1.SourceRepo/GetRepo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sourceRepoClient) CreateRepo(ctx context.Context, in *CreateRepoRequest, opts ...grpc.CallOption) (*Repo, error) {
	out := new(Repo)
	err := c.cc.Invoke(ctx, "/google.devtools.sourcerepo.v1.SourceRepo/CreateRepo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sourceRepoClient) DeleteRepo(ctx context.Context, in *DeleteRepoRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.devtools.sourcerepo.v1.SourceRepo/DeleteRepo", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sourceRepoClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.devtools.sourcerepo.v1.SourceRepo/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sourceRepoClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.devtools.sourcerepo.v1.SourceRepo/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *sourceRepoClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.devtools.sourcerepo.v1.SourceRepo/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SourceRepoServer is the server API for SourceRepo service.
type SourceRepoServer interface {
	// Returns all repos belonging to a project. The sizes of the repos are
	// not set by ListRepos.  To get the size of a repo, use GetRepo.
	ListRepos(context.Context, *ListReposRequest) (*ListReposResponse, error)
	// Returns information about a repo.
	GetRepo(context.Context, *GetRepoRequest) (*Repo, error)
	// Creates a repo in the given project with the given name.
	//
	// If the named repository already exists, `CreateRepo` returns
	// `ALREADY_EXISTS`.
	CreateRepo(context.Context, *CreateRepoRequest) (*Repo, error)
	// Deletes a repo.
	DeleteRepo(context.Context, *DeleteRepoRequest) (*emptypb.Empty, error)
	// Sets the access control policy on the specified resource. Replaces any
	// existing policy.
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Gets the access control policy for a resource.
	// Returns an empty policy if the resource exists and does not have a policy
	// set.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Returns permissions that a caller has on the specified resource.
	// If the resource does not exist, this will return an empty set of
	// permissions, not a NOT_FOUND error.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
}

// UnimplementedSourceRepoServer can be embedded to have forward compatible implementations.
type UnimplementedSourceRepoServer struct {
}

func (*UnimplementedSourceRepoServer) ListRepos(context.Context, *ListReposRequest) (*ListReposResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRepos not implemented")
}
func (*UnimplementedSourceRepoServer) GetRepo(context.Context, *GetRepoRequest) (*Repo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRepo not implemented")
}
func (*UnimplementedSourceRepoServer) CreateRepo(context.Context, *CreateRepoRequest) (*Repo, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRepo not implemented")
}
func (*UnimplementedSourceRepoServer) DeleteRepo(context.Context, *DeleteRepoRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRepo not implemented")
}
func (*UnimplementedSourceRepoServer) SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (*UnimplementedSourceRepoServer) GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (*UnimplementedSourceRepoServer) TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

func RegisterSourceRepoServer(s *grpc.Server, srv SourceRepoServer) {
	s.RegisterService(&_SourceRepo_serviceDesc, srv)
}

func _SourceRepo_ListRepos_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReposRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SourceRepoServer).ListRepos(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.sourcerepo.v1.SourceRepo/ListRepos",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SourceRepoServer).ListRepos(ctx, req.(*ListReposRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SourceRepo_GetRepo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRepoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SourceRepoServer).GetRepo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.sourcerepo.v1.SourceRepo/GetRepo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SourceRepoServer).GetRepo(ctx, req.(*GetRepoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SourceRepo_CreateRepo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRepoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SourceRepoServer).CreateRepo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.sourcerepo.v1.SourceRepo/CreateRepo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SourceRepoServer).CreateRepo(ctx, req.(*CreateRepoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SourceRepo_DeleteRepo_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRepoRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SourceRepoServer).DeleteRepo(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.sourcerepo.v1.SourceRepo/DeleteRepo",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SourceRepoServer).DeleteRepo(ctx, req.(*DeleteRepoRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SourceRepo_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SourceRepoServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.sourcerepo.v1.SourceRepo/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SourceRepoServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SourceRepo_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SourceRepoServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.sourcerepo.v1.SourceRepo/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SourceRepoServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SourceRepo_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SourceRepoServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.devtools.sourcerepo.v1.SourceRepo/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SourceRepoServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SourceRepo_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.sourcerepo.v1.SourceRepo",
	HandlerType: (*SourceRepoServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListRepos",
			Handler:    _SourceRepo_ListRepos_Handler,
		},
		{
			MethodName: "GetRepo",
			Handler:    _SourceRepo_GetRepo_Handler,
		},
		{
			MethodName: "CreateRepo",
			Handler:    _SourceRepo_CreateRepo_Handler,
		},
		{
			MethodName: "DeleteRepo",
			Handler:    _SourceRepo_DeleteRepo_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _SourceRepo_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _SourceRepo_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _SourceRepo_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/sourcerepo/v1/sourcerepo.proto",
}
