package resource

import (
	"github.com/spf13/cobra"
)

// RemoveAppsCmd removes the autogenerated `apps` command as we need the plugin to have this namespace
func RemoveAppsCmd(rootCmd *cobra.Command) error {
	for _, cmd := range rootCmd.Commands() {
		if cmd.Use == "apps" {
			// Remove the autogenerated in favor of the plugin
			rootCmd.RemoveCommand(cmd)
			break
		}
	}

	return nil
}
