// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/cx/v3/page.proto

package cxpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Pages_ListPages_FullMethodName  = "/google.cloud.dialogflow.cx.v3.Pages/ListPages"
	Pages_GetPage_FullMethodName    = "/google.cloud.dialogflow.cx.v3.Pages/GetPage"
	Pages_CreatePage_FullMethodName = "/google.cloud.dialogflow.cx.v3.Pages/CreatePage"
	Pages_UpdatePage_FullMethodName = "/google.cloud.dialogflow.cx.v3.Pages/UpdatePage"
	Pages_DeletePage_FullMethodName = "/google.cloud.dialogflow.cx.v3.Pages/DeletePage"
)

// PagesClient is the client API for Pages service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PagesClient interface {
	// Returns the list of all pages in the specified flow.
	ListPages(ctx context.Context, in *ListPagesRequest, opts ...grpc.CallOption) (*ListPagesResponse, error)
	// Retrieves the specified page.
	GetPage(ctx context.Context, in *GetPageRequest, opts ...grpc.CallOption) (*Page, error)
	// Creates a page in the specified flow.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	CreatePage(ctx context.Context, in *CreatePageRequest, opts ...grpc.CallOption) (*Page, error)
	// Updates the specified page.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	UpdatePage(ctx context.Context, in *UpdatePageRequest, opts ...grpc.CallOption) (*Page, error)
	// Deletes the specified page.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	DeletePage(ctx context.Context, in *DeletePageRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type pagesClient struct {
	cc grpc.ClientConnInterface
}

func NewPagesClient(cc grpc.ClientConnInterface) PagesClient {
	return &pagesClient{cc}
}

func (c *pagesClient) ListPages(ctx context.Context, in *ListPagesRequest, opts ...grpc.CallOption) (*ListPagesResponse, error) {
	out := new(ListPagesResponse)
	err := c.cc.Invoke(ctx, Pages_ListPages_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pagesClient) GetPage(ctx context.Context, in *GetPageRequest, opts ...grpc.CallOption) (*Page, error) {
	out := new(Page)
	err := c.cc.Invoke(ctx, Pages_GetPage_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pagesClient) CreatePage(ctx context.Context, in *CreatePageRequest, opts ...grpc.CallOption) (*Page, error) {
	out := new(Page)
	err := c.cc.Invoke(ctx, Pages_CreatePage_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pagesClient) UpdatePage(ctx context.Context, in *UpdatePageRequest, opts ...grpc.CallOption) (*Page, error) {
	out := new(Page)
	err := c.cc.Invoke(ctx, Pages_UpdatePage_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *pagesClient) DeletePage(ctx context.Context, in *DeletePageRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Pages_DeletePage_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PagesServer is the server API for Pages service.
// All implementations should embed UnimplementedPagesServer
// for forward compatibility
type PagesServer interface {
	// Returns the list of all pages in the specified flow.
	ListPages(context.Context, *ListPagesRequest) (*ListPagesResponse, error)
	// Retrieves the specified page.
	GetPage(context.Context, *GetPageRequest) (*Page, error)
	// Creates a page in the specified flow.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	CreatePage(context.Context, *CreatePageRequest) (*Page, error)
	// Updates the specified page.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	UpdatePage(context.Context, *UpdatePageRequest) (*Page, error)
	// Deletes the specified page.
	//
	// Note: You should always train a flow prior to sending it queries. See the
	// [training
	// documentation](https://cloud.google.com/dialogflow/cx/docs/concept/training).
	DeletePage(context.Context, *DeletePageRequest) (*emptypb.Empty, error)
}

// UnimplementedPagesServer should be embedded to have forward compatible implementations.
type UnimplementedPagesServer struct {
}

func (UnimplementedPagesServer) ListPages(context.Context, *ListPagesRequest) (*ListPagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPages not implemented")
}
func (UnimplementedPagesServer) GetPage(context.Context, *GetPageRequest) (*Page, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPage not implemented")
}
func (UnimplementedPagesServer) CreatePage(context.Context, *CreatePageRequest) (*Page, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreatePage not implemented")
}
func (UnimplementedPagesServer) UpdatePage(context.Context, *UpdatePageRequest) (*Page, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePage not implemented")
}
func (UnimplementedPagesServer) DeletePage(context.Context, *DeletePageRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePage not implemented")
}

// UnsafePagesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PagesServer will
// result in compilation errors.
type UnsafePagesServer interface {
	mustEmbedUnimplementedPagesServer()
}

func RegisterPagesServer(s grpc.ServiceRegistrar, srv PagesServer) {
	s.RegisterService(&Pages_ServiceDesc, srv)
}

func _Pages_ListPages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PagesServer).ListPages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Pages_ListPages_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PagesServer).ListPages(ctx, req.(*ListPagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pages_GetPage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PagesServer).GetPage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Pages_GetPage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PagesServer).GetPage(ctx, req.(*GetPageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pages_CreatePage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreatePageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PagesServer).CreatePage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Pages_CreatePage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PagesServer).CreatePage(ctx, req.(*CreatePageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pages_UpdatePage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PagesServer).UpdatePage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Pages_UpdatePage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PagesServer).UpdatePage(ctx, req.(*UpdatePageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Pages_DeletePage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PagesServer).DeletePage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Pages_DeletePage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PagesServer).DeletePage(ctx, req.(*DeletePageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Pages_ServiceDesc is the grpc.ServiceDesc for Pages service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Pages_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3.Pages",
	HandlerType: (*PagesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListPages",
			Handler:    _Pages_ListPages_Handler,
		},
		{
			MethodName: "GetPage",
			Handler:    _Pages_GetPage_Handler,
		},
		{
			MethodName: "CreatePage",
			Handler:    _Pages_CreatePage_Handler,
		},
		{
			MethodName: "UpdatePage",
			Handler:    _Pages_UpdatePage_Handler,
		},
		{
			MethodName: "DeletePage",
			Handler:    _Pages_DeletePage_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3/page.proto",
}
