// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/orchestration/airflow/service/v1/environments.proto

package servicepb

import (
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	Environments_CreateEnvironment_FullMethodName            = "/google.cloud.orchestration.airflow.service.v1.Environments/CreateEnvironment"
	Environments_GetEnvironment_FullMethodName               = "/google.cloud.orchestration.airflow.service.v1.Environments/GetEnvironment"
	Environments_ListEnvironments_FullMethodName             = "/google.cloud.orchestration.airflow.service.v1.Environments/ListEnvironments"
	Environments_UpdateEnvironment_FullMethodName            = "/google.cloud.orchestration.airflow.service.v1.Environments/UpdateEnvironment"
	Environments_DeleteEnvironment_FullMethodName            = "/google.cloud.orchestration.airflow.service.v1.Environments/DeleteEnvironment"
	Environments_ExecuteAirflowCommand_FullMethodName        = "/google.cloud.orchestration.airflow.service.v1.Environments/ExecuteAirflowCommand"
	Environments_StopAirflowCommand_FullMethodName           = "/google.cloud.orchestration.airflow.service.v1.Environments/StopAirflowCommand"
	Environments_PollAirflowCommand_FullMethodName           = "/google.cloud.orchestration.airflow.service.v1.Environments/PollAirflowCommand"
	Environments_ListWorkloads_FullMethodName                = "/google.cloud.orchestration.airflow.service.v1.Environments/ListWorkloads"
	Environments_CheckUpgrade_FullMethodName                 = "/google.cloud.orchestration.airflow.service.v1.Environments/CheckUpgrade"
	Environments_CreateUserWorkloadsSecret_FullMethodName    = "/google.cloud.orchestration.airflow.service.v1.Environments/CreateUserWorkloadsSecret"
	Environments_GetUserWorkloadsSecret_FullMethodName       = "/google.cloud.orchestration.airflow.service.v1.Environments/GetUserWorkloadsSecret"
	Environments_ListUserWorkloadsSecrets_FullMethodName     = "/google.cloud.orchestration.airflow.service.v1.Environments/ListUserWorkloadsSecrets"
	Environments_UpdateUserWorkloadsSecret_FullMethodName    = "/google.cloud.orchestration.airflow.service.v1.Environments/UpdateUserWorkloadsSecret"
	Environments_DeleteUserWorkloadsSecret_FullMethodName    = "/google.cloud.orchestration.airflow.service.v1.Environments/DeleteUserWorkloadsSecret"
	Environments_CreateUserWorkloadsConfigMap_FullMethodName = "/google.cloud.orchestration.airflow.service.v1.Environments/CreateUserWorkloadsConfigMap"
	Environments_GetUserWorkloadsConfigMap_FullMethodName    = "/google.cloud.orchestration.airflow.service.v1.Environments/GetUserWorkloadsConfigMap"
	Environments_ListUserWorkloadsConfigMaps_FullMethodName  = "/google.cloud.orchestration.airflow.service.v1.Environments/ListUserWorkloadsConfigMaps"
	Environments_UpdateUserWorkloadsConfigMap_FullMethodName = "/google.cloud.orchestration.airflow.service.v1.Environments/UpdateUserWorkloadsConfigMap"
	Environments_DeleteUserWorkloadsConfigMap_FullMethodName = "/google.cloud.orchestration.airflow.service.v1.Environments/DeleteUserWorkloadsConfigMap"
	Environments_SaveSnapshot_FullMethodName                 = "/google.cloud.orchestration.airflow.service.v1.Environments/SaveSnapshot"
	Environments_LoadSnapshot_FullMethodName                 = "/google.cloud.orchestration.airflow.service.v1.Environments/LoadSnapshot"
	Environments_DatabaseFailover_FullMethodName             = "/google.cloud.orchestration.airflow.service.v1.Environments/DatabaseFailover"
	Environments_FetchDatabaseProperties_FullMethodName      = "/google.cloud.orchestration.airflow.service.v1.Environments/FetchDatabaseProperties"
)

// EnvironmentsClient is the client API for Environments service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type EnvironmentsClient interface {
	// Create a new environment.
	CreateEnvironment(ctx context.Context, in *CreateEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Get an existing environment.
	GetEnvironment(ctx context.Context, in *GetEnvironmentRequest, opts ...grpc.CallOption) (*Environment, error)
	// List environments.
	ListEnvironments(ctx context.Context, in *ListEnvironmentsRequest, opts ...grpc.CallOption) (*ListEnvironmentsResponse, error)
	// Update an environment.
	UpdateEnvironment(ctx context.Context, in *UpdateEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Delete an environment.
	DeleteEnvironment(ctx context.Context, in *DeleteEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Executes Airflow CLI command.
	ExecuteAirflowCommand(ctx context.Context, in *ExecuteAirflowCommandRequest, opts ...grpc.CallOption) (*ExecuteAirflowCommandResponse, error)
	// Stops Airflow CLI command execution.
	StopAirflowCommand(ctx context.Context, in *StopAirflowCommandRequest, opts ...grpc.CallOption) (*StopAirflowCommandResponse, error)
	// Polls Airflow CLI command execution and fetches logs.
	PollAirflowCommand(ctx context.Context, in *PollAirflowCommandRequest, opts ...grpc.CallOption) (*PollAirflowCommandResponse, error)
	// Lists workloads in a Cloud Composer environment. Workload is a unit that
	// runs a single Composer component.
	//
	// This method is supported for Cloud Composer environments in versions
	// composer-2.*.*-airflow-*.*.* and newer.
	ListWorkloads(ctx context.Context, in *ListWorkloadsRequest, opts ...grpc.CallOption) (*ListWorkloadsResponse, error)
	// Check if an upgrade operation on the environment will succeed.
	//
	// In case of problems detailed info can be found in the returned Operation.
	CheckUpgrade(ctx context.Context, in *CheckUpgradeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Creates a user workloads Secret.
	//
	// This method is supported for Cloud Composer environments in versions
	// composer-3-airflow-*.*.*-build.* and newer.
	CreateUserWorkloadsSecret(ctx context.Context, in *CreateUserWorkloadsSecretRequest, opts ...grpc.CallOption) (*UserWorkloadsSecret, error)
	// Gets an existing user workloads Secret.
	// Values of the "data" field in the response are cleared.
	//
	// This method is supported for Cloud Composer environments in versions
	// composer-3-airflow-*.*.*-build.* and newer.
	GetUserWorkloadsSecret(ctx context.Context, in *GetUserWorkloadsSecretRequest, opts ...grpc.CallOption) (*UserWorkloadsSecret, error)
	// Lists user workloads Secrets.
	//
	// This method is supported for Cloud Composer environments in versions
	// composer-3-airflow-*.*.*-build.* and newer.
	ListUserWorkloadsSecrets(ctx context.Context, in *ListUserWorkloadsSecretsRequest, opts ...grpc.CallOption) (*ListUserWorkloadsSecretsResponse, error)
	// Updates a user workloads Secret.
	//
	// This method is supported for Cloud Composer environments in versions
	// composer-3-airflow-*.*.*-build.* and newer.
	UpdateUserWorkloadsSecret(ctx context.Context, in *UpdateUserWorkloadsSecretRequest, opts ...grpc.CallOption) (*UserWorkloadsSecret, error)
	// Deletes a user workloads Secret.
	//
	// This method is supported for Cloud Composer environments in versions
	// composer-3-airflow-*.*.*-build.* and newer.
	DeleteUserWorkloadsSecret(ctx context.Context, in *DeleteUserWorkloadsSecretRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a user workloads ConfigMap.
	//
	// This method is supported for Cloud Composer environments in versions
	// composer-3-airflow-*.*.*-build.* and newer.
	CreateUserWorkloadsConfigMap(ctx context.Context, in *CreateUserWorkloadsConfigMapRequest, opts ...grpc.CallOption) (*UserWorkloadsConfigMap, error)
	// Gets an existing user workloads ConfigMap.
	//
	// This method is supported for Cloud Composer environments in versions
	// composer-3-airflow-*.*.*-build.* and newer.
	GetUserWorkloadsConfigMap(ctx context.Context, in *GetUserWorkloadsConfigMapRequest, opts ...grpc.CallOption) (*UserWorkloadsConfigMap, error)
	// Lists user workloads ConfigMaps.
	//
	// This method is supported for Cloud Composer environments in versions
	// composer-3-airflow-*.*.*-build.* and newer.
	ListUserWorkloadsConfigMaps(ctx context.Context, in *ListUserWorkloadsConfigMapsRequest, opts ...grpc.CallOption) (*ListUserWorkloadsConfigMapsResponse, error)
	// Updates a user workloads ConfigMap.
	//
	// This method is supported for Cloud Composer environments in versions
	// composer-3-airflow-*.*.*-build.* and newer.
	UpdateUserWorkloadsConfigMap(ctx context.Context, in *UpdateUserWorkloadsConfigMapRequest, opts ...grpc.CallOption) (*UserWorkloadsConfigMap, error)
	// Deletes a user workloads ConfigMap.
	//
	// This method is supported for Cloud Composer environments in versions
	// composer-3-airflow-*.*.*-build.* and newer.
	DeleteUserWorkloadsConfigMap(ctx context.Context, in *DeleteUserWorkloadsConfigMapRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Creates a snapshots of a Cloud Composer environment.
	//
	// As a result of this operation, snapshot of environment's state is stored
	// in a location specified in the SaveSnapshotRequest.
	SaveSnapshot(ctx context.Context, in *SaveSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Loads a snapshot of a Cloud Composer environment.
	//
	// As a result of this operation, a snapshot of environment's specified in
	// LoadSnapshotRequest is loaded into the environment.
	LoadSnapshot(ctx context.Context, in *LoadSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Triggers database failover (only for highly resilient environments).
	DatabaseFailover(ctx context.Context, in *DatabaseFailoverRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Fetches database properties.
	FetchDatabaseProperties(ctx context.Context, in *FetchDatabasePropertiesRequest, opts ...grpc.CallOption) (*FetchDatabasePropertiesResponse, error)
}

type environmentsClient struct {
	cc grpc.ClientConnInterface
}

func NewEnvironmentsClient(cc grpc.ClientConnInterface) EnvironmentsClient {
	return &environmentsClient{cc}
}

func (c *environmentsClient) CreateEnvironment(ctx context.Context, in *CreateEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Environments_CreateEnvironment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) GetEnvironment(ctx context.Context, in *GetEnvironmentRequest, opts ...grpc.CallOption) (*Environment, error) {
	out := new(Environment)
	err := c.cc.Invoke(ctx, Environments_GetEnvironment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) ListEnvironments(ctx context.Context, in *ListEnvironmentsRequest, opts ...grpc.CallOption) (*ListEnvironmentsResponse, error) {
	out := new(ListEnvironmentsResponse)
	err := c.cc.Invoke(ctx, Environments_ListEnvironments_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) UpdateEnvironment(ctx context.Context, in *UpdateEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Environments_UpdateEnvironment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) DeleteEnvironment(ctx context.Context, in *DeleteEnvironmentRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Environments_DeleteEnvironment_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) ExecuteAirflowCommand(ctx context.Context, in *ExecuteAirflowCommandRequest, opts ...grpc.CallOption) (*ExecuteAirflowCommandResponse, error) {
	out := new(ExecuteAirflowCommandResponse)
	err := c.cc.Invoke(ctx, Environments_ExecuteAirflowCommand_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) StopAirflowCommand(ctx context.Context, in *StopAirflowCommandRequest, opts ...grpc.CallOption) (*StopAirflowCommandResponse, error) {
	out := new(StopAirflowCommandResponse)
	err := c.cc.Invoke(ctx, Environments_StopAirflowCommand_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) PollAirflowCommand(ctx context.Context, in *PollAirflowCommandRequest, opts ...grpc.CallOption) (*PollAirflowCommandResponse, error) {
	out := new(PollAirflowCommandResponse)
	err := c.cc.Invoke(ctx, Environments_PollAirflowCommand_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) ListWorkloads(ctx context.Context, in *ListWorkloadsRequest, opts ...grpc.CallOption) (*ListWorkloadsResponse, error) {
	out := new(ListWorkloadsResponse)
	err := c.cc.Invoke(ctx, Environments_ListWorkloads_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) CheckUpgrade(ctx context.Context, in *CheckUpgradeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Environments_CheckUpgrade_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) CreateUserWorkloadsSecret(ctx context.Context, in *CreateUserWorkloadsSecretRequest, opts ...grpc.CallOption) (*UserWorkloadsSecret, error) {
	out := new(UserWorkloadsSecret)
	err := c.cc.Invoke(ctx, Environments_CreateUserWorkloadsSecret_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) GetUserWorkloadsSecret(ctx context.Context, in *GetUserWorkloadsSecretRequest, opts ...grpc.CallOption) (*UserWorkloadsSecret, error) {
	out := new(UserWorkloadsSecret)
	err := c.cc.Invoke(ctx, Environments_GetUserWorkloadsSecret_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) ListUserWorkloadsSecrets(ctx context.Context, in *ListUserWorkloadsSecretsRequest, opts ...grpc.CallOption) (*ListUserWorkloadsSecretsResponse, error) {
	out := new(ListUserWorkloadsSecretsResponse)
	err := c.cc.Invoke(ctx, Environments_ListUserWorkloadsSecrets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) UpdateUserWorkloadsSecret(ctx context.Context, in *UpdateUserWorkloadsSecretRequest, opts ...grpc.CallOption) (*UserWorkloadsSecret, error) {
	out := new(UserWorkloadsSecret)
	err := c.cc.Invoke(ctx, Environments_UpdateUserWorkloadsSecret_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) DeleteUserWorkloadsSecret(ctx context.Context, in *DeleteUserWorkloadsSecretRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Environments_DeleteUserWorkloadsSecret_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) CreateUserWorkloadsConfigMap(ctx context.Context, in *CreateUserWorkloadsConfigMapRequest, opts ...grpc.CallOption) (*UserWorkloadsConfigMap, error) {
	out := new(UserWorkloadsConfigMap)
	err := c.cc.Invoke(ctx, Environments_CreateUserWorkloadsConfigMap_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) GetUserWorkloadsConfigMap(ctx context.Context, in *GetUserWorkloadsConfigMapRequest, opts ...grpc.CallOption) (*UserWorkloadsConfigMap, error) {
	out := new(UserWorkloadsConfigMap)
	err := c.cc.Invoke(ctx, Environments_GetUserWorkloadsConfigMap_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) ListUserWorkloadsConfigMaps(ctx context.Context, in *ListUserWorkloadsConfigMapsRequest, opts ...grpc.CallOption) (*ListUserWorkloadsConfigMapsResponse, error) {
	out := new(ListUserWorkloadsConfigMapsResponse)
	err := c.cc.Invoke(ctx, Environments_ListUserWorkloadsConfigMaps_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) UpdateUserWorkloadsConfigMap(ctx context.Context, in *UpdateUserWorkloadsConfigMapRequest, opts ...grpc.CallOption) (*UserWorkloadsConfigMap, error) {
	out := new(UserWorkloadsConfigMap)
	err := c.cc.Invoke(ctx, Environments_UpdateUserWorkloadsConfigMap_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) DeleteUserWorkloadsConfigMap(ctx context.Context, in *DeleteUserWorkloadsConfigMapRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, Environments_DeleteUserWorkloadsConfigMap_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) SaveSnapshot(ctx context.Context, in *SaveSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Environments_SaveSnapshot_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) LoadSnapshot(ctx context.Context, in *LoadSnapshotRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Environments_LoadSnapshot_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) DatabaseFailover(ctx context.Context, in *DatabaseFailoverRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, Environments_DatabaseFailover_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *environmentsClient) FetchDatabaseProperties(ctx context.Context, in *FetchDatabasePropertiesRequest, opts ...grpc.CallOption) (*FetchDatabasePropertiesResponse, error) {
	out := new(FetchDatabasePropertiesResponse)
	err := c.cc.Invoke(ctx, Environments_FetchDatabaseProperties_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EnvironmentsServer is the server API for Environments service.
// All implementations should embed UnimplementedEnvironmentsServer
// for forward compatibility
type EnvironmentsServer interface {
	// Create a new environment.
	CreateEnvironment(context.Context, *CreateEnvironmentRequest) (*longrunningpb.Operation, error)
	// Get an existing environment.
	GetEnvironment(context.Context, *GetEnvironmentRequest) (*Environment, error)
	// List environments.
	ListEnvironments(context.Context, *ListEnvironmentsRequest) (*ListEnvironmentsResponse, error)
	// Update an environment.
	UpdateEnvironment(context.Context, *UpdateEnvironmentRequest) (*longrunningpb.Operation, error)
	// Delete an environment.
	DeleteEnvironment(context.Context, *DeleteEnvironmentRequest) (*longrunningpb.Operation, error)
	// Executes Airflow CLI command.
	ExecuteAirflowCommand(context.Context, *ExecuteAirflowCommandRequest) (*ExecuteAirflowCommandResponse, error)
	// Stops Airflow CLI command execution.
	StopAirflowCommand(context.Context, *StopAirflowCommandRequest) (*StopAirflowCommandResponse, error)
	// Polls Airflow CLI command execution and fetches logs.
	PollAirflowCommand(context.Context, *PollAirflowCommandRequest) (*PollAirflowCommandResponse, error)
	// Lists workloads in a Cloud Composer environment. Workload is a unit that
	// runs a single Composer component.
	//
	// This method is supported for Cloud Composer environments in versions
	// composer-2.*.*-airflow-*.*.* and newer.
	ListWorkloads(context.Context, *ListWorkloadsRequest) (*ListWorkloadsResponse, error)
	// Check if an upgrade operation on the environment will succeed.
	//
	// In case of problems detailed info can be found in the returned Operation.
	CheckUpgrade(context.Context, *CheckUpgradeRequest) (*longrunningpb.Operation, error)
	// Creates a user workloads Secret.
	//
	// This method is supported for Cloud Composer environments in versions
	// composer-3-airflow-*.*.*-build.* and newer.
	CreateUserWorkloadsSecret(context.Context, *CreateUserWorkloadsSecretRequest) (*UserWorkloadsSecret, error)
	// Gets an existing user workloads Secret.
	// Values of the "data" field in the response are cleared.
	//
	// This method is supported for Cloud Composer environments in versions
	// composer-3-airflow-*.*.*-build.* and newer.
	GetUserWorkloadsSecret(context.Context, *GetUserWorkloadsSecretRequest) (*UserWorkloadsSecret, error)
	// Lists user workloads Secrets.
	//
	// This method is supported for Cloud Composer environments in versions
	// composer-3-airflow-*.*.*-build.* and newer.
	ListUserWorkloadsSecrets(context.Context, *ListUserWorkloadsSecretsRequest) (*ListUserWorkloadsSecretsResponse, error)
	// Updates a user workloads Secret.
	//
	// This method is supported for Cloud Composer environments in versions
	// composer-3-airflow-*.*.*-build.* and newer.
	UpdateUserWorkloadsSecret(context.Context, *UpdateUserWorkloadsSecretRequest) (*UserWorkloadsSecret, error)
	// Deletes a user workloads Secret.
	//
	// This method is supported for Cloud Composer environments in versions
	// composer-3-airflow-*.*.*-build.* and newer.
	DeleteUserWorkloadsSecret(context.Context, *DeleteUserWorkloadsSecretRequest) (*emptypb.Empty, error)
	// Creates a user workloads ConfigMap.
	//
	// This method is supported for Cloud Composer environments in versions
	// composer-3-airflow-*.*.*-build.* and newer.
	CreateUserWorkloadsConfigMap(context.Context, *CreateUserWorkloadsConfigMapRequest) (*UserWorkloadsConfigMap, error)
	// Gets an existing user workloads ConfigMap.
	//
	// This method is supported for Cloud Composer environments in versions
	// composer-3-airflow-*.*.*-build.* and newer.
	GetUserWorkloadsConfigMap(context.Context, *GetUserWorkloadsConfigMapRequest) (*UserWorkloadsConfigMap, error)
	// Lists user workloads ConfigMaps.
	//
	// This method is supported for Cloud Composer environments in versions
	// composer-3-airflow-*.*.*-build.* and newer.
	ListUserWorkloadsConfigMaps(context.Context, *ListUserWorkloadsConfigMapsRequest) (*ListUserWorkloadsConfigMapsResponse, error)
	// Updates a user workloads ConfigMap.
	//
	// This method is supported for Cloud Composer environments in versions
	// composer-3-airflow-*.*.*-build.* and newer.
	UpdateUserWorkloadsConfigMap(context.Context, *UpdateUserWorkloadsConfigMapRequest) (*UserWorkloadsConfigMap, error)
	// Deletes a user workloads ConfigMap.
	//
	// This method is supported for Cloud Composer environments in versions
	// composer-3-airflow-*.*.*-build.* and newer.
	DeleteUserWorkloadsConfigMap(context.Context, *DeleteUserWorkloadsConfigMapRequest) (*emptypb.Empty, error)
	// Creates a snapshots of a Cloud Composer environment.
	//
	// As a result of this operation, snapshot of environment's state is stored
	// in a location specified in the SaveSnapshotRequest.
	SaveSnapshot(context.Context, *SaveSnapshotRequest) (*longrunningpb.Operation, error)
	// Loads a snapshot of a Cloud Composer environment.
	//
	// As a result of this operation, a snapshot of environment's specified in
	// LoadSnapshotRequest is loaded into the environment.
	LoadSnapshot(context.Context, *LoadSnapshotRequest) (*longrunningpb.Operation, error)
	// Triggers database failover (only for highly resilient environments).
	DatabaseFailover(context.Context, *DatabaseFailoverRequest) (*longrunningpb.Operation, error)
	// Fetches database properties.
	FetchDatabaseProperties(context.Context, *FetchDatabasePropertiesRequest) (*FetchDatabasePropertiesResponse, error)
}

// UnimplementedEnvironmentsServer should be embedded to have forward compatible implementations.
type UnimplementedEnvironmentsServer struct {
}

func (UnimplementedEnvironmentsServer) CreateEnvironment(context.Context, *CreateEnvironmentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateEnvironment not implemented")
}
func (UnimplementedEnvironmentsServer) GetEnvironment(context.Context, *GetEnvironmentRequest) (*Environment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEnvironment not implemented")
}
func (UnimplementedEnvironmentsServer) ListEnvironments(context.Context, *ListEnvironmentsRequest) (*ListEnvironmentsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListEnvironments not implemented")
}
func (UnimplementedEnvironmentsServer) UpdateEnvironment(context.Context, *UpdateEnvironmentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateEnvironment not implemented")
}
func (UnimplementedEnvironmentsServer) DeleteEnvironment(context.Context, *DeleteEnvironmentRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteEnvironment not implemented")
}
func (UnimplementedEnvironmentsServer) ExecuteAirflowCommand(context.Context, *ExecuteAirflowCommandRequest) (*ExecuteAirflowCommandResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExecuteAirflowCommand not implemented")
}
func (UnimplementedEnvironmentsServer) StopAirflowCommand(context.Context, *StopAirflowCommandRequest) (*StopAirflowCommandResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopAirflowCommand not implemented")
}
func (UnimplementedEnvironmentsServer) PollAirflowCommand(context.Context, *PollAirflowCommandRequest) (*PollAirflowCommandResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PollAirflowCommand not implemented")
}
func (UnimplementedEnvironmentsServer) ListWorkloads(context.Context, *ListWorkloadsRequest) (*ListWorkloadsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListWorkloads not implemented")
}
func (UnimplementedEnvironmentsServer) CheckUpgrade(context.Context, *CheckUpgradeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CheckUpgrade not implemented")
}
func (UnimplementedEnvironmentsServer) CreateUserWorkloadsSecret(context.Context, *CreateUserWorkloadsSecretRequest) (*UserWorkloadsSecret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateUserWorkloadsSecret not implemented")
}
func (UnimplementedEnvironmentsServer) GetUserWorkloadsSecret(context.Context, *GetUserWorkloadsSecretRequest) (*UserWorkloadsSecret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetUserWorkloadsSecret not implemented")
}
func (UnimplementedEnvironmentsServer) ListUserWorkloadsSecrets(context.Context, *ListUserWorkloadsSecretsRequest) (*ListUserWorkloadsSecretsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListUserWorkloadsSecrets not implemented")
}
func (UnimplementedEnvironmentsServer) UpdateUserWorkloadsSecret(context.Context, *UpdateUserWorkloadsSecretRequest) (*UserWorkloadsSecret, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateUserWorkloadsSecret not implemented")
}
func (UnimplementedEnvironmentsServer) DeleteUserWorkloadsSecret(context.Context, *DeleteUserWorkloadsSecretRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteUserWorkloadsSecret not implemented")
}
func (UnimplementedEnvironmentsServer) CreateUserWorkloadsConfigMap(context.Context, *CreateUserWorkloadsConfigMapRequest) (*UserWorkloadsConfigMap, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateUserWorkloadsConfigMap not implemented")
}
func (UnimplementedEnvironmentsServer) GetUserWorkloadsConfigMap(context.Context, *GetUserWorkloadsConfigMapRequest) (*UserWorkloadsConfigMap, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetUserWorkloadsConfigMap not implemented")
}
func (UnimplementedEnvironmentsServer) ListUserWorkloadsConfigMaps(context.Context, *ListUserWorkloadsConfigMapsRequest) (*ListUserWorkloadsConfigMapsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListUserWorkloadsConfigMaps not implemented")
}
func (UnimplementedEnvironmentsServer) UpdateUserWorkloadsConfigMap(context.Context, *UpdateUserWorkloadsConfigMapRequest) (*UserWorkloadsConfigMap, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateUserWorkloadsConfigMap not implemented")
}
func (UnimplementedEnvironmentsServer) DeleteUserWorkloadsConfigMap(context.Context, *DeleteUserWorkloadsConfigMapRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteUserWorkloadsConfigMap not implemented")
}
func (UnimplementedEnvironmentsServer) SaveSnapshot(context.Context, *SaveSnapshotRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SaveSnapshot not implemented")
}
func (UnimplementedEnvironmentsServer) LoadSnapshot(context.Context, *LoadSnapshotRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method LoadSnapshot not implemented")
}
func (UnimplementedEnvironmentsServer) DatabaseFailover(context.Context, *DatabaseFailoverRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DatabaseFailover not implemented")
}
func (UnimplementedEnvironmentsServer) FetchDatabaseProperties(context.Context, *FetchDatabasePropertiesRequest) (*FetchDatabasePropertiesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method FetchDatabaseProperties not implemented")
}

// UnsafeEnvironmentsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to EnvironmentsServer will
// result in compilation errors.
type UnsafeEnvironmentsServer interface {
	mustEmbedUnimplementedEnvironmentsServer()
}

func RegisterEnvironmentsServer(s grpc.ServiceRegistrar, srv EnvironmentsServer) {
	s.RegisterService(&Environments_ServiceDesc, srv)
}

func _Environments_CreateEnvironment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEnvironmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).CreateEnvironment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_CreateEnvironment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).CreateEnvironment(ctx, req.(*CreateEnvironmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_GetEnvironment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEnvironmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).GetEnvironment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_GetEnvironment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).GetEnvironment(ctx, req.(*GetEnvironmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_ListEnvironments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEnvironmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).ListEnvironments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_ListEnvironments_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).ListEnvironments(ctx, req.(*ListEnvironmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_UpdateEnvironment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEnvironmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).UpdateEnvironment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_UpdateEnvironment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).UpdateEnvironment(ctx, req.(*UpdateEnvironmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_DeleteEnvironment_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEnvironmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).DeleteEnvironment(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_DeleteEnvironment_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).DeleteEnvironment(ctx, req.(*DeleteEnvironmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_ExecuteAirflowCommand_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExecuteAirflowCommandRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).ExecuteAirflowCommand(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_ExecuteAirflowCommand_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).ExecuteAirflowCommand(ctx, req.(*ExecuteAirflowCommandRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_StopAirflowCommand_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopAirflowCommandRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).StopAirflowCommand(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_StopAirflowCommand_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).StopAirflowCommand(ctx, req.(*StopAirflowCommandRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_PollAirflowCommand_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PollAirflowCommandRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).PollAirflowCommand(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_PollAirflowCommand_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).PollAirflowCommand(ctx, req.(*PollAirflowCommandRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_ListWorkloads_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListWorkloadsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).ListWorkloads(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_ListWorkloads_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).ListWorkloads(ctx, req.(*ListWorkloadsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_CheckUpgrade_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckUpgradeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).CheckUpgrade(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_CheckUpgrade_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).CheckUpgrade(ctx, req.(*CheckUpgradeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_CreateUserWorkloadsSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateUserWorkloadsSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).CreateUserWorkloadsSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_CreateUserWorkloadsSecret_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).CreateUserWorkloadsSecret(ctx, req.(*CreateUserWorkloadsSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_GetUserWorkloadsSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUserWorkloadsSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).GetUserWorkloadsSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_GetUserWorkloadsSecret_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).GetUserWorkloadsSecret(ctx, req.(*GetUserWorkloadsSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_ListUserWorkloadsSecrets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUserWorkloadsSecretsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).ListUserWorkloadsSecrets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_ListUserWorkloadsSecrets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).ListUserWorkloadsSecrets(ctx, req.(*ListUserWorkloadsSecretsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_UpdateUserWorkloadsSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateUserWorkloadsSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).UpdateUserWorkloadsSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_UpdateUserWorkloadsSecret_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).UpdateUserWorkloadsSecret(ctx, req.(*UpdateUserWorkloadsSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_DeleteUserWorkloadsSecret_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteUserWorkloadsSecretRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).DeleteUserWorkloadsSecret(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_DeleteUserWorkloadsSecret_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).DeleteUserWorkloadsSecret(ctx, req.(*DeleteUserWorkloadsSecretRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_CreateUserWorkloadsConfigMap_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateUserWorkloadsConfigMapRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).CreateUserWorkloadsConfigMap(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_CreateUserWorkloadsConfigMap_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).CreateUserWorkloadsConfigMap(ctx, req.(*CreateUserWorkloadsConfigMapRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_GetUserWorkloadsConfigMap_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetUserWorkloadsConfigMapRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).GetUserWorkloadsConfigMap(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_GetUserWorkloadsConfigMap_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).GetUserWorkloadsConfigMap(ctx, req.(*GetUserWorkloadsConfigMapRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_ListUserWorkloadsConfigMaps_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUserWorkloadsConfigMapsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).ListUserWorkloadsConfigMaps(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_ListUserWorkloadsConfigMaps_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).ListUserWorkloadsConfigMaps(ctx, req.(*ListUserWorkloadsConfigMapsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_UpdateUserWorkloadsConfigMap_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateUserWorkloadsConfigMapRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).UpdateUserWorkloadsConfigMap(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_UpdateUserWorkloadsConfigMap_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).UpdateUserWorkloadsConfigMap(ctx, req.(*UpdateUserWorkloadsConfigMapRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_DeleteUserWorkloadsConfigMap_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteUserWorkloadsConfigMapRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).DeleteUserWorkloadsConfigMap(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_DeleteUserWorkloadsConfigMap_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).DeleteUserWorkloadsConfigMap(ctx, req.(*DeleteUserWorkloadsConfigMapRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_SaveSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SaveSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).SaveSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_SaveSnapshot_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).SaveSnapshot(ctx, req.(*SaveSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_LoadSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LoadSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).LoadSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_LoadSnapshot_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).LoadSnapshot(ctx, req.(*LoadSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_DatabaseFailover_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DatabaseFailoverRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).DatabaseFailover(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_DatabaseFailover_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).DatabaseFailover(ctx, req.(*DatabaseFailoverRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Environments_FetchDatabaseProperties_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(FetchDatabasePropertiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EnvironmentsServer).FetchDatabaseProperties(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Environments_FetchDatabaseProperties_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EnvironmentsServer).FetchDatabaseProperties(ctx, req.(*FetchDatabasePropertiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Environments_ServiceDesc is the grpc.ServiceDesc for Environments service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Environments_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.orchestration.airflow.service.v1.Environments",
	HandlerType: (*EnvironmentsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateEnvironment",
			Handler:    _Environments_CreateEnvironment_Handler,
		},
		{
			MethodName: "GetEnvironment",
			Handler:    _Environments_GetEnvironment_Handler,
		},
		{
			MethodName: "ListEnvironments",
			Handler:    _Environments_ListEnvironments_Handler,
		},
		{
			MethodName: "UpdateEnvironment",
			Handler:    _Environments_UpdateEnvironment_Handler,
		},
		{
			MethodName: "DeleteEnvironment",
			Handler:    _Environments_DeleteEnvironment_Handler,
		},
		{
			MethodName: "ExecuteAirflowCommand",
			Handler:    _Environments_ExecuteAirflowCommand_Handler,
		},
		{
			MethodName: "StopAirflowCommand",
			Handler:    _Environments_StopAirflowCommand_Handler,
		},
		{
			MethodName: "PollAirflowCommand",
			Handler:    _Environments_PollAirflowCommand_Handler,
		},
		{
			MethodName: "ListWorkloads",
			Handler:    _Environments_ListWorkloads_Handler,
		},
		{
			MethodName: "CheckUpgrade",
			Handler:    _Environments_CheckUpgrade_Handler,
		},
		{
			MethodName: "CreateUserWorkloadsSecret",
			Handler:    _Environments_CreateUserWorkloadsSecret_Handler,
		},
		{
			MethodName: "GetUserWorkloadsSecret",
			Handler:    _Environments_GetUserWorkloadsSecret_Handler,
		},
		{
			MethodName: "ListUserWorkloadsSecrets",
			Handler:    _Environments_ListUserWorkloadsSecrets_Handler,
		},
		{
			MethodName: "UpdateUserWorkloadsSecret",
			Handler:    _Environments_UpdateUserWorkloadsSecret_Handler,
		},
		{
			MethodName: "DeleteUserWorkloadsSecret",
			Handler:    _Environments_DeleteUserWorkloadsSecret_Handler,
		},
		{
			MethodName: "CreateUserWorkloadsConfigMap",
			Handler:    _Environments_CreateUserWorkloadsConfigMap_Handler,
		},
		{
			MethodName: "GetUserWorkloadsConfigMap",
			Handler:    _Environments_GetUserWorkloadsConfigMap_Handler,
		},
		{
			MethodName: "ListUserWorkloadsConfigMaps",
			Handler:    _Environments_ListUserWorkloadsConfigMaps_Handler,
		},
		{
			MethodName: "UpdateUserWorkloadsConfigMap",
			Handler:    _Environments_UpdateUserWorkloadsConfigMap_Handler,
		},
		{
			MethodName: "DeleteUserWorkloadsConfigMap",
			Handler:    _Environments_DeleteUserWorkloadsConfigMap_Handler,
		},
		{
			MethodName: "SaveSnapshot",
			Handler:    _Environments_SaveSnapshot_Handler,
		},
		{
			MethodName: "LoadSnapshot",
			Handler:    _Environments_LoadSnapshot_Handler,
		},
		{
			MethodName: "DatabaseFailover",
			Handler:    _Environments_DatabaseFailover_Handler,
		},
		{
			MethodName: "FetchDatabaseProperties",
			Handler:    _Environments_FetchDatabaseProperties_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/orchestration/airflow/service/v1/environments.proto",
}
