// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/networkconnectivity/v1alpha1/hub.proto

package networkconnectivitypb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	HubService_ListHubs_FullMethodName    = "/google.cloud.networkconnectivity.v1alpha1.HubService/ListHubs"
	HubService_GetHub_FullMethodName      = "/google.cloud.networkconnectivity.v1alpha1.HubService/GetHub"
	HubService_CreateHub_FullMethodName   = "/google.cloud.networkconnectivity.v1alpha1.HubService/CreateHub"
	HubService_UpdateHub_FullMethodName   = "/google.cloud.networkconnectivity.v1alpha1.HubService/UpdateHub"
	HubService_DeleteHub_FullMethodName   = "/google.cloud.networkconnectivity.v1alpha1.HubService/DeleteHub"
	HubService_ListSpokes_FullMethodName  = "/google.cloud.networkconnectivity.v1alpha1.HubService/ListSpokes"
	HubService_GetSpoke_FullMethodName    = "/google.cloud.networkconnectivity.v1alpha1.HubService/GetSpoke"
	HubService_CreateSpoke_FullMethodName = "/google.cloud.networkconnectivity.v1alpha1.HubService/CreateSpoke"
	HubService_UpdateSpoke_FullMethodName = "/google.cloud.networkconnectivity.v1alpha1.HubService/UpdateSpoke"
	HubService_DeleteSpoke_FullMethodName = "/google.cloud.networkconnectivity.v1alpha1.HubService/DeleteSpoke"
)

// HubServiceClient is the client API for HubService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type HubServiceClient interface {
	// Lists Hubs in a given project and location.
	ListHubs(ctx context.Context, in *ListHubsRequest, opts ...grpc.CallOption) (*ListHubsResponse, error)
	// Gets details of a single Hub.
	GetHub(ctx context.Context, in *GetHubRequest, opts ...grpc.CallOption) (*Hub, error)
	// Creates a new Hub in a given project and location.
	CreateHub(ctx context.Context, in *CreateHubRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Hub.
	UpdateHub(ctx context.Context, in *UpdateHubRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Hub.
	DeleteHub(ctx context.Context, in *DeleteHubRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists Spokes in a given project and location.
	ListSpokes(ctx context.Context, in *ListSpokesRequest, opts ...grpc.CallOption) (*ListSpokesResponse, error)
	// Gets details of a single Spoke.
	GetSpoke(ctx context.Context, in *GetSpokeRequest, opts ...grpc.CallOption) (*Spoke, error)
	// Creates a new Spoke in a given project and location.
	CreateSpoke(ctx context.Context, in *CreateSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Spoke.
	UpdateSpoke(ctx context.Context, in *UpdateSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single Spoke.
	DeleteSpoke(ctx context.Context, in *DeleteSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type hubServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewHubServiceClient(cc grpc.ClientConnInterface) HubServiceClient {
	return &hubServiceClient{cc}
}

func (c *hubServiceClient) ListHubs(ctx context.Context, in *ListHubsRequest, opts ...grpc.CallOption) (*ListHubsResponse, error) {
	out := new(ListHubsResponse)
	err := c.cc.Invoke(ctx, HubService_ListHubs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) GetHub(ctx context.Context, in *GetHubRequest, opts ...grpc.CallOption) (*Hub, error) {
	out := new(Hub)
	err := c.cc.Invoke(ctx, HubService_GetHub_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) CreateHub(ctx context.Context, in *CreateHubRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, HubService_CreateHub_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) UpdateHub(ctx context.Context, in *UpdateHubRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, HubService_UpdateHub_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) DeleteHub(ctx context.Context, in *DeleteHubRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, HubService_DeleteHub_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) ListSpokes(ctx context.Context, in *ListSpokesRequest, opts ...grpc.CallOption) (*ListSpokesResponse, error) {
	out := new(ListSpokesResponse)
	err := c.cc.Invoke(ctx, HubService_ListSpokes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) GetSpoke(ctx context.Context, in *GetSpokeRequest, opts ...grpc.CallOption) (*Spoke, error) {
	out := new(Spoke)
	err := c.cc.Invoke(ctx, HubService_GetSpoke_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) CreateSpoke(ctx context.Context, in *CreateSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, HubService_CreateSpoke_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) UpdateSpoke(ctx context.Context, in *UpdateSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, HubService_UpdateSpoke_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) DeleteSpoke(ctx context.Context, in *DeleteSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, HubService_DeleteSpoke_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// HubServiceServer is the server API for HubService service.
// All implementations should embed UnimplementedHubServiceServer
// for forward compatibility
type HubServiceServer interface {
	// Lists Hubs in a given project and location.
	ListHubs(context.Context, *ListHubsRequest) (*ListHubsResponse, error)
	// Gets details of a single Hub.
	GetHub(context.Context, *GetHubRequest) (*Hub, error)
	// Creates a new Hub in a given project and location.
	CreateHub(context.Context, *CreateHubRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Hub.
	UpdateHub(context.Context, *UpdateHubRequest) (*longrunningpb.Operation, error)
	// Deletes a single Hub.
	DeleteHub(context.Context, *DeleteHubRequest) (*longrunningpb.Operation, error)
	// Lists Spokes in a given project and location.
	ListSpokes(context.Context, *ListSpokesRequest) (*ListSpokesResponse, error)
	// Gets details of a single Spoke.
	GetSpoke(context.Context, *GetSpokeRequest) (*Spoke, error)
	// Creates a new Spoke in a given project and location.
	CreateSpoke(context.Context, *CreateSpokeRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single Spoke.
	UpdateSpoke(context.Context, *UpdateSpokeRequest) (*longrunningpb.Operation, error)
	// Deletes a single Spoke.
	DeleteSpoke(context.Context, *DeleteSpokeRequest) (*longrunningpb.Operation, error)
}

// UnimplementedHubServiceServer should be embedded to have forward compatible implementations.
type UnimplementedHubServiceServer struct {
}

func (UnimplementedHubServiceServer) ListHubs(context.Context, *ListHubsRequest) (*ListHubsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHubs not implemented")
}
func (UnimplementedHubServiceServer) GetHub(context.Context, *GetHubRequest) (*Hub, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHub not implemented")
}
func (UnimplementedHubServiceServer) CreateHub(context.Context, *CreateHubRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateHub not implemented")
}
func (UnimplementedHubServiceServer) UpdateHub(context.Context, *UpdateHubRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateHub not implemented")
}
func (UnimplementedHubServiceServer) DeleteHub(context.Context, *DeleteHubRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteHub not implemented")
}
func (UnimplementedHubServiceServer) ListSpokes(context.Context, *ListSpokesRequest) (*ListSpokesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSpokes not implemented")
}
func (UnimplementedHubServiceServer) GetSpoke(context.Context, *GetSpokeRequest) (*Spoke, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSpoke not implemented")
}
func (UnimplementedHubServiceServer) CreateSpoke(context.Context, *CreateSpokeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSpoke not implemented")
}
func (UnimplementedHubServiceServer) UpdateSpoke(context.Context, *UpdateSpokeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSpoke not implemented")
}
func (UnimplementedHubServiceServer) DeleteSpoke(context.Context, *DeleteSpokeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSpoke not implemented")
}

// UnsafeHubServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to HubServiceServer will
// result in compilation errors.
type UnsafeHubServiceServer interface {
	mustEmbedUnimplementedHubServiceServer()
}

func RegisterHubServiceServer(s grpc.ServiceRegistrar, srv HubServiceServer) {
	s.RegisterService(&HubService_ServiceDesc, srv)
}

func _HubService_ListHubs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListHubsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).ListHubs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_ListHubs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).ListHubs(ctx, req.(*ListHubsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_GetHub_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetHubRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).GetHub(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_GetHub_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).GetHub(ctx, req.(*GetHubRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_CreateHub_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateHubRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).CreateHub(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_CreateHub_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).CreateHub(ctx, req.(*CreateHubRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_UpdateHub_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateHubRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).UpdateHub(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_UpdateHub_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).UpdateHub(ctx, req.(*UpdateHubRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_DeleteHub_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteHubRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).DeleteHub(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_DeleteHub_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).DeleteHub(ctx, req.(*DeleteHubRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_ListSpokes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSpokesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).ListSpokes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_ListSpokes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).ListSpokes(ctx, req.(*ListSpokesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_GetSpoke_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSpokeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).GetSpoke(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_GetSpoke_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).GetSpoke(ctx, req.(*GetSpokeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_CreateSpoke_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSpokeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).CreateSpoke(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_CreateSpoke_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).CreateSpoke(ctx, req.(*CreateSpokeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_UpdateSpoke_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSpokeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).UpdateSpoke(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_UpdateSpoke_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).UpdateSpoke(ctx, req.(*UpdateSpokeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_DeleteSpoke_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSpokeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).DeleteSpoke(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_DeleteSpoke_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).DeleteSpoke(ctx, req.(*DeleteSpokeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// HubService_ServiceDesc is the grpc.ServiceDesc for HubService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var HubService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.networkconnectivity.v1alpha1.HubService",
	HandlerType: (*HubServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListHubs",
			Handler:    _HubService_ListHubs_Handler,
		},
		{
			MethodName: "GetHub",
			Handler:    _HubService_GetHub_Handler,
		},
		{
			MethodName: "CreateHub",
			Handler:    _HubService_CreateHub_Handler,
		},
		{
			MethodName: "UpdateHub",
			Handler:    _HubService_UpdateHub_Handler,
		},
		{
			MethodName: "DeleteHub",
			Handler:    _HubService_DeleteHub_Handler,
		},
		{
			MethodName: "ListSpokes",
			Handler:    _HubService_ListSpokes_Handler,
		},
		{
			MethodName: "GetSpoke",
			Handler:    _HubService_GetSpoke_Handler,
		},
		{
			MethodName: "CreateSpoke",
			Handler:    _HubService_CreateSpoke_Handler,
		},
		{
			MethodName: "UpdateSpoke",
			Handler:    _HubService_UpdateSpoke_Handler,
		},
		{
			MethodName: "DeleteSpoke",
			Handler:    _HubService_DeleteSpoke_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/networkconnectivity/v1alpha1/hub.proto",
}
