// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/networkconnectivity/v1/hub.proto

package networkconnectivitypb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	HubService_ListHubs_FullMethodName          = "/google.cloud.networkconnectivity.v1.HubService/ListHubs"
	HubService_GetHub_FullMethodName            = "/google.cloud.networkconnectivity.v1.HubService/GetHub"
	HubService_CreateHub_FullMethodName         = "/google.cloud.networkconnectivity.v1.HubService/CreateHub"
	HubService_UpdateHub_FullMethodName         = "/google.cloud.networkconnectivity.v1.HubService/UpdateHub"
	HubService_DeleteHub_FullMethodName         = "/google.cloud.networkconnectivity.v1.HubService/DeleteHub"
	HubService_ListHubSpokes_FullMethodName     = "/google.cloud.networkconnectivity.v1.HubService/ListHubSpokes"
	HubService_QueryHubStatus_FullMethodName    = "/google.cloud.networkconnectivity.v1.HubService/QueryHubStatus"
	HubService_ListSpokes_FullMethodName        = "/google.cloud.networkconnectivity.v1.HubService/ListSpokes"
	HubService_GetSpoke_FullMethodName          = "/google.cloud.networkconnectivity.v1.HubService/GetSpoke"
	HubService_CreateSpoke_FullMethodName       = "/google.cloud.networkconnectivity.v1.HubService/CreateSpoke"
	HubService_UpdateSpoke_FullMethodName       = "/google.cloud.networkconnectivity.v1.HubService/UpdateSpoke"
	HubService_RejectHubSpoke_FullMethodName    = "/google.cloud.networkconnectivity.v1.HubService/RejectHubSpoke"
	HubService_AcceptHubSpoke_FullMethodName    = "/google.cloud.networkconnectivity.v1.HubService/AcceptHubSpoke"
	HubService_AcceptSpokeUpdate_FullMethodName = "/google.cloud.networkconnectivity.v1.HubService/AcceptSpokeUpdate"
	HubService_RejectSpokeUpdate_FullMethodName = "/google.cloud.networkconnectivity.v1.HubService/RejectSpokeUpdate"
	HubService_DeleteSpoke_FullMethodName       = "/google.cloud.networkconnectivity.v1.HubService/DeleteSpoke"
	HubService_GetRouteTable_FullMethodName     = "/google.cloud.networkconnectivity.v1.HubService/GetRouteTable"
	HubService_GetRoute_FullMethodName          = "/google.cloud.networkconnectivity.v1.HubService/GetRoute"
	HubService_ListRoutes_FullMethodName        = "/google.cloud.networkconnectivity.v1.HubService/ListRoutes"
	HubService_ListRouteTables_FullMethodName   = "/google.cloud.networkconnectivity.v1.HubService/ListRouteTables"
	HubService_GetGroup_FullMethodName          = "/google.cloud.networkconnectivity.v1.HubService/GetGroup"
	HubService_ListGroups_FullMethodName        = "/google.cloud.networkconnectivity.v1.HubService/ListGroups"
	HubService_UpdateGroup_FullMethodName       = "/google.cloud.networkconnectivity.v1.HubService/UpdateGroup"
)

// HubServiceClient is the client API for HubService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type HubServiceClient interface {
	// Lists the Network Connectivity Center hubs associated with a given project.
	ListHubs(ctx context.Context, in *ListHubsRequest, opts ...grpc.CallOption) (*ListHubsResponse, error)
	// Gets details about a Network Connectivity Center hub.
	GetHub(ctx context.Context, in *GetHubRequest, opts ...grpc.CallOption) (*Hub, error)
	// Creates a new Network Connectivity Center hub in the specified project.
	CreateHub(ctx context.Context, in *CreateHubRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the description and/or labels of a Network Connectivity Center
	// hub.
	UpdateHub(ctx context.Context, in *UpdateHubRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a Network Connectivity Center hub.
	DeleteHub(ctx context.Context, in *DeleteHubRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists the Network Connectivity Center spokes associated with a
	// specified hub and location. The list includes both spokes that are attached
	// to the hub and spokes that have been proposed but not yet accepted.
	ListHubSpokes(ctx context.Context, in *ListHubSpokesRequest, opts ...grpc.CallOption) (*ListHubSpokesResponse, error)
	// Query the Private Service Connect propagation status of a Network
	// Connectivity Center hub.
	QueryHubStatus(ctx context.Context, in *QueryHubStatusRequest, opts ...grpc.CallOption) (*QueryHubStatusResponse, error)
	// Lists the Network Connectivity Center spokes in a specified project and
	// location.
	ListSpokes(ctx context.Context, in *ListSpokesRequest, opts ...grpc.CallOption) (*ListSpokesResponse, error)
	// Gets details about a Network Connectivity Center spoke.
	GetSpoke(ctx context.Context, in *GetSpokeRequest, opts ...grpc.CallOption) (*Spoke, error)
	// Creates a Network Connectivity Center spoke.
	CreateSpoke(ctx context.Context, in *CreateSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a Network Connectivity Center spoke.
	UpdateSpoke(ctx context.Context, in *UpdateSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Rejects a Network Connectivity Center spoke from being attached to a hub.
	// If the spoke was previously in the `ACTIVE` state, it
	// transitions to the `INACTIVE` state and is no longer able to
	// connect to other spokes that are attached to the hub.
	RejectHubSpoke(ctx context.Context, in *RejectHubSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Accepts a proposal to attach a Network Connectivity Center spoke
	// to a hub.
	AcceptHubSpoke(ctx context.Context, in *AcceptHubSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Accepts a proposal to update a Network Connectivity Center spoke in a hub.
	AcceptSpokeUpdate(ctx context.Context, in *AcceptSpokeUpdateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Rejects a proposal to update a Network Connectivity Center spoke in a hub.
	RejectSpokeUpdate(ctx context.Context, in *RejectSpokeUpdateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a Network Connectivity Center spoke.
	DeleteSpoke(ctx context.Context, in *DeleteSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details about a Network Connectivity Center route table.
	GetRouteTable(ctx context.Context, in *GetRouteTableRequest, opts ...grpc.CallOption) (*RouteTable, error)
	// Gets details about the specified route.
	GetRoute(ctx context.Context, in *GetRouteRequest, opts ...grpc.CallOption) (*Route, error)
	// Lists routes in a given route table.
	ListRoutes(ctx context.Context, in *ListRoutesRequest, opts ...grpc.CallOption) (*ListRoutesResponse, error)
	// Lists route tables in a given hub.
	ListRouteTables(ctx context.Context, in *ListRouteTablesRequest, opts ...grpc.CallOption) (*ListRouteTablesResponse, error)
	// Gets details about a Network Connectivity Center group.
	GetGroup(ctx context.Context, in *GetGroupRequest, opts ...grpc.CallOption) (*Group, error)
	// Lists groups in a given hub.
	ListGroups(ctx context.Context, in *ListGroupsRequest, opts ...grpc.CallOption) (*ListGroupsResponse, error)
	// Updates the parameters of a Network Connectivity Center group.
	UpdateGroup(ctx context.Context, in *UpdateGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type hubServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewHubServiceClient(cc grpc.ClientConnInterface) HubServiceClient {
	return &hubServiceClient{cc}
}

func (c *hubServiceClient) ListHubs(ctx context.Context, in *ListHubsRequest, opts ...grpc.CallOption) (*ListHubsResponse, error) {
	out := new(ListHubsResponse)
	err := c.cc.Invoke(ctx, HubService_ListHubs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) GetHub(ctx context.Context, in *GetHubRequest, opts ...grpc.CallOption) (*Hub, error) {
	out := new(Hub)
	err := c.cc.Invoke(ctx, HubService_GetHub_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) CreateHub(ctx context.Context, in *CreateHubRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, HubService_CreateHub_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) UpdateHub(ctx context.Context, in *UpdateHubRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, HubService_UpdateHub_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) DeleteHub(ctx context.Context, in *DeleteHubRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, HubService_DeleteHub_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) ListHubSpokes(ctx context.Context, in *ListHubSpokesRequest, opts ...grpc.CallOption) (*ListHubSpokesResponse, error) {
	out := new(ListHubSpokesResponse)
	err := c.cc.Invoke(ctx, HubService_ListHubSpokes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) QueryHubStatus(ctx context.Context, in *QueryHubStatusRequest, opts ...grpc.CallOption) (*QueryHubStatusResponse, error) {
	out := new(QueryHubStatusResponse)
	err := c.cc.Invoke(ctx, HubService_QueryHubStatus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) ListSpokes(ctx context.Context, in *ListSpokesRequest, opts ...grpc.CallOption) (*ListSpokesResponse, error) {
	out := new(ListSpokesResponse)
	err := c.cc.Invoke(ctx, HubService_ListSpokes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) GetSpoke(ctx context.Context, in *GetSpokeRequest, opts ...grpc.CallOption) (*Spoke, error) {
	out := new(Spoke)
	err := c.cc.Invoke(ctx, HubService_GetSpoke_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) CreateSpoke(ctx context.Context, in *CreateSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, HubService_CreateSpoke_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) UpdateSpoke(ctx context.Context, in *UpdateSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, HubService_UpdateSpoke_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) RejectHubSpoke(ctx context.Context, in *RejectHubSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, HubService_RejectHubSpoke_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) AcceptHubSpoke(ctx context.Context, in *AcceptHubSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, HubService_AcceptHubSpoke_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) AcceptSpokeUpdate(ctx context.Context, in *AcceptSpokeUpdateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, HubService_AcceptSpokeUpdate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) RejectSpokeUpdate(ctx context.Context, in *RejectSpokeUpdateRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, HubService_RejectSpokeUpdate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) DeleteSpoke(ctx context.Context, in *DeleteSpokeRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, HubService_DeleteSpoke_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) GetRouteTable(ctx context.Context, in *GetRouteTableRequest, opts ...grpc.CallOption) (*RouteTable, error) {
	out := new(RouteTable)
	err := c.cc.Invoke(ctx, HubService_GetRouteTable_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) GetRoute(ctx context.Context, in *GetRouteRequest, opts ...grpc.CallOption) (*Route, error) {
	out := new(Route)
	err := c.cc.Invoke(ctx, HubService_GetRoute_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) ListRoutes(ctx context.Context, in *ListRoutesRequest, opts ...grpc.CallOption) (*ListRoutesResponse, error) {
	out := new(ListRoutesResponse)
	err := c.cc.Invoke(ctx, HubService_ListRoutes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) ListRouteTables(ctx context.Context, in *ListRouteTablesRequest, opts ...grpc.CallOption) (*ListRouteTablesResponse, error) {
	out := new(ListRouteTablesResponse)
	err := c.cc.Invoke(ctx, HubService_ListRouteTables_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) GetGroup(ctx context.Context, in *GetGroupRequest, opts ...grpc.CallOption) (*Group, error) {
	out := new(Group)
	err := c.cc.Invoke(ctx, HubService_GetGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) ListGroups(ctx context.Context, in *ListGroupsRequest, opts ...grpc.CallOption) (*ListGroupsResponse, error) {
	out := new(ListGroupsResponse)
	err := c.cc.Invoke(ctx, HubService_ListGroups_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *hubServiceClient) UpdateGroup(ctx context.Context, in *UpdateGroupRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, HubService_UpdateGroup_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// HubServiceServer is the server API for HubService service.
// All implementations should embed UnimplementedHubServiceServer
// for forward compatibility
type HubServiceServer interface {
	// Lists the Network Connectivity Center hubs associated with a given project.
	ListHubs(context.Context, *ListHubsRequest) (*ListHubsResponse, error)
	// Gets details about a Network Connectivity Center hub.
	GetHub(context.Context, *GetHubRequest) (*Hub, error)
	// Creates a new Network Connectivity Center hub in the specified project.
	CreateHub(context.Context, *CreateHubRequest) (*longrunningpb.Operation, error)
	// Updates the description and/or labels of a Network Connectivity Center
	// hub.
	UpdateHub(context.Context, *UpdateHubRequest) (*longrunningpb.Operation, error)
	// Deletes a Network Connectivity Center hub.
	DeleteHub(context.Context, *DeleteHubRequest) (*longrunningpb.Operation, error)
	// Lists the Network Connectivity Center spokes associated with a
	// specified hub and location. The list includes both spokes that are attached
	// to the hub and spokes that have been proposed but not yet accepted.
	ListHubSpokes(context.Context, *ListHubSpokesRequest) (*ListHubSpokesResponse, error)
	// Query the Private Service Connect propagation status of a Network
	// Connectivity Center hub.
	QueryHubStatus(context.Context, *QueryHubStatusRequest) (*QueryHubStatusResponse, error)
	// Lists the Network Connectivity Center spokes in a specified project and
	// location.
	ListSpokes(context.Context, *ListSpokesRequest) (*ListSpokesResponse, error)
	// Gets details about a Network Connectivity Center spoke.
	GetSpoke(context.Context, *GetSpokeRequest) (*Spoke, error)
	// Creates a Network Connectivity Center spoke.
	CreateSpoke(context.Context, *CreateSpokeRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a Network Connectivity Center spoke.
	UpdateSpoke(context.Context, *UpdateSpokeRequest) (*longrunningpb.Operation, error)
	// Rejects a Network Connectivity Center spoke from being attached to a hub.
	// If the spoke was previously in the `ACTIVE` state, it
	// transitions to the `INACTIVE` state and is no longer able to
	// connect to other spokes that are attached to the hub.
	RejectHubSpoke(context.Context, *RejectHubSpokeRequest) (*longrunningpb.Operation, error)
	// Accepts a proposal to attach a Network Connectivity Center spoke
	// to a hub.
	AcceptHubSpoke(context.Context, *AcceptHubSpokeRequest) (*longrunningpb.Operation, error)
	// Accepts a proposal to update a Network Connectivity Center spoke in a hub.
	AcceptSpokeUpdate(context.Context, *AcceptSpokeUpdateRequest) (*longrunningpb.Operation, error)
	// Rejects a proposal to update a Network Connectivity Center spoke in a hub.
	RejectSpokeUpdate(context.Context, *RejectSpokeUpdateRequest) (*longrunningpb.Operation, error)
	// Deletes a Network Connectivity Center spoke.
	DeleteSpoke(context.Context, *DeleteSpokeRequest) (*longrunningpb.Operation, error)
	// Gets details about a Network Connectivity Center route table.
	GetRouteTable(context.Context, *GetRouteTableRequest) (*RouteTable, error)
	// Gets details about the specified route.
	GetRoute(context.Context, *GetRouteRequest) (*Route, error)
	// Lists routes in a given route table.
	ListRoutes(context.Context, *ListRoutesRequest) (*ListRoutesResponse, error)
	// Lists route tables in a given hub.
	ListRouteTables(context.Context, *ListRouteTablesRequest) (*ListRouteTablesResponse, error)
	// Gets details about a Network Connectivity Center group.
	GetGroup(context.Context, *GetGroupRequest) (*Group, error)
	// Lists groups in a given hub.
	ListGroups(context.Context, *ListGroupsRequest) (*ListGroupsResponse, error)
	// Updates the parameters of a Network Connectivity Center group.
	UpdateGroup(context.Context, *UpdateGroupRequest) (*longrunningpb.Operation, error)
}

// UnimplementedHubServiceServer should be embedded to have forward compatible implementations.
type UnimplementedHubServiceServer struct {
}

func (UnimplementedHubServiceServer) ListHubs(context.Context, *ListHubsRequest) (*ListHubsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHubs not implemented")
}
func (UnimplementedHubServiceServer) GetHub(context.Context, *GetHubRequest) (*Hub, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHub not implemented")
}
func (UnimplementedHubServiceServer) CreateHub(context.Context, *CreateHubRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateHub not implemented")
}
func (UnimplementedHubServiceServer) UpdateHub(context.Context, *UpdateHubRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateHub not implemented")
}
func (UnimplementedHubServiceServer) DeleteHub(context.Context, *DeleteHubRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteHub not implemented")
}
func (UnimplementedHubServiceServer) ListHubSpokes(context.Context, *ListHubSpokesRequest) (*ListHubSpokesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListHubSpokes not implemented")
}
func (UnimplementedHubServiceServer) QueryHubStatus(context.Context, *QueryHubStatusRequest) (*QueryHubStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method QueryHubStatus not implemented")
}
func (UnimplementedHubServiceServer) ListSpokes(context.Context, *ListSpokesRequest) (*ListSpokesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListSpokes not implemented")
}
func (UnimplementedHubServiceServer) GetSpoke(context.Context, *GetSpokeRequest) (*Spoke, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSpoke not implemented")
}
func (UnimplementedHubServiceServer) CreateSpoke(context.Context, *CreateSpokeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSpoke not implemented")
}
func (UnimplementedHubServiceServer) UpdateSpoke(context.Context, *UpdateSpokeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateSpoke not implemented")
}
func (UnimplementedHubServiceServer) RejectHubSpoke(context.Context, *RejectHubSpokeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RejectHubSpoke not implemented")
}
func (UnimplementedHubServiceServer) AcceptHubSpoke(context.Context, *AcceptHubSpokeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AcceptHubSpoke not implemented")
}
func (UnimplementedHubServiceServer) AcceptSpokeUpdate(context.Context, *AcceptSpokeUpdateRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AcceptSpokeUpdate not implemented")
}
func (UnimplementedHubServiceServer) RejectSpokeUpdate(context.Context, *RejectSpokeUpdateRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RejectSpokeUpdate not implemented")
}
func (UnimplementedHubServiceServer) DeleteSpoke(context.Context, *DeleteSpokeRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSpoke not implemented")
}
func (UnimplementedHubServiceServer) GetRouteTable(context.Context, *GetRouteTableRequest) (*RouteTable, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRouteTable not implemented")
}
func (UnimplementedHubServiceServer) GetRoute(context.Context, *GetRouteRequest) (*Route, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRoute not implemented")
}
func (UnimplementedHubServiceServer) ListRoutes(context.Context, *ListRoutesRequest) (*ListRoutesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRoutes not implemented")
}
func (UnimplementedHubServiceServer) ListRouteTables(context.Context, *ListRouteTablesRequest) (*ListRouteTablesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRouteTables not implemented")
}
func (UnimplementedHubServiceServer) GetGroup(context.Context, *GetGroupRequest) (*Group, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGroup not implemented")
}
func (UnimplementedHubServiceServer) ListGroups(context.Context, *ListGroupsRequest) (*ListGroupsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListGroups not implemented")
}
func (UnimplementedHubServiceServer) UpdateGroup(context.Context, *UpdateGroupRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateGroup not implemented")
}

// UnsafeHubServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to HubServiceServer will
// result in compilation errors.
type UnsafeHubServiceServer interface {
	mustEmbedUnimplementedHubServiceServer()
}

func RegisterHubServiceServer(s grpc.ServiceRegistrar, srv HubServiceServer) {
	s.RegisterService(&HubService_ServiceDesc, srv)
}

func _HubService_ListHubs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListHubsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).ListHubs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_ListHubs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).ListHubs(ctx, req.(*ListHubsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_GetHub_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetHubRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).GetHub(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_GetHub_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).GetHub(ctx, req.(*GetHubRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_CreateHub_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateHubRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).CreateHub(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_CreateHub_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).CreateHub(ctx, req.(*CreateHubRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_UpdateHub_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateHubRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).UpdateHub(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_UpdateHub_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).UpdateHub(ctx, req.(*UpdateHubRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_DeleteHub_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteHubRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).DeleteHub(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_DeleteHub_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).DeleteHub(ctx, req.(*DeleteHubRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_ListHubSpokes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListHubSpokesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).ListHubSpokes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_ListHubSpokes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).ListHubSpokes(ctx, req.(*ListHubSpokesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_QueryHubStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(QueryHubStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).QueryHubStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_QueryHubStatus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).QueryHubStatus(ctx, req.(*QueryHubStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_ListSpokes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSpokesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).ListSpokes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_ListSpokes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).ListSpokes(ctx, req.(*ListSpokesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_GetSpoke_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSpokeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).GetSpoke(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_GetSpoke_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).GetSpoke(ctx, req.(*GetSpokeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_CreateSpoke_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSpokeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).CreateSpoke(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_CreateSpoke_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).CreateSpoke(ctx, req.(*CreateSpokeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_UpdateSpoke_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSpokeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).UpdateSpoke(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_UpdateSpoke_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).UpdateSpoke(ctx, req.(*UpdateSpokeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_RejectHubSpoke_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RejectHubSpokeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).RejectHubSpoke(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_RejectHubSpoke_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).RejectHubSpoke(ctx, req.(*RejectHubSpokeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_AcceptHubSpoke_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AcceptHubSpokeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).AcceptHubSpoke(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_AcceptHubSpoke_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).AcceptHubSpoke(ctx, req.(*AcceptHubSpokeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_AcceptSpokeUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AcceptSpokeUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).AcceptSpokeUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_AcceptSpokeUpdate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).AcceptSpokeUpdate(ctx, req.(*AcceptSpokeUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_RejectSpokeUpdate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RejectSpokeUpdateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).RejectSpokeUpdate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_RejectSpokeUpdate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).RejectSpokeUpdate(ctx, req.(*RejectSpokeUpdateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_DeleteSpoke_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSpokeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).DeleteSpoke(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_DeleteSpoke_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).DeleteSpoke(ctx, req.(*DeleteSpokeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_GetRouteTable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRouteTableRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).GetRouteTable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_GetRouteTable_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).GetRouteTable(ctx, req.(*GetRouteTableRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_GetRoute_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRouteRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).GetRoute(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_GetRoute_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).GetRoute(ctx, req.(*GetRouteRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_ListRoutes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRoutesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).ListRoutes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_ListRoutes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).ListRoutes(ctx, req.(*ListRoutesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_ListRouteTables_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRouteTablesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).ListRouteTables(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_ListRouteTables_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).ListRouteTables(ctx, req.(*ListRouteTablesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_GetGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).GetGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_GetGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).GetGroup(ctx, req.(*GetGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_ListGroups_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).ListGroups(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_ListGroups_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).ListGroups(ctx, req.(*ListGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HubService_UpdateGroup_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HubServiceServer).UpdateGroup(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HubService_UpdateGroup_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HubServiceServer).UpdateGroup(ctx, req.(*UpdateGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// HubService_ServiceDesc is the grpc.ServiceDesc for HubService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var HubService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.networkconnectivity.v1.HubService",
	HandlerType: (*HubServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListHubs",
			Handler:    _HubService_ListHubs_Handler,
		},
		{
			MethodName: "GetHub",
			Handler:    _HubService_GetHub_Handler,
		},
		{
			MethodName: "CreateHub",
			Handler:    _HubService_CreateHub_Handler,
		},
		{
			MethodName: "UpdateHub",
			Handler:    _HubService_UpdateHub_Handler,
		},
		{
			MethodName: "DeleteHub",
			Handler:    _HubService_DeleteHub_Handler,
		},
		{
			MethodName: "ListHubSpokes",
			Handler:    _HubService_ListHubSpokes_Handler,
		},
		{
			MethodName: "QueryHubStatus",
			Handler:    _HubService_QueryHubStatus_Handler,
		},
		{
			MethodName: "ListSpokes",
			Handler:    _HubService_ListSpokes_Handler,
		},
		{
			MethodName: "GetSpoke",
			Handler:    _HubService_GetSpoke_Handler,
		},
		{
			MethodName: "CreateSpoke",
			Handler:    _HubService_CreateSpoke_Handler,
		},
		{
			MethodName: "UpdateSpoke",
			Handler:    _HubService_UpdateSpoke_Handler,
		},
		{
			MethodName: "RejectHubSpoke",
			Handler:    _HubService_RejectHubSpoke_Handler,
		},
		{
			MethodName: "AcceptHubSpoke",
			Handler:    _HubService_AcceptHubSpoke_Handler,
		},
		{
			MethodName: "AcceptSpokeUpdate",
			Handler:    _HubService_AcceptSpokeUpdate_Handler,
		},
		{
			MethodName: "RejectSpokeUpdate",
			Handler:    _HubService_RejectSpokeUpdate_Handler,
		},
		{
			MethodName: "DeleteSpoke",
			Handler:    _HubService_DeleteSpoke_Handler,
		},
		{
			MethodName: "GetRouteTable",
			Handler:    _HubService_GetRouteTable_Handler,
		},
		{
			MethodName: "GetRoute",
			Handler:    _HubService_GetRoute_Handler,
		},
		{
			MethodName: "ListRoutes",
			Handler:    _HubService_ListRoutes_Handler,
		},
		{
			MethodName: "ListRouteTables",
			Handler:    _HubService_ListRouteTables_Handler,
		},
		{
			MethodName: "GetGroup",
			Handler:    _HubService_GetGroup_Handler,
		},
		{
			MethodName: "ListGroups",
			Handler:    _HubService_ListGroups_Handler,
		},
		{
			MethodName: "UpdateGroup",
			Handler:    _HubService_UpdateGroup_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/networkconnectivity/v1/hub.proto",
}
