// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/networkconnectivity/v1/cross_network_automation.proto

package networkconnectivitypb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	CrossNetworkAutomationService_ListServiceConnectionMaps_FullMethodName     = "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/ListServiceConnectionMaps"
	CrossNetworkAutomationService_GetServiceConnectionMap_FullMethodName       = "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/GetServiceConnectionMap"
	CrossNetworkAutomationService_CreateServiceConnectionMap_FullMethodName    = "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/CreateServiceConnectionMap"
	CrossNetworkAutomationService_UpdateServiceConnectionMap_FullMethodName    = "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/UpdateServiceConnectionMap"
	CrossNetworkAutomationService_DeleteServiceConnectionMap_FullMethodName    = "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/DeleteServiceConnectionMap"
	CrossNetworkAutomationService_ListServiceConnectionPolicies_FullMethodName = "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/ListServiceConnectionPolicies"
	CrossNetworkAutomationService_GetServiceConnectionPolicy_FullMethodName    = "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/GetServiceConnectionPolicy"
	CrossNetworkAutomationService_CreateServiceConnectionPolicy_FullMethodName = "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/CreateServiceConnectionPolicy"
	CrossNetworkAutomationService_UpdateServiceConnectionPolicy_FullMethodName = "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/UpdateServiceConnectionPolicy"
	CrossNetworkAutomationService_DeleteServiceConnectionPolicy_FullMethodName = "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/DeleteServiceConnectionPolicy"
	CrossNetworkAutomationService_ListServiceClasses_FullMethodName            = "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/ListServiceClasses"
	CrossNetworkAutomationService_GetServiceClass_FullMethodName               = "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/GetServiceClass"
	CrossNetworkAutomationService_UpdateServiceClass_FullMethodName            = "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/UpdateServiceClass"
	CrossNetworkAutomationService_DeleteServiceClass_FullMethodName            = "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/DeleteServiceClass"
	CrossNetworkAutomationService_GetServiceConnectionToken_FullMethodName     = "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/GetServiceConnectionToken"
	CrossNetworkAutomationService_ListServiceConnectionTokens_FullMethodName   = "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/ListServiceConnectionTokens"
	CrossNetworkAutomationService_CreateServiceConnectionToken_FullMethodName  = "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/CreateServiceConnectionToken"
	CrossNetworkAutomationService_DeleteServiceConnectionToken_FullMethodName  = "/google.cloud.networkconnectivity.v1.CrossNetworkAutomationService/DeleteServiceConnectionToken"
)

// CrossNetworkAutomationServiceClient is the client API for CrossNetworkAutomationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CrossNetworkAutomationServiceClient interface {
	// Lists ServiceConnectionMaps in a given project and location.
	ListServiceConnectionMaps(ctx context.Context, in *ListServiceConnectionMapsRequest, opts ...grpc.CallOption) (*ListServiceConnectionMapsResponse, error)
	// Gets details of a single ServiceConnectionMap.
	GetServiceConnectionMap(ctx context.Context, in *GetServiceConnectionMapRequest, opts ...grpc.CallOption) (*ServiceConnectionMap, error)
	// Creates a new ServiceConnectionMap in a given project and location.
	CreateServiceConnectionMap(ctx context.Context, in *CreateServiceConnectionMapRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single ServiceConnectionMap.
	UpdateServiceConnectionMap(ctx context.Context, in *UpdateServiceConnectionMapRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single ServiceConnectionMap.
	DeleteServiceConnectionMap(ctx context.Context, in *DeleteServiceConnectionMapRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists ServiceConnectionPolicies in a given project and location.
	ListServiceConnectionPolicies(ctx context.Context, in *ListServiceConnectionPoliciesRequest, opts ...grpc.CallOption) (*ListServiceConnectionPoliciesResponse, error)
	// Gets details of a single ServiceConnectionPolicy.
	GetServiceConnectionPolicy(ctx context.Context, in *GetServiceConnectionPolicyRequest, opts ...grpc.CallOption) (*ServiceConnectionPolicy, error)
	// Creates a new ServiceConnectionPolicy in a given project and location.
	CreateServiceConnectionPolicy(ctx context.Context, in *CreateServiceConnectionPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the parameters of a single ServiceConnectionPolicy.
	UpdateServiceConnectionPolicy(ctx context.Context, in *UpdateServiceConnectionPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single ServiceConnectionPolicy.
	DeleteServiceConnectionPolicy(ctx context.Context, in *DeleteServiceConnectionPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists ServiceClasses in a given project and location.
	ListServiceClasses(ctx context.Context, in *ListServiceClassesRequest, opts ...grpc.CallOption) (*ListServiceClassesResponse, error)
	// Gets details of a single ServiceClass.
	GetServiceClass(ctx context.Context, in *GetServiceClassRequest, opts ...grpc.CallOption) (*ServiceClass, error)
	// Updates the parameters of a single ServiceClass.
	UpdateServiceClass(ctx context.Context, in *UpdateServiceClassRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single ServiceClass.
	DeleteServiceClass(ctx context.Context, in *DeleteServiceClassRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Gets details of a single ServiceConnectionToken.
	GetServiceConnectionToken(ctx context.Context, in *GetServiceConnectionTokenRequest, opts ...grpc.CallOption) (*ServiceConnectionToken, error)
	// Lists ServiceConnectionTokens in a given project and location.
	ListServiceConnectionTokens(ctx context.Context, in *ListServiceConnectionTokensRequest, opts ...grpc.CallOption) (*ListServiceConnectionTokensResponse, error)
	// Creates a new ServiceConnectionToken in a given project and location.
	CreateServiceConnectionToken(ctx context.Context, in *CreateServiceConnectionTokenRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single ServiceConnectionToken.
	DeleteServiceConnectionToken(ctx context.Context, in *DeleteServiceConnectionTokenRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type crossNetworkAutomationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCrossNetworkAutomationServiceClient(cc grpc.ClientConnInterface) CrossNetworkAutomationServiceClient {
	return &crossNetworkAutomationServiceClient{cc}
}

func (c *crossNetworkAutomationServiceClient) ListServiceConnectionMaps(ctx context.Context, in *ListServiceConnectionMapsRequest, opts ...grpc.CallOption) (*ListServiceConnectionMapsResponse, error) {
	out := new(ListServiceConnectionMapsResponse)
	err := c.cc.Invoke(ctx, CrossNetworkAutomationService_ListServiceConnectionMaps_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) GetServiceConnectionMap(ctx context.Context, in *GetServiceConnectionMapRequest, opts ...grpc.CallOption) (*ServiceConnectionMap, error) {
	out := new(ServiceConnectionMap)
	err := c.cc.Invoke(ctx, CrossNetworkAutomationService_GetServiceConnectionMap_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) CreateServiceConnectionMap(ctx context.Context, in *CreateServiceConnectionMapRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CrossNetworkAutomationService_CreateServiceConnectionMap_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) UpdateServiceConnectionMap(ctx context.Context, in *UpdateServiceConnectionMapRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CrossNetworkAutomationService_UpdateServiceConnectionMap_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) DeleteServiceConnectionMap(ctx context.Context, in *DeleteServiceConnectionMapRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CrossNetworkAutomationService_DeleteServiceConnectionMap_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) ListServiceConnectionPolicies(ctx context.Context, in *ListServiceConnectionPoliciesRequest, opts ...grpc.CallOption) (*ListServiceConnectionPoliciesResponse, error) {
	out := new(ListServiceConnectionPoliciesResponse)
	err := c.cc.Invoke(ctx, CrossNetworkAutomationService_ListServiceConnectionPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) GetServiceConnectionPolicy(ctx context.Context, in *GetServiceConnectionPolicyRequest, opts ...grpc.CallOption) (*ServiceConnectionPolicy, error) {
	out := new(ServiceConnectionPolicy)
	err := c.cc.Invoke(ctx, CrossNetworkAutomationService_GetServiceConnectionPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) CreateServiceConnectionPolicy(ctx context.Context, in *CreateServiceConnectionPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CrossNetworkAutomationService_CreateServiceConnectionPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) UpdateServiceConnectionPolicy(ctx context.Context, in *UpdateServiceConnectionPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CrossNetworkAutomationService_UpdateServiceConnectionPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) DeleteServiceConnectionPolicy(ctx context.Context, in *DeleteServiceConnectionPolicyRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CrossNetworkAutomationService_DeleteServiceConnectionPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) ListServiceClasses(ctx context.Context, in *ListServiceClassesRequest, opts ...grpc.CallOption) (*ListServiceClassesResponse, error) {
	out := new(ListServiceClassesResponse)
	err := c.cc.Invoke(ctx, CrossNetworkAutomationService_ListServiceClasses_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) GetServiceClass(ctx context.Context, in *GetServiceClassRequest, opts ...grpc.CallOption) (*ServiceClass, error) {
	out := new(ServiceClass)
	err := c.cc.Invoke(ctx, CrossNetworkAutomationService_GetServiceClass_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) UpdateServiceClass(ctx context.Context, in *UpdateServiceClassRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CrossNetworkAutomationService_UpdateServiceClass_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) DeleteServiceClass(ctx context.Context, in *DeleteServiceClassRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CrossNetworkAutomationService_DeleteServiceClass_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) GetServiceConnectionToken(ctx context.Context, in *GetServiceConnectionTokenRequest, opts ...grpc.CallOption) (*ServiceConnectionToken, error) {
	out := new(ServiceConnectionToken)
	err := c.cc.Invoke(ctx, CrossNetworkAutomationService_GetServiceConnectionToken_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) ListServiceConnectionTokens(ctx context.Context, in *ListServiceConnectionTokensRequest, opts ...grpc.CallOption) (*ListServiceConnectionTokensResponse, error) {
	out := new(ListServiceConnectionTokensResponse)
	err := c.cc.Invoke(ctx, CrossNetworkAutomationService_ListServiceConnectionTokens_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) CreateServiceConnectionToken(ctx context.Context, in *CreateServiceConnectionTokenRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CrossNetworkAutomationService_CreateServiceConnectionToken_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossNetworkAutomationServiceClient) DeleteServiceConnectionToken(ctx context.Context, in *DeleteServiceConnectionTokenRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, CrossNetworkAutomationService_DeleteServiceConnectionToken_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CrossNetworkAutomationServiceServer is the server API for CrossNetworkAutomationService service.
// All implementations should embed UnimplementedCrossNetworkAutomationServiceServer
// for forward compatibility
type CrossNetworkAutomationServiceServer interface {
	// Lists ServiceConnectionMaps in a given project and location.
	ListServiceConnectionMaps(context.Context, *ListServiceConnectionMapsRequest) (*ListServiceConnectionMapsResponse, error)
	// Gets details of a single ServiceConnectionMap.
	GetServiceConnectionMap(context.Context, *GetServiceConnectionMapRequest) (*ServiceConnectionMap, error)
	// Creates a new ServiceConnectionMap in a given project and location.
	CreateServiceConnectionMap(context.Context, *CreateServiceConnectionMapRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single ServiceConnectionMap.
	UpdateServiceConnectionMap(context.Context, *UpdateServiceConnectionMapRequest) (*longrunningpb.Operation, error)
	// Deletes a single ServiceConnectionMap.
	DeleteServiceConnectionMap(context.Context, *DeleteServiceConnectionMapRequest) (*longrunningpb.Operation, error)
	// Lists ServiceConnectionPolicies in a given project and location.
	ListServiceConnectionPolicies(context.Context, *ListServiceConnectionPoliciesRequest) (*ListServiceConnectionPoliciesResponse, error)
	// Gets details of a single ServiceConnectionPolicy.
	GetServiceConnectionPolicy(context.Context, *GetServiceConnectionPolicyRequest) (*ServiceConnectionPolicy, error)
	// Creates a new ServiceConnectionPolicy in a given project and location.
	CreateServiceConnectionPolicy(context.Context, *CreateServiceConnectionPolicyRequest) (*longrunningpb.Operation, error)
	// Updates the parameters of a single ServiceConnectionPolicy.
	UpdateServiceConnectionPolicy(context.Context, *UpdateServiceConnectionPolicyRequest) (*longrunningpb.Operation, error)
	// Deletes a single ServiceConnectionPolicy.
	DeleteServiceConnectionPolicy(context.Context, *DeleteServiceConnectionPolicyRequest) (*longrunningpb.Operation, error)
	// Lists ServiceClasses in a given project and location.
	ListServiceClasses(context.Context, *ListServiceClassesRequest) (*ListServiceClassesResponse, error)
	// Gets details of a single ServiceClass.
	GetServiceClass(context.Context, *GetServiceClassRequest) (*ServiceClass, error)
	// Updates the parameters of a single ServiceClass.
	UpdateServiceClass(context.Context, *UpdateServiceClassRequest) (*longrunningpb.Operation, error)
	// Deletes a single ServiceClass.
	DeleteServiceClass(context.Context, *DeleteServiceClassRequest) (*longrunningpb.Operation, error)
	// Gets details of a single ServiceConnectionToken.
	GetServiceConnectionToken(context.Context, *GetServiceConnectionTokenRequest) (*ServiceConnectionToken, error)
	// Lists ServiceConnectionTokens in a given project and location.
	ListServiceConnectionTokens(context.Context, *ListServiceConnectionTokensRequest) (*ListServiceConnectionTokensResponse, error)
	// Creates a new ServiceConnectionToken in a given project and location.
	CreateServiceConnectionToken(context.Context, *CreateServiceConnectionTokenRequest) (*longrunningpb.Operation, error)
	// Deletes a single ServiceConnectionToken.
	DeleteServiceConnectionToken(context.Context, *DeleteServiceConnectionTokenRequest) (*longrunningpb.Operation, error)
}

// UnimplementedCrossNetworkAutomationServiceServer should be embedded to have forward compatible implementations.
type UnimplementedCrossNetworkAutomationServiceServer struct {
}

func (UnimplementedCrossNetworkAutomationServiceServer) ListServiceConnectionMaps(context.Context, *ListServiceConnectionMapsRequest) (*ListServiceConnectionMapsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServiceConnectionMaps not implemented")
}
func (UnimplementedCrossNetworkAutomationServiceServer) GetServiceConnectionMap(context.Context, *GetServiceConnectionMapRequest) (*ServiceConnectionMap, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServiceConnectionMap not implemented")
}
func (UnimplementedCrossNetworkAutomationServiceServer) CreateServiceConnectionMap(context.Context, *CreateServiceConnectionMapRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateServiceConnectionMap not implemented")
}
func (UnimplementedCrossNetworkAutomationServiceServer) UpdateServiceConnectionMap(context.Context, *UpdateServiceConnectionMapRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateServiceConnectionMap not implemented")
}
func (UnimplementedCrossNetworkAutomationServiceServer) DeleteServiceConnectionMap(context.Context, *DeleteServiceConnectionMapRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteServiceConnectionMap not implemented")
}
func (UnimplementedCrossNetworkAutomationServiceServer) ListServiceConnectionPolicies(context.Context, *ListServiceConnectionPoliciesRequest) (*ListServiceConnectionPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServiceConnectionPolicies not implemented")
}
func (UnimplementedCrossNetworkAutomationServiceServer) GetServiceConnectionPolicy(context.Context, *GetServiceConnectionPolicyRequest) (*ServiceConnectionPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServiceConnectionPolicy not implemented")
}
func (UnimplementedCrossNetworkAutomationServiceServer) CreateServiceConnectionPolicy(context.Context, *CreateServiceConnectionPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateServiceConnectionPolicy not implemented")
}
func (UnimplementedCrossNetworkAutomationServiceServer) UpdateServiceConnectionPolicy(context.Context, *UpdateServiceConnectionPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateServiceConnectionPolicy not implemented")
}
func (UnimplementedCrossNetworkAutomationServiceServer) DeleteServiceConnectionPolicy(context.Context, *DeleteServiceConnectionPolicyRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteServiceConnectionPolicy not implemented")
}
func (UnimplementedCrossNetworkAutomationServiceServer) ListServiceClasses(context.Context, *ListServiceClassesRequest) (*ListServiceClassesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServiceClasses not implemented")
}
func (UnimplementedCrossNetworkAutomationServiceServer) GetServiceClass(context.Context, *GetServiceClassRequest) (*ServiceClass, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServiceClass not implemented")
}
func (UnimplementedCrossNetworkAutomationServiceServer) UpdateServiceClass(context.Context, *UpdateServiceClassRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateServiceClass not implemented")
}
func (UnimplementedCrossNetworkAutomationServiceServer) DeleteServiceClass(context.Context, *DeleteServiceClassRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteServiceClass not implemented")
}
func (UnimplementedCrossNetworkAutomationServiceServer) GetServiceConnectionToken(context.Context, *GetServiceConnectionTokenRequest) (*ServiceConnectionToken, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetServiceConnectionToken not implemented")
}
func (UnimplementedCrossNetworkAutomationServiceServer) ListServiceConnectionTokens(context.Context, *ListServiceConnectionTokensRequest) (*ListServiceConnectionTokensResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListServiceConnectionTokens not implemented")
}
func (UnimplementedCrossNetworkAutomationServiceServer) CreateServiceConnectionToken(context.Context, *CreateServiceConnectionTokenRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateServiceConnectionToken not implemented")
}
func (UnimplementedCrossNetworkAutomationServiceServer) DeleteServiceConnectionToken(context.Context, *DeleteServiceConnectionTokenRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteServiceConnectionToken not implemented")
}

// UnsafeCrossNetworkAutomationServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CrossNetworkAutomationServiceServer will
// result in compilation errors.
type UnsafeCrossNetworkAutomationServiceServer interface {
	mustEmbedUnimplementedCrossNetworkAutomationServiceServer()
}

func RegisterCrossNetworkAutomationServiceServer(s grpc.ServiceRegistrar, srv CrossNetworkAutomationServiceServer) {
	s.RegisterService(&CrossNetworkAutomationService_ServiceDesc, srv)
}

func _CrossNetworkAutomationService_ListServiceConnectionMaps_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceConnectionMapsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).ListServiceConnectionMaps(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CrossNetworkAutomationService_ListServiceConnectionMaps_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).ListServiceConnectionMaps(ctx, req.(*ListServiceConnectionMapsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_GetServiceConnectionMap_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceConnectionMapRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).GetServiceConnectionMap(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CrossNetworkAutomationService_GetServiceConnectionMap_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).GetServiceConnectionMap(ctx, req.(*GetServiceConnectionMapRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_CreateServiceConnectionMap_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceConnectionMapRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).CreateServiceConnectionMap(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CrossNetworkAutomationService_CreateServiceConnectionMap_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).CreateServiceConnectionMap(ctx, req.(*CreateServiceConnectionMapRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_UpdateServiceConnectionMap_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServiceConnectionMapRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).UpdateServiceConnectionMap(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CrossNetworkAutomationService_UpdateServiceConnectionMap_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).UpdateServiceConnectionMap(ctx, req.(*UpdateServiceConnectionMapRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_DeleteServiceConnectionMap_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceConnectionMapRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).DeleteServiceConnectionMap(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CrossNetworkAutomationService_DeleteServiceConnectionMap_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).DeleteServiceConnectionMap(ctx, req.(*DeleteServiceConnectionMapRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_ListServiceConnectionPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceConnectionPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).ListServiceConnectionPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CrossNetworkAutomationService_ListServiceConnectionPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).ListServiceConnectionPolicies(ctx, req.(*ListServiceConnectionPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_GetServiceConnectionPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceConnectionPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).GetServiceConnectionPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CrossNetworkAutomationService_GetServiceConnectionPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).GetServiceConnectionPolicy(ctx, req.(*GetServiceConnectionPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_CreateServiceConnectionPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceConnectionPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).CreateServiceConnectionPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CrossNetworkAutomationService_CreateServiceConnectionPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).CreateServiceConnectionPolicy(ctx, req.(*CreateServiceConnectionPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_UpdateServiceConnectionPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServiceConnectionPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).UpdateServiceConnectionPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CrossNetworkAutomationService_UpdateServiceConnectionPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).UpdateServiceConnectionPolicy(ctx, req.(*UpdateServiceConnectionPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_DeleteServiceConnectionPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceConnectionPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).DeleteServiceConnectionPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CrossNetworkAutomationService_DeleteServiceConnectionPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).DeleteServiceConnectionPolicy(ctx, req.(*DeleteServiceConnectionPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_ListServiceClasses_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceClassesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).ListServiceClasses(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CrossNetworkAutomationService_ListServiceClasses_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).ListServiceClasses(ctx, req.(*ListServiceClassesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_GetServiceClass_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceClassRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).GetServiceClass(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CrossNetworkAutomationService_GetServiceClass_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).GetServiceClass(ctx, req.(*GetServiceClassRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_UpdateServiceClass_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateServiceClassRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).UpdateServiceClass(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CrossNetworkAutomationService_UpdateServiceClass_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).UpdateServiceClass(ctx, req.(*UpdateServiceClassRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_DeleteServiceClass_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceClassRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).DeleteServiceClass(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CrossNetworkAutomationService_DeleteServiceClass_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).DeleteServiceClass(ctx, req.(*DeleteServiceClassRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_GetServiceConnectionToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetServiceConnectionTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).GetServiceConnectionToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CrossNetworkAutomationService_GetServiceConnectionToken_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).GetServiceConnectionToken(ctx, req.(*GetServiceConnectionTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_ListServiceConnectionTokens_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListServiceConnectionTokensRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).ListServiceConnectionTokens(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CrossNetworkAutomationService_ListServiceConnectionTokens_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).ListServiceConnectionTokens(ctx, req.(*ListServiceConnectionTokensRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_CreateServiceConnectionToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateServiceConnectionTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).CreateServiceConnectionToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CrossNetworkAutomationService_CreateServiceConnectionToken_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).CreateServiceConnectionToken(ctx, req.(*CreateServiceConnectionTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossNetworkAutomationService_DeleteServiceConnectionToken_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteServiceConnectionTokenRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossNetworkAutomationServiceServer).DeleteServiceConnectionToken(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CrossNetworkAutomationService_DeleteServiceConnectionToken_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossNetworkAutomationServiceServer).DeleteServiceConnectionToken(ctx, req.(*DeleteServiceConnectionTokenRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CrossNetworkAutomationService_ServiceDesc is the grpc.ServiceDesc for CrossNetworkAutomationService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CrossNetworkAutomationService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.networkconnectivity.v1.CrossNetworkAutomationService",
	HandlerType: (*CrossNetworkAutomationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListServiceConnectionMaps",
			Handler:    _CrossNetworkAutomationService_ListServiceConnectionMaps_Handler,
		},
		{
			MethodName: "GetServiceConnectionMap",
			Handler:    _CrossNetworkAutomationService_GetServiceConnectionMap_Handler,
		},
		{
			MethodName: "CreateServiceConnectionMap",
			Handler:    _CrossNetworkAutomationService_CreateServiceConnectionMap_Handler,
		},
		{
			MethodName: "UpdateServiceConnectionMap",
			Handler:    _CrossNetworkAutomationService_UpdateServiceConnectionMap_Handler,
		},
		{
			MethodName: "DeleteServiceConnectionMap",
			Handler:    _CrossNetworkAutomationService_DeleteServiceConnectionMap_Handler,
		},
		{
			MethodName: "ListServiceConnectionPolicies",
			Handler:    _CrossNetworkAutomationService_ListServiceConnectionPolicies_Handler,
		},
		{
			MethodName: "GetServiceConnectionPolicy",
			Handler:    _CrossNetworkAutomationService_GetServiceConnectionPolicy_Handler,
		},
		{
			MethodName: "CreateServiceConnectionPolicy",
			Handler:    _CrossNetworkAutomationService_CreateServiceConnectionPolicy_Handler,
		},
		{
			MethodName: "UpdateServiceConnectionPolicy",
			Handler:    _CrossNetworkAutomationService_UpdateServiceConnectionPolicy_Handler,
		},
		{
			MethodName: "DeleteServiceConnectionPolicy",
			Handler:    _CrossNetworkAutomationService_DeleteServiceConnectionPolicy_Handler,
		},
		{
			MethodName: "ListServiceClasses",
			Handler:    _CrossNetworkAutomationService_ListServiceClasses_Handler,
		},
		{
			MethodName: "GetServiceClass",
			Handler:    _CrossNetworkAutomationService_GetServiceClass_Handler,
		},
		{
			MethodName: "UpdateServiceClass",
			Handler:    _CrossNetworkAutomationService_UpdateServiceClass_Handler,
		},
		{
			MethodName: "DeleteServiceClass",
			Handler:    _CrossNetworkAutomationService_DeleteServiceClass_Handler,
		},
		{
			MethodName: "GetServiceConnectionToken",
			Handler:    _CrossNetworkAutomationService_GetServiceConnectionToken_Handler,
		},
		{
			MethodName: "ListServiceConnectionTokens",
			Handler:    _CrossNetworkAutomationService_ListServiceConnectionTokens_Handler,
		},
		{
			MethodName: "CreateServiceConnectionToken",
			Handler:    _CrossNetworkAutomationService_CreateServiceConnectionToken_Handler,
		},
		{
			MethodName: "DeleteServiceConnectionToken",
			Handler:    _CrossNetworkAutomationService_DeleteServiceConnectionToken_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/networkconnectivity/v1/cross_network_automation.proto",
}
