/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	v1 "sigs.k8s.io/gateway-api/apis/v1"
)

// GatewayClassSpecApplyConfiguration represents an declarative configuration of the GatewayClassSpec type for use
// with apply.
type GatewayClassSpecApplyConfiguration struct {
	ControllerName *v1.GatewayController                  `json:"controllerName,omitempty"`
	ParametersRef  *ParametersReferenceApplyConfiguration `json:"parametersRef,omitempty"`
	Description    *string                                `json:"description,omitempty"`
}

// GatewayClassSpecApplyConfiguration constructs an declarative configuration of the GatewayClassSpec type for use with
// apply.
func GatewayClassSpec() *GatewayClassSpecApplyConfiguration {
	return &GatewayClassSpecApplyConfiguration{}
}

// WithControllerName sets the ControllerName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ControllerName field is set to the value of the last call.
func (b *GatewayClassSpecApplyConfiguration) WithControllerName(value v1.GatewayController) *GatewayClassSpecApplyConfiguration {
	b.ControllerName = &value
	return b
}

// WithParametersRef sets the ParametersRef field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ParametersRef field is set to the value of the last call.
func (b *GatewayClassSpecApplyConfiguration) WithParametersRef(value *ParametersReferenceApplyConfiguration) *GatewayClassSpecApplyConfiguration {
	b.ParametersRef = value
	return b
}

// WithDescription sets the Description field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Description field is set to the value of the last call.
func (b *GatewayClassSpecApplyConfiguration) WithDescription(value string) *GatewayClassSpecApplyConfiguration {
	b.Description = &value
	return b
}
