// Code generated by smithy-go-codegen DO NOT EDIT.

package elasticloadbalancingv2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/elasticloadbalancingv2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes the revocation files in use by the specified trust store or
// revocation files.
func (c *Client) DescribeTrustStoreRevocations(ctx context.Context, params *DescribeTrustStoreRevocationsInput, optFns ...func(*Options)) (*DescribeTrustStoreRevocationsOutput, error) {
	if params == nil {
		params = &DescribeTrustStoreRevocationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeTrustStoreRevocations", params, optFns, c.addOperationDescribeTrustStoreRevocationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeTrustStoreRevocationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeTrustStoreRevocationsInput struct {

	// The Amazon Resource Name (ARN) of the trust store.
	//
	// This member is required.
	TrustStoreArn *string

	// The marker for the next set of results. (You received this marker from a
	// previous call.)
	Marker *string

	// The maximum number of results to return with this call.
	PageSize *int32

	// The revocation IDs of the revocation files you want to describe.
	RevocationIds []int64

	noSmithyDocumentSerde
}

type DescribeTrustStoreRevocationsOutput struct {

	// If there are additional results, this is the marker for the next set of
	// results. Otherwise, this is null.
	NextMarker *string

	// Information about the revocation file in the trust store.
	TrustStoreRevocations []types.DescribeTrustStoreRevocation

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeTrustStoreRevocationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpDescribeTrustStoreRevocations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpDescribeTrustStoreRevocations{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeTrustStoreRevocations"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeTrustStoreRevocationsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeTrustStoreRevocations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeTrustStoreRevocationsPaginatorOptions is the paginator options for
// DescribeTrustStoreRevocations
type DescribeTrustStoreRevocationsPaginatorOptions struct {
	// The maximum number of results to return with this call.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeTrustStoreRevocationsPaginator is a paginator for
// DescribeTrustStoreRevocations
type DescribeTrustStoreRevocationsPaginator struct {
	options   DescribeTrustStoreRevocationsPaginatorOptions
	client    DescribeTrustStoreRevocationsAPIClient
	params    *DescribeTrustStoreRevocationsInput
	nextToken *string
	firstPage bool
}

// NewDescribeTrustStoreRevocationsPaginator returns a new
// DescribeTrustStoreRevocationsPaginator
func NewDescribeTrustStoreRevocationsPaginator(client DescribeTrustStoreRevocationsAPIClient, params *DescribeTrustStoreRevocationsInput, optFns ...func(*DescribeTrustStoreRevocationsPaginatorOptions)) *DescribeTrustStoreRevocationsPaginator {
	if params == nil {
		params = &DescribeTrustStoreRevocationsInput{}
	}

	options := DescribeTrustStoreRevocationsPaginatorOptions{}
	if params.PageSize != nil {
		options.Limit = *params.PageSize
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeTrustStoreRevocationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeTrustStoreRevocationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeTrustStoreRevocations page.
func (p *DescribeTrustStoreRevocationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeTrustStoreRevocationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.PageSize = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeTrustStoreRevocations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextMarker

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeTrustStoreRevocationsAPIClient is a client that implements the
// DescribeTrustStoreRevocations operation.
type DescribeTrustStoreRevocationsAPIClient interface {
	DescribeTrustStoreRevocations(context.Context, *DescribeTrustStoreRevocationsInput, ...func(*Options)) (*DescribeTrustStoreRevocationsOutput, error)
}

var _ DescribeTrustStoreRevocationsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeTrustStoreRevocations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeTrustStoreRevocations",
	}
}
