// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/devtools/artifactregistry/v1beta2/service.proto

package artifactregistrypb

import (
	context "context"

	iampb "cloud.google.com/go/iam/apiv1/iampb"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ArtifactRegistry_ImportAptArtifacts_FullMethodName    = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/ImportAptArtifacts"
	ArtifactRegistry_ImportYumArtifacts_FullMethodName    = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/ImportYumArtifacts"
	ArtifactRegistry_ListRepositories_FullMethodName      = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/ListRepositories"
	ArtifactRegistry_GetRepository_FullMethodName         = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/GetRepository"
	ArtifactRegistry_CreateRepository_FullMethodName      = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/CreateRepository"
	ArtifactRegistry_UpdateRepository_FullMethodName      = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/UpdateRepository"
	ArtifactRegistry_DeleteRepository_FullMethodName      = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/DeleteRepository"
	ArtifactRegistry_ListPackages_FullMethodName          = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/ListPackages"
	ArtifactRegistry_GetPackage_FullMethodName            = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/GetPackage"
	ArtifactRegistry_DeletePackage_FullMethodName         = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/DeletePackage"
	ArtifactRegistry_ListVersions_FullMethodName          = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/ListVersions"
	ArtifactRegistry_GetVersion_FullMethodName            = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/GetVersion"
	ArtifactRegistry_DeleteVersion_FullMethodName         = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/DeleteVersion"
	ArtifactRegistry_ListFiles_FullMethodName             = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/ListFiles"
	ArtifactRegistry_GetFile_FullMethodName               = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/GetFile"
	ArtifactRegistry_ListTags_FullMethodName              = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/ListTags"
	ArtifactRegistry_GetTag_FullMethodName                = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/GetTag"
	ArtifactRegistry_CreateTag_FullMethodName             = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/CreateTag"
	ArtifactRegistry_UpdateTag_FullMethodName             = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/UpdateTag"
	ArtifactRegistry_DeleteTag_FullMethodName             = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/DeleteTag"
	ArtifactRegistry_SetIamPolicy_FullMethodName          = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/SetIamPolicy"
	ArtifactRegistry_GetIamPolicy_FullMethodName          = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/GetIamPolicy"
	ArtifactRegistry_TestIamPermissions_FullMethodName    = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/TestIamPermissions"
	ArtifactRegistry_GetProjectSettings_FullMethodName    = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/GetProjectSettings"
	ArtifactRegistry_UpdateProjectSettings_FullMethodName = "/google.devtools.artifactregistry.v1beta2.ArtifactRegistry/UpdateProjectSettings"
)

// ArtifactRegistryClient is the client API for ArtifactRegistry service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ArtifactRegistryClient interface {
	// Imports Apt artifacts. The returned Operation will complete once the
	// resources are imported. Package, Version, and File resources are created
	// based on the imported artifacts. Imported artifacts that conflict with
	// existing resources are ignored.
	ImportAptArtifacts(ctx context.Context, in *ImportAptArtifactsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Imports Yum (RPM) artifacts. The returned Operation will complete once the
	// resources are imported. Package, Version, and File resources are created
	// based on the imported artifacts. Imported artifacts that conflict with
	// existing resources are ignored.
	ImportYumArtifacts(ctx context.Context, in *ImportYumArtifactsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists repositories.
	ListRepositories(ctx context.Context, in *ListRepositoriesRequest, opts ...grpc.CallOption) (*ListRepositoriesResponse, error)
	// Gets a repository.
	GetRepository(ctx context.Context, in *GetRepositoryRequest, opts ...grpc.CallOption) (*Repository, error)
	// Creates a repository. The returned Operation will finish once the
	// repository has been created. Its response will be the created Repository.
	CreateRepository(ctx context.Context, in *CreateRepositoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates a repository.
	UpdateRepository(ctx context.Context, in *UpdateRepositoryRequest, opts ...grpc.CallOption) (*Repository, error)
	// Deletes a repository and all of its contents. The returned Operation will
	// finish once the repository has been deleted. It will not have any Operation
	// metadata and will return a google.protobuf.Empty response.
	DeleteRepository(ctx context.Context, in *DeleteRepositoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists packages.
	ListPackages(ctx context.Context, in *ListPackagesRequest, opts ...grpc.CallOption) (*ListPackagesResponse, error)
	// Gets a package.
	GetPackage(ctx context.Context, in *GetPackageRequest, opts ...grpc.CallOption) (*Package, error)
	// Deletes a package and all of its versions and tags. The returned operation
	// will complete once the package has been deleted.
	DeletePackage(ctx context.Context, in *DeletePackageRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists versions.
	ListVersions(ctx context.Context, in *ListVersionsRequest, opts ...grpc.CallOption) (*ListVersionsResponse, error)
	// Gets a version
	GetVersion(ctx context.Context, in *GetVersionRequest, opts ...grpc.CallOption) (*Version, error)
	// Deletes a version and all of its content. The returned operation will
	// complete once the version has been deleted.
	DeleteVersion(ctx context.Context, in *DeleteVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists files.
	ListFiles(ctx context.Context, in *ListFilesRequest, opts ...grpc.CallOption) (*ListFilesResponse, error)
	// Gets a file.
	GetFile(ctx context.Context, in *GetFileRequest, opts ...grpc.CallOption) (*File, error)
	// Lists tags.
	ListTags(ctx context.Context, in *ListTagsRequest, opts ...grpc.CallOption) (*ListTagsResponse, error)
	// Gets a tag.
	GetTag(ctx context.Context, in *GetTagRequest, opts ...grpc.CallOption) (*Tag, error)
	// Creates a tag.
	CreateTag(ctx context.Context, in *CreateTagRequest, opts ...grpc.CallOption) (*Tag, error)
	// Updates a tag.
	UpdateTag(ctx context.Context, in *UpdateTagRequest, opts ...grpc.CallOption) (*Tag, error)
	// Deletes a tag.
	DeleteTag(ctx context.Context, in *DeleteTagRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates the IAM policy for a given resource.
	SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Gets the IAM policy for a given resource.
	GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error)
	// Tests if the caller has a list of permissions on a resource.
	TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error)
	// Retrieves the Settings for the Project.
	GetProjectSettings(ctx context.Context, in *GetProjectSettingsRequest, opts ...grpc.CallOption) (*ProjectSettings, error)
	// Updates the Settings for the Project.
	UpdateProjectSettings(ctx context.Context, in *UpdateProjectSettingsRequest, opts ...grpc.CallOption) (*ProjectSettings, error)
}

type artifactRegistryClient struct {
	cc grpc.ClientConnInterface
}

func NewArtifactRegistryClient(cc grpc.ClientConnInterface) ArtifactRegistryClient {
	return &artifactRegistryClient{cc}
}

func (c *artifactRegistryClient) ImportAptArtifacts(ctx context.Context, in *ImportAptArtifactsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ArtifactRegistry_ImportAptArtifacts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) ImportYumArtifacts(ctx context.Context, in *ImportYumArtifactsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ArtifactRegistry_ImportYumArtifacts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) ListRepositories(ctx context.Context, in *ListRepositoriesRequest, opts ...grpc.CallOption) (*ListRepositoriesResponse, error) {
	out := new(ListRepositoriesResponse)
	err := c.cc.Invoke(ctx, ArtifactRegistry_ListRepositories_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) GetRepository(ctx context.Context, in *GetRepositoryRequest, opts ...grpc.CallOption) (*Repository, error) {
	out := new(Repository)
	err := c.cc.Invoke(ctx, ArtifactRegistry_GetRepository_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) CreateRepository(ctx context.Context, in *CreateRepositoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ArtifactRegistry_CreateRepository_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) UpdateRepository(ctx context.Context, in *UpdateRepositoryRequest, opts ...grpc.CallOption) (*Repository, error) {
	out := new(Repository)
	err := c.cc.Invoke(ctx, ArtifactRegistry_UpdateRepository_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) DeleteRepository(ctx context.Context, in *DeleteRepositoryRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ArtifactRegistry_DeleteRepository_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) ListPackages(ctx context.Context, in *ListPackagesRequest, opts ...grpc.CallOption) (*ListPackagesResponse, error) {
	out := new(ListPackagesResponse)
	err := c.cc.Invoke(ctx, ArtifactRegistry_ListPackages_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) GetPackage(ctx context.Context, in *GetPackageRequest, opts ...grpc.CallOption) (*Package, error) {
	out := new(Package)
	err := c.cc.Invoke(ctx, ArtifactRegistry_GetPackage_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) DeletePackage(ctx context.Context, in *DeletePackageRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ArtifactRegistry_DeletePackage_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) ListVersions(ctx context.Context, in *ListVersionsRequest, opts ...grpc.CallOption) (*ListVersionsResponse, error) {
	out := new(ListVersionsResponse)
	err := c.cc.Invoke(ctx, ArtifactRegistry_ListVersions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) GetVersion(ctx context.Context, in *GetVersionRequest, opts ...grpc.CallOption) (*Version, error) {
	out := new(Version)
	err := c.cc.Invoke(ctx, ArtifactRegistry_GetVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) DeleteVersion(ctx context.Context, in *DeleteVersionRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, ArtifactRegistry_DeleteVersion_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) ListFiles(ctx context.Context, in *ListFilesRequest, opts ...grpc.CallOption) (*ListFilesResponse, error) {
	out := new(ListFilesResponse)
	err := c.cc.Invoke(ctx, ArtifactRegistry_ListFiles_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) GetFile(ctx context.Context, in *GetFileRequest, opts ...grpc.CallOption) (*File, error) {
	out := new(File)
	err := c.cc.Invoke(ctx, ArtifactRegistry_GetFile_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) ListTags(ctx context.Context, in *ListTagsRequest, opts ...grpc.CallOption) (*ListTagsResponse, error) {
	out := new(ListTagsResponse)
	err := c.cc.Invoke(ctx, ArtifactRegistry_ListTags_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) GetTag(ctx context.Context, in *GetTagRequest, opts ...grpc.CallOption) (*Tag, error) {
	out := new(Tag)
	err := c.cc.Invoke(ctx, ArtifactRegistry_GetTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) CreateTag(ctx context.Context, in *CreateTagRequest, opts ...grpc.CallOption) (*Tag, error) {
	out := new(Tag)
	err := c.cc.Invoke(ctx, ArtifactRegistry_CreateTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) UpdateTag(ctx context.Context, in *UpdateTagRequest, opts ...grpc.CallOption) (*Tag, error) {
	out := new(Tag)
	err := c.cc.Invoke(ctx, ArtifactRegistry_UpdateTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) DeleteTag(ctx context.Context, in *DeleteTagRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ArtifactRegistry_DeleteTag_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) SetIamPolicy(ctx context.Context, in *iampb.SetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, ArtifactRegistry_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) GetIamPolicy(ctx context.Context, in *iampb.GetIamPolicyRequest, opts ...grpc.CallOption) (*iampb.Policy, error) {
	out := new(iampb.Policy)
	err := c.cc.Invoke(ctx, ArtifactRegistry_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) TestIamPermissions(ctx context.Context, in *iampb.TestIamPermissionsRequest, opts ...grpc.CallOption) (*iampb.TestIamPermissionsResponse, error) {
	out := new(iampb.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, ArtifactRegistry_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) GetProjectSettings(ctx context.Context, in *GetProjectSettingsRequest, opts ...grpc.CallOption) (*ProjectSettings, error) {
	out := new(ProjectSettings)
	err := c.cc.Invoke(ctx, ArtifactRegistry_GetProjectSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *artifactRegistryClient) UpdateProjectSettings(ctx context.Context, in *UpdateProjectSettingsRequest, opts ...grpc.CallOption) (*ProjectSettings, error) {
	out := new(ProjectSettings)
	err := c.cc.Invoke(ctx, ArtifactRegistry_UpdateProjectSettings_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ArtifactRegistryServer is the server API for ArtifactRegistry service.
// All implementations should embed UnimplementedArtifactRegistryServer
// for forward compatibility
type ArtifactRegistryServer interface {
	// Imports Apt artifacts. The returned Operation will complete once the
	// resources are imported. Package, Version, and File resources are created
	// based on the imported artifacts. Imported artifacts that conflict with
	// existing resources are ignored.
	ImportAptArtifacts(context.Context, *ImportAptArtifactsRequest) (*longrunningpb.Operation, error)
	// Imports Yum (RPM) artifacts. The returned Operation will complete once the
	// resources are imported. Package, Version, and File resources are created
	// based on the imported artifacts. Imported artifacts that conflict with
	// existing resources are ignored.
	ImportYumArtifacts(context.Context, *ImportYumArtifactsRequest) (*longrunningpb.Operation, error)
	// Lists repositories.
	ListRepositories(context.Context, *ListRepositoriesRequest) (*ListRepositoriesResponse, error)
	// Gets a repository.
	GetRepository(context.Context, *GetRepositoryRequest) (*Repository, error)
	// Creates a repository. The returned Operation will finish once the
	// repository has been created. Its response will be the created Repository.
	CreateRepository(context.Context, *CreateRepositoryRequest) (*longrunningpb.Operation, error)
	// Updates a repository.
	UpdateRepository(context.Context, *UpdateRepositoryRequest) (*Repository, error)
	// Deletes a repository and all of its contents. The returned Operation will
	// finish once the repository has been deleted. It will not have any Operation
	// metadata and will return a google.protobuf.Empty response.
	DeleteRepository(context.Context, *DeleteRepositoryRequest) (*longrunningpb.Operation, error)
	// Lists packages.
	ListPackages(context.Context, *ListPackagesRequest) (*ListPackagesResponse, error)
	// Gets a package.
	GetPackage(context.Context, *GetPackageRequest) (*Package, error)
	// Deletes a package and all of its versions and tags. The returned operation
	// will complete once the package has been deleted.
	DeletePackage(context.Context, *DeletePackageRequest) (*longrunningpb.Operation, error)
	// Lists versions.
	ListVersions(context.Context, *ListVersionsRequest) (*ListVersionsResponse, error)
	// Gets a version
	GetVersion(context.Context, *GetVersionRequest) (*Version, error)
	// Deletes a version and all of its content. The returned operation will
	// complete once the version has been deleted.
	DeleteVersion(context.Context, *DeleteVersionRequest) (*longrunningpb.Operation, error)
	// Lists files.
	ListFiles(context.Context, *ListFilesRequest) (*ListFilesResponse, error)
	// Gets a file.
	GetFile(context.Context, *GetFileRequest) (*File, error)
	// Lists tags.
	ListTags(context.Context, *ListTagsRequest) (*ListTagsResponse, error)
	// Gets a tag.
	GetTag(context.Context, *GetTagRequest) (*Tag, error)
	// Creates a tag.
	CreateTag(context.Context, *CreateTagRequest) (*Tag, error)
	// Updates a tag.
	UpdateTag(context.Context, *UpdateTagRequest) (*Tag, error)
	// Deletes a tag.
	DeleteTag(context.Context, *DeleteTagRequest) (*emptypb.Empty, error)
	// Updates the IAM policy for a given resource.
	SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error)
	// Gets the IAM policy for a given resource.
	GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error)
	// Tests if the caller has a list of permissions on a resource.
	TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error)
	// Retrieves the Settings for the Project.
	GetProjectSettings(context.Context, *GetProjectSettingsRequest) (*ProjectSettings, error)
	// Updates the Settings for the Project.
	UpdateProjectSettings(context.Context, *UpdateProjectSettingsRequest) (*ProjectSettings, error)
}

// UnimplementedArtifactRegistryServer should be embedded to have forward compatible implementations.
type UnimplementedArtifactRegistryServer struct {
}

func (UnimplementedArtifactRegistryServer) ImportAptArtifacts(context.Context, *ImportAptArtifactsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportAptArtifacts not implemented")
}
func (UnimplementedArtifactRegistryServer) ImportYumArtifacts(context.Context, *ImportYumArtifactsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportYumArtifacts not implemented")
}
func (UnimplementedArtifactRegistryServer) ListRepositories(context.Context, *ListRepositoriesRequest) (*ListRepositoriesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListRepositories not implemented")
}
func (UnimplementedArtifactRegistryServer) GetRepository(context.Context, *GetRepositoryRequest) (*Repository, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRepository not implemented")
}
func (UnimplementedArtifactRegistryServer) CreateRepository(context.Context, *CreateRepositoryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateRepository not implemented")
}
func (UnimplementedArtifactRegistryServer) UpdateRepository(context.Context, *UpdateRepositoryRequest) (*Repository, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateRepository not implemented")
}
func (UnimplementedArtifactRegistryServer) DeleteRepository(context.Context, *DeleteRepositoryRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteRepository not implemented")
}
func (UnimplementedArtifactRegistryServer) ListPackages(context.Context, *ListPackagesRequest) (*ListPackagesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPackages not implemented")
}
func (UnimplementedArtifactRegistryServer) GetPackage(context.Context, *GetPackageRequest) (*Package, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPackage not implemented")
}
func (UnimplementedArtifactRegistryServer) DeletePackage(context.Context, *DeletePackageRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePackage not implemented")
}
func (UnimplementedArtifactRegistryServer) ListVersions(context.Context, *ListVersionsRequest) (*ListVersionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListVersions not implemented")
}
func (UnimplementedArtifactRegistryServer) GetVersion(context.Context, *GetVersionRequest) (*Version, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVersion not implemented")
}
func (UnimplementedArtifactRegistryServer) DeleteVersion(context.Context, *DeleteVersionRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteVersion not implemented")
}
func (UnimplementedArtifactRegistryServer) ListFiles(context.Context, *ListFilesRequest) (*ListFilesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListFiles not implemented")
}
func (UnimplementedArtifactRegistryServer) GetFile(context.Context, *GetFileRequest) (*File, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFile not implemented")
}
func (UnimplementedArtifactRegistryServer) ListTags(context.Context, *ListTagsRequest) (*ListTagsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListTags not implemented")
}
func (UnimplementedArtifactRegistryServer) GetTag(context.Context, *GetTagRequest) (*Tag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetTag not implemented")
}
func (UnimplementedArtifactRegistryServer) CreateTag(context.Context, *CreateTagRequest) (*Tag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateTag not implemented")
}
func (UnimplementedArtifactRegistryServer) UpdateTag(context.Context, *UpdateTagRequest) (*Tag, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateTag not implemented")
}
func (UnimplementedArtifactRegistryServer) DeleteTag(context.Context, *DeleteTagRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteTag not implemented")
}
func (UnimplementedArtifactRegistryServer) SetIamPolicy(context.Context, *iampb.SetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedArtifactRegistryServer) GetIamPolicy(context.Context, *iampb.GetIamPolicyRequest) (*iampb.Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedArtifactRegistryServer) TestIamPermissions(context.Context, *iampb.TestIamPermissionsRequest) (*iampb.TestIamPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedArtifactRegistryServer) GetProjectSettings(context.Context, *GetProjectSettingsRequest) (*ProjectSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProjectSettings not implemented")
}
func (UnimplementedArtifactRegistryServer) UpdateProjectSettings(context.Context, *UpdateProjectSettingsRequest) (*ProjectSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateProjectSettings not implemented")
}

// UnsafeArtifactRegistryServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ArtifactRegistryServer will
// result in compilation errors.
type UnsafeArtifactRegistryServer interface {
	mustEmbedUnimplementedArtifactRegistryServer()
}

func RegisterArtifactRegistryServer(s grpc.ServiceRegistrar, srv ArtifactRegistryServer) {
	s.RegisterService(&ArtifactRegistry_ServiceDesc, srv)
}

func _ArtifactRegistry_ImportAptArtifacts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportAptArtifactsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).ImportAptArtifacts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_ImportAptArtifacts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).ImportAptArtifacts(ctx, req.(*ImportAptArtifactsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_ImportYumArtifacts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportYumArtifactsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).ImportYumArtifacts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_ImportYumArtifacts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).ImportYumArtifacts(ctx, req.(*ImportYumArtifactsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_ListRepositories_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListRepositoriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).ListRepositories(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_ListRepositories_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).ListRepositories(ctx, req.(*ListRepositoriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_GetRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).GetRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_GetRepository_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).GetRepository(ctx, req.(*GetRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_CreateRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).CreateRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_CreateRepository_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).CreateRepository(ctx, req.(*CreateRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_UpdateRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).UpdateRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_UpdateRepository_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).UpdateRepository(ctx, req.(*UpdateRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_DeleteRepository_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteRepositoryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).DeleteRepository(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_DeleteRepository_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).DeleteRepository(ctx, req.(*DeleteRepositoryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_ListPackages_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPackagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).ListPackages(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_ListPackages_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).ListPackages(ctx, req.(*ListPackagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_GetPackage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPackageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).GetPackage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_GetPackage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).GetPackage(ctx, req.(*GetPackageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_DeletePackage_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePackageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).DeletePackage(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_DeletePackage_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).DeletePackage(ctx, req.(*DeletePackageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_ListVersions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListVersionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).ListVersions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_ListVersions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).ListVersions(ctx, req.(*ListVersionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_GetVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).GetVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_GetVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).GetVersion(ctx, req.(*GetVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_DeleteVersion_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVersionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).DeleteVersion(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_DeleteVersion_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).DeleteVersion(ctx, req.(*DeleteVersionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_ListFiles_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).ListFiles(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_ListFiles_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).ListFiles(ctx, req.(*ListFilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_GetFile_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).GetFile(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_GetFile_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).GetFile(ctx, req.(*GetFileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_ListTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTagsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).ListTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_ListTags_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).ListTags(ctx, req.(*ListTagsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_GetTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).GetTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_GetTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).GetTag(ctx, req.(*GetTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_CreateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).CreateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_CreateTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).CreateTag(ctx, req.(*CreateTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_UpdateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).UpdateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_UpdateTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).UpdateTag(ctx, req.(*UpdateTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_DeleteTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).DeleteTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_DeleteTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).DeleteTag(ctx, req.(*DeleteTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).SetIamPolicy(ctx, req.(*iampb.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).GetIamPolicy(ctx, req.(*iampb.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(iampb.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).TestIamPermissions(ctx, req.(*iampb.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_GetProjectSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProjectSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).GetProjectSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_GetProjectSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).GetProjectSettings(ctx, req.(*GetProjectSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ArtifactRegistry_UpdateProjectSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateProjectSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ArtifactRegistryServer).UpdateProjectSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ArtifactRegistry_UpdateProjectSettings_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ArtifactRegistryServer).UpdateProjectSettings(ctx, req.(*UpdateProjectSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ArtifactRegistry_ServiceDesc is the grpc.ServiceDesc for ArtifactRegistry service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ArtifactRegistry_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.devtools.artifactregistry.v1beta2.ArtifactRegistry",
	HandlerType: (*ArtifactRegistryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ImportAptArtifacts",
			Handler:    _ArtifactRegistry_ImportAptArtifacts_Handler,
		},
		{
			MethodName: "ImportYumArtifacts",
			Handler:    _ArtifactRegistry_ImportYumArtifacts_Handler,
		},
		{
			MethodName: "ListRepositories",
			Handler:    _ArtifactRegistry_ListRepositories_Handler,
		},
		{
			MethodName: "GetRepository",
			Handler:    _ArtifactRegistry_GetRepository_Handler,
		},
		{
			MethodName: "CreateRepository",
			Handler:    _ArtifactRegistry_CreateRepository_Handler,
		},
		{
			MethodName: "UpdateRepository",
			Handler:    _ArtifactRegistry_UpdateRepository_Handler,
		},
		{
			MethodName: "DeleteRepository",
			Handler:    _ArtifactRegistry_DeleteRepository_Handler,
		},
		{
			MethodName: "ListPackages",
			Handler:    _ArtifactRegistry_ListPackages_Handler,
		},
		{
			MethodName: "GetPackage",
			Handler:    _ArtifactRegistry_GetPackage_Handler,
		},
		{
			MethodName: "DeletePackage",
			Handler:    _ArtifactRegistry_DeletePackage_Handler,
		},
		{
			MethodName: "ListVersions",
			Handler:    _ArtifactRegistry_ListVersions_Handler,
		},
		{
			MethodName: "GetVersion",
			Handler:    _ArtifactRegistry_GetVersion_Handler,
		},
		{
			MethodName: "DeleteVersion",
			Handler:    _ArtifactRegistry_DeleteVersion_Handler,
		},
		{
			MethodName: "ListFiles",
			Handler:    _ArtifactRegistry_ListFiles_Handler,
		},
		{
			MethodName: "GetFile",
			Handler:    _ArtifactRegistry_GetFile_Handler,
		},
		{
			MethodName: "ListTags",
			Handler:    _ArtifactRegistry_ListTags_Handler,
		},
		{
			MethodName: "GetTag",
			Handler:    _ArtifactRegistry_GetTag_Handler,
		},
		{
			MethodName: "CreateTag",
			Handler:    _ArtifactRegistry_CreateTag_Handler,
		},
		{
			MethodName: "UpdateTag",
			Handler:    _ArtifactRegistry_UpdateTag_Handler,
		},
		{
			MethodName: "DeleteTag",
			Handler:    _ArtifactRegistry_DeleteTag_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _ArtifactRegistry_SetIamPolicy_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _ArtifactRegistry_GetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _ArtifactRegistry_TestIamPermissions_Handler,
		},
		{
			MethodName: "GetProjectSettings",
			Handler:    _ArtifactRegistry_GetProjectSettings_Handler,
		},
		{
			MethodName: "UpdateProjectSettings",
			Handler:    _ArtifactRegistry_UpdateProjectSettings_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/devtools/artifactregistry/v1beta2/service.proto",
}
