// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dialogflow/cx/v3beta1/conversation_history.proto

package cxpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	ConversationHistory_ListConversations_FullMethodName  = "/google.cloud.dialogflow.cx.v3beta1.ConversationHistory/ListConversations"
	ConversationHistory_GetConversation_FullMethodName    = "/google.cloud.dialogflow.cx.v3beta1.ConversationHistory/GetConversation"
	ConversationHistory_DeleteConversation_FullMethodName = "/google.cloud.dialogflow.cx.v3beta1.ConversationHistory/DeleteConversation"
)

// ConversationHistoryClient is the client API for ConversationHistory service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ConversationHistoryClient interface {
	// Returns the list of all conversations.
	ListConversations(ctx context.Context, in *ListConversationsRequest, opts ...grpc.CallOption) (*ListConversationsResponse, error)
	// Retrieves the specified conversation.
	GetConversation(ctx context.Context, in *GetConversationRequest, opts ...grpc.CallOption) (*Conversation, error)
	// Deletes the specified conversation.
	DeleteConversation(ctx context.Context, in *DeleteConversationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type conversationHistoryClient struct {
	cc grpc.ClientConnInterface
}

func NewConversationHistoryClient(cc grpc.ClientConnInterface) ConversationHistoryClient {
	return &conversationHistoryClient{cc}
}

func (c *conversationHistoryClient) ListConversations(ctx context.Context, in *ListConversationsRequest, opts ...grpc.CallOption) (*ListConversationsResponse, error) {
	out := new(ListConversationsResponse)
	err := c.cc.Invoke(ctx, ConversationHistory_ListConversations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationHistoryClient) GetConversation(ctx context.Context, in *GetConversationRequest, opts ...grpc.CallOption) (*Conversation, error) {
	out := new(Conversation)
	err := c.cc.Invoke(ctx, ConversationHistory_GetConversation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *conversationHistoryClient) DeleteConversation(ctx context.Context, in *DeleteConversationRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, ConversationHistory_DeleteConversation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ConversationHistoryServer is the server API for ConversationHistory service.
// All implementations should embed UnimplementedConversationHistoryServer
// for forward compatibility
type ConversationHistoryServer interface {
	// Returns the list of all conversations.
	ListConversations(context.Context, *ListConversationsRequest) (*ListConversationsResponse, error)
	// Retrieves the specified conversation.
	GetConversation(context.Context, *GetConversationRequest) (*Conversation, error)
	// Deletes the specified conversation.
	DeleteConversation(context.Context, *DeleteConversationRequest) (*emptypb.Empty, error)
}

// UnimplementedConversationHistoryServer should be embedded to have forward compatible implementations.
type UnimplementedConversationHistoryServer struct {
}

func (UnimplementedConversationHistoryServer) ListConversations(context.Context, *ListConversationsRequest) (*ListConversationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListConversations not implemented")
}
func (UnimplementedConversationHistoryServer) GetConversation(context.Context, *GetConversationRequest) (*Conversation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConversation not implemented")
}
func (UnimplementedConversationHistoryServer) DeleteConversation(context.Context, *DeleteConversationRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteConversation not implemented")
}

// UnsafeConversationHistoryServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ConversationHistoryServer will
// result in compilation errors.
type UnsafeConversationHistoryServer interface {
	mustEmbedUnimplementedConversationHistoryServer()
}

func RegisterConversationHistoryServer(s grpc.ServiceRegistrar, srv ConversationHistoryServer) {
	s.RegisterService(&ConversationHistory_ServiceDesc, srv)
}

func _ConversationHistory_ListConversations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListConversationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationHistoryServer).ListConversations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationHistory_ListConversations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationHistoryServer).ListConversations(ctx, req.(*ListConversationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationHistory_GetConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationHistoryServer).GetConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationHistory_GetConversation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationHistoryServer).GetConversation(ctx, req.(*GetConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ConversationHistory_DeleteConversation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteConversationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ConversationHistoryServer).DeleteConversation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ConversationHistory_DeleteConversation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ConversationHistoryServer).DeleteConversation(ctx, req.(*DeleteConversationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ConversationHistory_ServiceDesc is the grpc.ServiceDesc for ConversationHistory service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ConversationHistory_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.cx.v3beta1.ConversationHistory",
	HandlerType: (*ConversationHistoryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListConversations",
			Handler:    _ConversationHistory_ListConversations_Handler,
		},
		{
			MethodName: "GetConversation",
			Handler:    _ConversationHistory_GetConversation_Handler,
		},
		{
			MethodName: "DeleteConversation",
			Handler:    _ConversationHistory_DeleteConversation_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/cx/v3beta1/conversation_history.proto",
}
