// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package delivery

import (
	"bytes"
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"
	"regexp"
	"strings"
	"time"

	deliverypb "cloud.google.com/go/maps/fleetengine/delivery/apiv1/deliverypb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newClientHook clientHook

// CallOptions contains the retry settings for each method of Client.
type CallOptions struct {
	CreateDeliveryVehicle []gax.CallOption
	GetDeliveryVehicle    []gax.CallOption
	DeleteDeliveryVehicle []gax.CallOption
	UpdateDeliveryVehicle []gax.CallOption
	BatchCreateTasks      []gax.CallOption
	CreateTask            []gax.CallOption
	GetTask               []gax.CallOption
	DeleteTask            []gax.CallOption
	UpdateTask            []gax.CallOption
	ListTasks             []gax.CallOption
	GetTaskTrackingInfo   []gax.CallOption
	ListDeliveryVehicles  []gax.CallOption
}

func defaultGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("fleetengine.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("fleetengine.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("fleetengine.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://fleetengine.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultCallOptions() *CallOptions {
	return &CallOptions{
		CreateDeliveryVehicle: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetDeliveryVehicle: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteDeliveryVehicle: []gax.CallOption{},
		UpdateDeliveryVehicle: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		BatchCreateTasks: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		CreateTask: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetTask: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		DeleteTask: []gax.CallOption{},
		UpdateTask: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListTasks: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		GetTaskTrackingInfo: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		ListDeliveryVehicles: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
	}
}

func defaultRESTCallOptions() *CallOptions {
	return &CallOptions{
		CreateDeliveryVehicle: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetDeliveryVehicle: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		DeleteDeliveryVehicle: []gax.CallOption{},
		UpdateDeliveryVehicle: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		BatchCreateTasks: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		CreateTask: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetTask: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		DeleteTask: []gax.CallOption{},
		UpdateTask: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListTasks: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		GetTaskTrackingInfo: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		ListDeliveryVehicles: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
	}
}

// internalClient is an interface that defines the methods available from Last Mile Fleet Solution Delivery API.
type internalClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	CreateDeliveryVehicle(context.Context, *deliverypb.CreateDeliveryVehicleRequest, ...gax.CallOption) (*deliverypb.DeliveryVehicle, error)
	GetDeliveryVehicle(context.Context, *deliverypb.GetDeliveryVehicleRequest, ...gax.CallOption) (*deliverypb.DeliveryVehicle, error)
	DeleteDeliveryVehicle(context.Context, *deliverypb.DeleteDeliveryVehicleRequest, ...gax.CallOption) error
	UpdateDeliveryVehicle(context.Context, *deliverypb.UpdateDeliveryVehicleRequest, ...gax.CallOption) (*deliverypb.DeliveryVehicle, error)
	BatchCreateTasks(context.Context, *deliverypb.BatchCreateTasksRequest, ...gax.CallOption) (*deliverypb.BatchCreateTasksResponse, error)
	CreateTask(context.Context, *deliverypb.CreateTaskRequest, ...gax.CallOption) (*deliverypb.Task, error)
	GetTask(context.Context, *deliverypb.GetTaskRequest, ...gax.CallOption) (*deliverypb.Task, error)
	DeleteTask(context.Context, *deliverypb.DeleteTaskRequest, ...gax.CallOption) error
	UpdateTask(context.Context, *deliverypb.UpdateTaskRequest, ...gax.CallOption) (*deliverypb.Task, error)
	ListTasks(context.Context, *deliverypb.ListTasksRequest, ...gax.CallOption) *TaskIterator
	GetTaskTrackingInfo(context.Context, *deliverypb.GetTaskTrackingInfoRequest, ...gax.CallOption) (*deliverypb.TaskTrackingInfo, error)
	ListDeliveryVehicles(context.Context, *deliverypb.ListDeliveryVehiclesRequest, ...gax.CallOption) *DeliveryVehicleIterator
}

// Client is a client for interacting with Last Mile Fleet Solution Delivery API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// The Last Mile Delivery service.
type Client struct {
	// The internal transport-dependent client.
	internalClient internalClient

	// The call options for this service.
	CallOptions *CallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *Client) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *Client) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *Client) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// CreateDeliveryVehicle creates and returns a new DeliveryVehicle.
func (c *Client) CreateDeliveryVehicle(ctx context.Context, req *deliverypb.CreateDeliveryVehicleRequest, opts ...gax.CallOption) (*deliverypb.DeliveryVehicle, error) {
	return c.internalClient.CreateDeliveryVehicle(ctx, req, opts...)
}

// GetDeliveryVehicle returns the specified DeliveryVehicle instance.
func (c *Client) GetDeliveryVehicle(ctx context.Context, req *deliverypb.GetDeliveryVehicleRequest, opts ...gax.CallOption) (*deliverypb.DeliveryVehicle, error) {
	return c.internalClient.GetDeliveryVehicle(ctx, req, opts...)
}

// DeleteDeliveryVehicle deletes a DeliveryVehicle from the Fleet Engine.
//
// Returns FAILED_PRECONDITION if the DeliveryVehicle has OPEN Tasks
// assigned to it.
func (c *Client) DeleteDeliveryVehicle(ctx context.Context, req *deliverypb.DeleteDeliveryVehicleRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteDeliveryVehicle(ctx, req, opts...)
}

// UpdateDeliveryVehicle writes updated DeliveryVehicle data to Fleet Engine, and assigns
// Tasks to the DeliveryVehicle. You cannot update the name of the
// DeliveryVehicle. You can update remaining_vehicle_journey_segments,
// but it must contain all of the VehicleJourneySegments to be persisted on
// the DeliveryVehicle. The task_ids are retrieved from
// remaining_vehicle_journey_segments, and their corresponding Tasks are
// assigned to the DeliveryVehicle if they have not yet been assigned.
func (c *Client) UpdateDeliveryVehicle(ctx context.Context, req *deliverypb.UpdateDeliveryVehicleRequest, opts ...gax.CallOption) (*deliverypb.DeliveryVehicle, error) {
	return c.internalClient.UpdateDeliveryVehicle(ctx, req, opts...)
}

// BatchCreateTasks creates and returns a batch of new Task objects.
func (c *Client) BatchCreateTasks(ctx context.Context, req *deliverypb.BatchCreateTasksRequest, opts ...gax.CallOption) (*deliverypb.BatchCreateTasksResponse, error) {
	return c.internalClient.BatchCreateTasks(ctx, req, opts...)
}

// CreateTask creates and returns a new Task object.
func (c *Client) CreateTask(ctx context.Context, req *deliverypb.CreateTaskRequest, opts ...gax.CallOption) (*deliverypb.Task, error) {
	return c.internalClient.CreateTask(ctx, req, opts...)
}

// GetTask gets information about a Task.
func (c *Client) GetTask(ctx context.Context, req *deliverypb.GetTaskRequest, opts ...gax.CallOption) (*deliverypb.Task, error) {
	return c.internalClient.GetTask(ctx, req, opts...)
}

// DeleteTask deletes a single Task.
//
// Returns FAILED_PRECONDITION if the Task is OPEN and assigned to a
// DeliveryVehicle.
func (c *Client) DeleteTask(ctx context.Context, req *deliverypb.DeleteTaskRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteTask(ctx, req, opts...)
}

// UpdateTask updates Task data.
func (c *Client) UpdateTask(ctx context.Context, req *deliverypb.UpdateTaskRequest, opts ...gax.CallOption) (*deliverypb.Task, error) {
	return c.internalClient.UpdateTask(ctx, req, opts...)
}

// ListTasks gets all Tasks that meet the specified filtering criteria.
func (c *Client) ListTasks(ctx context.Context, req *deliverypb.ListTasksRequest, opts ...gax.CallOption) *TaskIterator {
	return c.internalClient.ListTasks(ctx, req, opts...)
}

// GetTaskTrackingInfo returns the specified TaskTrackingInfo instance.
func (c *Client) GetTaskTrackingInfo(ctx context.Context, req *deliverypb.GetTaskTrackingInfoRequest, opts ...gax.CallOption) (*deliverypb.TaskTrackingInfo, error) {
	return c.internalClient.GetTaskTrackingInfo(ctx, req, opts...)
}

// ListDeliveryVehicles gets all DeliveryVehicles that meet the specified filtering criteria.
func (c *Client) ListDeliveryVehicles(ctx context.Context, req *deliverypb.ListDeliveryVehiclesRequest, opts ...gax.CallOption) *DeliveryVehicleIterator {
	return c.internalClient.ListDeliveryVehicles(ctx, req, opts...)
}

// gRPCClient is a client for interacting with Last Mile Fleet Solution Delivery API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type gRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	// The gRPC API client.
	client deliverypb.DeliveryServiceClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewClient creates a new delivery service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// The Last Mile Delivery service.
func NewClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := defaultGRPCClientOptions()
	if newClientHook != nil {
		hookOpts, err := newClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := Client{CallOptions: defaultCallOptions()}

	c := &gRPCClient{
		connPool:    connPool,
		client:      deliverypb.NewDeliveryServiceClient(connPool),
		CallOptions: &client.CallOptions,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *gRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *gRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version, "pb", protoVersion)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *gRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type restClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	logger *slog.Logger
}

// NewRESTClient creates a new delivery service rest client.
//
// The Last Mile Delivery service.
func NewRESTClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := append(defaultRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultRESTCallOptions()
	c := &restClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	return &Client{internalClient: c, CallOptions: callOpts}, nil
}

func defaultRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://fleetengine.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://fleetengine.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://fleetengine.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://fleetengine.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *restClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN", "pb", protoVersion)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *restClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *restClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *gRPCClient) CreateDeliveryVehicle(ctx context.Context, req *deliverypb.CreateDeliveryVehicleRequest, opts ...gax.CallOption) (*deliverypb.DeliveryVehicle, error) {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetParent()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateDeliveryVehicle[0:len((*c.CallOptions).CreateDeliveryVehicle):len((*c.CallOptions).CreateDeliveryVehicle)], opts...)
	var resp *deliverypb.DeliveryVehicle
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateDeliveryVehicle, req, settings.GRPC, c.logger, "CreateDeliveryVehicle")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) GetDeliveryVehicle(ctx context.Context, req *deliverypb.GetDeliveryVehicleRequest, opts ...gax.CallOption) (*deliverypb.DeliveryVehicle, error) {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetDeliveryVehicle[0:len((*c.CallOptions).GetDeliveryVehicle):len((*c.CallOptions).GetDeliveryVehicle)], opts...)
	var resp *deliverypb.DeliveryVehicle
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetDeliveryVehicle, req, settings.GRPC, c.logger, "GetDeliveryVehicle")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) DeleteDeliveryVehicle(ctx context.Context, req *deliverypb.DeleteDeliveryVehicleRequest, opts ...gax.CallOption) error {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteDeliveryVehicle[0:len((*c.CallOptions).DeleteDeliveryVehicle):len((*c.CallOptions).DeleteDeliveryVehicle)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.client.DeleteDeliveryVehicle, req, settings.GRPC, c.logger, "DeleteDeliveryVehicle")
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) UpdateDeliveryVehicle(ctx context.Context, req *deliverypb.UpdateDeliveryVehicleRequest, opts ...gax.CallOption) (*deliverypb.DeliveryVehicle, error) {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetDeliveryVehicle().GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetDeliveryVehicle().GetName())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetDeliveryVehicle().GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateDeliveryVehicle[0:len((*c.CallOptions).UpdateDeliveryVehicle):len((*c.CallOptions).UpdateDeliveryVehicle)], opts...)
	var resp *deliverypb.DeliveryVehicle
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateDeliveryVehicle, req, settings.GRPC, c.logger, "UpdateDeliveryVehicle")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) BatchCreateTasks(ctx context.Context, req *deliverypb.BatchCreateTasksRequest, opts ...gax.CallOption) (*deliverypb.BatchCreateTasksResponse, error) {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetParent()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).BatchCreateTasks[0:len((*c.CallOptions).BatchCreateTasks):len((*c.CallOptions).BatchCreateTasks)], opts...)
	var resp *deliverypb.BatchCreateTasksResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.BatchCreateTasks, req, settings.GRPC, c.logger, "BatchCreateTasks")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateTask(ctx context.Context, req *deliverypb.CreateTaskRequest, opts ...gax.CallOption) (*deliverypb.Task, error) {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetParent()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateTask[0:len((*c.CallOptions).CreateTask):len((*c.CallOptions).CreateTask)], opts...)
	var resp *deliverypb.Task
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateTask, req, settings.GRPC, c.logger, "CreateTask")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) GetTask(ctx context.Context, req *deliverypb.GetTaskRequest, opts ...gax.CallOption) (*deliverypb.Task, error) {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetTask[0:len((*c.CallOptions).GetTask):len((*c.CallOptions).GetTask)], opts...)
	var resp *deliverypb.Task
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetTask, req, settings.GRPC, c.logger, "GetTask")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) DeleteTask(ctx context.Context, req *deliverypb.DeleteTaskRequest, opts ...gax.CallOption) error {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteTask[0:len((*c.CallOptions).DeleteTask):len((*c.CallOptions).DeleteTask)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.client.DeleteTask, req, settings.GRPC, c.logger, "DeleteTask")
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) UpdateTask(ctx context.Context, req *deliverypb.UpdateTaskRequest, opts ...gax.CallOption) (*deliverypb.Task, error) {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetTask().GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetTask().GetName())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetTask().GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateTask[0:len((*c.CallOptions).UpdateTask):len((*c.CallOptions).UpdateTask)], opts...)
	var resp *deliverypb.Task
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateTask, req, settings.GRPC, c.logger, "UpdateTask")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListTasks(ctx context.Context, req *deliverypb.ListTasksRequest, opts ...gax.CallOption) *TaskIterator {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetParent()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListTasks[0:len((*c.CallOptions).ListTasks):len((*c.CallOptions).ListTasks)], opts...)
	it := &TaskIterator{}
	req = proto.Clone(req).(*deliverypb.ListTasksRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*deliverypb.Task, string, error) {
		resp := &deliverypb.ListTasksResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListTasks, req, settings.GRPC, c.logger, "ListTasks")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetTasks(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetTaskTrackingInfo(ctx context.Context, req *deliverypb.GetTaskTrackingInfoRequest, opts ...gax.CallOption) (*deliverypb.TaskTrackingInfo, error) {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetTaskTrackingInfo[0:len((*c.CallOptions).GetTaskTrackingInfo):len((*c.CallOptions).GetTaskTrackingInfo)], opts...)
	var resp *deliverypb.TaskTrackingInfo
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetTaskTrackingInfo, req, settings.GRPC, c.logger, "GetTaskTrackingInfo")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListDeliveryVehicles(ctx context.Context, req *deliverypb.ListDeliveryVehiclesRequest, opts ...gax.CallOption) *DeliveryVehicleIterator {
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetParent()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListDeliveryVehicles[0:len((*c.CallOptions).ListDeliveryVehicles):len((*c.CallOptions).ListDeliveryVehicles)], opts...)
	it := &DeliveryVehicleIterator{}
	req = proto.Clone(req).(*deliverypb.ListDeliveryVehiclesRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*deliverypb.DeliveryVehicle, string, error) {
		resp := &deliverypb.ListDeliveryVehiclesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListDeliveryVehicles, req, settings.GRPC, c.logger, "ListDeliveryVehicles")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetDeliveryVehicles(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateDeliveryVehicle creates and returns a new DeliveryVehicle.
func (c *restClient) CreateDeliveryVehicle(ctx context.Context, req *deliverypb.CreateDeliveryVehicleRequest, opts ...gax.CallOption) (*deliverypb.DeliveryVehicle, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetDeliveryVehicle()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/deliveryVehicles", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("deliveryVehicleId", fmt.Sprintf("%v", req.GetDeliveryVehicleId()))
	if req.GetHeader().GetAndroidApiLevel() != 0 {
		params.Add("header.androidApiLevel", fmt.Sprintf("%v", req.GetHeader().GetAndroidApiLevel()))
	}
	if req.GetHeader().GetDeviceModel() != "" {
		params.Add("header.deviceModel", fmt.Sprintf("%v", req.GetHeader().GetDeviceModel()))
	}
	if req.GetHeader().GetLanguageCode() != "" {
		params.Add("header.languageCode", fmt.Sprintf("%v", req.GetHeader().GetLanguageCode()))
	}
	if req.GetHeader().GetManufacturer() != "" {
		params.Add("header.manufacturer", fmt.Sprintf("%v", req.GetHeader().GetManufacturer()))
	}
	if req.GetHeader().GetMapsSdkVersion() != "" {
		params.Add("header.mapsSdkVersion", fmt.Sprintf("%v", req.GetHeader().GetMapsSdkVersion()))
	}
	if req.GetHeader().GetNavSdkVersion() != "" {
		params.Add("header.navSdkVersion", fmt.Sprintf("%v", req.GetHeader().GetNavSdkVersion()))
	}
	if req.GetHeader().GetOsVersion() != "" {
		params.Add("header.osVersion", fmt.Sprintf("%v", req.GetHeader().GetOsVersion()))
	}
	if req.GetHeader().GetPlatform() != 0 {
		params.Add("header.platform", fmt.Sprintf("%v", req.GetHeader().GetPlatform()))
	}
	params.Add("header.regionCode", fmt.Sprintf("%v", req.GetHeader().GetRegionCode()))
	if req.GetHeader().GetSdkType() != 0 {
		params.Add("header.sdkType", fmt.Sprintf("%v", req.GetHeader().GetSdkType()))
	}
	if req.GetHeader().GetSdkVersion() != "" {
		params.Add("header.sdkVersion", fmt.Sprintf("%v", req.GetHeader().GetSdkVersion()))
	}
	if req.GetHeader().GetTraceId() != "" {
		params.Add("header.traceId", fmt.Sprintf("%v", req.GetHeader().GetTraceId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetParent()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateDeliveryVehicle[0:len((*c.CallOptions).CreateDeliveryVehicle):len((*c.CallOptions).CreateDeliveryVehicle)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &deliverypb.DeliveryVehicle{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateDeliveryVehicle")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetDeliveryVehicle returns the specified DeliveryVehicle instance.
func (c *restClient) GetDeliveryVehicle(ctx context.Context, req *deliverypb.GetDeliveryVehicleRequest, opts ...gax.CallOption) (*deliverypb.DeliveryVehicle, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetHeader().GetAndroidApiLevel() != 0 {
		params.Add("header.androidApiLevel", fmt.Sprintf("%v", req.GetHeader().GetAndroidApiLevel()))
	}
	if req.GetHeader().GetDeviceModel() != "" {
		params.Add("header.deviceModel", fmt.Sprintf("%v", req.GetHeader().GetDeviceModel()))
	}
	if req.GetHeader().GetLanguageCode() != "" {
		params.Add("header.languageCode", fmt.Sprintf("%v", req.GetHeader().GetLanguageCode()))
	}
	if req.GetHeader().GetManufacturer() != "" {
		params.Add("header.manufacturer", fmt.Sprintf("%v", req.GetHeader().GetManufacturer()))
	}
	if req.GetHeader().GetMapsSdkVersion() != "" {
		params.Add("header.mapsSdkVersion", fmt.Sprintf("%v", req.GetHeader().GetMapsSdkVersion()))
	}
	if req.GetHeader().GetNavSdkVersion() != "" {
		params.Add("header.navSdkVersion", fmt.Sprintf("%v", req.GetHeader().GetNavSdkVersion()))
	}
	if req.GetHeader().GetOsVersion() != "" {
		params.Add("header.osVersion", fmt.Sprintf("%v", req.GetHeader().GetOsVersion()))
	}
	if req.GetHeader().GetPlatform() != 0 {
		params.Add("header.platform", fmt.Sprintf("%v", req.GetHeader().GetPlatform()))
	}
	params.Add("header.regionCode", fmt.Sprintf("%v", req.GetHeader().GetRegionCode()))
	if req.GetHeader().GetSdkType() != 0 {
		params.Add("header.sdkType", fmt.Sprintf("%v", req.GetHeader().GetSdkType()))
	}
	if req.GetHeader().GetSdkVersion() != "" {
		params.Add("header.sdkVersion", fmt.Sprintf("%v", req.GetHeader().GetSdkVersion()))
	}
	if req.GetHeader().GetTraceId() != "" {
		params.Add("header.traceId", fmt.Sprintf("%v", req.GetHeader().GetTraceId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetDeliveryVehicle[0:len((*c.CallOptions).GetDeliveryVehicle):len((*c.CallOptions).GetDeliveryVehicle)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &deliverypb.DeliveryVehicle{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetDeliveryVehicle")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteDeliveryVehicle deletes a DeliveryVehicle from the Fleet Engine.
//
// Returns FAILED_PRECONDITION if the DeliveryVehicle has OPEN Tasks
// assigned to it.
func (c *restClient) DeleteDeliveryVehicle(ctx context.Context, req *deliverypb.DeleteDeliveryVehicleRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetHeader().GetAndroidApiLevel() != 0 {
		params.Add("header.androidApiLevel", fmt.Sprintf("%v", req.GetHeader().GetAndroidApiLevel()))
	}
	if req.GetHeader().GetDeviceModel() != "" {
		params.Add("header.deviceModel", fmt.Sprintf("%v", req.GetHeader().GetDeviceModel()))
	}
	if req.GetHeader().GetLanguageCode() != "" {
		params.Add("header.languageCode", fmt.Sprintf("%v", req.GetHeader().GetLanguageCode()))
	}
	if req.GetHeader().GetManufacturer() != "" {
		params.Add("header.manufacturer", fmt.Sprintf("%v", req.GetHeader().GetManufacturer()))
	}
	if req.GetHeader().GetMapsSdkVersion() != "" {
		params.Add("header.mapsSdkVersion", fmt.Sprintf("%v", req.GetHeader().GetMapsSdkVersion()))
	}
	if req.GetHeader().GetNavSdkVersion() != "" {
		params.Add("header.navSdkVersion", fmt.Sprintf("%v", req.GetHeader().GetNavSdkVersion()))
	}
	if req.GetHeader().GetOsVersion() != "" {
		params.Add("header.osVersion", fmt.Sprintf("%v", req.GetHeader().GetOsVersion()))
	}
	if req.GetHeader().GetPlatform() != 0 {
		params.Add("header.platform", fmt.Sprintf("%v", req.GetHeader().GetPlatform()))
	}
	params.Add("header.regionCode", fmt.Sprintf("%v", req.GetHeader().GetRegionCode()))
	if req.GetHeader().GetSdkType() != 0 {
		params.Add("header.sdkType", fmt.Sprintf("%v", req.GetHeader().GetSdkType()))
	}
	if req.GetHeader().GetSdkVersion() != "" {
		params.Add("header.sdkVersion", fmt.Sprintf("%v", req.GetHeader().GetSdkVersion()))
	}
	if req.GetHeader().GetTraceId() != "" {
		params.Add("header.traceId", fmt.Sprintf("%v", req.GetHeader().GetTraceId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteDeliveryVehicle")
		return err
	}, opts...)
}

// UpdateDeliveryVehicle writes updated DeliveryVehicle data to Fleet Engine, and assigns
// Tasks to the DeliveryVehicle. You cannot update the name of the
// DeliveryVehicle. You can update remaining_vehicle_journey_segments,
// but it must contain all of the VehicleJourneySegments to be persisted on
// the DeliveryVehicle. The task_ids are retrieved from
// remaining_vehicle_journey_segments, and their corresponding Tasks are
// assigned to the DeliveryVehicle if they have not yet been assigned.
func (c *restClient) UpdateDeliveryVehicle(ctx context.Context, req *deliverypb.UpdateDeliveryVehicleRequest, opts ...gax.CallOption) (*deliverypb.DeliveryVehicle, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetDeliveryVehicle()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetDeliveryVehicle().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetHeader().GetAndroidApiLevel() != 0 {
		params.Add("header.androidApiLevel", fmt.Sprintf("%v", req.GetHeader().GetAndroidApiLevel()))
	}
	if req.GetHeader().GetDeviceModel() != "" {
		params.Add("header.deviceModel", fmt.Sprintf("%v", req.GetHeader().GetDeviceModel()))
	}
	if req.GetHeader().GetLanguageCode() != "" {
		params.Add("header.languageCode", fmt.Sprintf("%v", req.GetHeader().GetLanguageCode()))
	}
	if req.GetHeader().GetManufacturer() != "" {
		params.Add("header.manufacturer", fmt.Sprintf("%v", req.GetHeader().GetManufacturer()))
	}
	if req.GetHeader().GetMapsSdkVersion() != "" {
		params.Add("header.mapsSdkVersion", fmt.Sprintf("%v", req.GetHeader().GetMapsSdkVersion()))
	}
	if req.GetHeader().GetNavSdkVersion() != "" {
		params.Add("header.navSdkVersion", fmt.Sprintf("%v", req.GetHeader().GetNavSdkVersion()))
	}
	if req.GetHeader().GetOsVersion() != "" {
		params.Add("header.osVersion", fmt.Sprintf("%v", req.GetHeader().GetOsVersion()))
	}
	if req.GetHeader().GetPlatform() != 0 {
		params.Add("header.platform", fmt.Sprintf("%v", req.GetHeader().GetPlatform()))
	}
	params.Add("header.regionCode", fmt.Sprintf("%v", req.GetHeader().GetRegionCode()))
	if req.GetHeader().GetSdkType() != 0 {
		params.Add("header.sdkType", fmt.Sprintf("%v", req.GetHeader().GetSdkType()))
	}
	if req.GetHeader().GetSdkVersion() != "" {
		params.Add("header.sdkVersion", fmt.Sprintf("%v", req.GetHeader().GetSdkVersion()))
	}
	if req.GetHeader().GetTraceId() != "" {
		params.Add("header.traceId", fmt.Sprintf("%v", req.GetHeader().GetTraceId()))
	}
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetDeliveryVehicle().GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetDeliveryVehicle().GetName())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetDeliveryVehicle().GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateDeliveryVehicle[0:len((*c.CallOptions).UpdateDeliveryVehicle):len((*c.CallOptions).UpdateDeliveryVehicle)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &deliverypb.DeliveryVehicle{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateDeliveryVehicle")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// BatchCreateTasks creates and returns a batch of new Task objects.
func (c *restClient) BatchCreateTasks(ctx context.Context, req *deliverypb.BatchCreateTasksRequest, opts ...gax.CallOption) (*deliverypb.BatchCreateTasksResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/tasks:batchCreate", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetParent()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).BatchCreateTasks[0:len((*c.CallOptions).BatchCreateTasks):len((*c.CallOptions).BatchCreateTasks)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &deliverypb.BatchCreateTasksResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "BatchCreateTasks")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateTask creates and returns a new Task object.
func (c *restClient) CreateTask(ctx context.Context, req *deliverypb.CreateTaskRequest, opts ...gax.CallOption) (*deliverypb.Task, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetTask()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/tasks", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetHeader().GetAndroidApiLevel() != 0 {
		params.Add("header.androidApiLevel", fmt.Sprintf("%v", req.GetHeader().GetAndroidApiLevel()))
	}
	if req.GetHeader().GetDeviceModel() != "" {
		params.Add("header.deviceModel", fmt.Sprintf("%v", req.GetHeader().GetDeviceModel()))
	}
	if req.GetHeader().GetLanguageCode() != "" {
		params.Add("header.languageCode", fmt.Sprintf("%v", req.GetHeader().GetLanguageCode()))
	}
	if req.GetHeader().GetManufacturer() != "" {
		params.Add("header.manufacturer", fmt.Sprintf("%v", req.GetHeader().GetManufacturer()))
	}
	if req.GetHeader().GetMapsSdkVersion() != "" {
		params.Add("header.mapsSdkVersion", fmt.Sprintf("%v", req.GetHeader().GetMapsSdkVersion()))
	}
	if req.GetHeader().GetNavSdkVersion() != "" {
		params.Add("header.navSdkVersion", fmt.Sprintf("%v", req.GetHeader().GetNavSdkVersion()))
	}
	if req.GetHeader().GetOsVersion() != "" {
		params.Add("header.osVersion", fmt.Sprintf("%v", req.GetHeader().GetOsVersion()))
	}
	if req.GetHeader().GetPlatform() != 0 {
		params.Add("header.platform", fmt.Sprintf("%v", req.GetHeader().GetPlatform()))
	}
	params.Add("header.regionCode", fmt.Sprintf("%v", req.GetHeader().GetRegionCode()))
	if req.GetHeader().GetSdkType() != 0 {
		params.Add("header.sdkType", fmt.Sprintf("%v", req.GetHeader().GetSdkType()))
	}
	if req.GetHeader().GetSdkVersion() != "" {
		params.Add("header.sdkVersion", fmt.Sprintf("%v", req.GetHeader().GetSdkVersion()))
	}
	if req.GetHeader().GetTraceId() != "" {
		params.Add("header.traceId", fmt.Sprintf("%v", req.GetHeader().GetTraceId()))
	}
	params.Add("taskId", fmt.Sprintf("%v", req.GetTaskId()))

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetParent()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetParent())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateTask[0:len((*c.CallOptions).CreateTask):len((*c.CallOptions).CreateTask)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &deliverypb.Task{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateTask")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetTask gets information about a Task.
func (c *restClient) GetTask(ctx context.Context, req *deliverypb.GetTaskRequest, opts ...gax.CallOption) (*deliverypb.Task, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetHeader().GetAndroidApiLevel() != 0 {
		params.Add("header.androidApiLevel", fmt.Sprintf("%v", req.GetHeader().GetAndroidApiLevel()))
	}
	if req.GetHeader().GetDeviceModel() != "" {
		params.Add("header.deviceModel", fmt.Sprintf("%v", req.GetHeader().GetDeviceModel()))
	}
	if req.GetHeader().GetLanguageCode() != "" {
		params.Add("header.languageCode", fmt.Sprintf("%v", req.GetHeader().GetLanguageCode()))
	}
	if req.GetHeader().GetManufacturer() != "" {
		params.Add("header.manufacturer", fmt.Sprintf("%v", req.GetHeader().GetManufacturer()))
	}
	if req.GetHeader().GetMapsSdkVersion() != "" {
		params.Add("header.mapsSdkVersion", fmt.Sprintf("%v", req.GetHeader().GetMapsSdkVersion()))
	}
	if req.GetHeader().GetNavSdkVersion() != "" {
		params.Add("header.navSdkVersion", fmt.Sprintf("%v", req.GetHeader().GetNavSdkVersion()))
	}
	if req.GetHeader().GetOsVersion() != "" {
		params.Add("header.osVersion", fmt.Sprintf("%v", req.GetHeader().GetOsVersion()))
	}
	if req.GetHeader().GetPlatform() != 0 {
		params.Add("header.platform", fmt.Sprintf("%v", req.GetHeader().GetPlatform()))
	}
	params.Add("header.regionCode", fmt.Sprintf("%v", req.GetHeader().GetRegionCode()))
	if req.GetHeader().GetSdkType() != 0 {
		params.Add("header.sdkType", fmt.Sprintf("%v", req.GetHeader().GetSdkType()))
	}
	if req.GetHeader().GetSdkVersion() != "" {
		params.Add("header.sdkVersion", fmt.Sprintf("%v", req.GetHeader().GetSdkVersion()))
	}
	if req.GetHeader().GetTraceId() != "" {
		params.Add("header.traceId", fmt.Sprintf("%v", req.GetHeader().GetTraceId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetTask[0:len((*c.CallOptions).GetTask):len((*c.CallOptions).GetTask)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &deliverypb.Task{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetTask")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteTask deletes a single Task.
//
// Returns FAILED_PRECONDITION if the Task is OPEN and assigned to a
// DeliveryVehicle.
func (c *restClient) DeleteTask(ctx context.Context, req *deliverypb.DeleteTaskRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetHeader().GetAndroidApiLevel() != 0 {
		params.Add("header.androidApiLevel", fmt.Sprintf("%v", req.GetHeader().GetAndroidApiLevel()))
	}
	if req.GetHeader().GetDeviceModel() != "" {
		params.Add("header.deviceModel", fmt.Sprintf("%v", req.GetHeader().GetDeviceModel()))
	}
	if req.GetHeader().GetLanguageCode() != "" {
		params.Add("header.languageCode", fmt.Sprintf("%v", req.GetHeader().GetLanguageCode()))
	}
	if req.GetHeader().GetManufacturer() != "" {
		params.Add("header.manufacturer", fmt.Sprintf("%v", req.GetHeader().GetManufacturer()))
	}
	if req.GetHeader().GetMapsSdkVersion() != "" {
		params.Add("header.mapsSdkVersion", fmt.Sprintf("%v", req.GetHeader().GetMapsSdkVersion()))
	}
	if req.GetHeader().GetNavSdkVersion() != "" {
		params.Add("header.navSdkVersion", fmt.Sprintf("%v", req.GetHeader().GetNavSdkVersion()))
	}
	if req.GetHeader().GetOsVersion() != "" {
		params.Add("header.osVersion", fmt.Sprintf("%v", req.GetHeader().GetOsVersion()))
	}
	if req.GetHeader().GetPlatform() != 0 {
		params.Add("header.platform", fmt.Sprintf("%v", req.GetHeader().GetPlatform()))
	}
	params.Add("header.regionCode", fmt.Sprintf("%v", req.GetHeader().GetRegionCode()))
	if req.GetHeader().GetSdkType() != 0 {
		params.Add("header.sdkType", fmt.Sprintf("%v", req.GetHeader().GetSdkType()))
	}
	if req.GetHeader().GetSdkVersion() != "" {
		params.Add("header.sdkVersion", fmt.Sprintf("%v", req.GetHeader().GetSdkVersion()))
	}
	if req.GetHeader().GetTraceId() != "" {
		params.Add("header.traceId", fmt.Sprintf("%v", req.GetHeader().GetTraceId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteTask")
		return err
	}, opts...)
}

// UpdateTask updates Task data.
func (c *restClient) UpdateTask(ctx context.Context, req *deliverypb.UpdateTaskRequest, opts ...gax.CallOption) (*deliverypb.Task, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetTask()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetTask().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetHeader().GetAndroidApiLevel() != 0 {
		params.Add("header.androidApiLevel", fmt.Sprintf("%v", req.GetHeader().GetAndroidApiLevel()))
	}
	if req.GetHeader().GetDeviceModel() != "" {
		params.Add("header.deviceModel", fmt.Sprintf("%v", req.GetHeader().GetDeviceModel()))
	}
	if req.GetHeader().GetLanguageCode() != "" {
		params.Add("header.languageCode", fmt.Sprintf("%v", req.GetHeader().GetLanguageCode()))
	}
	if req.GetHeader().GetManufacturer() != "" {
		params.Add("header.manufacturer", fmt.Sprintf("%v", req.GetHeader().GetManufacturer()))
	}
	if req.GetHeader().GetMapsSdkVersion() != "" {
		params.Add("header.mapsSdkVersion", fmt.Sprintf("%v", req.GetHeader().GetMapsSdkVersion()))
	}
	if req.GetHeader().GetNavSdkVersion() != "" {
		params.Add("header.navSdkVersion", fmt.Sprintf("%v", req.GetHeader().GetNavSdkVersion()))
	}
	if req.GetHeader().GetOsVersion() != "" {
		params.Add("header.osVersion", fmt.Sprintf("%v", req.GetHeader().GetOsVersion()))
	}
	if req.GetHeader().GetPlatform() != 0 {
		params.Add("header.platform", fmt.Sprintf("%v", req.GetHeader().GetPlatform()))
	}
	params.Add("header.regionCode", fmt.Sprintf("%v", req.GetHeader().GetRegionCode()))
	if req.GetHeader().GetSdkType() != 0 {
		params.Add("header.sdkType", fmt.Sprintf("%v", req.GetHeader().GetSdkType()))
	}
	if req.GetHeader().GetSdkVersion() != "" {
		params.Add("header.sdkVersion", fmt.Sprintf("%v", req.GetHeader().GetSdkVersion()))
	}
	if req.GetHeader().GetTraceId() != "" {
		params.Add("header.traceId", fmt.Sprintf("%v", req.GetHeader().GetTraceId()))
	}
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetTask().GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetTask().GetName())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetTask().GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateTask[0:len((*c.CallOptions).UpdateTask):len((*c.CallOptions).UpdateTask)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &deliverypb.Task{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateTask")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListTasks gets all Tasks that meet the specified filtering criteria.
func (c *restClient) ListTasks(ctx context.Context, req *deliverypb.ListTasksRequest, opts ...gax.CallOption) *TaskIterator {
	it := &TaskIterator{}
	req = proto.Clone(req).(*deliverypb.ListTasksRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*deliverypb.Task, string, error) {
		resp := &deliverypb.ListTasksResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/tasks", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetHeader().GetAndroidApiLevel() != 0 {
			params.Add("header.androidApiLevel", fmt.Sprintf("%v", req.GetHeader().GetAndroidApiLevel()))
		}
		if req.GetHeader().GetDeviceModel() != "" {
			params.Add("header.deviceModel", fmt.Sprintf("%v", req.GetHeader().GetDeviceModel()))
		}
		if req.GetHeader().GetLanguageCode() != "" {
			params.Add("header.languageCode", fmt.Sprintf("%v", req.GetHeader().GetLanguageCode()))
		}
		if req.GetHeader().GetManufacturer() != "" {
			params.Add("header.manufacturer", fmt.Sprintf("%v", req.GetHeader().GetManufacturer()))
		}
		if req.GetHeader().GetMapsSdkVersion() != "" {
			params.Add("header.mapsSdkVersion", fmt.Sprintf("%v", req.GetHeader().GetMapsSdkVersion()))
		}
		if req.GetHeader().GetNavSdkVersion() != "" {
			params.Add("header.navSdkVersion", fmt.Sprintf("%v", req.GetHeader().GetNavSdkVersion()))
		}
		if req.GetHeader().GetOsVersion() != "" {
			params.Add("header.osVersion", fmt.Sprintf("%v", req.GetHeader().GetOsVersion()))
		}
		if req.GetHeader().GetPlatform() != 0 {
			params.Add("header.platform", fmt.Sprintf("%v", req.GetHeader().GetPlatform()))
		}
		params.Add("header.regionCode", fmt.Sprintf("%v", req.GetHeader().GetRegionCode()))
		if req.GetHeader().GetSdkType() != 0 {
			params.Add("header.sdkType", fmt.Sprintf("%v", req.GetHeader().GetSdkType()))
		}
		if req.GetHeader().GetSdkVersion() != "" {
			params.Add("header.sdkVersion", fmt.Sprintf("%v", req.GetHeader().GetSdkVersion()))
		}
		if req.GetHeader().GetTraceId() != "" {
			params.Add("header.traceId", fmt.Sprintf("%v", req.GetHeader().GetTraceId()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListTasks")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetTasks(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetTaskTrackingInfo returns the specified TaskTrackingInfo instance.
func (c *restClient) GetTaskTrackingInfo(ctx context.Context, req *deliverypb.GetTaskTrackingInfoRequest, opts ...gax.CallOption) (*deliverypb.TaskTrackingInfo, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetHeader().GetAndroidApiLevel() != 0 {
		params.Add("header.androidApiLevel", fmt.Sprintf("%v", req.GetHeader().GetAndroidApiLevel()))
	}
	if req.GetHeader().GetDeviceModel() != "" {
		params.Add("header.deviceModel", fmt.Sprintf("%v", req.GetHeader().GetDeviceModel()))
	}
	if req.GetHeader().GetLanguageCode() != "" {
		params.Add("header.languageCode", fmt.Sprintf("%v", req.GetHeader().GetLanguageCode()))
	}
	if req.GetHeader().GetManufacturer() != "" {
		params.Add("header.manufacturer", fmt.Sprintf("%v", req.GetHeader().GetManufacturer()))
	}
	if req.GetHeader().GetMapsSdkVersion() != "" {
		params.Add("header.mapsSdkVersion", fmt.Sprintf("%v", req.GetHeader().GetMapsSdkVersion()))
	}
	if req.GetHeader().GetNavSdkVersion() != "" {
		params.Add("header.navSdkVersion", fmt.Sprintf("%v", req.GetHeader().GetNavSdkVersion()))
	}
	if req.GetHeader().GetOsVersion() != "" {
		params.Add("header.osVersion", fmt.Sprintf("%v", req.GetHeader().GetOsVersion()))
	}
	if req.GetHeader().GetPlatform() != 0 {
		params.Add("header.platform", fmt.Sprintf("%v", req.GetHeader().GetPlatform()))
	}
	params.Add("header.regionCode", fmt.Sprintf("%v", req.GetHeader().GetRegionCode()))
	if req.GetHeader().GetSdkType() != 0 {
		params.Add("header.sdkType", fmt.Sprintf("%v", req.GetHeader().GetSdkType()))
	}
	if req.GetHeader().GetSdkVersion() != "" {
		params.Add("header.sdkVersion", fmt.Sprintf("%v", req.GetHeader().GetSdkVersion()))
	}
	if req.GetHeader().GetTraceId() != "" {
		params.Add("header.traceId", fmt.Sprintf("%v", req.GetHeader().GetTraceId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	routingHeaders := ""
	routingHeadersMap := make(map[string]string)
	if reg := regexp.MustCompile("(?P<provider_id>providers/[^/]+)"); reg.MatchString(req.GetName()) && len(url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])) > 0 {
		routingHeadersMap["provider_id"] = url.QueryEscape(reg.FindStringSubmatch(req.GetName())[1])
	}
	for headerName, headerValue := range routingHeadersMap {
		routingHeaders = fmt.Sprintf("%s%s=%s&", routingHeaders, headerName, headerValue)
	}
	routingHeaders = strings.TrimSuffix(routingHeaders, "&")
	hds := []string{"x-goog-request-params", routingHeaders}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetTaskTrackingInfo[0:len((*c.CallOptions).GetTaskTrackingInfo):len((*c.CallOptions).GetTaskTrackingInfo)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &deliverypb.TaskTrackingInfo{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetTaskTrackingInfo")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListDeliveryVehicles gets all DeliveryVehicles that meet the specified filtering criteria.
func (c *restClient) ListDeliveryVehicles(ctx context.Context, req *deliverypb.ListDeliveryVehiclesRequest, opts ...gax.CallOption) *DeliveryVehicleIterator {
	it := &DeliveryVehicleIterator{}
	req = proto.Clone(req).(*deliverypb.ListDeliveryVehiclesRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*deliverypb.DeliveryVehicle, string, error) {
		resp := &deliverypb.ListDeliveryVehiclesResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/deliveryVehicles", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetHeader().GetAndroidApiLevel() != 0 {
			params.Add("header.androidApiLevel", fmt.Sprintf("%v", req.GetHeader().GetAndroidApiLevel()))
		}
		if req.GetHeader().GetDeviceModel() != "" {
			params.Add("header.deviceModel", fmt.Sprintf("%v", req.GetHeader().GetDeviceModel()))
		}
		if req.GetHeader().GetLanguageCode() != "" {
			params.Add("header.languageCode", fmt.Sprintf("%v", req.GetHeader().GetLanguageCode()))
		}
		if req.GetHeader().GetManufacturer() != "" {
			params.Add("header.manufacturer", fmt.Sprintf("%v", req.GetHeader().GetManufacturer()))
		}
		if req.GetHeader().GetMapsSdkVersion() != "" {
			params.Add("header.mapsSdkVersion", fmt.Sprintf("%v", req.GetHeader().GetMapsSdkVersion()))
		}
		if req.GetHeader().GetNavSdkVersion() != "" {
			params.Add("header.navSdkVersion", fmt.Sprintf("%v", req.GetHeader().GetNavSdkVersion()))
		}
		if req.GetHeader().GetOsVersion() != "" {
			params.Add("header.osVersion", fmt.Sprintf("%v", req.GetHeader().GetOsVersion()))
		}
		if req.GetHeader().GetPlatform() != 0 {
			params.Add("header.platform", fmt.Sprintf("%v", req.GetHeader().GetPlatform()))
		}
		params.Add("header.regionCode", fmt.Sprintf("%v", req.GetHeader().GetRegionCode()))
		if req.GetHeader().GetSdkType() != 0 {
			params.Add("header.sdkType", fmt.Sprintf("%v", req.GetHeader().GetSdkType()))
		}
		if req.GetHeader().GetSdkVersion() != "" {
			params.Add("header.sdkVersion", fmt.Sprintf("%v", req.GetHeader().GetSdkVersion()))
		}
		if req.GetHeader().GetTraceId() != "" {
			params.Add("header.traceId", fmt.Sprintf("%v", req.GetHeader().GetTraceId()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}
		if req.GetViewport().GetHigh().GetLatitude() != 0 {
			params.Add("viewport.high.latitude", fmt.Sprintf("%v", req.GetViewport().GetHigh().GetLatitude()))
		}
		if req.GetViewport().GetHigh().GetLongitude() != 0 {
			params.Add("viewport.high.longitude", fmt.Sprintf("%v", req.GetViewport().GetHigh().GetLongitude()))
		}
		if req.GetViewport().GetLow().GetLatitude() != 0 {
			params.Add("viewport.low.latitude", fmt.Sprintf("%v", req.GetViewport().GetLow().GetLatitude()))
		}
		if req.GetViewport().GetLow().GetLongitude() != 0 {
			params.Add("viewport.low.longitude", fmt.Sprintf("%v", req.GetViewport().GetLow().GetLongitude()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListDeliveryVehicles")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetDeliveryVehicles(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}
