// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	"google.golang.org/protobuf/proto"
	"google.golang.org/protobuf/types/known/emptypb"

	"go.opentelemetry.io/collector/featuregate"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyLogsRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesLogsRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewLogsRequest()
				CopyLogsRequest(dest, src)
				assert.Equal(t, src, dest)
				CopyLogsRequest(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestCopyLogsRequestSlice(t *testing.T) {
	src := []LogsRequest{}
	dest := []LogsRequest{}
	// Test CopyTo empty
	dest = CopyLogsRequestSlice(dest, src)
	assert.Equal(t, []LogsRequest{}, dest)

	// Test CopyTo larger slice
	src = GenTestLogsRequestSlice()
	dest = CopyLogsRequestSlice(dest, src)
	assert.Equal(t, GenTestLogsRequestSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyLogsRequestSlice(dest, src)
	assert.Equal(t, GenTestLogsRequestSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyLogsRequestSlice(dest, []LogsRequest{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyLogsRequestSlice(dest, src)
	assert.Equal(t, GenTestLogsRequestSlice(), dest)
}

func TestCopyLogsRequestPtrSlice(t *testing.T) {
	src := []*LogsRequest{}
	dest := []*LogsRequest{}
	// Test CopyTo empty
	dest = CopyLogsRequestPtrSlice(dest, src)
	assert.Equal(t, []*LogsRequest{}, dest)

	// Test CopyTo larger slice
	src = GenTestLogsRequestPtrSlice()
	dest = CopyLogsRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestLogsRequestPtrSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyLogsRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestLogsRequestPtrSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyLogsRequestPtrSlice(dest, []*LogsRequest{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyLogsRequestPtrSlice(dest, src)
	assert.Equal(t, GenTestLogsRequestPtrSlice(), dest)
}

func TestMarshalAndUnmarshalJSONLogsRequestUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewLogsRequest()
	dest.UnmarshalJSON(iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewLogsRequest(), dest)
}

func TestMarshalAndUnmarshalJSONLogsRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesLogsRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				src.MarshalJSON(stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewLogsRequest()
				dest.UnmarshalJSON(iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteLogsRequest(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoLogsRequestFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesLogsRequest() {
		t.Run(name, func(t *testing.T) {
			dest := NewLogsRequest()
			require.Error(t, dest.UnmarshalProto(buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoLogsRequestUnknown(t *testing.T) {
	dest := NewLogsRequest()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, dest.UnmarshalProto([]byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewLogsRequest(), dest)
}

func TestMarshalAndUnmarshalProtoLogsRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesLogsRequest() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, src.SizeProto())
				gotSize := src.MarshalProto(buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewLogsRequest()
				require.NoError(t, dest.UnmarshalProto(buf))

				assert.Equal(t, src, dest)
				DeleteLogsRequest(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufLogsRequest(t *testing.T) {
	for name, src := range genTestEncodingValuesLogsRequest() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, src.SizeProto())
			gotSize := src.MarshalProto(buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &emptypb.Empty{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewLogsRequest()
			require.NoError(t, dest.UnmarshalProto(goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesLogsRequest() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                  {0x02},
		"RequestContext/wrong_wire_type": {0x14},
		"RequestContext/missing_value":   {0x12},
		"LogsData/wrong_wire_type":       {0x1c},
		"LogsData/missing_value":         {0x1a},
		"FormatVersion/wrong_wire_type":  {0xc},
		"FormatVersion/missing_value":    {0xd},
	}
}

func genTestEncodingValuesLogsRequest() map[string]*LogsRequest {
	return map[string]*LogsRequest{
		"empty":               NewLogsRequest(),
		"RequestContext/test": {RequestContext: GenTestRequestContext()},
		"LogsData/test":       {LogsData: *GenTestLogsData()},
		"FormatVersion/test":  {FormatVersion: uint32(13)},
	}
}
