// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudformation

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudformation/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Specifies the configuration data for a registered CloudFormation extension, in
// the given account and Region.
//
// To view the current configuration data for an extension, refer to the
// ConfigurationSchema element of [DescribeType]. For more information, see [Edit configuration data for extensions in your account] in the
// CloudFormation User Guide.
//
// It's strongly recommended that you use dynamic references to restrict sensitive
// configuration definitions, such as third-party credentials. For more details on
// dynamic references, see [Specify values stored in other services using dynamic references]in the CloudFormation User Guide.
//
// [DescribeType]: https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html
// [Edit configuration data for extensions in your account]: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/registry-set-configuration.html
// [Specify values stored in other services using dynamic references]: https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/dynamic-references.html
func (c *Client) SetTypeConfiguration(ctx context.Context, params *SetTypeConfigurationInput, optFns ...func(*Options)) (*SetTypeConfigurationOutput, error) {
	if params == nil {
		params = &SetTypeConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "SetTypeConfiguration", params, optFns, c.addOperationSetTypeConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*SetTypeConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type SetTypeConfigurationInput struct {

	// The configuration data for the extension, in this account and Region.
	//
	// The configuration data must be formatted as JSON, and validate against the
	// schema returned in the ConfigurationSchema response element of [DescribeType]. For more
	// information, see [Defining the account-level configuration of an extension]in the CloudFormation Command Line Interface (CLI) User Guide.
	//
	// [DescribeType]: https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_DescribeType.html
	// [Defining the account-level configuration of an extension]: https://docs.aws.amazon.com/cloudformation-cli/latest/userguide/resource-type-model.html#resource-type-howto-configuration
	//
	// This member is required.
	Configuration *string

	// An alias by which to refer to this extension configuration data.
	//
	// Conditional: Specifying a configuration alias is required when setting a
	// configuration for a resource type extension.
	ConfigurationAlias *string

	// The type of extension.
	//
	// Conditional: You must specify ConfigurationArn , or Type and TypeName .
	Type types.ThirdPartyType

	// The Amazon Resource Name (ARN) for the extension, in this account and Region.
	//
	// For public extensions, this will be the ARN assigned when you call the [ActivateType] API
	// operation in this account and Region. For private extensions, this will be the
	// ARN assigned when you call the [RegisterType]API operation in this account and Region.
	//
	// Do not include the extension versions suffix at the end of the ARN. You can set
	// the configuration for an extension, but not for a specific extension version.
	//
	// [ActivateType]: https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_ActivateType.html
	// [RegisterType]: https://docs.aws.amazon.com/AWSCloudFormation/latest/APIReference/API_RegisterType.html
	TypeArn *string

	// The name of the extension.
	//
	// Conditional: You must specify ConfigurationArn , or Type and TypeName .
	TypeName *string

	noSmithyDocumentSerde
}

type SetTypeConfigurationOutput struct {

	// The Amazon Resource Name (ARN) for the configuration data, in this account and
	// Region.
	//
	// Conditional: You must specify ConfigurationArn , or Type and TypeName .
	ConfigurationArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationSetTypeConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsquery_serializeOpSetTypeConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsquery_deserializeOpSetTypeConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "SetTypeConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpSetTypeConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opSetTypeConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opSetTypeConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "SetTypeConfiguration",
	}
}
