// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/dataproc/v1/autoscaling_policies.proto

package dataprocpb

import (
	context "context"

	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	AutoscalingPolicyService_CreateAutoscalingPolicy_FullMethodName = "/google.cloud.dataproc.v1.AutoscalingPolicyService/CreateAutoscalingPolicy"
	AutoscalingPolicyService_UpdateAutoscalingPolicy_FullMethodName = "/google.cloud.dataproc.v1.AutoscalingPolicyService/UpdateAutoscalingPolicy"
	AutoscalingPolicyService_GetAutoscalingPolicy_FullMethodName    = "/google.cloud.dataproc.v1.AutoscalingPolicyService/GetAutoscalingPolicy"
	AutoscalingPolicyService_ListAutoscalingPolicies_FullMethodName = "/google.cloud.dataproc.v1.AutoscalingPolicyService/ListAutoscalingPolicies"
	AutoscalingPolicyService_DeleteAutoscalingPolicy_FullMethodName = "/google.cloud.dataproc.v1.AutoscalingPolicyService/DeleteAutoscalingPolicy"
)

// AutoscalingPolicyServiceClient is the client API for AutoscalingPolicyService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AutoscalingPolicyServiceClient interface {
	// Creates new autoscaling policy.
	CreateAutoscalingPolicy(ctx context.Context, in *CreateAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error)
	// Updates (replaces) autoscaling policy.
	//
	// Disabled check for update_mask, because all updates will be full
	// replacements.
	UpdateAutoscalingPolicy(ctx context.Context, in *UpdateAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error)
	// Retrieves autoscaling policy.
	GetAutoscalingPolicy(ctx context.Context, in *GetAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error)
	// Lists autoscaling policies in the project.
	ListAutoscalingPolicies(ctx context.Context, in *ListAutoscalingPoliciesRequest, opts ...grpc.CallOption) (*ListAutoscalingPoliciesResponse, error)
	// Deletes an autoscaling policy. It is an error to delete an autoscaling
	// policy that is in use by one or more clusters.
	DeleteAutoscalingPolicy(ctx context.Context, in *DeleteAutoscalingPolicyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
}

type autoscalingPolicyServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewAutoscalingPolicyServiceClient(cc grpc.ClientConnInterface) AutoscalingPolicyServiceClient {
	return &autoscalingPolicyServiceClient{cc}
}

func (c *autoscalingPolicyServiceClient) CreateAutoscalingPolicy(ctx context.Context, in *CreateAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error) {
	out := new(AutoscalingPolicy)
	err := c.cc.Invoke(ctx, AutoscalingPolicyService_CreateAutoscalingPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoscalingPolicyServiceClient) UpdateAutoscalingPolicy(ctx context.Context, in *UpdateAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error) {
	out := new(AutoscalingPolicy)
	err := c.cc.Invoke(ctx, AutoscalingPolicyService_UpdateAutoscalingPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoscalingPolicyServiceClient) GetAutoscalingPolicy(ctx context.Context, in *GetAutoscalingPolicyRequest, opts ...grpc.CallOption) (*AutoscalingPolicy, error) {
	out := new(AutoscalingPolicy)
	err := c.cc.Invoke(ctx, AutoscalingPolicyService_GetAutoscalingPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoscalingPolicyServiceClient) ListAutoscalingPolicies(ctx context.Context, in *ListAutoscalingPoliciesRequest, opts ...grpc.CallOption) (*ListAutoscalingPoliciesResponse, error) {
	out := new(ListAutoscalingPoliciesResponse)
	err := c.cc.Invoke(ctx, AutoscalingPolicyService_ListAutoscalingPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoscalingPolicyServiceClient) DeleteAutoscalingPolicy(ctx context.Context, in *DeleteAutoscalingPolicyRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, AutoscalingPolicyService_DeleteAutoscalingPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AutoscalingPolicyServiceServer is the server API for AutoscalingPolicyService service.
// All implementations should embed UnimplementedAutoscalingPolicyServiceServer
// for forward compatibility
type AutoscalingPolicyServiceServer interface {
	// Creates new autoscaling policy.
	CreateAutoscalingPolicy(context.Context, *CreateAutoscalingPolicyRequest) (*AutoscalingPolicy, error)
	// Updates (replaces) autoscaling policy.
	//
	// Disabled check for update_mask, because all updates will be full
	// replacements.
	UpdateAutoscalingPolicy(context.Context, *UpdateAutoscalingPolicyRequest) (*AutoscalingPolicy, error)
	// Retrieves autoscaling policy.
	GetAutoscalingPolicy(context.Context, *GetAutoscalingPolicyRequest) (*AutoscalingPolicy, error)
	// Lists autoscaling policies in the project.
	ListAutoscalingPolicies(context.Context, *ListAutoscalingPoliciesRequest) (*ListAutoscalingPoliciesResponse, error)
	// Deletes an autoscaling policy. It is an error to delete an autoscaling
	// policy that is in use by one or more clusters.
	DeleteAutoscalingPolicy(context.Context, *DeleteAutoscalingPolicyRequest) (*emptypb.Empty, error)
}

// UnimplementedAutoscalingPolicyServiceServer should be embedded to have forward compatible implementations.
type UnimplementedAutoscalingPolicyServiceServer struct {
}

func (UnimplementedAutoscalingPolicyServiceServer) CreateAutoscalingPolicy(context.Context, *CreateAutoscalingPolicyRequest) (*AutoscalingPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateAutoscalingPolicy not implemented")
}
func (UnimplementedAutoscalingPolicyServiceServer) UpdateAutoscalingPolicy(context.Context, *UpdateAutoscalingPolicyRequest) (*AutoscalingPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAutoscalingPolicy not implemented")
}
func (UnimplementedAutoscalingPolicyServiceServer) GetAutoscalingPolicy(context.Context, *GetAutoscalingPolicyRequest) (*AutoscalingPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAutoscalingPolicy not implemented")
}
func (UnimplementedAutoscalingPolicyServiceServer) ListAutoscalingPolicies(context.Context, *ListAutoscalingPoliciesRequest) (*ListAutoscalingPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAutoscalingPolicies not implemented")
}
func (UnimplementedAutoscalingPolicyServiceServer) DeleteAutoscalingPolicy(context.Context, *DeleteAutoscalingPolicyRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAutoscalingPolicy not implemented")
}

// UnsafeAutoscalingPolicyServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AutoscalingPolicyServiceServer will
// result in compilation errors.
type UnsafeAutoscalingPolicyServiceServer interface {
	mustEmbedUnimplementedAutoscalingPolicyServiceServer()
}

func RegisterAutoscalingPolicyServiceServer(s grpc.ServiceRegistrar, srv AutoscalingPolicyServiceServer) {
	s.RegisterService(&AutoscalingPolicyService_ServiceDesc, srv)
}

func _AutoscalingPolicyService_CreateAutoscalingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateAutoscalingPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalingPolicyServiceServer).CreateAutoscalingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoscalingPolicyService_CreateAutoscalingPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalingPolicyServiceServer).CreateAutoscalingPolicy(ctx, req.(*CreateAutoscalingPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoscalingPolicyService_UpdateAutoscalingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAutoscalingPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalingPolicyServiceServer).UpdateAutoscalingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoscalingPolicyService_UpdateAutoscalingPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalingPolicyServiceServer).UpdateAutoscalingPolicy(ctx, req.(*UpdateAutoscalingPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoscalingPolicyService_GetAutoscalingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAutoscalingPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalingPolicyServiceServer).GetAutoscalingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoscalingPolicyService_GetAutoscalingPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalingPolicyServiceServer).GetAutoscalingPolicy(ctx, req.(*GetAutoscalingPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoscalingPolicyService_ListAutoscalingPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAutoscalingPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalingPolicyServiceServer).ListAutoscalingPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoscalingPolicyService_ListAutoscalingPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalingPolicyServiceServer).ListAutoscalingPolicies(ctx, req.(*ListAutoscalingPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AutoscalingPolicyService_DeleteAutoscalingPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAutoscalingPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalingPolicyServiceServer).DeleteAutoscalingPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AutoscalingPolicyService_DeleteAutoscalingPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalingPolicyServiceServer).DeleteAutoscalingPolicy(ctx, req.(*DeleteAutoscalingPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AutoscalingPolicyService_ServiceDesc is the grpc.ServiceDesc for AutoscalingPolicyService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AutoscalingPolicyService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dataproc.v1.AutoscalingPolicyService",
	HandlerType: (*AutoscalingPolicyServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateAutoscalingPolicy",
			Handler:    _AutoscalingPolicyService_CreateAutoscalingPolicy_Handler,
		},
		{
			MethodName: "UpdateAutoscalingPolicy",
			Handler:    _AutoscalingPolicyService_UpdateAutoscalingPolicy_Handler,
		},
		{
			MethodName: "GetAutoscalingPolicy",
			Handler:    _AutoscalingPolicyService_GetAutoscalingPolicy_Handler,
		},
		{
			MethodName: "ListAutoscalingPolicies",
			Handler:    _AutoscalingPolicyService_ListAutoscalingPolicies_Handler,
		},
		{
			MethodName: "DeleteAutoscalingPolicy",
			Handler:    _AutoscalingPolicyService_DeleteAutoscalingPolicy_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dataproc/v1/autoscaling_policies.proto",
}
