//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

// Aircraft-rated danger from this threat.
type MAV_COLLISION_THREAT_LEVEL uint64

const (
	// Not a threat
	MAV_COLLISION_THREAT_LEVEL_NONE MAV_COLLISION_THREAT_LEVEL = 0
	// Craft is mildly concerned about this threat
	MAV_COLLISION_THREAT_LEVEL_LOW MAV_COLLISION_THREAT_LEVEL = 1
	// Craft is panicking, and may take actions to avoid threat
	MAV_COLLISION_THREAT_LEVEL_HIGH MAV_COLLISION_THREAT_LEVEL = 2
)

var value_to_label_MAV_COLLISION_THREAT_LEVEL = map[MAV_COLLISION_THREAT_LEVEL]string{
	MAV_COLLISION_THREAT_LEVEL_NONE: "MAV_COLLISION_THREAT_LEVEL_NONE",
	MAV_COLLISION_THREAT_LEVEL_LOW:  "MAV_COLLISION_THREAT_LEVEL_LOW",
	MAV_COLLISION_THREAT_LEVEL_HIGH: "MAV_COLLISION_THREAT_LEVEL_HIGH",
}

var label_to_value_MAV_COLLISION_THREAT_LEVEL = map[string]MAV_COLLISION_THREAT_LEVEL{
	"MAV_COLLISION_THREAT_LEVEL_NONE": MAV_COLLISION_THREAT_LEVEL_NONE,
	"MAV_COLLISION_THREAT_LEVEL_LOW":  MAV_COLLISION_THREAT_LEVEL_LOW,
	"MAV_COLLISION_THREAT_LEVEL_HIGH": MAV_COLLISION_THREAT_LEVEL_HIGH,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_COLLISION_THREAT_LEVEL) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_MAV_COLLISION_THREAT_LEVEL[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_COLLISION_THREAT_LEVEL) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_MAV_COLLISION_THREAT_LEVEL[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MAV_COLLISION_THREAT_LEVEL(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_COLLISION_THREAT_LEVEL) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
