//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package common

import (
	"fmt"
	"strconv"
)

type MAG_CAL_STATUS uint64

const (
	MAG_CAL_NOT_STARTED      MAG_CAL_STATUS = 0
	MAG_CAL_WAITING_TO_START MAG_CAL_STATUS = 1
	MAG_CAL_RUNNING_STEP_ONE MAG_CAL_STATUS = 2
	MAG_CAL_RUNNING_STEP_TWO MAG_CAL_STATUS = 3
	MAG_CAL_SUCCESS          MAG_CAL_STATUS = 4
	MAG_CAL_FAILED           MAG_CAL_STATUS = 5
	MAG_CAL_BAD_ORIENTATION  MAG_CAL_STATUS = 6
	MAG_CAL_BAD_RADIUS       MAG_CAL_STATUS = 7
)

var value_to_label_MAG_CAL_STATUS = map[MAG_CAL_STATUS]string{
	MAG_CAL_NOT_STARTED:      "MAG_CAL_NOT_STARTED",
	MAG_CAL_WAITING_TO_START: "MAG_CAL_WAITING_TO_START",
	MAG_CAL_RUNNING_STEP_ONE: "MAG_CAL_RUNNING_STEP_ONE",
	MAG_CAL_RUNNING_STEP_TWO: "MAG_CAL_RUNNING_STEP_TWO",
	MAG_CAL_SUCCESS:          "MAG_CAL_SUCCESS",
	MAG_CAL_FAILED:           "MAG_CAL_FAILED",
	MAG_CAL_BAD_ORIENTATION:  "MAG_CAL_BAD_ORIENTATION",
	MAG_CAL_BAD_RADIUS:       "MAG_CAL_BAD_RADIUS",
}

var label_to_value_MAG_CAL_STATUS = map[string]MAG_CAL_STATUS{
	"MAG_CAL_NOT_STARTED":      MAG_CAL_NOT_STARTED,
	"MAG_CAL_WAITING_TO_START": MAG_CAL_WAITING_TO_START,
	"MAG_CAL_RUNNING_STEP_ONE": MAG_CAL_RUNNING_STEP_ONE,
	"MAG_CAL_RUNNING_STEP_TWO": MAG_CAL_RUNNING_STEP_TWO,
	"MAG_CAL_SUCCESS":          MAG_CAL_SUCCESS,
	"MAG_CAL_FAILED":           MAG_CAL_FAILED,
	"MAG_CAL_BAD_ORIENTATION":  MAG_CAL_BAD_ORIENTATION,
	"MAG_CAL_BAD_RADIUS":       MAG_CAL_BAD_RADIUS,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAG_CAL_STATUS) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_MAG_CAL_STATUS[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAG_CAL_STATUS) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_MAG_CAL_STATUS[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MAG_CAL_STATUS(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAG_CAL_STATUS) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
