//autogenerated:yes
//nolint:revive,misspell,govet,lll,dupl,gocritic
package minimal

import (
	"fmt"
	"strconv"
)

type MAV_STATE uint64

const (
	// Uninitialized system, state is unknown.
	MAV_STATE_UNINIT MAV_STATE = 0
	// System is booting up.
	MAV_STATE_BOOT MAV_STATE = 1
	// System is calibrating and not flight-ready.
	MAV_STATE_CALIBRATING MAV_STATE = 2
	// System is grounded and on standby. It can be launched any time.
	MAV_STATE_STANDBY MAV_STATE = 3
	// System is active and might be already airborne. Motors are engaged.
	MAV_STATE_ACTIVE MAV_STATE = 4
	// System is in a non-normal flight mode (failsafe). It can however still navigate.
	MAV_STATE_CRITICAL MAV_STATE = 5
	// System is in a non-normal flight mode (failsafe). It lost control over parts or over the whole airframe. It is in mayday and going down.
	MAV_STATE_EMERGENCY MAV_STATE = 6
	// System just initialized its power-down sequence, will shut down now.
	MAV_STATE_POWEROFF MAV_STATE = 7
	// System is terminating itself (failsafe or commanded).
	MAV_STATE_FLIGHT_TERMINATION MAV_STATE = 8
)

var value_to_label_MAV_STATE = map[MAV_STATE]string{
	MAV_STATE_UNINIT:             "MAV_STATE_UNINIT",
	MAV_STATE_BOOT:               "MAV_STATE_BOOT",
	MAV_STATE_CALIBRATING:        "MAV_STATE_CALIBRATING",
	MAV_STATE_STANDBY:            "MAV_STATE_STANDBY",
	MAV_STATE_ACTIVE:             "MAV_STATE_ACTIVE",
	MAV_STATE_CRITICAL:           "MAV_STATE_CRITICAL",
	MAV_STATE_EMERGENCY:          "MAV_STATE_EMERGENCY",
	MAV_STATE_POWEROFF:           "MAV_STATE_POWEROFF",
	MAV_STATE_FLIGHT_TERMINATION: "MAV_STATE_FLIGHT_TERMINATION",
}

var label_to_value_MAV_STATE = map[string]MAV_STATE{
	"MAV_STATE_UNINIT":             MAV_STATE_UNINIT,
	"MAV_STATE_BOOT":               MAV_STATE_BOOT,
	"MAV_STATE_CALIBRATING":        MAV_STATE_CALIBRATING,
	"MAV_STATE_STANDBY":            MAV_STATE_STANDBY,
	"MAV_STATE_ACTIVE":             MAV_STATE_ACTIVE,
	"MAV_STATE_CRITICAL":           MAV_STATE_CRITICAL,
	"MAV_STATE_EMERGENCY":          MAV_STATE_EMERGENCY,
	"MAV_STATE_POWEROFF":           MAV_STATE_POWEROFF,
	"MAV_STATE_FLIGHT_TERMINATION": MAV_STATE_FLIGHT_TERMINATION,
}

// MarshalText implements the encoding.TextMarshaler interface.
func (e MAV_STATE) MarshalText() ([]byte, error) {
	if name, ok := value_to_label_MAV_STATE[e]; ok {
		return []byte(name), nil
	}
	return []byte(strconv.Itoa(int(e))), nil
}

// UnmarshalText implements the encoding.TextUnmarshaler interface.
func (e *MAV_STATE) UnmarshalText(text []byte) error {
	if value, ok := label_to_value_MAV_STATE[string(text)]; ok {
		*e = value
	} else if value, err := strconv.Atoi(string(text)); err == nil {
		*e = MAV_STATE(value)
	} else {
		return fmt.Errorf("invalid label '%s'", text)
	}
	return nil
}

// String implements the fmt.Stringer interface.
func (e MAV_STATE) String() string {
	val, _ := e.MarshalText()
	return string(val)
}
