//autogenerated:yes
//nolint:revive,misspell,govet,lll
package common

// Time synchronization message.
// The message is used for both timesync requests and responses.
// The request is sent with `ts1=syncing component timestamp` and `tc1=0`, and may be broadcast or targeted to a specific system/component.
// The response is sent with `ts1=syncing component timestamp` (mirror back unchanged), and `tc1=responding component timestamp`, with the `target_system` and `target_component` set to ids of the original request.
// Systems can determine if they are receiving a request or response based on the value of `tc`.
// If the response has `target_system==target_component==0` the remote system has not been updated to use the component IDs and cannot reliably timesync; the requester may report an error.
// Timestamps are UNIX Epoch time or time since system boot in nanoseconds (the timestamp format can be inferred by checking for the magnitude of the number; generally it doesn't matter as only the offset is used).
// The message sequence is repeated numerous times with results being filtered/averaged to estimate the offset.
// See also: https://mavlink.io/en/services/timesync.html.
type MessageTimesync struct {
	// Time sync timestamp 1. Syncing: 0. Responding: Timestamp of responding component.
	Tc1 int64
	// Time sync timestamp 2. Timestamp of syncing component (mirrored in response).
	Ts1 int64
	// Target system id. Request: 0 (broadcast) or id of specific system. Response must contain system id of the requesting component.
	TargetSystem uint8 `mavext:"true"`
	// Target component id. Request: 0 (broadcast) or id of specific component. Response must contain component id of the requesting component.
	TargetComponent uint8 `mavext:"true"`
}

// GetID implements the message.Message interface.
func (*MessageTimesync) GetID() uint32 {
	return 111
}
